local hud_levels = {}
local hud = {}
local map_version = 3
local rrr = 0
local rrrr = 0
local timer = 0
local timer2 = 0
local pon = 0
local tptp = 0
local set = 0
local main = {}
main.get_formspec = function(player, pos)
	if player == nil then
        return
    end
	local meta = player:get_meta()
	local elements = ""
	if meta:get_string("levels") then
		local t = minetest.deserialize(meta:get_string("levels"))
		if not t then
			t = {}
		end
		for i = 1, #t do
			if tostring(t[i]) == "" then
				table.remove(t, i)
			end
		end
		meta:set_string("levels", minetest.serialize(t))
		local t = minetest.deserialize(meta:get_string("levels"))
		if t then
			for i = 1, #t do
				if t[i] ~= "" then
					elements = elements..t[i]..","
				end
			end
		end
	end
	elements = elements:sub(1, #elements - 1)
	meta:set_string("celected", "")
	local formspec = "size[8,8]"
	.."textlist[0,0;4,8;levels;"..elements.."]"
	.."background9[5,5;1,1;gui_formbg.png;true;10]"
	.."button[5,0;2,1;play;Play]"
	.."button[5,1;2,1;create;Create]"
	.."button[5,2;2,1;change;Change]"
	.."button[5,3;2,1;delete;Delete]"
	.."button[5,4;2,1;import;Import]"
	return formspec		
end
minetest.register_on_joinplayer(function(player)
	local name = player:get_player_name()
    player:hud_set_flags({hotbar=false, healthbar=false, breathbar=false, wielditem=false, minimap=false, minimap_radar=false})
	player:hud_add({
		hud_elem_type = "text",
		position = {x=0, y=0.85},
		offset = {x=0, y=10},
		alignment = {x=1, y=0},
		number = 0xFFFFFF ,
		text = "For Minetest 	  :  5.7.0",
	})
	player:hud_add({
		hud_elem_type = "text",
		position = {x=0, y=0.85},
		offset = {x=0, y=30},
		alignment = {x=1, y=0},
		number = 0xFFFFFF ,
		text = "Game Version	 :  2.18.0",
	})
    hud_levels[name] = player:hud_add({
		hud_elem_type = "text",
		position = {x=0, y=0.85},
		offset = {x=0, y=-710},
		alignment = {x=1, y=0},
		number = 0xFFFFFF ,
		text = "Level: /",
	})
	for i=1,9 do
		hud[""..i] = player:hud_add({
			hud_elem_type = "image",
			position = {x=0, y=0.85},
			offset = {x=70, y=-10-(i*70)},
			alignment = {x=0, y=0},
			scale = {x=6, y=6},
			text = "labyrinthus_glass.png",
		})
	end
	player:set_inventory_formspec(main.get_formspec(player))
	if not minetest.is_singleplayer() then
		minetest.kick_player(player:get_player_name(), "You can play Sudoku only in singleplayer")
	end
end)

local node_list1 = {
	{"0","labyrinthus:sand",					"labyrinthus_sand.png",														1,	1,	true},
	{"1","labyrinthus:water",					"labyrinthus_water.png",													10,	3,	true},
	{"2","labyrinthus:rainbow",					"nyancat_rainbow.png",														2,	1,	false},
	{"3","labyrinthus:red1",					"labyrinthus_red1.png",														5,	1,	true},
	{"4","labyrinthus:green1",					"labyrinthus_green1.png",													6,	1,	true},
	{"5","labyrinthus:button1",					"labyrinthus_sand.png^labyrinthus_button.png",								1,	2,	true},
	{"6","labyrinthus:blue1",					"labyrinthus_blue1.png",													7,	1,	true},
	{"7","labyrinthus:green_col",				"labyrinthus_sand.png^labyrinthus_green_col.png",							9,	1,	true},
	{"8","labyrinthus:red_col",					"labyrinthus_sand.png^labyrinthus_red_col.png",								8,	1,	true},
	{"9","labyrinthus:blue_col",				"labyrinthus_sand.png^labyrinthus_blue_col.png",							10,	1,	true},
	{"a","labyrinthus:key2",					"labyrinthus_sand.png^labyrinthus_key.png",									2,	2,	true},
	{"b","labyrinthus:tp",						"labyrinthus_sand.png^labyrinthus_tp.png",									3,	2,	true},
	{"c","labyrinthus:ball1",					"labyrinthus_sand.png^labyrinthus_ball.png",								7,	2,	true},
	{"d","labyrinthus:boom",					"labyrinthus_sand.png^labyrinthus_boom.png",								8,	2,	true},
	{"e","labyrinthus:00",						"labyrinthus_sand.png^labyrinthus_0.png",									9,	2,	true},
	{"f","labyrinthus:eye1",					"labyrinthus_sand.png^labyrinthus_eye.png",									10,	2,	true},
	{"g","labyrinthus:box",						"labyrinthus_sand.png^labyrinthus_box.png",									4,	1,	true},
	{"h","labyrinthus:bones",					"labyrinthus_bones_front.png",												11,	2,	true},
	{"i","labyrinthus:button11",				"labyrinthus_sand.png^labyrinthus_button1.png",								12,	2,	true},
	{"j","labyrinthus:fire",					"labyrinthus_sand.png^labyrinthus_flame.png",								13,	2,	true},
	{"k","labyrinthus:arrow",					"labyrinthus_sand.png^labyrinthus_arrow.png",								11,	6,	true},
	{"l","labyrinthus:round2",					"labyrinthus_sand.png^labyrinthus_round2.png",								5,	3,	true},
	{"m","labyrinthus:round3",					"labyrinthus_sand.png^labyrinthus_round3.png",								4,	3,	true},
	{"n","labyrinthus:arrow2",					"labyrinthus_sand.png^labyrinthus_arrow2.png",								12,	6,	true},
	{"o","labyrinthus:red_sand",				"labyrinthus_sand.png^labyrinthus_red.png",									1,	3,	true},
	{"p","labyrinthus:moon",					"labyrinthus_sand.png^labyrinthus_moon.png",								7,	3,	true},
	{"q","labyrinthus:sun",						"labyrinthus_sand.png^labyrinthus_sun.png",									8,	3,	true},
	{"r","labyrinthus:water_wood",				"labyrinthus_water.png^labyrinthus_water_wood.png",							3,	4,	true},
	{"s","labyrinthus:time30",					"labyrinthus_sand.png^labyrinthus_time30.png",								9,	3,	false},
	{"t","labyrinthus:ice1",					"labyrinthus_ice.png",														13,	3,	true},
	{"u","labyrinthus:ice2",					"labyrinthus_ice2.png",														12,	3,	true},
	{"v","labyrinthus:ice3",					"labyrinthus_ice3.png",														11,	3,	true},
	{"w","labyrinthus:round4",					"labyrinthus_sand.png^labyrinthus_round4.png",								6,	3,	true},
	{"x","labyrinthus:round1",					"labyrinthus_sand.png^labyrinthus_round1.png",								3,	3,	true},
	{"y","labyrinthus:dirt",					"labyrinthus_dirt.png",														4,	4,	true},
	{"z","labyrinthus:rainbow2",				"labyrinthus_rainbow2.png",													3,	1,	true},
	{"A","labyrinthus:purple",					"labyrinthus_sand.png^labyrinthus_purple.png",								5,	4,	true},
	{"B","labyrinthus:empty_gate",				"labyrinthus_sand.png^labyrinthus_empty_gate.png",							8,	4,	true},
	{"C","labyrinthus:gate_arrows",				"labyrinthus_sand.png^labyrinthus_gate_arrows.png",							7,	4,	true},
	{"D","labyrinthus:red_cross",				"labyrinthus_sand.png^labyrinthus_red_cross.png",							11,	1,	true},
	{"E","labyrinthus:green_cross",				"labyrinthus_sand.png^labyrinthus_green_cross.png",							12,	1,	true},
	{"F","labyrinthus:blue_cross",				"labyrinthus_sand.png^labyrinthus_blue_cross.png",							13,	1,	true},
	{"G","labyrinthus:purple_dirt",				"labyrinthus_dirt.png^labyrinthus_purple.png",								6,	4,	true},
	{"H","labyrinthus:gate",					"labyrinthus_sand.png^labyrinthus_gate.png",								9,	4,	true},
	{"I","labyrinthus:green",					"labyrinthus_sand.png^labyrinthus_green.png",								10,	4,	true},
	{"J","labyrinthus:water_wood_with_green",	"labyrinthus_water.png^labyrinthus_water_wood_with_green.png",				12,	4,	true},
	{"K","labyrinthus:sand_for_green",			"labyrinthus_sand.png^labyrinthus_stone_for_green.png",						3,	5,	true},
	{"L","labyrinthus:cyan",					"labyrinthus_sand.png^labyrinthus_cyan.png",								4,	6,	true},
	{"M","labyrinthus:bow",						"labyrinthus_sand.png^labyrinthus_bow.png",									7,	6,	true},
	{"N","labyrinthus:arrow4_2",				"labyrinthus_sand.png^labyrinthus_arrow4_2.png",							10,	6,	true},
	{"O","labyrinthus:green_dirt",				"labyrinthus_dirt.png^labyrinthus_green.png",								11,	4,	true},
	{"P","labyrinthus:cyan_dirt",				"labyrinthus_dirt.png^labyrinthus_cyan.png",								5,	6,	true},
	{"Q","labyrinthus:tp2",						"labyrinthus_sand.png^labyrinthus_tp2.png",									4,	2,	true},
	{"R","labyrinthus:yellow2",					"labyrinthus_sand.png^labyrinthus_yellow2.png",								5,	5,	true},
	{"S","labyrinthus:yellow_dirt",				"labyrinthus_dirt.png^labyrinthus_yellow2.png",								6,	5,	true},
	{"T","labyrinthus:wood_for_yellow",			"labyrinthus_wood.png^labyrinthus_stone_for_yellow.png",					10,	5,	true},
	{"U","labyrinthus:water_stone",				"labyrinthus_water.png^labyrinthus_water_stone.png",						11,	5,	true},
	{"V","labyrinthus:sand_for_green_dirt",		"labyrinthus_dirt.png^labyrinthus_stone_for_green.png",						4,	5,	true},
	{"W","labyrinthus:red3",					"labyrinthus_sand.png^labyrinthus_red3.png",								12,	5,	true},
	{"X","labyrinthus:water_wood_with_red",		"labyrinthus_water.png^labyrinthus_water_wood_with_red.png",				1,	6,	true},
	{"Y","labyrinthus:wood",					"labyrinthus_wood.png",														9,	5, 	true},
	{"Z","labyrinthus:white",					"labyrinthus_sand.png^labyrinthus_white.png",								2,	6,	true},
	{":","labyrinthus:tp3",						"labyrinthus_sand.png^labyrinthus_tp3.png",									5,	2,	true},
	{";","labyrinthus:ice_with_green",			"labyrinthus_ice3.png^labyrinthus_green.png",								13,	4,	true},
	{"<","labyrinthus:ice_with_white",			"labyrinthus_ice3.png^labyrinthus_white.png",								3,	6,	true},
	{">","labyrinthus:button_eye",				"labyrinthus_sand.png^labyrinthus_button_eye.png",							1,	4,	true},
	{"|","labyrinthus:water_eye1",				"labyrinthus_water.png^labyrinthus_water_eye.png",							2,	4,	false},
	{".","labyrinthus:water_eye1_with_yellow",	"labyrinthus_water.png^labyrinthus_water_eye.png^labyrinthus_yellow2.png",	8,	5,	false},
	{",","labyrinthus:water_eye1_with_cyan",	"labyrinthus_water.png^labyrinthus_water_eye.png^labyrinthus_cyan.png",		6,	6,	false},
	{"-","labyrinthus:arrow_path",				"labyrinthus_sand.png^labyrinthus_arrow_path.png",							8,	6,	true},
	{"_","labyrinthus:arrow_path_button",		"labyrinthus_sand.png^labyrinthus_arrow_path_button.png",					9,	6,	true},
	{"#","labyrinthus:ball3",					"labyrinthus_sand.png^labyrinthus_ball2.png",								6,	2,	true},
	{"'","labyrinthus:ice_with_yellow",			"labyrinthus_ice3.png^labyrinthus_yellow2.png",								7,	5,	true},
	{"*","labyrinthus:dirt_with_yellow_circle",	"labyrinthus_dirt.png^labyrinthus_yellow_circle.png",						13,	6,	true},
	{"+","labyrinthus:dirt_with_red_circle",	"labyrinthus_dirt.png^labyrinthus_red_circle.png",							1,	7,	true},
	{"~","labyrinthus:arrow_path_with_green",	"labyrinthus_sand.png^labyrinthus_arrow_path.png^labyrinthus_green.png",	2,	5,	true},
	{"@","labyrinthus:cross_red",				"labyrinthus_sand.png^labyrinthus_cross_red.png",							3,	7,	true},
	{"?","labyrinthus:cross_green",				"labyrinthus_sand.png^labyrinthus_cross_green.png",							4,	7,	true},
	{"\\","labyrinthus:cross_switch",			"labyrinthus_sand.png^labyrinthus_cross_switch.png",						2,	7,	true},
	{"{","labyrinthus:grey_sand",				"labyrinthus_sand.png^labyrinthus_grey3.png",								2,	3,	true},
	{"[","labyrinthus:red_dirt",				"labyrinthus_dirt.png^labyrinthus_red3.png",								13,	5,	true},
	{"]","labyrinthus:water_eye1_with_green",	"labyrinthus_water.png^labyrinthus_water_eye.png^labyrinthus_green.png",	1,	5,	false},
	
	{"!","labyrinthus:button12",				"labyrinthus_sand.png^labyrinthus_button2.png",								0, 	0,	true},
	{"$","labyrinthus:button2_1",				"labyrinthus_sand.png^labyrinthus_button_2.png",							0,	0,	true},
	{"%","labyrinthus:empty_gate_purple",		"labyrinthus_sand.png^labyrinthus_gate_with_purple.png",					0, 	0,	true},
	{"&","labyrinthus:gate",					"",																			0, 	0,	false},
	{"/","labyrinthus:button3_1",				"labyrinthus_sand.png^labyrinthus_button_3.png",							0,	0,	true},
	{"(","labyrinthus:water_eye2",				"labyrinthus_water.png^labyrinthus_water_eye.png",							0,	0,	true},
	{")","labyrinthus:water_eye2_with_yellow",	"labyrinthus_water.png^labyrinthus_water_eye.png^labyrinthus_yellow2.png",	0,	0,	true},
	{"=","labyrinthus:water_eye2_with_cyan",	"labyrinthus_water.png^labyrinthus_water_eye.png^labyrinthus_cyan.png",		0,	0,	true},
	{"}","labyrinthus:water_eye2_with_green",	"labyrinthus_water.png^labyrinthus_water_eye.png^labyrinthus_green.png",	0,	0,	true},
	{"`","labyrinthus:button2_2",				"labyrinthus_dirt.png^labyrinthus_button_2.png",							0,	0,	true},
	{"^","labyrinthus:button3_2",				"labyrinthus_dirt.png^labyrinthus_button_3.png",							0,	0,	true},
	--noch offen: 93/94   "
}

local node_list2 = {
	{"0","air",											"",																	1,	1,	false},
	{"1","labyrinthus:junglewood",						"labyrinthus_junglewood.png",										5,	1,	true},
	{"2","labyrinthus:stone",							"labyrinthus_stone.png",											3,	1,	true},
	{"3","labyrinthus:meselamp2",						"labyrinthus_meselamp2.png",										5,	2,	true},
	{"4","labyrinthus:red2",							"labyrinthus_ball_red.png",											8,	1,	false},
	{"5","labyrinthus:green2",							"labyrinthus_ball_green.png",										9,	1,	false},
	{"6","labyrinthus:button2",							"labyrinthus_stone.png^labyrinthus_button_2.png",					1,	2,	true},
	{"7","labyrinthus:blue2",							"labyrinthus_ball_blue.png",										10,	1,	false},
	{"8","labyrinthus:key1",							"labyrinthus_stone.png^labyrinthus_key2.png",						3,	2,	true},
	{"9","labyrinthus:diamondblock",					"labyrinthus_diamond_block.png",									6,	2,	true},
	{"a","labyrinthus:pbj_pup",							"labyrinthus_pup_front.png",										7,	2,	false},
	{"b","labyrinthus:cobble",							"labyrinthus_cobble.png",											8,	2,	true},
	{"c","labyrinthus:tnt",								"labyrinthus_tnt_side.png",											9,	2,	true},
	{"d","labyrinthus:apple",							"labyrinthus_apple.png",											4,	1,	false},
	{"e","labyrinthus:4",								"labyrinthus_mese_block.png^labyrinthus_4.png",						10,	2,	true},
	{"f","labyrinthus:3",								"labyrinthus_mese_block.png^labyrinthus_3.png",						11,	2,	true},
	{"g","labyrinthus:2",								"labyrinthus_mese_block.png^labyrinthus_2.png",						12,	2,	true},
	{"h","labyrinthus:1",								"labyrinthus_mese_block.png^labyrinthus_1.png",						13,	2,	true},
	{"i","labyrinthus:eye2",							"labyrinthus_mese_block.png^labyrinthus_eye.png",					1,	3,	true},
	{"j","labyrinthus:red",								"labyrinthus_mese_block.png^labyrinthus_red.png",					3,	3,	true},
	{"k","labyrinthus:blue",							"labyrinthus_mese_block.png^labyrinthus_blue.png",					4,	3,	true},
	{"l","labyrinthus:yellow",							"labyrinthus_mese_block.png^labyrinthus_yellow.png",				5,	3,	true},
	{"m","labyrinthus:glass",							"labyrinthus_eye2.png",												2,	3,	false},
	{"n","labyrinthus:nyan1",							"labyrinthus_part1.png",											12,	3,	true},
	{"o","labyrinthus:nyan2",							"labyrinthus_part2.png",											13,	3,	true},
	{"p","labyrinthus:nyan3",							"labyrinthus_part3.png",											1,	4,	true},
	{"q","labyrinthus:nyan4",							"labyrinthus_part4.png",											2,	4,	true},
	{"r","labyrinthus:arrow3",							"labyrinthus_mese_block.png^labyrinthus_arrow2.png",				12,	5,	true},
	{"s","labyrinthus:leaves",							"labyrinthus_leaves.png",											2,	5,	false},
	{"t","labyrinthus:water_ball",						"labyrinthus_ball_water.png",										7,	1,	false},
	{"u","labyrinthus:transport_stone",					"labyrinthus_mese_block.png^labyrinthus_gate_arrows2.png",			8,	4,	true},
	{"v","labyrinthus:red_pyramid",						"labyrinthus_pyramid_red.png",										11,	1,	false},
	{"w","labyrinthus:green_pyramid",					"labyrinthus_pyramid_green.png",									12,	1,	false},
	{"x","labyrinthus:blue_pyramid",					"labyrinthus_pyramid_blue.png",										13,	1,	false},
	{"y","labyrinthus:bow_right",						"labyrinthus_mese_block.png^labyrinthus_bow_right.png",				3,	5,	true},
	{"z","labyrinthus:bow_left",						"labyrinthus_mese_block.png^labyrinthus_bow_left.png",				4,	5,	true},
	{"A","labyrinthus:bow_down",						"labyrinthus_mese_block.png^labyrinthus_bow_down.png",				5,	5,	true},
	{"B","labyrinthus:bow_up",							"labyrinthus_mese_block.png^labyrinthus_bow_up.png",				6,	5,	true},
	{"C","labyrinthus:button3",							"labyrinthus_stone.png^labyrinthus_button_3.png",					2,	2,	true},
	{"D","labyrinthus:yellow_block",					"labyrinthus_stone.png^labyrinthus_yellow_arrow.png",				10,	4,	false},
	{"E","labyrinthus:yellow_red",						"labyrinthus_stone.png^labyrinthus_yellow_red.png",					11,	4,	true},
	{"F","labyrinthus:stone_for_white",					"labyrinthus_stone.png^labyrinthus_stone_for_white.png",			12,	4,	true},
	{"G","labyrinthus:stone_with_no_white1",			"labyrinthus_mese_block.png^labyrinthus_stone_with_no_white.png",	13,	4,	true},
	{"H","labyrinthus:remember1_off",					"labyrinthus_mese_block.png^labyrinthus_remember1.png",				3,	4,	false},
	{"I","labyrinthus:remember2_off",					"labyrinthus_mese_block.png^labyrinthus_remember2.png",				4,	4,	false},
	{"J","labyrinthus:remember3_off",					"labyrinthus_mese_block.png^labyrinthus_remember3.png",				5,	4,	false},
	{"K","labyrinthus:remember4_off",					"labyrinthus_mese_block.png^labyrinthus_remember4.png",				6,	4,	false},
	{"L","labyrinthus:remember5_off",					"labyrinthus_mese_block.png^labyrinthus_remember5.png",				7,	4,	false},
	{"M","labyrinthus:arrow4",							"labyrinthus_mese_block.png^labyrinthus_arrow4.png",				11,	5,	true},
	{"N","labyrinthus:arrow5_yellow",					"labyrinthus_mese_block.png^labyrinthus_arrow5_yellow.png",			13,	5,	true},
	{"O","labyrinthus:arrow5_red",						"labyrinthus_mese_block.png^labyrinthus_arrow5_red.png",			1,	6,	true},
	{"P","labyrinthus:key3",							"labyrinthus_stone.png^labyrinthus_key3.png",						4,	2,	true},
	{"Q","labyrinthus:2red",							"labyrinthus_mese_block.png^labyrinthus_2red.png",					9,	3,	true},
	{"R","labyrinthus:2blue",							"labyrinthus_mese_block.png^labyrinthus_2blue.png",					10,	3,	true},
	{"S","labyrinthus:2yellow",							"labyrinthus_mese_block.png^labyrinthus_2yellow.png",				11,	3,	true},
	{"T","labyrinthus:grey1",							"labyrinthus_mese_block.png^labyrinthus_grey1.png",					8,	3,	true},
	{"U","labyrinthus:grey2",							"labyrinthus_mese_block.png^labyrinthus_grey2.png",					7,	3,	true},
	{"V","labyrinthus:grey3",							"labyrinthus_mese_block.png^labyrinthus_grey3.png",					6,	3,	true},
	{"W","labyrinthus:backward_arrow",					"labyrinthus_mese_block.png^labyrinthus_backward_arrow.png",		9,	4,	true},
	{"X","labyrinthus:wood2",							"labyrinthus_wood2.png",											6,	1,	true},
	{"Y","labyrinthus:bow_right_block",					"labyrinthus_stone.png^labyrinthus_bow_right2.png",					7,	5,	true},
	{"Z","labyrinthus:bow_left_block",					"labyrinthus_stone.png^labyrinthus_bow_left2.png",					8,	5,	true},
	{"'","labyrinthus:bow_down_block",					"labyrinthus_stone.png^labyrinthus_bow_down2.png",					9,	5,	true},
	{"*","labyrinthus:bow_up_block",					"labyrinthus_stone.png^labyrinthus_bow_up2.png",					10,	5,	true},
	{"+","labyrinthus:stone_with_white2",				"labyrinthus_stone.png^labyrinthus_stone_with_white2.png",			1,	5,	true},
	
	{"!","nyancat:nyancat",								"",																	0,	0,	false},
	{"$","labyrinthus:button13",						"labyrinthus_stone.png^labyrinthus_button2.png",					0,	0,	true},
	{"%","labyrinthus:transport_stone_gate_arrows",		"labyrinthus_mese_block.png^labyrinthus_gate_arrows3.png",			0,	0,	true},
	{"&","labyrinthus:red_with_no_yellow",				"labyrinthus_stone.png^labyrinthus_red_with_no_yellow.png",			0,	0,	true},
	{"/","labyrinthus:stone_with_white",				"labyrinthus_stone.png^labyrinthus_stone_with_white.png",			0,	0,	true},
	{")","labyrinthus:stone_with_no_white2",			"labyrinthus_stone.png^labyrinthus_stone_with_no_white.png",		0,	0,	true},
	{"=","labyrinthus:remember1_on",					"labyrinthus_stone.png^labyrinthus_remember1.png",					0,	0,	true},
	{"[","labyrinthus:remember2_on",					"labyrinthus_stone.png^labyrinthus_remember2.png",					0,	0,	true},
	{"]","labyrinthus:remember3_on",					"labyrinthus_stone.png^labyrinthus_remember3.png",					0,	0,	true},
	{"{","labyrinthus:remember4_on",					"labyrinthus_stone.png^labyrinthus_remember4.png",					0,	0,	true},
	{"}","labyrinthus:remember5_on",					"labyrinthus_stone.png^labyrinthus_remember5.png",					0,	0,	true},
	{"?","labyrinthus:remember5_temp",					"labyrinthus_stone.png^labyrinthus_remember5.png",					0,	0,	true},
	{"\\","labyrinthus:0",								"labyrinthus_stone.png^labyrinthus_0.png",							0,	0,	true},
	{":","labyrinthus:wire_10100000",					"",																	0,	0,	false},
	{";","labyrinthus:wire_10000000",					"",																	0,	0,	false},
	{"<","labyrinthus:wire_01000000",					"",																	0,	0,	false},
	{">","labyrinthus:wire_00100000",					"",																	0,	0,	false},
	{"|","labyrinthus:wire_00010000",					"",																	0,	0,	false},
	{".","labyrinthus:wire_01010000",					"",																	0,	0,	false},
	{",","labyrinthus:wire_11000000",					"",																	0,	0,	false},
	{"-","labyrinthus:wire_01100000",					"",																	0,	0,	false},
	{"_","labyrinthus:wire_00110000",					"",																	0,	0,	false},
	{"#","labyrinthus:wire_10010000",					"",																	0,	0,	false},	
	--noch offen 88/94	` ^ " ( @ ~
}

function get_item_list(list,index,index_number,number)
	for index2, value in ipairs(list) do
        if value[index_number] == index then
            return list[index2][number]
        end
    end
	return ""
end

function get_item_list2(list, x, y, row_num)
	for _, row in ipairs(list) do
		if row[4] == x and row[5] == y then
			return row[row_num]
		end
	end
	return ""
end

function utf8_char(s,n)
	local k = 0
	for uchar in string.gmatch(s, "([%z\1-\127\194-\244][\128-\191]*)") do
        k = k+1
		if k == n then
			return uchar
		end
    end
	return ""
end

minetest.register_globalstep(function(dtime)
	timer = timer + dtime
    timer2 = timer2 + dtime
	local dots_change = true
	local players = minetest.get_connected_players()
	for _,player in ipairs(players) do
		if timer2 >= 1 then
			timer2 = 0
			change_timer(player)
			minetest.set_timeofday(0.5)
        end
		if timer >= 0.355 and dots_change then
			dots_change = false
			timer = 0
			change_dots(player)
		end
    end
	update()
end)


function change_timer(player)
	local message = true
	local player_inv = player:get_inventory()
	local time = player_inv:get_stack("time", 1):get_count()
	local x = player_inv:get_stack("x", 1):get_count()
	local y = player_inv:get_stack("y", 1):get_count()
	for j=10,29 do
		for l=9,20 do
			for m=0,30 do
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:time"..m and (time == 2 or pon == 2) and y ~= 0 then
					if m ~= 0 then
						minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:time"..(m-1)})
						if message then
							minetest.chat_send_all((m-1).."sec left")
							message = false
						end
					else
						player_inv:set_stack("x", 1, nil)
						player_inv:set_stack("y", 1, nil)
						minetest.chat_send_all("you run out of time")
						for j=10,29 do
							for l=9,20 do
								if minetest.get_node({x=j, y=l, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:nyancat2" then
									minetest.set_node({x=j, y=l, z=-77}, {name="air"})
								end
							end
						end
					end 
				end
			end
		end
	end
end


function dot_help(j, l)
	return (minetest.get_node({x=j, y=l, z=-77}).name == "air" or (minetest.get_node({x=j, y=l, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:nyancat2"))
end

local directions = {
    {x = -1, y = 0, r = 1},  -- links
    {x =  0, y = 1, r = 2},  -- oben
    {x =  0, y = -1, r = 4}, -- unten
    {x =  1, y = 0, r = 3}   -- rechts
}

local directions2 = {
	{x =  0, y = 1, r = 2},  -- oben
	{x =  1, y = 0, r = 3},   -- rechts
	{x =  0, y = -1, r = 4}, -- unten
    {x = -1, y = 0, r = 1},  -- links
}

local function check_direction(x, y, dx, dy)
    local node_name = minetest.get_node({x = x + dx, y = y + dy, z = -76}).name
    if node_name == "labyrinthus:round3" and dot_help(x + dx, y + dy) then
        return true, "round3"
    elseif node_name == "labyrinthus:round1" and dot_help(x + dx, y + dy) then
        return true, "round1"
    end
    return false
end


function change_dots()
	local dd = 0
    local dd2 = 0
	for j=10,29 do
		for l=9,20 do
			if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:round2" and dd == 0 then
				local d = 0
				for k=1,2 do
					if d == 0 then
						if rrr == 0 then
							for _, dir in ipairs(directions) do
								local valid, node_type = check_direction(j, l, dir.x, dir.y)
								if valid then
									rrr = dir.r
									break
								end
							end
							if rrr == 0 then
								rrr = 3
							end
						end
						for _, dir in ipairs(directions) do
							if rrr == dir.r then
								local valid, node_type = check_direction(j, l, dir.x, dir.y)
								if valid then
									minetest.set_node({x = j, y = l, z = -76}, {name = "labyrinthus:round1"})
									minetest.set_node({x = j + dir.x, y = l + dir.y, z = -76}, {name = "labyrinthus:round2"})
									d = 1
									dd = 1
									break
								else
									local localr = rrr+1
									local locall = rrr-1
									if localr == 5 then
										localr = 1
									end
									if locall == 0 then
										locall = 4
									end
									local dirr = 0
									for _, dir2 in ipairs(directions) do
										if dir2.r == localr then
											dirr = dir2
											break
										end
									end
									local dirl = 0
									for _, dir2 in ipairs(directions) do
										if dir2.r == locall then
											dirl = dir2
											break
										end
									end
									local valid2, node_type2 = check_direction(j, l, dirr.x, dirr.y)
									local valid3, node_type3 = check_direction(j, l, dirl.x, dirl.y)
									if valid2 and node_type2 == "round3" then
										rrr = dirr.r
									elseif valid3 and node_type3 == "round3" then
										rrr = dirl.r
									elseif valid2 and node_type2 == "round1" then
										rrr = dirr.r
									elseif valid3 and node_type3 == "round1" then
										rrr = dirl.r
									else
										rrr = rrr+2
										if rrr > 4 then
											rrr = rrr-4
										end
									end
								end
							end
						end
					end
				end
				if d == 0 then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:round1"})
				end
			end
			if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:round4" and dd2 == 0 then
				local d = 0
				for k=1,2 do
					if d == 0 then
						if rrrr == 0 then
							for _, dir in ipairs(directions2) do
								local valid, node_type = check_direction(j, l, dir.x, dir.y)
								if valid then
									rrrr = dir.r
									break
								end
							end
							if rrrr == 0 then
								rrrr = 3
							end
						end
						for _, dir in ipairs(directions) do
							if rrrr == dir.r then
								local valid, node_type = check_direction(j, l, dir.x, dir.y)
								if valid then
									minetest.set_node({x = j, y = l, z = -76}, {name = "labyrinthus:round1"})
									minetest.set_node({x = j + dir.x, y = l + dir.y, z = -76}, {name = "labyrinthus:round4"})
									d = 1
									dd2 = 1
									break
								else
									local localr = rrrr+1
									local locall = rrrr-1
									if localr == 5 then
										localr = 1
									end
									if locall == 0 then
										locall = 4
									end
									local dirr = 0
									for _, dir2 in ipairs(directions) do
										if dir2.r == localr then
											dirr = dir2
											break
										end
									end
									local dirl = 0
									for _, dir2 in ipairs(directions) do
										if dir2.r == locall then
											dirl = dir2
											break
										end
									end
									local valid2, node_type2 = check_direction(j, l, dirr.x, dirr.y)
									local valid3, node_type3 = check_direction(j, l, dirl.x, dirl.y)
									if valid2 and node_type2 == "round3" and rrrr < 3 then
										rrrr = dirr.r
									elseif valid3 and node_type3 == "round3" and rrrr < 3 then
										rrrr = dirl.r
									elseif valid2 and node_type2 == "round1" and rrrr < 3 then
										rrrr = dirr.r
									elseif valid3 and node_type3 == "round1" and rrrr < 3 then
										rrrr = dirl.r
									elseif valid2 and valid3 and node_type2 == "round3" and node_type3 == "round3" and rrrr > 2 then
										rrrr = dirl.r
									elseif valid2 and valid3 and node_type2 == "round1" and node_type3 == "round1" and rrrr > 2 then
										rrrr = dirl.r
									elseif valid2 and valid3 and node_type2 == "round3" and node_type3 == "round1" and rrrr > 2 then
										rrrr = dirr.r
									elseif valid2 and valid3 and node_type2 == "round1" and node_type3 == "round3" and rrrr > 2 then
										rrrr = dirl.r
									elseif valid3 and (node_type3 == "round1" or node_type3 == "round3") and rrrr > 2 then
										rrrr = dirl.r
									elseif valid2 and (node_type2 == "round1" or node_type2 == "round3") and rrrr > 2 then
										rrrr = dirr.r
									else
										rrrr = rrrr+2
										if rrrr > 4 then
											rrrr = rrrr-4
										end
									end
								end
							end
						end
					end
				end
				if d == 0 then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:round1"})
				end
			end
		end
	end
end

local create = {}
create.get_formspec = function(player, pos)
	if player == nil then
        return
    end
	local formspec = "size[5.5,3]"
		.."background9[5,5;1,1;gui_formbg.png;true;10]"
        .."label[0.15,0.5;own_level_]"
		.."label[4.85,0.5;.txt]"
		.."field[1.55,0.85;3.8,0.5;input2;;]"
		.."button[1.75,1.3;2,1;create2;Set Name]"
	return formspec		
end
function letter(i)
	return string.char(i+96)
end
local create2 = {}
create2.get_formspec = function(player, pos)
	if player == nil then
        return
    end
	local formspec = "size[20.5,12]"
	.."background9[5,5;1,1;gui_formbg.png;true;10]"
	for i=0,20 do
		for j=0,12 do
			if i == 0 and j ~= 0 then
				formspec = formspec.."image_button["..(0.5+i*0.45)..","..(0.5+j*0.5)..";0.6,0.6;;raa"..letter(j)..";"..j.."]"
			elseif j == 0 and i ~= 0 then
				formspec = formspec.."image_button["..(0.5+i*0.45)..","..(0.5+j*0.5)..";0.6,0.6;;rab"..letter(i)..";"..i.."]"
			elseif j ~= 0 and i ~= 0 then
				local meta = player:get_meta()
				local ind = meta:get_string("na"..letter(i)..letter(j))
				local img = get_item_list(node_list1,ind,1,3)
				formspec = formspec.."image_button["..(0.5+i*0.45)..","..(0.5+j*0.5)..";0.6,0.6;"..img..";na"..letter(i)..letter(j)..";]"
			end
		end
	end
	for i=0,20 do
		for j=0,12 do
			if i == 0 and j ~= 0 then
				formspec = formspec.."image_button["..(10+0.5+i*0.45)..","..(0.5+j*0.5)..";0.6,0.6;;rba"..letter(j)..";"..j.."]"
			elseif j == 0 and i ~= 0 then
				formspec = formspec.."image_button["..(10+0.5+i*0.45)..","..(0.5+j*0.5)..";0.6,0.6;;rbb"..letter(i)..";"..i.."]"
			elseif j ~= 0 and i ~= 0 then
				local meta = player:get_meta()
				local ind = meta:get_string("nb"..letter(i)..letter(j))
				local img = ""
				if ind == "nn" then
					img = "nyancat_front.png"
				else
					img = get_item_list(node_list2,ind,1,3)
				end
				formspec = formspec.."image_button["..(10+0.5+i*0.45)..","..(0.5+j*0.5)..";0.6,0.6;"..img..";nb"..letter(i)..letter(j)..";]"
			end
		end
	end
	local meta = player:get_meta()
	local message = meta:get_string("error_message")
	formspec = formspec
	.."label[8.3,8.5;"..message.."]"
	.."background["..(0.572+(meta:get_string("new_node1x")+3)*0.45)..","..(0.53+(meta:get_string("new_node1y")+13)*0.5)..";0.47,0.557;labyrinthus_edge.png]"
	.."background["..(10.572+(meta:get_string("new_node2x")+3)*0.45)..","..(0.53+(meta:get_string("new_node2y")+13)*0.5)..";0.47,0.557;labyrinthus_edge.png]"
	.."button[8,11;2,1;save;Save]"
	.."button[10,11;2,1;back;Back]"
	for row = 1, 7 do
		local row_labels1 = "sa" .. string.char(96 + row)
		local row_labels2 = "sb" .. string.char(96 + row)
		for col = 1, 13 do
			local x1 = 0.5 + (col + 3) * 0.45
			local x2 = 10.5 + (col + 3) * 0.45
			local y = 0.5 + (13 + row) * 0.5
			local img1 = get_item_list2(node_list1, col, row, 3)
			local img2 = get_item_list2(node_list2, col, row, 3)
			if row == 1 and col == 2 then
				img2 = "nyancat_front.png"
			end
			local name1 = row_labels1 .. string.char(96 + col) -- a,b,c...
			local name2 = row_labels2 .. string.char(96 + col) -- a,b,c...
			if row < 7 or col < 5 then
				formspec = formspec .. string.format("image_button[%.2f,%.2f;0.6,0.6;%s;%s;]", x1, y, img1, name1)
			end
			if row < 6 or (row < 7 and col < 2) then
				formspec = formspec .. string.format("image_button[%.2f,%.2f;0.6,0.6;%s;%s;]", x2, y, img2, name2)
			end
		end
	end
	return formspec		
end

local import = {}
import.get_formspec = function(player, pos)
	if player == nil then
        return
    end
	local formspec = "size[5.5,3]"
		.."background9[5,5;1,1;gui_formbg.png;true;10]"
        .."label[0.15,0.5;own_level_]"
		.."label[4.85,0.5;.txt]"
		.."field[1.55,0.85;3.8,0.5;input1;;]"
		.."button[1.75,1.3;2,1;import2;Import]"
	return formspec		
end

local delete = {}
delete.get_formspec = function(player, pos)
	if player == nil then
        return
    end
	local formspec = "size[5.5,3]"
		.."background9[5,5;1,1;gui_formbg.png;true;10]"
        .."label[0.1,0.5;Do you want to delete the level from the inventory list?]"
		.."button[0.75,1.3;2,1;delete2;Yes]"
		.."button[2.75,1.3;2,1;main;No]"
	return formspec		
end

local back = {}
back.get_formspec = function(player, pos)
	if player == nil then
        return
    end
	local formspec = "size[5.5,3]"
		.."background9[5,5;1,1;gui_formbg.png;true;10]"
        .."label[0,0.5;Do you want to go back? You will lose you builded level.]"
		.."button[0.75,1.3;2,1;main;Yes]"
		.."button[2.75,1.3;2,1;create2;No]"
	return formspec		
end

local info = {}
info.get_formspec = function(player, txt)
	if player == nil then
        return
    end
	local formspec = "size[5.5,3]"
		.."background9[5,5;1,1;gui_formbg.png;true;10]"
        .."label[0,0.5;"..txt.."]"
		.."button[1.5,1.3;2,1;main;Ok]"
	return formspec		
end


function fsize (file)
    local current = file:seek()      -- get current position
    local size = file:seek("end")    -- get file size
    file:seek("set", current)        -- restore position
    return size
end
function move_data(player)
    local file = io.open(minetest.get_worldpath().."/move1.txt", "w")
    local t = ""
    local tt = ""
    local k = 21	
    for l=1,12 do
        k = k-1
        for j=10,29 do
			local e = true
            if minetest.get_node({x=j, y=k, z=-76}).name == "nyancat:nyancat_rainbow" then
                t = t.."2"
				e = false
			elseif minetest.get_node({x=j, y=k, z=-76}).name == "labyrinthus:rainbow3" then
                t = t.."z"
				e = false
            end
            for i=0,30 do
                if minetest.get_node({x=j, y=k, z=-76}).name == "labyrinthus:time"..i then
                    t = t.."s"
                    tt = ""..i
					e = false
                end
            end
			if e then
				t = t..get_item_list(node_list1,minetest.get_node({x=j, y=k, z=-76}).name,2,1)
			end
        end
        t = t.."\n"
    end
    t = t.."\n"
    local k = 21
    for l=1,12 do
        k = k-1
        for j=10,29 do
            if minetest.get_node({x=j, y=k, z=-77}).name == "labyrinthus:nyancat2" then
                t = t.."!"
			else
				t = t..get_item_list(node_list2,minetest.get_node({x=j, y=k, z=-77}).name,2,1)
            end
        end
        t = t.."\n"
    end
    t = t.."\n"
    if minetest.get_node({x=20, y=22, z=-82}).name == "labyrinthus:stone" then
        t = t.."true\n"
    else
        t = t.."false\n"
    end
    local player_inv = player:get_inventory()
	local w = player_inv:get_stack("w", 1):get_count()
	local re = player_inv:get_stack("re", 1):get_count()
	local ye = player_inv:get_stack("ye", 1):get_count()
	local c = player_inv:get_stack("c", 1):get_count()
	local p = player_inv:get_stack("p", 1):get_count()
	local g = player_inv:get_stack("g", 1):get_count()
    local k = player_inv:get_stack("k", 1):get_count()
    local r = player_inv:get_stack("r", 1):get_count()
    local s = player_inv:get_stack("s", 1):get_count()
	local ss = player_inv:get_stack("ss", 1):get_count()
    local b = player_inv:get_stack("b", 1):get_count()
    local a = player_inv:get_stack("a", 1):get_count()
    local a2 = player_inv:get_stack("a2", 1):get_count()
    local time = player_inv:get_stack("time", 1):get_count()
    local f = player_inv:get_stack("f", 1):get_count()
    local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
    local z = player_inv:get_stack("z", 1):get_count()
	t = t..w.."\n"
	t = t..re.."\n"
	t = t..ye.."\n"
	t = t..c.."\n"
	t = t..p.."\n"
	t = t..g.."\n"
    t = t..k.."\n"
    t = t..r.."\n"
    t = t..s.."\n"
	t = t..ss.."\n"
    t = t..b.."\n"
    t = t..a.."\n"
    t = t..a2.."\n"
    t = t..time.."\n"
    t = t..tt.."\n"
    t = t..f.."\n"
    t = t..x.."\n"
    t = t..y.."\n"
    t = t..z.."\n"
    t = t..pon.."\n"
    t = t..rrr.."\n"
    t = t..rrrr.."\n"
    file:write(t)
	file:close()
end

function update()
    local players = minetest.get_connected_players()
    local ll = 0
	local green = 0
    for _,player in ipairs(players) do
        local player_inv = player:get_inventory()
        Load(player)
		
        local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        local key = player_inv:get_stack("k", 1):get_count()
        local balls = player_inv:get_stack("s", 1):get_count()
		local balls2 = player_inv:get_stack("ss", 1):get_count()
		local purple = player_inv:get_stack("p", 1):get_count()
		local cyan = player_inv:get_stack("c", 1):get_count()
		local yellow = player_inv:get_stack("ye", 1):get_count()
		local red = player_inv:get_stack("re", 1):get_count()
		local white = player_inv:get_stack("w", 1):get_count()
		green = player_inv:get_stack("g", 1):get_count()
        ll = player_inv:get_stack("ll", 1):get_count()
        local l = player_inv:get_stack("l", ll):get_count()
		local huds = 0
		
		if key ~= 0 then
			player:hud_change(hud["1"], 'text', "labyrinthus_key_"..key..".png")
			huds = huds+1
		end
		if balls ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_ball_1.png")
			huds = huds+1
		end
		if balls2 ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_ball2_1.png")
			huds = huds+1
		end
		if white ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_white_"..white..".png")
			huds = huds+1
		end
		if purple ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_purple_"..purple..".png")
			huds = huds+1
		end
		if green ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_green_"..green..".png")
			huds = huds+1
		end
		if cyan ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_cyan_"..cyan..".png")
			huds = huds+1
		end
		if yellow ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_yellow_"..yellow..".png")
			huds = huds+1
		end
		if red ~= 0 then
			player:hud_change(hud[""..(huds+1)], 'text', "labyrinthus_red_"..red..".png")
			huds = huds+1
		end
		for i=(huds+1),9 do
			player:hud_change(hud[""..i], 'text', "labyrinthus_glass.png")
		end
		local meta = player:get_meta()
        if ll == 0 and meta:get_string("celected") ~= "" then
		elseif ll ~= 0 then
			player:hud_change(hud_levels[player:get_player_name()], 'text', "Level: "..ll.."."..l)
        elseif meta:get_string("toplay") ~= "" then
            player:hud_change(hud_levels[player:get_player_name()], 'text', "Level: Own("..meta:get_string("toplay")..")")
		else
			player:hud_change(hud_levels[player:get_player_name()], 'text', "Level: /")
        end
    end
    local d = 0
    local d1 = 0
    local d2 = 0
    local d3 = 0
    local d4 = 0
    local dd = 0
	local dd2 = 0
	local dd3 = 0
    local ddd = 0
	local ddd2 = 0
	local ddd3 = 0
	if green > 0 then
		d = 1
	end
    for i=10,29 do
        for k=9,20 do
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:eye1" then
                if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:glass" then
                    minetest.set_node({x=i, y=k, z=-77}, {name="labyrinthus:eye2"})
                end
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button12" and minetest.get_node({x=i, y=k, z=-77}).name == "air" then
                dd = dd+1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button1" then
                if minetest.get_node({x=i, y=k, z=-77}).name ~= "air" and minetest.get_node({x=i, y=k, z=-77}).name ~= "nyancat:nyancat" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyancat2" and minetest.get_node({x=i, y=k, z=-77}).name:match('%f[%a]labyrinthus:wire%f[%A]') == nil and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:ball2" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:ball4" then
					ddd = 1
				end
				if minetest.get_node({x=i, y=k, z=-77}).name ~= "air" and minetest.get_node({x=i, y=k, z=-77}).name:match('%f[%a]labyrinthus:wire%f[%A]') == nil and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:ball2" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:ball4" then
					ddd2 = 1
				end
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button_eye" then
				if minetest.get_node({x=i, y=k, z=-77}).name ~= "air" and minetest.get_node({x=i, y=k, z=-77}).name:match('%f[%a]labyrinthus:wire%f[%A]') == nil and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:ball2" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:ball4" then
					ddd3 = 1
				end
			end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:arrow_path_button" then
				dd2 = dd2+1
				if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:arrow4" then
					dd3 = dd3+1
				end
			end
            if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:apple" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:water_ball" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:red2" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:green2" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:blue2"  or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:meselamp2" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:diamondblock" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:pbj_pup" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:blue" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:yellow" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:2red" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:2blue" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:backward_arrow" then
				d = 1
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:green" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:green_dirt" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:water_wood_with_green" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:ice_with_green" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:arrow_path_with_green" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:water_eye1_with_green" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:water_eye2_with_green" then
				d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:ball1" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:remember1_off" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:remember2_off" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:remember3_off" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:remember4_off" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:remember5_off" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:remember5_temp" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:00" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:0" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:eye1" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:eye2" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan1" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan2" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan3" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan4" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:arrow3" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:box" and (minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:junglewood" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:wood2") and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan1" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan2" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan3" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:nyan4" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:arrow3" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name ~= "labyrinthus:red_sand" and minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:red" then
                d = 1
			end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:grey_sand" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:grey3" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button11" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button12" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:round3" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:round2" or minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:round4" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:arrow3" and minetest.get_node({x=i-1, y=k, z=-77}).name ~= "labyrinthus:arrow3" and minetest.get_node({x=i+1, y=k, z=-77}).name ~= "labyrinthus:arrow3" and minetest.get_node({x=i, y=k-1, z=-77}).name ~= "labyrinthus:arrow3" and minetest.get_node({x=i, y=k+1, z=-77}).name ~= "labyrinthus:arrow3" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:red_cross" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:red_pyramid" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:green_cross" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:green_pyramid" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:blue_cross" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:blue_pyramid" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:dirt_with_yellow_circle" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:arrow5_yellow" then
                d = 1
            end
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:dirt_with_red_circle" and minetest.get_node({x=i, y=k, z=-77}).name ~= "labyrinthus:arrow5_red" then
                d = 1
            end
            if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:nyan1" then
                d1 = d1+1
            end
            if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:nyan2" then
                d2 = d2+1
            end
            if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:nyan3" then
                d3 = d3+1
            end
            if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:nyan4" then
                d4 = d4+1
            end
        end
    end
    for i=10,29 do
        for k=9,20 do
            if d1 > 0 and d2 > 0 and d3 > 0 and d4 > 0 then
				local d5 = 0
				if d1 <= d2 and d1 <= d3 and d1 <= d4 then
					d5 = 1
				elseif d2 <= d1 and d2 <= d3 and d2 <= d4 then
					d5 = 2
				elseif d3 <= d1 and d3 <= d2 and d3 <= d4 then
					d5 = 3
				else
					d5 = 4
				end
                if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:nyan"..d5 then
                    if d5 == 4 then
						if minetest.get_node({x=i-1, y=k-1, z=-77}).name == "labyrinthus:nyan1" and minetest.get_node({x=i-1, y=k, z=-77}).name == "labyrinthus:nyan2" and minetest.get_node({x=i, y=k-1, z=-77}).name == "labyrinthus:nyan3" then
						else
							d = 1
						end
					elseif d5 == 3 then
						if minetest.get_node({x=i-1, y=k, z=-77}).name == "labyrinthus:nyan1" and minetest.get_node({x=i-1, y=k+1, z=-77}).name == "labyrinthus:nyan2" and minetest.get_node({x=i, y=k+1, z=-77}).name == "labyrinthus:nyan4" then
						else
							d = 1
						end
					elseif d5 == 2 then
						if minetest.get_node({x=i, y=k-1, z=-77}).name == "labyrinthus:nyan1" and minetest.get_node({x=i+1, y=k-1, z=-77}).name == "labyrinthus:nyan3" and minetest.get_node({x=i+1, y=k, z=-77}).name == "labyrinthus:nyan4" then
						else
							d = 1
						end
					else
						if minetest.get_node({x=i, y=k+1, z=-77}).name == "labyrinthus:nyan2" and minetest.get_node({x=i+1, y=k, z=-77}).name == "labyrinthus:nyan3" and minetest.get_node({x=i+1, y=k+1, z=-77}).name == "labyrinthus:nyan4" then
						else
							d = 1
						end
					end
                end
            end
        end
    end
	if dd2 == dd3 and dd2 > 0 then
		for j=10,29 do
			for l=9,20 do
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:arrow4_2" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:sand"})
				end
			end
		end
	end
    if ddd == 1 then
        for j=10,29 do
            for l=9,20 do
                if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:button2" then
                    minetest.set_node({x=j, y=l, z=-77}, {name="air"})
					if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:dirt" then
						minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:button2_2"})
					else
						minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:button2_1"})
					end
                    ddd = 1
                end
            end
        end
    else
        for j=10,29 do
            for l=9,20 do
                if (minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:button2_1") and minetest.get_node({x=j, y=l, z=-77}).name == "air" and ddd == 0 then
                    minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:button2"})
                    minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:sand"})
                end
				if (minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:button2_2") and minetest.get_node({x=j, y=l, z=-77}).name == "air" and ddd == 0 then
                    minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:button2"})
                    minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:dirt"})
                end
            end
        end
    end
	if ddd2 == 1 then
        for j=10,29 do
            for l=9,20 do
                if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:button3" then
                    minetest.set_node({x=j, y=l, z=-77}, {name="air"})
					if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:dirt" then
						minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:button3_2"})
					else
						minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:button3_1"})
					end
                    ddd = 1
                end
            end
        end
    else
        for j=10,29 do
            for l=9,20 do
                if (minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:button3_1") and minetest.get_node({x=j, y=l, z=-77}).name == "air" and ddd2 == 0 then
                    minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:button3"})
                    minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:sand"})
                end
				if (minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:button3_2") and minetest.get_node({x=j, y=l, z=-77}).name == "air" and ddd2 == 0 then
                    minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:button3"})
                    minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:dirt"})
                end
            end
        end
    end
	if ddd3 == 1 then
		for j=10,29 do
			for l=9,20 do
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye1" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye2"})
				end
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye1_with_yellow" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye2_with_yellow"})
				end
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye1_with_cyan" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye2_with_cyan"})
				end
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye1_with_green" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye2_with_green"})
				end
			end
		end
	else
		for j=10,29 do
			for l=9,20 do
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye2" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye1"})
				end
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye2_with_yellow" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye1_with_yellow"})
				end
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye2_with_cyan" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye1_with_cyan"})
				end
				if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:water_eye2_with_green" then
					minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:water_eye1_with_green"})
				end
			end
		end
	end
	local cross_red = false
	local cross_green = false
	for i=10,29 do
		for k=9,20 do
			if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:cross_green" then
				cross_green = true
			elseif minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:cross_red" then
				cross_red = true
			end
		end
	end
	if cross_red and cross_green then
		d = 1
	end
    if dd == 2 then
        for i=10,29 do
            for k=9,20 do
                if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button12" and minetest.get_node({x=i, y=k, z=-77}).name == "air" then
                    minetest.set_node({x=i, y=k, z=-77}, {name="labyrinthus:button13"})
                    minetest.set_node({x=i, y=k, z=-76}, {name="labyrinthus:sand"})
                end
            end
        end
    end
    if d == 0 then
        for i=10,29 do
            for k=9,20 do
                if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:rainbow" then
                    minetest.set_node({x=i, y=k, z=-76}, {name="nyancat:nyancat_rainbow"})
				elseif minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:rainbow3" then
					minetest.set_node({x=i, y=k, z=-76}, {name="labyrinthus:rainbow2"})
                end
            end
        end     
    end
    if d == 1 then
        for i=10,29 do
            for k=9,20 do
                if minetest.get_node({x=i, y=k, z=-76}).name == "nyancat:nyancat_rainbow" then
                    minetest.set_node({x=i, y=k, z=-76}, {name="labyrinthus:rainbow"})
				elseif minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:rainbow2" then
					minetest.set_node({x=i, y=k, z=-76}, {name="labyrinthus:rainbow3"})
                end
            end
        end     
    end
	for _,player in ipairs(players) do
		local player_inv = player:get_inventory()
		local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
		if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "nyancat:nyancat_rainbow" or minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:rainbow2" then
            minetest.set_node({x=x+10, y=y+8, z=-77}, {name="air"})
            player_inv:set_stack("x", 1, nil)
            player_inv:set_stack("y", 1, nil)
            player_inv:set_stack("z", 1, nil)
            player_inv:set_stack("time", 1, nil)
            pon = 0
			local level = ""
			if ll ~= 0 then
				local lv = io.open(minetest.get_worldpath().."/level"..ll..".txt", "r")
				level = lv:read("*l")
				lv:close()
			end
            minetest.chat_send_all("level completed")
            for i = 9, 30 do
                for j = 0,14 do
                    minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:meselamp"})
                end
            end
            local pos = {x=19, y=10.5, z=-88}
	        local size = 30
	        size = math.max(math.floor(size - 8), 0) 
	        local minp = vector.subtract(pos, size)
	        local maxp = vector.add(pos, size)
	        local vm = minetest.get_voxel_manip(minp, maxp)
	        vm:update_liquids()
	        vm:write_to_map()
	        vm:update_map()
	        local emin, emax = vm:get_emerged_area()
			if ll ~= 0 then
				if tonumber(level) == tonumber(l) then
					local le = io.open(minetest.get_worldpath().."/level"..ll..".txt", "w")
					le:write(level+1)
					le:close()
				end
			end
        end
	end
	local players = minetest.get_connected_players()
    for _,player in ipairs(players) do
		minetest.set_node({x=10, y=8, z=-77}, {name="labyrinthus:desert"})
        local player_inv = player:get_inventory()
		local fire = player_inv:get_stack("f", 1):get_count()
		local x = player_inv:get_stack("x", 1):get_count()
		local y = player_inv:get_stack("y", 1):get_count()
		if y ~= 0 then
			for i=1,2 do
				for j=10,29 do
					for l=9,20 do
						if minetest.get_node({x=j, y=l, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:nyancat2" then
							minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						end
					end
				end
				if fire > 0 then
					minetest.set_node({x=10+x, y=y+8, z=-77}, {name="labyrinthus:nyancat2"})
				else
					minetest.set_node({x=10+x, y=y+8, z=-77}, {name="nyancat:nyancat"})
				end
			end
		end
	end
end
function file_check(file_name)
	local file_found=io.open(file_name, "r")
	if file_found==nil then
		file_found=false
	else
		file_found=true
	end
	return file_found
end
minetest.register_on_joinplayer(function(player)
	
	--minetest.settings:set("node_highlighting", "none")
	player:set_pos({x=19.5, y=10.5, z=-88})
	player:set_physics_override({
        speed = 0,
        jump = 0,
    })
	local formspec = [[
			bgcolor[#080808BB;true]
			listcolors[#00000069;#5A5A5A;#141318;#30434C;#FFF] ]]
	local name = player:get_player_name()
	local info = minetest.get_player_information(name)
	if info.formspec_version > 1 then
		formspec = formspec .. "background9[5,5;1,1;gui_formbg.png;true;10]"
	else
		formspec = formspec .. "background[5,5;1,1;gui_formbg.png;true]"
	end
	player:set_formspec_prepend(formspec)
	local player_inv = player:get_inventory()
	local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
    local z = player_inv:get_stack("z", 1):get_count()
	if file_check(minetest.get_worldpath().."/Map_Version.txt") == true then
	else
		minetest.place_schematic({ x = 9, y = 7, z = -89 }, minetest.get_modpath("labyrinthus").."/schematics/sector1.mts","0")
		minetest.set_node({x=x+10, y=y+8, z=-77}, {name="air"})
        player_inv:set_stack("x", 1, nil)
        player_inv:set_stack("y", 1, nil)
        player_inv:set_stack("z", 1, nil)
        player_inv:set_stack("time", 1, nil)
        pon = 0
        local pos = {x=19, y=10.5, z=-88}
	    local size = 30
	    size = math.max(math.floor(size - 8), 0) 
	    local minp = vector.subtract(pos, size)
	    local maxp = vector.add(pos, size)
	    local vm = minetest.get_voxel_manip(minp, maxp)
	    vm:update_liquids()
	    vm:write_to_map()
	    vm:update_map()
		local file = io.open(minetest.get_worldpath().."/Map_Version.txt", "w")
		file:write(1)
		file:close()
	end
	local file = io.open(minetest.get_worldpath().."/Map_Version.txt", "r")
	local map_ver = file:read("*l")
    file:close()
	if tonumber(map_ver) < map_version then
		minetest.place_schematic({ x = 9, y = 7, z = -89 }, minetest.get_modpath("labyrinthus").."/schematics/sector1.mts","0")
		minetest.set_node({x=x+10, y=y+8, z=-77}, {name="air"})
        player_inv:set_stack("x", 1, nil)
        player_inv:set_stack("y", 1, nil)
        player_inv:set_stack("z", 1, nil)
        player_inv:set_stack("time", 1, nil)
        pon = 0
        local pos = {x=19, y=10.5, z=-88}
	    local size = 30
	    size = math.max(math.floor(size - 8), 0) 
	    local minp = vector.subtract(pos, size)
	    local maxp = vector.add(pos, size)
	    local vm = minetest.get_voxel_manip(minp, maxp)
	    vm:update_liquids()
	    vm:write_to_map()
	    vm:update_map()
		local file = io.open(minetest.get_worldpath().."/Map_Version.txt", "w")
		file:write(map_version)
		file:close()
	end
	if file_check(minetest.get_worldpath().."/level1.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/level1.txt", "w")
		file:write("1")
		file:close()
	end
    if file_check(minetest.get_worldpath().."/level2.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/level2.txt", "w")
		file:write("1")
		file:close()
	end
    if file_check(minetest.get_worldpath().."/level3.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/level3.txt", "w")
		file:write("1")
		file:close()
	end
    if file_check(minetest.get_worldpath().."/level4.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/level4.txt", "w")
		file:write("1")
		file:close()
	end
	if file_check(minetest.get_worldpath().."/level5.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/level5.txt", "w")
		file:write("1")
		file:close()
	end
	if file_check(minetest.get_worldpath().."/level6.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/level6.txt", "w")
		file:write("1")
		file:close()
	end
	if file_check(minetest.get_worldpath().."/move1.txt") == true then
	else
		local file = io.open(minetest.get_worldpath().."/move1.txt", "w")
		file:close()
	end
end)
minetest.register_node("labyrinthus:apple", {
	drawtype = "plantlike",
	tiles = {"labyrinthus_apple.png"},
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	is_ground_content = false,
})
minetest.register_alias("mapgen_stone", "labyrinthus:stone")
minetest.register_alias("mapgen_water_source", "labyrinthus:water")
minetest.register_item(":", {
	type = "none",
	wield_image = "wieldhand.png",
	wield_scale = {x = 1, y = 1, z = 2.5},
	range = 8,
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
	}
})

local lists = {node_list1, node_list2}

for _, list in ipairs(lists) do
    for _, def in ipairs(list) do
        local id, name, texture, hardness, group, creatable = unpack(def)
        if creatable then
            minetest.register_node(name, {
                tiles = {texture},
				selection_box = { type = "fixed", fixed = {} },
            })
        end
    end
end

minetest.register_node("labyrinthus:wall",{
	tiles = {"labyrinthus_wall.png"},
})
minetest.register_node("labyrinthus:rainbow",{
	tiles = {"labyrinthus_water.png^labyrinthus_rainbow.png"},
})
minetest.register_node("labyrinthus:rainbow3",{
	tiles = {"labyrinthus_water.png^labyrinthus_rainbow3.png"},
})
minetest.register_node("labyrinthus:water_eye1_with_yellow",{
	tiles = {"labyrinthus_water.png^labyrinthus_yellow2.png"},
})
minetest.register_node("labyrinthus:water_eye1_with_cyan",{
	tiles = {"labyrinthus_water.png^labyrinthus_cyan.png"},
})
minetest.register_node("labyrinthus:water_eye1_with_green",{
	tiles = {"labyrinthus_water.png^labyrinthus_green.png"},
})
minetest.register_node("labyrinthus:desert",{
	tiles = {"labyrinthus_desert_sand.png"},
})
minetest.register_node("labyrinthus:remember1_off",{
	tiles = {"labyrinthus_mese_block.png^labyrinthus_remember.png"},
})
minetest.register_node("labyrinthus:remember2_off",{
	tiles = {"labyrinthus_mese_block.png^labyrinthus_remember.png"},
})
minetest.register_node("labyrinthus:remember3_off",{
	tiles = {"labyrinthus_mese_block.png^labyrinthus_remember.png"},
})
minetest.register_node("labyrinthus:remember4_off",{
	tiles = {"labyrinthus_mese_block.png^labyrinthus_remember.png"},
})
minetest.register_node("labyrinthus:remember5_off",{
	tiles = {"labyrinthus_mese_block.png^labyrinthus_remember.png"},
})
minetest.register_node("labyrinthus:water_eye1",{
	tiles = {"labyrinthus_water.png"},
})
minetest.register_node("labyrinthus:yellow_block", {
	drawtype = "nodebox",
	tiles = {"labyrinthus_stone.png^labyrinthus_yellow_arrow.png","labyrinthus_stone.png","labyrinthus_stone.png","labyrinthus_stone.png","labyrinthus_stone.png","labyrinthus_stone.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = true,
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, 0, 0.5},
	},
})
minetest.register_node("labyrinthus:pbj_pup", {
	tiles = {"labyrinthus_pup_sides.png","labyrinthus_pup_sides.png","labyrinthus_pup_sides.png","labyrinthus_pup_sides.png","labyrinthus_pup_sides.png","labyrinthus_pup_front.png"},
})
minetest.register_node("labyrinthus:meselamp", {
	tiles = {"labyrinthus_meselamp.png"},
	drawtype = "glasslike",
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	light_source = 14,
})
minetest.register_node("labyrinthus:glass",{
	tiles = {"labyrinthus_glass.png"},
	drawtype = "glasslike_framed_optional",
	paramtype = "light",
	sunlight_propagates = true,
	use_texture_alpha = "clip",
	is_ground_content = true,
	selection_box = { type = "fixed", fixed = {} },
})
minetest.register_node("labyrinthus:nyancat2",{
	tiles = {"nyancat_side.png", "nyancat_side.png", "nyancat_side.png","nyancat_side.png", "nyancat_back.png", "labyrinthus_nyancat2_front.png"},
    paramtype = "light",
	light_source = 4,
})
minetest.register_node("labyrinthus:red2", {
	tiles = {"labyrinthus_red2.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_ball.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:blue2", {
	tiles = {"labyrinthus_blue2.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_ball.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:green2", {
	tiles = {"labyrinthus_green2.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_ball.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:water_ball", {
	tiles = {"labyrinthus_water.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_ball.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:red_pyramid", {
	tiles = {"labyrinthus_red2.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_pyramid.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:green_pyramid", {
	tiles = {"labyrinthus_green2.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_pyramid.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:blue_pyramid", {
	tiles = {"labyrinthus_blue2.png"},
	drawtype = "mesh",
	mesh = "labyrinthus_pyramid.obj",
	paramtype = "light",
	paramtype2 = "facedir",
})
minetest.register_node("labyrinthus:ball2",{
	tiles = {"labyrinthus_ball.png"},
	drawtype = "glasslike_framed_optional",
	paramtype = "light",
	sunlight_propagates = true,
	use_texture_alpha = "clip",
	is_ground_content = true,
})
minetest.register_node("labyrinthus:ball4",{
	tiles = {"labyrinthus_ball2.png"},
	drawtype = "glasslike_framed_optional",
	paramtype = "light",
	sunlight_propagates = true,
	use_texture_alpha = "clip",
	is_ground_content = true,
})
minetest.register_node("labyrinthus:leaves", {
	tiles = {"labyrinthus_leaves.png"},
	drawtype = "allfaces_optional",
	paramtype = "light",
	is_ground_content = false,
})

for i=0,30 do
    minetest.register_node("labyrinthus:time"..i,{
	    tiles = {"labyrinthus_sand.png^labyrinthus_time"..i..".png"},
    })
end

local nbox_nid =
{
	[0] = {1/16, -.5, -1/16, 8/16, -.5+1/16, 1/16}, -- x positive
	[1] = {-1/16, -.5, 1/16, 1/16, -.5+1/16, 8/16}, -- z positive
	[2] = {-8/16, -.5, -1/16, -1/16, -.5+1/16, 1/16}, -- x negative
	[3] = {-1/16, -.5, -8/16, 1/16, -.5+1/16, -1/16}, -- z negative

	[4] = {.5-1/16, -.5+1/16, -1/16, .5, .4999+1/16, 1/16}, -- x positive up
	[5] = {-1/16, -.5+1/16, .5-1/16, 1/16, .4999+1/16, .5}, -- z positive up
	[6] = {-.5, -.5+1/16, -1/16, -.5+1/16, .4999+1/16, 1/16}, -- x negative up
	[7] = {-1/16, -.5+1/16, -.5, 1/16, .4999+1/16, -.5+1/16}  -- z negative up
}
local box_center = {-1/16, -.5, -1/16, 1/16, -.5+1/16, 1/16}
local box_bump1 =  { -2/16, -8/16,  -2/16, 2/16, -13/32, 2/16 }
local nid_inc = function() end
nid_inc = function (nid)
	local i = 0
	while nid[i-1] ~= 1 do
		nid[i] = (nid[i] ~= 1) and 1 or 0
		i = i + 1
	end

	-- BUT: Skip impossible nodeids:
	if ((nid[0] == 0 and nid[4] == 1) or (nid[1] == 0 and nid[5] == 1) 
	or (nid[2] == 0 and nid[6] == 1) or (nid[3] == 0 and nid[7] == 1)) then
		return nid_inc(nid)
	end

	return i <= 8
end
register_wires = function()
	local nid = {}
	while true do
		-- Create group specifiction and nodeid string (see note above for details)
		local nodeid = 	  (nid[0] or "0")..(nid[1] or "0")..(nid[2] or "0")..(nid[3] or "0")
				..(nid[4] or "0")..(nid[5] or "0")..(nid[6] or "0")..(nid[7] or "0")

		-- Calculate nodebox
		local nodebox = {type = "fixed", fixed={box_center}}
		for i=0,7 do
			if nid[i] == 1 then
				table.insert(nodebox.fixed, nbox_nid[i])
			end
		end

		-- Add bump to nodebox if curved
		if (nid[0] == 1 and nid[1] == 1) or (nid[1] == 1 and nid[2] == 1)
		or (nid[2] == 1 and nid[3] == 1) or (nid[3] == 1 and nid[0] == 1) then
			table.insert(nodebox.fixed, box_bump1)
		end

		-- If nothing to connect to, still make a nodebox of a straight wire
		if nodeid == "00000000" then
			nodebox.fixed = {-8/16, -.5, -1/16, 8/16, -.5+1/16, 1/16}
		end

		local rules = {}
		if (nid[0] == 1) then table.insert(rules, vector.new( 1,  0,  0)) end
		if (nid[1] == 1) then table.insert(rules, vector.new( 0,  0,  1)) end
		if (nid[2] == 1) then table.insert(rules, vector.new(-1,  0,  0)) end
		if (nid[3] == 1) then table.insert(rules, vector.new( 0,  0, -1)) end

		if (nid[0] == 1) then table.insert(rules, vector.new( 1, -1,  0)) end
		if (nid[1] == 1) then table.insert(rules, vector.new( 0, -1,  1)) end
		if (nid[2] == 1) then table.insert(rules, vector.new(-1, -1,  0)) end
		if (nid[3] == 1) then table.insert(rules, vector.new( 0, -1, -1)) end

		if (nid[4] == 1) then table.insert(rules, vector.new( 1,  1,  0)) end
		if (nid[5] == 1) then table.insert(rules, vector.new( 0,  1,  1)) end
		if (nid[6] == 1) then table.insert(rules, vector.new(-1,  1,  0)) end
		if (nid[7] == 1) then table.insert(rules, vector.new( 0,  1, -1)) end


		local groups_on = {dig_immediate = 3, mesecon_conductor_craftable = 1,
			not_in_creative_inventory = 1}
		local groups_off = {dig_immediate = 3, mesecon_conductor_craftable = 1}
		if nodeid ~= "00000000" then
			groups_off["not_in_creative_inventory"] = 1
		end

		minetest.register_node("labyrinthus:wire_"..nodeid, {
			description = "Mesecon",
			drawtype = "nodebox",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = nodebox,
			walkable = false,
			tiles = {"labyrinthus_wire.png"}
		})
		if (nid_inc(nid) == false) then return end
	end
end
register_wires()

function one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,node,set_node,donetp2,mode)
	local player_inv = player:get_inventory()
	if mode == 1 then
		if set_node then
			minetest.set_node(e1m2, {name=node})
		end
		minetest.set_node(e2m1, {name="air"})
		player_inv:set_stack(ko, 1, "labyrinthus:dirt "..koad)
		Other(player, pbjnr)
		minetest.set_node(e2m2, {name="nyancat:nyancat"})
	elseif mode == 2 then
		minetest.set_node(e2m2, {name="air"})
		minetest.set_node(e2m1, {name="air"})
		if donetp2 == 0 then
			player_inv:set_stack(ko, 1, "labyrinthus:dirt "..koad)
			Other(player, pbjnr)
			minetest.set_node(e2m2, {name="nyancat:nyancat"})
		end
	end
end
function move(player,e1m1,e1m2,e1m3,e2m1,e2m2,e2m3,ko,koad,dir1,dir2,pbjnr,trfire,overdirt)
	local player_inv = player:get_inventory()
    local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
	player_inv:set_stack("sx", 1, "labyrinthus:dirt "..x)
	player_inv:set_stack("sy", 1, "labyrinthus:dirt "..y)
	local wire_x = player_inv:get_stack("x", 1):get_count()
    local wire_y = player_inv:get_stack("y", 1):get_count()
    local z = player_inv:get_stack("z", 1):get_count()
    local key = player_inv:get_stack("k", 1):get_count()
    local ll = player_inv:get_stack("ll", 1):get_count()
    local bones = player_inv:get_stack("b", 1):get_count()
	local wire = player_inv:get_stack("wire", 1):get_count()
    local level2 = player_inv:get_stack("l", ll):get_count()
    local fire = player_inv:get_stack("f", 1):get_count()
    local time = player_inv:get_stack("time", 1):get_count()
	local tp3 = false
	local donetp2 = 0
	local no_wire = false
	if minetest.get_node(e1m3).name == "labyrinthus:tp3" and minetest.get_node(e2m3).name == "air" then
		tp3 = true
	end
	if minetest.get_node(e1m1).name == "labyrinthus:button11" then
        minetest.set_node(e1m1, {name="labyrinthus:button12"})
    end
    if minetest.get_node(e1m1).name == "labyrinthus:ice3" and trfire == true then
        minetest.set_node(e1m1, {name="labyrinthus:water"})
    end
	if minetest.get_node(e1m1).name == "labyrinthus:ice_with_green" and trfire == true then
        minetest.set_node(e1m1, {name="labyrinthus:water"})
    end
	if minetest.get_node(e1m1).name == "labyrinthus:ice_with_white" and trfire == true then
        minetest.set_node(e1m1, {name="labyrinthus:water"})
    end
	if minetest.get_node(e1m1).name == "labyrinthus:ice_with_yellow" and trfire == true then
        minetest.set_node(e1m1, {name="labyrinthus:water"})
    end
    if minetest.get_node(e1m1).name == "labyrinthus:ice2" and trfire == true then
        minetest.set_node(e1m1, {name="labyrinthus:ice3"})
    end
    if minetest.get_node(e1m1).name == "labyrinthus:ice1" and trfire == true then
        minetest.set_node(e1m1, {name="labyrinthus:ice2"})
    end
	local wood_moved = false
	if minetest.get_node(e1m1).name == "labyrinthus:wood" then
		local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
		minetest.set_node(e2m1, {name="air"})
		if dir1 == "up" then
			minetest.set_node(e1m1, {name="labyrinthus:water"})
			local ad = 9
			local ex = 0
			while ex == 0 do
				if minetest.get_node({x=x+10, y=y+ad, z=-76}).name == "labyrinthus:water"  and minetest.get_node({x=x+10, y=y+ad, z=-77}).name == "air" then
					ad = ad+1
					wood_moved = true
				else
					ex = 1
				end
			end
			minetest.set_node({x=x+10, y=y+ad-1, z=-76}, {name="labyrinthus:wood"})
			player_inv:set_stack("y", 1, "labyrinthus:dirt "..(y+ad-9))
		elseif dir1 == "down" then
			minetest.set_node(e1m1, {name="labyrinthus:water"})
			local ad = 7
			local ex = 0
			while ex == 0 do
				if minetest.get_node({x=x+10, y=y+ad, z=-76}).name == "labyrinthus:water" and minetest.get_node({x=x+10, y=y+ad, z=-77}).name == "air" then
					ad = ad-1
					wood_moved = true
				else
					ex = 1
				end
			end
			minetest.set_node({x=x+10, y=y+ad+1, z=-76}, {name="labyrinthus:wood"})
			player_inv:set_stack("y", 1, "labyrinthus:dirt "..(y+ad-7))
		elseif dir1 == "right" then
			minetest.set_node(e1m1, {name="labyrinthus:water"})
			local ad = 11
			local ex = 0
			while ex == 0 do
				if minetest.get_node({x=x+ad, y=y+8, z=-76}).name == "labyrinthus:water" and minetest.get_node({x=x+ad, y=y+8, z=-77}).name == "air" then
					ad = ad+1
					wood_moved = true
				else
					ex = 1
				end
			end
			minetest.set_node({x=x+ad-1, y=y+8, z=-76}, {name="labyrinthus:wood"})
			player_inv:set_stack("x", 1, "labyrinthus:dirt "..(x+ad-11))
		elseif dir1 == "left" then
			minetest.set_node(e1m1, {name="labyrinthus:water"})
			local ad = 9
			local ex = 0
			while ex == 0 do
				if minetest.get_node({x=x+ad, y=y+8, z=-76}).name == "labyrinthus:water" and minetest.get_node({x=x+ad, y=y+8, z=-77}).name == "air" then
					ad = ad-1
					wood_moved = true
				else
					ex = 1
				end
			end
			minetest.set_node({x=x+ad+1, y=y+8, z=-76}, {name="labyrinthus:wood"})
			player_inv:set_stack("x", 1, "labyrinthus:dirt "..(x+ad-9))
		end
		local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        minetest.set_node({x=x+10, y=y+8, z=-77}, {name="nyancat:nyancat"})
	end
	local wire = player_inv:get_stack("wire", 1):get_count()
	local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
	local anotherstep = 0
    if minetest.get_node(e1m2).name == "labyrinthus:water" then
	elseif minetest.get_node(e1m2).name == "labyrinthus:arrow4_2" then
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_stone" then
	elseif minetest.get_node(e1m2).name == "labyrinthus:sand_for_green" then
		if dir1 == "up" then
			player_inv:set_stack("g", 1, nil)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:sand_for_green_dirt" then
		if dir1 == "up" and Dirt_Move2(e1m1,overdirt) then
			player_inv:set_stack("g", 1, nil)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:wood_for_yellow" then
		if dir1 == "right" then
			player_inv:set_stack("ye", 1, nil)
			local is_yellow = 0
			for j=10,29 do
				for l=9,20 do
					if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:yellow2" or minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:yellow_dirt" or minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:yellow_red" then
						is_yellow = 1
					end
				end
			end
			if is_yellow == 0 then
				minetest.set_node(e1m2, {name="labyrinthus:wood"})
			end
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:bow" then
		local bow_shot = 0
		local cyan = player_inv:get_stack("c", 1):get_count()
		if cyan > 0 then
			if dir1 == "up" then
				local bow_r = "up"
				local bow_x = x+10
				local bow_y = y+10
				while Is_Node(bow_x,bow_y,"bow") and bow_shot < 20 do
					if minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "labyrinthus:stone_with_no_white1" then
						minetest.set_node({x=bow_x, y=bow_y, z=-77}, {name="labyrinthus:stone_with_white2"})
					end
					if minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "labyrinthus:bow_right" then
						bow_r = "right"
						bow_shot = bow_shot+1
					elseif minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "labyrinthus:bow_left" then
						bow_r = "left"
						bow_shot = bow_shot+1
					elseif minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "labyrinthus:bow_up" then
						bow_r = "up"
						bow_shot = bow_shot+1
					elseif minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "labyrinthus:bow_down" then
						bow_r = "down"
						bow_shot = bow_shot+1
					end
					if bow_r == "up" then
						bow_y = bow_y+1
					elseif bow_r == "right" then
						bow_x = bow_x+1
					elseif bow_r == "left" then
						bow_x = bow_x-1
					elseif bow_r == "down" then
						bow_y = bow_y-1	
					end
				end
				if minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "labyrinthus:leaves" and Is_Node(bow_x,bow_y,"not_group_dirt") then
					if bow_r == "up" then
						bow_y = bow_y+1
					elseif bow_r == "right" then
						bow_x = bow_x+1
					elseif bow_r == "left" then
						bow_x = bow_x-1
					elseif bow_r == "down" then
						bow_y = bow_y-1	
					end
					if Is_Node(bow_x,bow_y,nil) then
						minetest.set_node({x=bow_x, y=bow_y, z=-77}, {name="labyrinthus:arrow4"})
					end
				end
				player_inv:set_stack("c", 1, "labyrinthus:dirt "..(cyan-1))
			end
			if bow_shot == 20 then
				minetest.chat_send_all("Oh no! Nyan Cat shot in a circle with the bow.")
			end
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:rainbow2" and dir1 ~= "up" then
	elseif minetest.get_node(e1m2).name == "labyrinthus:rainbow3" and dir1 ~= "up" then
    elseif minetest.get_node(e1m2).name == "labyrinthus:key2" then
        player_inv:set_stack("k", 1, "labyrinthus:dirt "..(key+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:purple" then
		local purple = player_inv:get_stack("p", 1):get_count()
        player_inv:set_stack("p", 1, "labyrinthus:dirt "..(purple+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:cyan" then
		local cyan = player_inv:get_stack("c", 1):get_count()
        player_inv:set_stack("c", 1, "labyrinthus:dirt "..(cyan+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:yellow2" then
		local yellow = player_inv:get_stack("ye", 1):get_count()
        player_inv:set_stack("ye", 1, "labyrinthus:dirt "..(yellow+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_eye1_with_yellow" then
		local yellow = player_inv:get_stack("ye", 1):get_count()
        player_inv:set_stack("ye", 1, "labyrinthus:dirt "..(yellow+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_eye1",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_eye2_with_yellow" then
		local yellow = player_inv:get_stack("ye", 1):get_count()
        player_inv:set_stack("ye", 1, "labyrinthus:dirt "..(yellow+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_eye2",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_eye1_with_green" then
		local green = player_inv:get_stack("g", 1):get_count()
        player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_eye1",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_eye2_with_green" then
		local green = player_inv:get_stack("g", 1):get_count()
        player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_eye2",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_eye1_with_cyan" then
		local cyan = player_inv:get_stack("c", 1):get_count()
        player_inv:set_stack("c", 1, "labyrinthus:dirt "..(cyan+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_eye1",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_eye2_with_yellow" then
		local cyan = player_inv:get_stack("c", 1):get_count()
        player_inv:set_stack("c", 1, "labyrinthus:dirt "..(cyan+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_eye2",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:red3" then
		local red = player_inv:get_stack("re", 1):get_count()
        player_inv:set_stack("re", 1, "labyrinthus:dirt "..(red+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:white" then
		local white = player_inv:get_stack("w", 1):get_count()
        player_inv:set_stack("w", 1, "labyrinthus:dirt "..(white+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:green" then
		local green = player_inv:get_stack("g", 1):get_count()
        player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:arrow_path_with_green" then
		local green = player_inv:get_stack("g", 1):get_count()
        player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:arrow_path",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_wood_with_green" then
		local green = player_inv:get_stack("g", 1):get_count()
        player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_wood",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:water_wood_with_red" then
		local red = player_inv:get_stack("re", 1):get_count()
        player_inv:set_stack("re", 1, "labyrinthus:dirt "..(red+1))
		one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:water_wood",true,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:purple_dirt" then
		if Dirt_Move2(e1m1,overdirt) then
			local purple = player_inv:get_stack("p", 1):get_count()
			player_inv:set_stack("p", 1, "labyrinthus:dirt "..(purple+1))
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:dirt",true,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:green_dirt" then
		if Dirt_Move2(e1m1,overdirt) then
			local green = player_inv:get_stack("g", 1):get_count()
			player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:dirt",true,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:cyan_dirt" then
		if Dirt_Move2(e1m1,overdirt) then
			local cyan = player_inv:get_stack("c", 1):get_count()
			player_inv:set_stack("c", 1, "labyrinthus:dirt "..(cyan+1))
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:dirt",true,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:red_dirt" then
		if Dirt_Move2(e1m1,overdirt) then
			local red = player_inv:get_stack("re", 1):get_count()
			player_inv:set_stack("re", 1, "labyrinthus:dirt "..(red+1))
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:dirt",true,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:yellow_dirt" then
		if Dirt_Move2(e1m1,overdirt) then
			local yellow = player_inv:get_stack("ye", 1):get_count()
			player_inv:set_stack("ye", 1, "labyrinthus:dirt "..(yellow+1))
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:dirt",true,donetp2,1)
		end
    elseif minetest.get_node(e1m2).name == "labyrinthus:bones" then
        player_inv:set_stack("b", 1, "labyrinthus:dirt")
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:cross_switch" then
        local wire = player_inv:get_stack("wire", 1):get_count()
		if wire == 0 then
			player_inv:set_stack("wire", 1, "labyrinthus:dirt")
			no_wire = true
		else
			minetest.set_node(e1m2, {name="labyrinthus:sand"})
			player_inv:set_stack("wire", 1, "")
			for j=10,29 do
				for l=9,20 do
					if minetest.get_node({x=j, y=l, z=-77}).name:match('%f[%a]labyrinthus:wire%f[%A]') ~= nil or minetest.get_node({x=j, y=l, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:nyancat2" then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						if minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:cross_green" then
							minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:cross_red"})
						elseif minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:cross_red" then
							minetest.set_node({x=j, y=l, z=-76}, {name="labyrinthus:cross_green"})
						end
					end
				end
			end
		end
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
    elseif minetest.get_node(e1m2).name == "labyrinthus:ball1" then
		local s = player_inv:get_stack("s", 1):get_count()
        if s == 0 then
            minetest.set_node(e1m2, {name="labyrinthus:sand"})
            player_inv:set_stack("s", 1, "labyrinthus:dirt")
        end
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
	elseif minetest.get_node(e1m2).name == "labyrinthus:ball3" then
		local ss = player_inv:get_stack("ss", 1):get_count()
        if ss == 0 then
            player_inv:set_stack("ss", 1, "labyrinthus:dirt")
        end
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"labyrinthus:sand",true,donetp2,1)
    elseif minetest.get_node(e2m2).name == "labyrinthus:stone" or minetest.get_node(e2m2).name == "labyrinthus:leaves" or minetest.get_node(e2m2).name == "labyrinthus:button2" or minetest.get_node(e2m2).name == "labyrinthus:button3" or minetest.get_node(e2m2).name == "labyrinthus:cobble" or minetest.get_node(e2m2).name == "labyrinthus:0" or minetest.get_node(e2m2).name == "labyrinthus:button13" or minetest.get_node(e2m2).name == "labyrinthus:yellow_block" or minetest.get_node(e2m2).name == "labyrinthus:red_with_no_yellow" or minetest.get_node(e2m2).name == "labyrinthus:stone_with_white" or minetest.get_node(e2m2).name == "labyrinthus:stone_with_no_white2" then
    elseif minetest.get_node(e2m2).name == "labyrinthus:remember1_on" or minetest.get_node(e2m2).name == "labyrinthus:remember2_on" or minetest.get_node(e2m2).name == "labyrinthus:remember3_on" or minetest.get_node(e2m2).name == "labyrinthus:remember4_on" or minetest.get_node(e2m2).name == "labyrinthus:remember5_on" or minetest.get_node(e2m2).name == "labyrinthus:remember5_temp" then
	elseif minetest.get_node(e2m2).name:match('%f[%a]labyrinthus:wire%f[%A]') ~= nil or minetest.get_node(e2m2).name == "labyrinthus:backward_arrow" then
	elseif minetest.get_node(e2m2).name == "labyrinthus:junglewood" then
		if Dirt_Move(e1m1,e1m2,e1m3,"wood") then
        	if minetest.get_node(e1m3).name == "labyrinthus:water" then
                minetest.set_node(e1m3, {name="labyrinthus:water_wood"})
            else
                minetest.set_node(e2m3, {name="labyrinthus:junglewood"})
            end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
		end
	elseif minetest.get_node(e2m2).name == "labyrinthus:wood2" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:wood2"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
		end
	elseif minetest.get_node(e2m2).name == "labyrinthus:water_ball" then
		if Dirt_Move(e1m1,e1m2,e1m3,"wood") then
			if minetest.get_node(e1m3).name == "labyrinthus:water" then
            else
                minetest.set_node(e2m3, {name="labyrinthus:water_ball"})
            end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:remember1_off" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:remember1_on"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:remember2_off" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:remember2_on"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
			minetest.after(1, function(e2m3) 
				local re = 0
				for j=10,29 do
					for l=9,20 do
						if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
							re = 1
						end
					end
				end
				if re == 0 then
					for j=10,29 do
						for l=9,20 do
							if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember2_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember2_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember3_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember3_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember4_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember4_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember5_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember5_off"})
							end
						end
					end
				end
			end, e2m3)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:remember3_off" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:remember3_on"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
			minetest.after(1, function(e2m3) 
				local re = 0
				for j=10,29 do
					for l=9,20 do
						if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
							re = re+1
						elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember2_on" then
							re = re+1
						end
					end
				end
				if re ~= 2 then
					for j=10,29 do
						for l=9,20 do
							if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember1_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember3_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember3_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember4_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember4_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember5_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember5_off"})
							end
						end
					end
				end
			end, e2m3)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:remember4_off" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:remember4_on"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
			minetest.after(1, function(e2m3) 
				local re = 0
				for j=10,29 do
					for l=9,20 do
						if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
							re = re+1
						elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember2_on" then
							re = re+1
						elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember3_on" then
							re = re+1
						end
					end
				end
				if re ~= 3 then
					for j=10,29 do
						for l=9,20 do
							if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember1_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember2_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember2_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember4_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember4_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember5_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember5_off"})
							end
						end
					end
				end
			end, e2m3)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:remember5_off" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			local re = 0
			for j=10,29 do
				for l=9,20 do
					if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
						re = re+1
					elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember2_on" then
						re = re+1
					elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember3_on" then
						re = re+1
					elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember4_on" then
						re = re+1
					end
				end
			end
			if re == 4 then
				minetest.set_node(e2m3, {name="labyrinthus:remember5_on"})
			else
				minetest.set_node(e2m3, {name="labyrinthus:remember5_temp"})
				minetest.after(1, function(e2m3) 
					for j=10,29 do
						for l=9,20 do
							if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember1_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember1_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember2_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember2_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember3_on" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember3_off"})
							elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:remember5_temp" then
								minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:remember5_off"})
							end
						end
					end
				end, e2m3)
			end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e1m2).name == "labyrinthus:gate" then
		one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
		anotherstep = 1
	elseif minetest.get_node(e2m2).name == "labyrinthus:stone_for_white" then
		local white = player_inv:get_stack("w", 1):get_count()
		if white > 0 and not Dirt_Move2(e1m1,overdirt) then
            player_inv:set_stack("w", 1, "labyrinthus:dirt "..(white-1))
			minetest.set_node(e2m2, {name="labyrinthus:stone_with_white"})
			local sw = 0
			for j=10,29 do
                for l=9,20 do
                    if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:stone_for_white" then
						sw = 1
					end
				end
			end
			if sw == 0 then
				for j=10,29 do
					for l=9,20 do
						if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:stone_with_white" then
							minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						end
					end
				end
			end
		end
    elseif minetest.get_node(e2m2).name == "labyrinthus:diamondblock" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m2, {name="air"})
            minetest.set_node(e2m3, {name="labyrinthus:diamondblock"})
            if minetest.get_node({x=e2m3.x+1, y=e2m3.y, z=-77}).name == "labyrinthus:diamondblock" and (Is_Node(e2m3.x, e2m3.y, "group_dirt") and Is_Node(e2m3.x+1, e2m3.y, "group_dirt") or Is_Node(e2m3.x, e2m3.y, "not_group_dirt") and Is_Node(e2m3.x+1, e2m3.y, "not_group_dirt")) then
                minetest.set_node(e2m3, {name="air"})
                minetest.set_node({x=e2m3.x+1, y=e2m3.y, z=-77}, {name="air"})
            end
            if minetest.get_node({x=e2m3.x-1, y=e2m3.y, z=-77}).name == "labyrinthus:diamondblock" and (Is_Node(e2m3.x, e2m3.y, "group_dirt") and Is_Node(e2m3.x-1, e2m3.y, "group_dirt") or Is_Node(e2m3.x, e2m3.y, "not_group_dirt") and Is_Node(e2m3.x-1, e2m3.y, "not_group_dirt")) then
                minetest.set_node(e2m3, {name="air"})
                minetest.set_node({x=e2m3.x-1, y=e2m3.y, z=-77}, {name="air"})
            end
            if minetest.get_node({x=e2m3.x, y=e2m3.y+1, z=-77}).name == "labyrinthus:diamondblock" and (Is_Node(e2m3.x, e2m3.y, "group_dirt") and Is_Node(e2m3.x, e2m3.y+1, "group_dirt") or Is_Node(e2m3.x, e2m3.y, "not_group_dirt") and Is_Node(e2m3.x, e2m3.y+1, "not_group_dirt")) then
                minetest.set_node(e2m3, {name="air"})
                minetest.set_node({x=e2m3.x, y=e2m3.y+1, z=-77}, {name="air"})
            end
            if minetest.get_node({x=e2m3.x, y=e2m3.y-1, z=-77}).name == "labyrinthus:diamondblock" and (Is_Node(e2m3.x, e2m3.y, "group_dirt") and Is_Node(e2m3.x, e2m3.y-1, "group_dirt") or Is_Node(e2m3.x, e2m3.y, "not_group_dirt") and Is_Node(e2m3.x, e2m3.y-1, "not_group_dirt")) then
                minetest.set_node(e2m3, {name="air"})
                minetest.set_node({x=e2m3.x, y=e2m3.y-1, z=-77}, {name="air"})
            end  
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:meselamp2" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:meselamp2"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:red_pyramid" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then 
			local red_pyramid = {}
			for j=10,29 do
				for l=9,20 do
					if dir1 == "right" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:red_pyramid" and Dirt_Move3(j+1,l,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(red_pyramid, {x=j+1, y=l, z=-77})
					elseif dir1 == "left" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:red_pyramid" and Dirt_Move3(j-1,l,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(red_pyramid, {x=j-1, y=l, z=-77})
					elseif dir1 == "up" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:red_pyramid" and Dirt_Move3(j,l+1,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(red_pyramid, {x=j, y=l+1, z=-77})
					elseif dir1 == "down" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:red_pyramid" and Dirt_Move3(j,l-1,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(red_pyramid, {x=j, y=l-1, z=-77})
					end
				end
			end
			for k, v in pairs(red_pyramid) do
				minetest.set_node(v, {name="labyrinthus:red_pyramid"})
			end
			minetest.set_node(e2m3, {name="labyrinthus:red_pyramid"})
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:green_pyramid" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then 
			local green_pyramid = {}
			for j=10,29 do
				for l=9,20 do
					if dir1 == "right" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:green_pyramid" and Dirt_Move3(j+1,l,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(green_pyramid, {x=j+1, y=l, z=-77})
					elseif dir1 == "left" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:green_pyramid" and Dirt_Move3(j-1,l,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(green_pyramid, {x=j-1, y=l, z=-77})
					elseif dir1 == "up" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:green_pyramid" and Dirt_Move3(j,l+1,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(green_pyramid, {x=j, y=l+1, z=-77})
					elseif dir1 == "down" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:green_pyramid" and Dirt_Move3(j,l-1,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(green_pyramid, {x=j, y=l-1, z=-77})
					end
				end
			end
			for k, v in pairs(green_pyramid) do
				minetest.set_node(v, {name="labyrinthus:green_pyramid"})
			end
			minetest.set_node(e2m3, {name="labyrinthus:green_pyramid"})
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:blue_pyramid" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			local blue_pyramid = {}
			for j=10,29 do
				for l=9,20 do
					if dir1 == "right" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:blue_pyramid" and Dirt_Move3(j+1,l,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(blue_pyramid, {x=j+1, y=l, z=-77})
					elseif dir1 == "left" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:blue_pyramid" and Dirt_Move3(j-1,l,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(blue_pyramid, {x=j-1, y=l, z=-77})
					elseif dir1 == "up" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:blue_pyramid" and Dirt_Move3(j,l+1,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(blue_pyramid, {x=j, y=l+1, z=-77})
					elseif dir1 == "down" and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:blue_pyramid" and Dirt_Move3(j,l-1,dir1,nil) then
						minetest.set_node({x=j, y=l, z=-77}, {name="air"})
						table.insert(blue_pyramid, {x=j, y=l-1, z=-77})
					end
				end
			end
			for k, v in pairs(blue_pyramid) do
				minetest.set_node(v, {name="labyrinthus:blue_pyramid"})
			end
			minetest.set_node(e2m3, {name="labyrinthus:blue_pyramid"})
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:transport_stone" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			if minetest.get_node(e1m3).name == "labyrinthus:gate_arrows" then
                minetest.set_node(e2m3, {name="labyrinthus:transport_stone_gate_arrows"})
			else
				minetest.set_node(e2m3, {name="labyrinthus:transport_stone"})
			end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:transport_stone_gate_arrows" then
        if Is_Node(e1m3.x,e1m3.y,nil) then
			if minetest.get_node(e1m3).name == "labyrinthus:empty_gate_purple" then
                minetest.set_node(e1m3, {name="labyrinthus:gate"})
			else
				minetest.set_node(e2m3, {name="labyrinthus:transport_stone_gate_arrows"})
			end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:arrow4" then
		minetest.set_node(e2m2, {name="air"})
		local d = 0
		local dd = 0
		local mode = 0
		local dir_x = 0
		local dir_y = 0
		
		if dir1 == "up" then
			dir_y = 1
		elseif dir1 == "down" then
			dir_y = -1
		elseif dir1 == "right" then
			dir_x = 1
		elseif dir1 == "left" then
			dir_x = -1
		end
		local bow_x = x+10+2*dir_x
		local bow_y = y+8+2*dir_y
		local bow_sx = bow_x
		local bow_sy = bow_y
		if minetest.get_node({x=x+10+dir_x, y=y+8+dir_y, z=-76}).name == "labyrinthus:arrow_path" or minetest.get_node({x=x+10+dir_x, y=y+8+dir_y, z=-76}).name == "labyrinthus:arrow_path_button" then
			mode = 1
		end
		while (((Is_Node(bow_x,bow_y,"arrow4") or (Is_Node(bow_x,bow_y,"group_dirt") and Is_Node(bow_x+dir_x*(-1),bow_y+dir_y*(-1),"group_dirt") and minetest.get_node({x=bow_x, y=bow_y, z=-77	}).name == "air")) and mode == 0) or (Is_Node(bow_x,bow_y,"arrow5") and mode == 1 )) and d == 0 do
			if minetest.get_node({x=bow_x, y=bow_y, z=-76}).name == "labyrinthus:arrow_path" or minetest.get_node({x=bow_x, y=bow_y, z=-76}).name == "labyrinthus:arrow_path_button" then
				mode = 1
			else
				mode = 0
			end
			if minetest.get_node({x=bow_x, y=bow_y, z=-76}).name == "labyrinthus:arrow4_2" then
				d = 1
				minetest.set_node({x=bow_x, y=bow_y, z=-76}, {name="labyrinthus:sand"})
			end
			bow_y = bow_y+dir_y
			bow_x = bow_x+dir_x
		end
		if bow_x == bow_sx and bow_y == bow_sy then
			dd = 1
		end
		bow_y = bow_y-dir_y
		bow_x = bow_x-dir_x
		if d == 0 then
			minetest.set_node({x=bow_x, y=bow_y, z=-77}, {name="labyrinthus:arrow4"})
		end
		if dd == 0 then
			minetest.set_node(e2m1, {name="air"})
			if donetp2 == 0 then
				minetest.set_node(e2m2, {name="nyancat:nyancat"})
				Other(player, pbjnr)
				player_inv:set_stack(ko, 1, "labyrinthus:dirt "..koad)
			end
		end
	elseif minetest.get_node(e2m2).name == "labyrinthus:arrow5_yellow" then
		local d = 0
		local dir_x = 0
		local dir_y = 0
		if dir1 == "up" then
			dir_y = 1
		elseif dir1 == "down" then
			dir_y = -1
		elseif dir1 == "right" then
			dir_x = 1
		elseif dir1 == "left" then
			dir_x = -1
		end
		local bow_x = x+10+2*dir_x
		local bow_y = y+8+2*dir_y
		local mode = ""
		if Is_Node(e1m1.x,e1m1.y,"group_dirt") and Is_Node(e1m2.x,e1m2.y,"group_dirt") then
			mode = "dirt"
		end
		if Is_Node(e1m1.x,e1m1.y,"not_group_dirt") and Is_Node(e1m2.x,e1m2.y,"not_group_dirt") then
			mode = "not_dirt"
		end
		while d == 0 do
			if (Dirt_Move2({x=bow_x, y=bow_y, z=-76}, false) and minetest.get_node({x=bow_x, y=bow_y, z=-76}).name ~= "labyrinthus:dirt_with_red_circle" and minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "air" and mode == "dirt") or (Is_Node(bow_x,bow_y,nil) and mode == "not_dirt") then
				minetest.set_node({x=bow_x, y=bow_y, z=-77}, {name="labyrinthus:arrow5_yellow"})
			else
				d = 1
			end
			bow_y = bow_y+dir_y
			bow_x = bow_x+dir_x
		end
	elseif minetest.get_node(e2m2).name == "labyrinthus:arrow5_red" then
		local d = 0
		local dir_x = 0
		local dir_y = 0
		if dir1 == "up" then
			dir_y = 1
		elseif dir1 == "down" then
			dir_y = -1
		elseif dir1 == "right" then
			dir_x = 1
		elseif dir1 == "left" then
			dir_x = -1
		end
		local bow_x = x+10+2*dir_x
		local bow_y = y+8+2*dir_y
		local mode = ""
		if Is_Node(e1m1.x,e1m1.y,"group_dirt") and Is_Node(e1m2.x,e1m2.y,"group_dirt") then
			mode = "dirt"
		end
		if Is_Node(e1m1.x,e1m1.y,"not_group_dirt") and Is_Node(e1m2.x,e1m2.y,"not_group_dirt") then
			mode = "not_dirt"
		end
		while d == 0 do
			if (Dirt_Move2({x=bow_x, y=bow_y, z=-76}, false) and minetest.get_node({x=bow_x, y=bow_y, z=-76}).name ~= "labyrinthus:dirt_with_yellow_circle" and minetest.get_node({x=bow_x, y=bow_y, z=-77}).name == "air" and mode == "dirt") or (Is_Node(bow_x,bow_y,nil) and mode == "not_dirt") then
				minetest.set_node({x=bow_x, y=bow_y, z=-77}, {name="labyrinthus:arrow5_red"})
			else
				d = 1
			end
			bow_y = bow_y+dir_y
			bow_x = bow_x+dir_x
		end
    elseif minetest.get_node(e2m2).name == "labyrinthus:arrow3" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:arrow3"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
            update()
            if minetest.get_node(e1m1).name == "labyrinthus:boom" then
                minetest.set_node(e1m1, {name="labyrinthus:sand"})
                local x = player_inv:get_stack("x", 1):get_count()
                local y = player_inv:get_stack("y", 1):get_count()
                for j=10,29 do
                    for l=9,20 do
                        if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:tnt" then
                            minetest.set_node({x=j, y=l, z=-77}, {name="air"})
                            if minetest.get_node({x=j-1, y=l, z=-77}).name == "labyrinthus:cobble" then
                                minetest.set_node({x=j-1, y=l, z=-77}, {name="air"})
                            end
                            if minetest.get_node({x=j+1, y=l, z=-77}).name == "labyrinthus:cobble" then
                                minetest.set_node({x=j+1, y=l, z=-77}, {name="air"})
                            end
                            if minetest.get_node({x=j, y=l-1, z=-77}).name == "labyrinthus:cobble" then
                                minetest.set_node({x=j, y=l-1, z=-77}, {name="air"})
                            end
                            if minetest.get_node({x=j, y=l+1, z=-77}).name == "labyrinthus:cobble" then
                                minetest.set_node({x=j, y=l+1, z=-77}, {name="air"})
                            end
                        end
                    end
                end
            end
            local bones = player_inv:get_stack("b", 1):get_count()
            if minetest.get_node(e1m1).name == "labyrinthus:sand" then
                if bones == 1 then
                    minetest.set_node(e1m1, {name="labyrinthus:bones"})
                end
            end
            local a = player_inv:get_stack("a", 1):get_count()
			
            if a == 0 then
                if dir1 == "right" then
					move_control(player, pointed_thing, Right, Left, 1)
                elseif dir1 == "up" then
					move_control(player, pointed_thing, Up, Down, 4)
                elseif dir1 == "down" then
                    move_control(player, pointed_thing, Down, Up, 2)
                elseif dir1 == "left" then
                    move_control(player, pointed_thing, Left, Right, 3)
                end
            else
                if dir2 == "right" then
                    move_control(player, pointed_thing, Right, Left, 1)
                elseif dir2 == "up" then
                    move_control(player, pointed_thing, Up, Down, 4)
                elseif dir2 == "down" then
                    move_control(player, pointed_thing, Down, Up, 2)
                elseif dir2 == "left" then
                    move_control(player, pointed_thing, Left, Right, 3)
                end
            end
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:bow_right" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:bow_right"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:bow_left" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:bow_left"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:bow_down" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:bow_down"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:bow_up" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:bow_up"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:stone_with_no_white1" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:stone_with_no_white1"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:stone_with_white2" then
		minetest.set_node(e2m2, {name="labyrinthus:stone_with_no_white2"})
		local white = player_inv:get_stack("w", 1):get_count()
		player_inv:set_stack("w", 1, "labyrinthus:dirt "..(white+1))
    elseif minetest.get_node(e2m2).name == "labyrinthus:nyan1" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:nyan1"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:nyan2" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:nyan2"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:nyan3" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:nyan3"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:nyan4" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:nyan4"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:eye2" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:glass"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:glass" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:glass"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:tnt" then
		if Dirt_Move(e1m1,e1m2,e1m3,nil) then
			minetest.set_node(e2m3, {name="labyrinthus:tnt"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:4" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:3"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:3" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:2"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:2" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:1"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:1" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:0"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:red" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:blue"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:blue" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:yellow"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:yellow" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:red"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:grey1" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:grey3"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:grey2" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:grey1"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:grey3" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:grey2"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:2red" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:2blue"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:2blue" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:2yellow"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:2yellow" then
        if Dirt_Move(e1m1,e1m2,e1m3,nil) then
            minetest.set_node(e2m3, {name="labyrinthus:2red"})
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:red2" then
        if Dirt_Move(e1m1,e1m2,e1m3,"red") then
            if minetest.get_node(e1m3).name == "labyrinthus:red1" then
            elseif minetest.get_node(e1m3).name == "labyrinthus:green_col" then
                minetest.set_node(e2m3, {name="labyrinthus:green2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            elseif minetest.get_node(e1m3).name == "labyrinthus:blue_col" then
                minetest.set_node(e2m3, {name="labyrinthus:blue2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            elseif minetest.get_node(e1m3).name == "labyrinthus:red_col" then
                minetest.set_node(e2m3, {name="labyrinthus:red2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            else
                minetest.set_node(e2m3, {name="labyrinthus:red2"})
            end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:green2" then
        if Dirt_Move(e1m1,e1m2,e1m3,"green") then
            if minetest.get_node(e1m3).name == "labyrinthus:green1" then
            elseif minetest.get_node(e1m3).name == "labyrinthus:green_col" then
                minetest.set_node(e2m3, {name="labyrinthus:green2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            elseif minetest.get_node(e1m3).name == "labyrinthus:blue_col" then
                minetest.set_node(e2m3, {name="labyrinthus:blue2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            elseif minetest.get_node(e1m3).name == "labyrinthus:red_col" then
                minetest.set_node(e2m3, {name="labyrinthus:red2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            else
                minetest.set_node(e2m3, {name="labyrinthus:green2"})
            end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
    elseif minetest.get_node(e2m2).name == "labyrinthus:blue2" then
        if Dirt_Move(e1m1,e1m2,e1m3,"blue") then
            if minetest.get_node(e1m3).name == "labyrinthus:blue1" then
            elseif minetest.get_node(e1m3).name == "labyrinthus:green_col" then
                minetest.set_node(e2m3, {name="labyrinthus:green2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            elseif minetest.get_node(e1m3).name == "labyrinthus:blue_col" then
                minetest.set_node(e2m3, {name="labyrinthus:blue2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            elseif minetest.get_node(e1m3).name == "labyrinthus:red_col" then
                minetest.set_node(e2m3, {name="labyrinthus:red2"})
                minetest.set_node(e1m3, {name="labyrinthus:sand"})
            else
                minetest.set_node(e2m3, {name="labyrinthus:blue2"})
            end
            one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:bow_right_block" or minetest.get_node(e2m2).name == "labyrinthus:bow_left_block" or minetest.get_node(e2m2).name == "labyrinthus:bow_down_block" or minetest.get_node(e2m2).name == "labyrinthus:bow_up_block" then
		for i=10,29 do
			for k=9,20 do
				if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_right" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_left" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_up" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_down" then
					minetest.set_node({x=i, y=k, z=-77}, {name="labyrinthus:bow_"..dir1})
				end
				if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_right_block" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_left_block" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_up_block" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:bow_down_block" then
					minetest.set_node({x=i, y=k, z=-77}, {name="labyrinthus:bow_"..dir1.."_block"})
				end
			end
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:dirt" then
		if Dirt_Move2(e1m1,overdirt) or (minetest.get_node(e1m1).name == "labyrinthus:rainbow3" and minetest.get_node({x=e1m1.x, y=e1m1.y-1, z=e1m1.z}).name == "labyrinthus:dirt") then
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:dirt_with_yellow_circle" then
		if Dirt_Move2(e1m1,overdirt) or (minetest.get_node(e1m1).name == "labyrinthus:rainbow3" and minetest.get_node({x=e1m1.x, y=e1m1.y-1, z=e1m1.z}).name == "labyrinthus:dirt") then
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:dirt_with_red_circle" then
		if Dirt_Move2(e1m1,overdirt) or (minetest.get_node(e1m1).name == "labyrinthus:rainbow3" and minetest.get_node({x=e1m1.x, y=e1m1.y-1, z=e1m1.z}).name == "labyrinthus:dirt") then
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:button2_2" then
		if Dirt_Move2(e1m1,overdirt) or (minetest.get_node(e1m1).name == "labyrinthus:rainbow3" and minetest.get_node({x=e1m1.x, y=e1m1.y-1, z=e1m1.z}).name == "labyrinthus:dirt") then
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
		end
	elseif minetest.get_node(e1m2).name == "labyrinthus:button3_2" then
		if Dirt_Move2(e1m1,overdirt) or (minetest.get_node(e1m1).name == "labyrinthus:rainbow3" and minetest.get_node({x=e1m1.x, y=e1m1.y-1, z=e1m1.z}).name == "labyrinthus:dirt") then
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
		end
    elseif minetest.get_node(e2m2).name == "labyrinthus:key1" then
        if key > 0 then
            player_inv:set_stack("k", 1, "labyrinthus:dirt "..(key-1))
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
        end
	elseif minetest.get_node(e2m2).name == "labyrinthus:key3" then
        if key > 0 then
            player_inv:set_stack("k", 1, "labyrinthus:dirt "..(key-1))
			minetest.set_node(e2m2, {name="air"})
        end
		local a2 = player_inv:get_stack("a2", 1):get_count()
		if a2 == 1 then
			one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,2)
		end
	elseif minetest.get_node(e2m2).name == "labyrinthus:yellow_red" then
		if dir1 == "up" then
			local red = player_inv:get_stack("re", 1):get_count()
			if red > 0 then
				player_inv:set_stack("re", 1, "labyrinthus:dirt "..(red-1))
				minetest.set_node(e2m2, {name="labyrinthus:red_with_no_yellow"})
				local yellow = player_inv:get_stack("ye", 1):get_count()
				player_inv:set_stack("ye", 1, "labyrinthus:dirt "..(yellow+1))
			end
		end
    elseif donetp2 == 0 then
        one_step(e1m2,e2m1,e2m2,ko,koad,player,pbjnr,"",false,donetp2,1)
    end
	local tp_wire = false
	local f = 0
	if minetest.get_node(e1m3).name == "labyrinthus:tp3" and tp3 then
		local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        local z = player_inv:get_stack("z", 1):get_count()
        for i=(x+10),28 do
            for k=9,20 do
                if i == (x+10) and (k-(y+8)) < 1 then
                else
                    if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp3" and (minetest.get_node({x=i, y=k, z=-77}).name == "air" or minetest.get_node({x=i, y=k, z=-77}).name == "nyancat:nyancat") and f == 0 then
						if e1m3.x ~= i or e1m3.y ~= k then
                            minetest.set_node({x=i, y=k, z=-77}, {name=minetest.get_node(e2m3).name})
							f = 1
                        end
                    end
                end
            end
        end
        for i=11,(x+10) do
            for k=9,20 do
                if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp3" and (minetest.get_node({x=i, y=k, z=-77}).name == "air" or minetest.get_node({x=i, y=k, z=-77}).name == "nyancat:nyancat") and f == 0 then
					if e1m3.x ~= i or e1m3.y ~= k then
                        minetest.set_node({x=i, y=k, z=-77}, {name=minetest.get_node(e2m3).name})
                        f = 1
                    end
                end
            end
        end
		if f == 1 then
			minetest.set_node(e2m3, {name="air"})
		end
	end
	if (minetest.get_node(e1m2).name == "labyrinthus:tp" or minetest.get_node(e1m2).name == "labyrinthus:tp2" or minetest.get_node(e1m2).name == "labyrinthus:tp3") and (minetest.get_node(e2m2).name == "nyancat:nyancat" or f == 1) then
		if minetest.get_node(e1m1).name == "labyrinthus:tp3" or minetest.get_node(e1m1).name == "labyrinthus:tp2" or minetest.get_node(e1m1).name == "labyrinthus:tp" then
			if minetest.get_node(e2m1).name == "air" and wire == 1 and no_wire == false then
				if dir1 == "up" then
					if minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_11000000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01100000", param2 = 8})
					end
				elseif dir1 == "down" then
					if minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00110000", param2 = 8})
					end
				elseif dir1 == "right" then
					if minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10100000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_11000000", param2 = 8})
					end
				elseif dir1 == "left" then
					if minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10100000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00110000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01100000", param2 = 8})
					end
				end
			end
		else
			if minetest.get_node(e2m2).name == "nyancat:nyancat" and wire == 1 and no_wire == false then
				if dir1 == "down" then
					minetest.set_node(e2m2, {name="labyrinthus:wire_01000000", param2 = 8})
				elseif dir1 == "up" then
					minetest.set_node(e2m2, {name="labyrinthus:wire_00010000", param2 = 8})
				elseif dir1 == "left" then
					minetest.set_node(e2m2, {name="labyrinthus:wire_10000000", param2 = 8})
				elseif dir1 == "right" then
					minetest.set_node(e2m2, {name="labyrinthus:wire_00100000", param2 = 8})
				end
			end
			minetest.set_node(e2m1, {name="air"})
		end
        player_inv:set_stack(ko, 1, "labyrinthus:dirt "..koad)
        Other(player, pbjnr)
        local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        local z = player_inv:get_stack("z", 1):get_count()
        local f = 0
        for i=(x+10),29 do
            for k=9,20 do
                if i == (x+10) and (k-(y+8)) < 1 then
                else
                    if ((minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp" and minetest.get_node(e1m2).name == "labyrinthus:tp") or (minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp2" and minetest.get_node({x=i, y=k, z=-77}).name == "air" and minetest.get_node(e1m2).name == "labyrinthus:tp2") or (minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp3" and minetest.get_node({x=i, y=k, z=-77}).name == "air" and minetest.get_node(e1m2).name == "labyrinthus:tp3")) and f == 0 then
                        local xx = i-10
                        local yy = k-8
                        if x ~= xx or y ~= yy then
                            x = xx
                            y = yy
                            f = 1
							donetp2 = 1
                        end
                    end
                end
            end
        end
        for i=10,(x+10) do
            for k=9,20 do
                if ((minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp" and minetest.get_node(e1m2).name == "labyrinthus:tp") or (minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp2" and minetest.get_node({x=i, y=k, z=-77}).name == "air" and minetest.get_node(e1m2).name == "labyrinthus:tp2") or (minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:tp3" and minetest.get_node({x=i, y=k, z=-77}).name == "air" and minetest.get_node(e1m2).name == "labyrinthus:tp3")) and f == 0 then
                    local xx = i-10
                    local yy = k-8
                    if x ~= xx or y ~= yy then
                        x = xx
                        y = yy
                        f = 1
						donetp2 = 1
                    end
                end
            end
        end
		if donetp2 == 1 and f == 1 then
			if wire == 1 and no_wire == false then
				if dir1 == "up" then
					if minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
					else
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
					end
				elseif dir1 == "down" then
					if minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
					else
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
					end
				elseif dir1 == "right" then
					if minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
					else
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
					end
				elseif dir1 == "left" then
					if minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
					elseif minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
					else
						minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
					end
				end
			end
		end
        player_inv:set_stack("x", 1, "labyrinthus:dirt "..x)
        player_inv:set_stack("y", 1, "labyrinthus:dirt "..y)
        local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        minetest.set_node({x=x+10, y=y+8, z=-77}, {name="nyancat:nyancat"})
        tptp = tptp+1
	end
    local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
    local bones = player_inv:get_stack("b", 1):get_count()
	if minetest.get_node(e1m2).name == "labyrinthus:empty_gate" and (minetest.get_node(e2m2).name == "nyancat:nyancat" or minetest.get_node(e2m2).name == "labyrinthus:nyancat2") then
		local purple = player_inv:get_stack("p", 1):get_count()
		if purple > 0 then
            player_inv:set_stack("p", 1, "labyrinthus:dirt "..(purple-1))
			minetest.set_node(e1m2, {name="labyrinthus:empty_gate_purple"})
		end
	end
	if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:ice_with_green" and trfire == true then
		local green = player_inv:get_stack("g", 1):get_count()
        player_inv:set_stack("g", 1, "labyrinthus:dirt "..(green+1))
    end
	if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:ice_with_white" and trfire == true then
		local green = player_inv:get_stack("w", 1):get_count()
        player_inv:set_stack("w", 1, "labyrinthus:dirt "..(green+1))
    end
	if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:ice_with_yellow" and trfire == true then
		local yellow = player_inv:get_stack("ye", 1):get_count()
        player_inv:set_stack("ye", 1, "labyrinthus:dirt "..(yellow+1))
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:sand" then
        if bones == 1 then
            minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:bones"})
        end
    end
	local wire = player_inv:get_stack("wire", 1):get_count()
	
	if minetest.get_node({x=wire_x+10, y=wire_y+8, z=-77}).name == "air" and wire == 1 and no_wire == false then
		if minetest.get_node({x=wire_x+10, y=wire_y+8, z=-76}).name == "labyrinthus:cross_switch" or ((minetest.get_node({x=wire_x+10, y=wire_y+8, z=-76}).name == "labyrinthus:tp3" or minetest.get_node({x=wire_x+10, y=wire_y+8, z=-76}).name == "labyrinthus:tp2" or minetest.get_node({x=wire_x+10, y=wire_y+8, z=-76}).name == "labyrinthus:tp") and donetp2 == 1) then
			if minetest.get_node({x=wire_x+10, y=wire_y+8, z=-76}).name == "labyrinthus:cross_switch" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-76}, {name="labyrinthus:sand"})
			end
			if dir1 == "up" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
			elseif dir1 == "down" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
			elseif dir1 == "right" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
			elseif dir1 == "left" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
			end
		elseif dir1 == "up" then
		    if minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01010000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_11000000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01100000", param2 = 8})
			else
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
			end
		elseif dir1 == "down" then
		    if minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01010000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10010000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00110000", param2 = 8})
			else
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
			end
		elseif dir1 == "right" then
		    if minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10010000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10100000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10010000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_11000000", param2 = 8})
			else
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
			end
		elseif dir1 == "left" then
		    if minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_10100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00100000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_00110000" or minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_10100000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_11000000" or minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:wire_01100000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00110000", param2 = 8})
			elseif minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_01010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_10010000" or minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:wire_00110000" then
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_01100000", param2 = 8})
			else
				minetest.set_node({x=wire_x+10, y=wire_y+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
			end
		end
	end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:button11" then
        minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:button12"})
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:moon" then
        for i = 9, 30 do
            for j = 0,14 do
                minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:stone"})
            end
        end
        local pos = {x=19, y=10.5, z=-88}
	    local size = 30
	    size = math.max(math.floor(size - 8), 0) 
	    local minp = vector.subtract(pos, size)
	    local maxp = vector.add(pos, size)
	    local vm = minetest.get_voxel_manip(minp, maxp)
	    vm:update_liquids()
	    vm:write_to_map()
	    vm:update_map()
	    local emin, emax = vm:get_emerged_area()
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:sun" then
        for i = 9, 30 do
            for j = 0,14 do
                minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:meselamp"})
            end
        end
        local pos = {x=19, y=10.5, z=-88}
	    local size = 30
	    size = math.max(math.floor(size - 8), 0) 
	    local minp = vector.subtract(pos, size)
	    local maxp = vector.add(pos, size)
	    local vm = minetest.get_voxel_manip(minp, maxp)
	    vm:update_liquids()
	    vm:write_to_map()
	    vm:update_map()
	    local emin, emax = vm:get_emerged_area()
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:time30" then
        player_inv:set_stack("time", 1, "labyrinthus:dirt")
    end
    local time = player_inv:get_stack("time", 1):get_count()
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name ~= "labyrinthus:time30" and time == 1 then
        player_inv:set_stack("time", 1, "labyrinthus:dirt 2")
    end
	local secx = player_inv:get_stack("sx", 1):get_count()
    local secy = player_inv:get_stack("sy", 1):get_count()
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:fire" and trfire == true and (secx ~= x or secy ~= y) then
        player_inv:set_stack("f", 1, "labyrinthus:dirt "..(fire+1))
        player_inv:set_stack("a2", 1, nil)
        local fire = player_inv:get_stack("f", 1):get_count()
        if fire > 1 then
            player_inv:set_stack("x", 1, nil)
            player_inv:set_stack("y", 1, nil)
            player_inv:set_stack("z", 1, nil)
            minetest.set_node({x=x+10, y=y+8, z=-77}, {name="air"})
            minetest.chat_send_all("Oh no! Nyan Cat was killed!")
        else
            minetest.chat_send_all("That hurt!")
        end
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:arrow" then
        local a = player_inv:get_stack("a", 1):get_count()
        if a == 0 then
            minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:sand"})
        end
        local bones = player_inv:get_stack("b", 1):get_count()
        if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:sand" then
            if bones == 1 then
                minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:bones"})
            end
        end
        player_inv:set_stack("a", 1, "labyrinthus:dirt")
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:arrow2" then
        minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:sand"})
        local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        local bones = player_inv:get_stack("b", 1):get_count()
        if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:sand" then
            if bones == 1 then
                minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:bones"})
            end
        end
        player_inv:set_stack("a2", 1, "labyrinthus:dirt")
        local a = player_inv:get_stack("a", 1):get_count()
		if a == 0 then
			if dir1 == "right" then
				move_control(player, pointed_thing, Right, Left, 1)
			elseif dir1 == "up" then
				move_control(player, pointed_thing, Up, Down, 4)
			elseif dir1 == "down" then
				move_control(player, pointed_thing, Down, Up, 2)
			elseif dir1 == "left" then
				move_control(player, pointed_thing, Left, Right, 3)
			end
		else
			if dir2 == "right" then
				move_control(player, pointed_thing, Right, Left, 1)
			elseif dir2 == "up" then
				move_control(player, pointed_thing, Up, Down, 4)
			elseif dir2 == "down" then
				move_control(player, pointed_thing, Down, Up, 2)
			elseif dir2 == "left" then
				move_control(player, pointed_thing, Left, Right, 3)
			end
		end
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:boom" then
        minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:sand"})
        local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        local bones = player_inv:get_stack("b", 1):get_count()
        if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:sand" then
            if bones == 1 then
                minetest.set_node({x=x+10, y=y+8, z=-76}, {name="labyrinthus:bones"})
            end
        end
        for j=10,29 do
            for l=9,20 do
                if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:tnt" then
                    minetest.set_node({x=j, y=l, z=-77}, {name="air"})
                    if minetest.get_node({x=j-1, y=l, z=-77}).name == "labyrinthus:cobble" then
                        minetest.set_node({x=j-1, y=l, z=-77}, {name="air"})
                    end
                    if minetest.get_node({x=j+1, y=l, z=-77}).name == "labyrinthus:cobble" then
                        minetest.set_node({x=j+1, y=l, z=-77}, {name="air"})
                    end
                    if minetest.get_node({x=j, y=l-1, z=-77}).name == "labyrinthus:cobble" then
                        minetest.set_node({x=j, y=l-1, z=-77}, {name="air"})
                    end
                    if minetest.get_node({x=j, y=l+1, z=-77}).name == "labyrinthus:cobble" then
                        minetest.set_node({x=j, y=l+1, z=-77}, {name="air"})
                    end
                end
            end
        end
    end
	if dir1 == "up" and minetest.get_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}).name == "labyrinthus:backward_arrow" then
		if minetest.get_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}).name == "air" and Dirt_Move3(e1m1.x,e1m1.y,dir1,"wood") and wood_moved == false then
			minetest.set_node({x=e2m1.x, y=e2m1.y-1, z=e2m1.z}, {name="air"})
			if minetest.get_node({x=e1m1.x, y=e1m1.y, z=e1m1.z}).name ~= "labyrinthus:gate_arrows" then
				minetest.set_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}, {name="labyrinthus:backward_arrow"})
			end
		end
	elseif dir1 == "down" and minetest.get_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}).name == "labyrinthus:backward_arrow" then
		if minetest.get_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}).name == "air" and Dirt_Move3(e1m1.x,e1m1.y,dir1,"wood") and wood_moved == false then
			minetest.set_node({x=e2m1.x, y=e2m1.y+1, z=e2m1.z}, {name="air"})
			if minetest.get_node({x=e1m1.x, y=e1m1.y, z=e1m1.z}).name ~= "labyrinthus:gate_arrows" then
				minetest.set_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}, {name="labyrinthus:backward_arrow"})
			end
		end
	elseif dir1 == "right" and minetest.get_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:backward_arrow" then
		if minetest.get_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}).name == "air" and Dirt_Move3(e1m1.x,e1m1.y,dir1,"wood") and wood_moved == false then
			minetest.set_node({x=e2m1.x-1, y=e2m1.y, z=e2m1.z}, {name="air"})
			if minetest.get_node({x=e1m1.x, y=e1m1.y, z=e1m1.z}).name ~= "labyrinthus:gate_arrows" then
				minetest.set_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}, {name="labyrinthus:backward_arrow"})
			end	
		end
	elseif dir1 == "left" and minetest.get_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}).name == "labyrinthus:backward_arrow" then
		if minetest.get_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}).name == "air" and Dirt_Move3(e1m1.x,e1m1.y,dir1,"wood") and wood_moved == false then
			minetest.set_node({x=e2m1.x+1, y=e2m1.y, z=e2m1.z}, {name="air"})
			if minetest.get_node({x=e1m1.x, y=e1m1.y, z=e1m1.z}).name ~= "labyrinthus:gate_arrows" then
				minetest.set_node({x=e2m1.x, y=e2m1.y, z=e2m1.z}, {name="labyrinthus:backward_arrow"})
			end	
		end
	end
    local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
    local dd = 0
    for i=10,29 do
        for k=9,20 do
            if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button12" and minetest.get_node({x=i, y=k, z=-77}).name == "air" then
                dd = dd+1
            end
        end
    end
    if dd == 2 then
        for i=10,29 do
            for k=9,20 do
                if minetest.get_node({x=i, y=k, z=-76}).name == "labyrinthus:button12" and minetest.get_node({x=i, y=k, z=-77}).name == "air" then
                    minetest.set_node({x=i, y=k, z=-77}, {name="labyrinthus:button13"})
                    minetest.set_node({x=i, y=k, z=-76}, {name="labyrinthus:sand"})
                end
            end
        end
    end
    for j=10,29 do
        for l=9,20 do
			local time_string = "labyrinthus:time"
			if string.sub(minetest.get_node({x=j, y=l, z=-76}).name, 1, #time_string) == time_string and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and pon == 0 then
				pon = 1
			end
			if string.sub(minetest.get_node({x=j, y=l, z=-76}).name, 1, #time_string) == time_string and minetest.get_node({x=j, y=l, z=-77}).name ~= "labyrinthus:pbj_pup" and pon == 1 then
				pon = 2
			end
        end
    end
    if minetest.get_node({x=x+10, y=y+8, z=-76}).name == "nyancat:nyancat_rainbow" or minetest.get_node({x=x+10, y=y+8, z=-76}).name == "labyrinthus:rainbow2" then
        minetest.set_node({x=x+10, y=y+8, z=-77}, {name="air"})
        player_inv:set_stack("x", 1, nil)
        player_inv:set_stack("y", 1, nil)
        player_inv:set_stack("z", 1, nil)
        player_inv:set_stack("time", 1, nil)
        pon = 0
		local level = ""
		if ll ~= 0 then
			local lv = io.open(minetest.get_worldpath().."/level"..ll..".txt", "r")
			level = lv:read("*l")
			lv:close()
		end
        minetest.chat_send_all("level completed")
        for i = 9, 30 do
            for j = 0,14 do
                minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:meselamp"})
            end
        end
        local pos = {x=19, y=10.5, z=-88}
	    local size = 30
	    size = math.max(math.floor(size - 8), 0) 
	    local minp = vector.subtract(pos, size)
	    local maxp = vector.add(pos, size)
	    local vm = minetest.get_voxel_manip(minp, maxp)
	    vm:update_liquids()
	    vm:write_to_map()
	    vm:update_map()
	    local emin, emax = vm:get_emerged_area()
		if ll ~= 0 then
			if tonumber(level) == tonumber(level2) then
				local le = io.open(minetest.get_worldpath().."/level"..ll..".txt", "w")
				le:write(level+1)
				le:close()
			end
		end
    end
	if anotherstep == 1 and minetest.get_node(e2m3).name == "air" then
		local a = player_inv:get_stack("a", 1):get_count()
		if a == 0 then
			if dir1 == "right" then
				move_control(player, true, Right, Left, 1)
			elseif dir1 == "up" then
				move_control(player, true, Up, Down, 4)
			elseif dir1 == "down" then
				move_control(player, true, Down, Up, 2)
			elseif dir1 == "left" then
				move_control(player, true, Left, Right, 3)
			end
		else
			if dir2 == "right" then
				move_control(player, true, Right, Left, 1)
			elseif dir2 == "up" then
				move_control(player, true, Up, Down, 4)
			elseif dir2 == "down" then
				move_control(player, true, Down, Up, 2)
			elseif dir2 == "left" then
				move_control(player, true, Left, Right, 3)
			end
		end
	end
end

function move_dir(player, dx, dy, dz, ko, koad, dir1, dir2, pbjnr, cond, overdirt, trfire)
	local inv = player:get_inventory()
	local x = inv:get_stack("x", 1):get_count()
	local y = inv:get_stack("y", 1):get_count()
	local koadf = player:get_inventory():get_stack(ko, 1):get_count()+koad
	if cond(x, y) then
		local base = {x = x + 10, y = y + 8, z = -76}
		local e1 = {
			base,
			{x = base.x + dx, y = base.y + dy, z = base.z + dz},
			{x = base.x + 2*dx, y = base.y + 2*dy, z = base.z + 2*dz}
		}
		local e2 = {
			{x = e1[1].x, y = e1[1].y, z = -77},
			{x = e1[2].x, y = e1[2].y, z = -77},
			{x = e1[3].x, y = e1[3].y, z = -77}
		}
		move(player, e1[1], e1[2], e1[3], e2[1], e2[2], e2[3], ko, koadf, dir1, dir2, pbjnr, trfire, overdirt)
	end
end

function Right(player, overdirt, trfire)
	move_dir(player, 1, 0, 0, "x", 1, "right", "left", 1,
		function(x, y) return x < 19 and x > -1 and y > 0 end, overdirt, trfire)
end

function Left(player, overdirt, trfire)
	move_dir(player, -1, 0, 0, "x", -1, "left", "right", 3,
		function(x, y) return x > 0 and x < 20 and y > 0 end, overdirt, trfire)
end

function Up(player, overdirt, trfire)
	move_dir(player, 0, 1, 0, "y", 1, "up", "down", 4,
		function(x, y) return y < 12 and y > 0 end, overdirt, trfire)
end

function Down(player, overdirt, trfire)
	move_dir(player, 0, -1, 0, "y", -1, "down", "up", 2,
		function(x, y) return y > 1 and y < 13 end, overdirt, trfire)
end

function move_control(player, overdirt, func, func2, r)
	Load(player)
    local player_inv = player:get_inventory()
    local a2 = player_inv:get_stack("a2", 1):get_count()
    local ff = 0
    tptp = 0
    player_inv:set_stack("r", 1, "labyrinthus:dirt "..r)
	while ff == 0 and a2 == 1 and tptp < 10 do
		local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        local a = player_inv:get_stack("a", 1):get_count()
		if a == 0 then
			func(player, overdirt, true)
        else
            func2(player, overdirt, true)
        end
		local x2 = player_inv:get_stack("x", 1):get_count()
        local y2 = player_inv:get_stack("y", 1):get_count()
		if x == x2 and y == y2 then
			ff = 1
		end
	end
	local a = player_inv:get_stack("a", 1):get_count()
    if a == 0 then
        if a2 == 1 then
            func(player, overdirt, false)
        else
            func(player, overdirt, true)
        end
    else
        if a2 == 1 then
            func2(player, overdirt, false)
        else
            func2(player, overdirt, true)
        end
    end
	if tptp < 10 then
    else
        minetest.chat_send_all("Oh no! Nyan Cat was teleported 10 times in a row and died of motion sickness!")
        local x = player_inv:get_stack("x", 1):get_count()
        local y = player_inv:get_stack("y", 1):get_count()
        minetest.set_node({x=x+10, y=y+8, z=-77}, {name="air"})
        player_inv:set_stack("x", 1, nil)
        player_inv:set_stack("y", 1, nil)
        player_inv:set_stack("z", 1, nil)
        player_inv:set_stack("time", 1, nil)
    end
end

controls.register_on_press(function(player, key)
	if player:get_player_control()[key] then
		if key == "aux1" then
			New(player,"","",2)
		elseif key == "sneak" then
			local player_inv = player:get_inventory()
			player_inv:set_size("ll", 1)
			player_inv:set_size("l", 6)
			local ll = player_inv:get_stack("ll", 1):get_count()
			local l = player_inv:get_stack("l", ll):get_count()
			local meta = player:get_meta()
			if ll == 0 and meta:get_string("celected") ~= "" then
			elseif ll ~= 0 then
				New(player,ll.."_"..l,"n",1)
			elseif meta:get_string("toplay") ~= "" then
				New(player,""..meta:get_string("toplay"),"o",1)
			end
		else
			move_data(player)
			if key == "up" then
				move_control(player, false, Up, Down, 4)
			elseif key == "down" then
				move_control(player, false, Down, Up, 2)
			elseif key == "right" then
				move_control(player, false, Right, Left, 1)
			elseif key == "left" then
				move_control(player, false, Left, Right, 3)
			elseif key == "jump" then
				Shot(player)
			update()
			end
		end
	end
end)

function Shot(player)
    local player_inv = player:get_inventory()
    Load(player)
    local r = player_inv:get_stack("r", 1):get_count()
    local x = player_inv:get_stack("x", 1):get_count()
    local y = player_inv:get_stack("y", 1):get_count()
    local s = player_inv:get_stack("s", 1):get_count()
	local ss = player_inv:get_stack("ss", 1):get_count()
	local a = player_inv:get_stack("a", 1):get_count()
	if a == 1 then
		if r == 1 then
			r = 3
		elseif r == 2 then
			r = 4
		elseif r == 3 then
			r = 1
		elseif r == 4 then
			r = 2
		end
	end
	local xx = x+10
	local yy = y+8
	local fx = 0
	local fy = 0
	if r == 1 then
		xx = x+11
		fx = 1
	elseif r == 2 then
		yy = y+7
		fy = -1
	elseif r == 3 then
		xx = x+9
		fx = -1
	elseif r == 4 then
		yy = y+9
		fy = 1
	end
    local d = 0
    if s > 0 or ss > 0 then
		while (r == 1 and x < 18 and d == 0) or (r == 2 and y > 1 and d == 0) or (r == 3 and x > 1 and d == 0) or (r == 4 and y < 10 and d == 0) do
			if minetest.get_node({x=xx, y=yy, z=-77}).name == "labyrinthus:apple" then
				if minetest.get_node({x=xx, y=yy, z=-76}).name ~= "labyrinthus:key2" and ((Is_Node(x+10,y+8,"group_dirt") and Is_Node(xx,yy,"group_dirt")) or (Is_Node(x+10,y+8,"not_group_dirt") and Is_Node(xx,yy,"not_group_dirt"))) then
					xx = xx+fx
					yy = yy+fy
				else
					d = 1
				end
			elseif minetest.get_node({x=xx, y=yy, z=-77}).name == "air" or minetest.get_node({x=xx, y=yy, z=-77}).name == "labyrinthus:meselamp2" then
				if minetest.get_node({x=xx, y=yy, z=-76}).name ~= "labyrinthus:key2" and ((Is_Node(x+10,y+8,"group_dirt") and Is_Node(xx,yy,"group_dirt")) or (Is_Node(x+10,y+8,"not_group_dirt") and Is_Node(xx,yy,"not_group_dirt"))) then
					if s > 0 then
						minetest.set_node({x=xx, y=yy, z=-77}, {name="labyrinthus:ball2"})
					else
						minetest.set_node({x=xx, y=yy, z=-77}, {name="labyrinthus:ball4"})
					end
					xx = xx+fx
					yy = yy+fy
				else
					d = 1
				end
			else
				d = 1
			end
		end
        minetest.after(0.1, function() 
            for i=10,29 do
                for k=9,20 do
                    if minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:ball2" or minetest.get_node({x=i, y=k, z=-77}).name == "labyrinthus:ball4" then
                        minetest.set_node({x=i, y=k, z=-77}, {name="air"})
                    end
                end
            end
        end)
		if s > 0 then
			player_inv:set_stack("s", 1, "")
		else
			player_inv:set_stack("ss", 1, "")
		end
    end
end

function Other(player,ri)
    local dd = 0
	local jj = 0
	local ll = 0
	local d = 0
	for j=10,29 do
		for l=9,20 do
			if ri == 1 then
				jj = j-1
				ll = l
			elseif ri == 3 then
				jj = j+1
				ll = l
			elseif ri == 2 then
				jj = j
				ll = l+1
			elseif ri == 4 then
				jj = j
				ll = l-1
			end
			local time_string = "labyrinthus:time"
			if string.sub(minetest.get_node({x=j, y=l, z=-76}).name, 1, #time_string) == time_string and minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and d == 0 then
				dd = 1
			end
			if minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and minetest.get_node({x=jj, y=ll, z=-77}).name == "air" and minetest.get_node({x=jj, y=ll, z=-76}).name == "labyrinthus:sand" and d == 0 then
				minetest.set_node({x=j, y=l, z=-77}, {name="air"})
				minetest.set_node({x=jj, y=ll, z=-77}, {name="labyrinthus:pbj_pup"})
				d = 1
			elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and (minetest.get_node({x=jj, y=ll, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=jj, y=ll, z=-77}).name == "labyrinthus:nyancat2") and minetest.get_node({x=jj, y=ll, z=-76}).name == "labyrinthus:sand" and d == 0 then
				minetest.set_node({x=j, y=l, z=-77}, {name="air"})
				minetest.set_node({x=jj, y=ll, z=-77}, {name="labyrinthus:pbj_pup"})
				d = 1
			elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and minetest.get_node({x=jj, y=ll, z=-77}).name == "air" and minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:dirt" and minetest.get_node({x=jj, y=ll, z=-76}).name == "labyrinthus:dirt" and d == 0 then
				minetest.set_node({x=j, y=l, z=-77}, {name="air"})
				minetest.set_node({x=jj, y=ll, z=-77}, {name="labyrinthus:pbj_pup"})
				d = 1
			elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and (minetest.get_node({x=jj, y=ll, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=jj, y=ll, z=-77}).name == "labyrinthus:nyancat2") and minetest.get_node({x=j, y=l, z=-76}).name == "labyrinthus:dirt" and minetest.get_node({x=jj, y=ll, z=-76}).name == "labyrinthus:dirt" and d == 0 then
				minetest.set_node({x=j, y=l, z=-77}, {name="air"})
				minetest.set_node({x=jj, y=ll, z=-77}, {name="labyrinthus:pbj_pup"})
				d = 1	
			elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and minetest.get_node({x=jj, y=ll, z=-77}).name == "air" and dd == 1 and d == 0 then
				minetest.set_node({x=j, y=l, z=-77}, {name="air"})
				minetest.set_node({x=jj, y=ll, z=-77}, {name="labyrinthus:pbj_pup"})
				d = 1
			elseif minetest.get_node({x=j, y=l, z=-77}).name == "labyrinthus:pbj_pup" and (minetest.get_node({x=jj, y=ll, z=-77}).name == "nyancat:nyancat" or minetest.get_node({x=jj, y=ll, z=-77}).name == "labyrinthus:nyancat2") and dd == 1 and d == 0 then
				minetest.set_node({x=j, y=l, z=-77}, {name="air"})
				minetest.set_node({x=jj, y=ll, z=-77}, {name="labyrinthus:pbj_pup"})
				d = 1
			end
		end
	end
end

function Is_Node(x,y,block)
	local d = 0
	if block == "group_dirt" then
		if minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:dirt" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:dirt_with_yellow_circle" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:dirt_with_red_circle" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:button2_2" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:button3_2" then
			return true
		end
	elseif block == "not_group_dirt" then
		if minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:dirt" and minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:dirt_with_yellow_circle" and minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:dirt_with_red_circle" and minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:button2_2" and minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:button3_2" then
			return true
		end
	else
		if block == "bow" then
			if minetest.get_node({x=x, y=y, z=-77}).name ~= "air" and 
			minetest.get_node({x=x, y=y, z=-77}).name ~= "labyrinthus:bow_right" and 
			minetest.get_node({x=x, y=y, z=-77}).name ~= "labyrinthus:bow_left" and 
			minetest.get_node({x=x, y=y, z=-77}).name ~= "labyrinthus:bow_down" and 
			minetest.get_node({x=x, y=y, z=-77}).name ~= "labyrinthus:bow_up" and 
			minetest.get_node({x=x, y=y, z=-77}).name ~= "labyrinthus:stone_with_no_white1" then
				d = 1
			end
			if (minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:dirt" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:dirt_with_yellow_circle" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:dirt_with_red_circle") or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:button2_2" or minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:button3_2" then
				d = 1
			end
		else
			if minetest.get_node({x=x, y=y, z=-77}).name ~= "air" then
				d = 1
			end
		end
		if minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:moon" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:white" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:key2" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:tp" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:ball1" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "nyancat:nyancat_rainbow" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:rainbow" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:bones" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:button12" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:fire" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:round2" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:round4" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:arrow" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:arrow2" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:sun" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:cyan" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:yellow2" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:red3" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:purple" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:gate" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:rainbow2" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:rainbow3" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:green" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:arrow_path_with_green" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:sand_for_green" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:sand_for_green_dirt" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:wood_for_yellow" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:purple_dirt" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:cyan_dirt" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:red_dirt" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:yellow_dirt" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:green_dirt" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_wood_with_green" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_wood_with_red" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_stone" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:ice_with_green" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:ice_with_white" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:ice_with_yellow" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_eye1_with_yellow" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_eye2_with_yellow" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_eye1_with_green" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_eye2_with_green" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_eye1_with_cyan" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:water_eye2_with_cyan" and 
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:ball3" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:bow" and
			minetest.get_node({x=x, y=y, z=-76}).name ~= "labyrinthus:cross_switch" then
			if block ~= "bow" then
				if block ~= "wood" and minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:water" then
					d = 1
				end
				if block ~= "red" and minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:red1" then
					d = 1
				end
				if block ~= "green" and minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:green1" then
					d = 1
				end
				if block ~= "blue" and minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:blue1" then
					d = 1
				end
				if block ~= "dirt" and Is_Node(x,y,"group_dirt") then
					if block ~= "wood" then
						d = 1
					end
				end
				if block ~= "arrow4" and minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:arrow4_2" then
					d = 1
				end
				if block == "arrow5" and minetest.get_node({x=x, y=y, z=-76}).name == "labyrinthus:sand" then
					d = 1
				end
			end
			if d == 0 then
				return true
			end
		end
	end
	return false
end

function Dirt_Move(e1m1,e1m2,e1m3,block)
	if (Is_Node(e1m1.x,e1m1.y,"group_dirt") and Is_Node(e1m2.x,e1m2.y,"group_dirt")
	and (Is_Node(e1m3.x,e1m3.y,"dirt") or Is_Node(e1m3.x,e1m3.y,"red") or Is_Node(e1m3.x,e1m3.y,"blue") or Is_Node(e1m3.x,e1m3.y,"green") or Is_Node(e1m3.x,e1m3.y,"wood")))
	or (Is_Node(e1m3.x,e1m3.y,block) and Is_Node(e1m1.x,e1m1.y,"not_group_dirt") and block ~= "wood") 
	or (Is_Node(e1m3.x,e1m3.y,block) and Is_Node(e1m1.x,e1m1.y,"not_group_dirt") and Is_Node(e1m2.x,e1m2.y,"not_group_dirt") and Is_Node(e1m3.x,e1m3.y,"not_group_dirt") and block == "wood") then
		return true
	end
end

function Dirt_Move2(e1m1,overdirt)
	if Is_Node(e1m1.x,e1m1.y,"group_dirt") or overdirt then
		return true
	end
end

function Dirt_Move3(x,y,dir,block)
	local firstx = x
	local firsty = y
	if dir == "up" then
		firsty = firsty-1
	elseif dir == "right" then
		firstx = firstx-1
	elseif dir == "left" then
		firstx = firstx+1
	elseif dir == "down" then
		firsty = firsty+1
	end
	if Is_Node(firstx,firsty,"group_dirt") and Is_Node(x,y,"group_dirt") and minetest.get_node({x=x, y=y, z=-77}).name == "air" then
		return true
	end
	if Is_Node(x,y,block) then
		return true
	end
end

function Load(player)
    local player_inv = player:get_inventory()
    player_inv:set_size("x", 1)
    player_inv:set_size("y", 1)
    player_inv:set_size("z", 1)
    player_inv:set_size("k", 1)
	player_inv:set_size("p", 1)
	player_inv:set_size("g", 1)
	player_inv:set_size("c", 1)
	player_inv:set_size("ye", 1)
	player_inv:set_size("re", 1)
	player_inv:set_size("w", 1)
    player_inv:set_size("r", 1)
    player_inv:set_size("s", 1)
	player_inv:set_size("ss", 1)
    player_inv:set_size("l", 6)
    player_inv:set_size("b", 1)
	player_inv:set_size("wire", 1)
    player_inv:set_size("a", 1)
    player_inv:set_size("a2", 1)
    player_inv:set_size("ll", 1)
    player_inv:set_size("page1", 1)
    player_inv:set_size("page2", 1)
    player_inv:set_size("page3", 1)
	player_inv:set_size("page5", 1)
	player_inv:set_size("page6", 1)
    player_inv:set_size("time", 1)
    player_inv:set_size("f", 1)
	player_inv:set_size("sx", 1)
	player_inv:set_size("sy", 1)
end

function New(player,page,art,num)
    local player_inv = player:get_inventory()
    Load(player)
	local file = io.open(minetest.get_worldpath().."/move1.txt", "r")
    local c = fsize(file)
    file:close()
	local ar1 = {}
    local ar2 = {}
	local ar3 = {}
	if c > 5 and num == 2 then
        local lv = io.open(minetest.get_worldpath().."/move1.txt", "r")
        for i=1,12 do
	        ar1[i] = lv:read("*l")
        end
        local zw = lv:read("*l")
        for i=1,12 do
	        ar2[i] = lv:read("*l")
        end
        local zw2 = lv:read("*l")
		for i = 1, 23 do 
			ar3[i] = lv:read("*l") 
		end
	end
	if num == 1 then
		local lv = io.open(minetest.get_worldpath().."/level1.txt", "r")
		local level = lv:read("*l")
		lv:close()
		if art == "n" then
			lv = io.open(minetest.get_modpath("labyrinthus").."/lv"..page..".txt", "r")
		elseif art == "o" then
			lv = io.open(minetest.get_worldpath().."/own_level_"..page..".txt", "r")
		end
		if string.sub(page, 1, 1) == "5" or string.sub(page, 1, 1) == "6" or art == "o" then
			for i=1,12 do
				ar1[i] = lv:read("*l")
			end
		else
			ar1[1] = "00000000000000000000"
			ar1[2] = "00000000000000000000"
			for i=3,12 do
				ar1[i] = "0"..lv:read("*l").."0"
			end
		end
		local zw = lv:read("*l")
		if string.sub(page, 1, 1) == "5" or string.sub(page, 1, 1) == "6" or art == "o" then
			for i=1,12 do
				ar2[i] = lv:read("*l")
			end
		else
			ar2[1] = "22222222222222222222"
			ar2[2] = "22222222222222222222"
			for i=3,12 do
				ar2[i] = "2"..lv:read("*l").."2"
			end
		end
		local zw2 = lv:read("*l")
		ar3[1] = lv:read("*l")
		ar3[2] = lv:read("*l")
		ar3[3] = lv:read("*l")
	end
	if num == 1 or (c > 5 and num == 2) then
		for i=10,29 do
			for j=-78,-76 do
				for k=9,20 do
					minetest.set_node({x=i, y=k, z=j}, {name="air"})
				end
			end
		end
		for j = 1, 12 do
			for i = 1, string.len(string.gsub(ar1[j], "\r", "")) do
				if string.sub(ar1[j], i, i) == "s" then
					if num == 1 then
						minetest.set_node({x=i+9, y=(13-j)+8, z=-76}, {name="labyrinthus:time30"})
					else
						minetest.set_node({x=i+9, y=(13-j)+8, z=-76}, {name="labyrinthus:time"..ar3[16]})
					end
				else
					minetest.set_node({x=i+9, y=(13-j)+8, z=-76}, {name=get_item_list(node_list1,string.sub(ar1[j], i, i),1,2)})
				end
			end
		end
		for j = 1, 12 do
			for i = 1, string.len(string.gsub(ar2[j], "\r", "")) do
				if string.sub(ar2[j], i, i) == "D" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:yellow_block", param2 = 8})
				elseif string.sub(ar2[j], i, i) == ":" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_10100000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == ";" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_10000000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "<" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_01000000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == ">" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_00100000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "|" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_00010000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "." then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_01010000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "," then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_11000000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "-" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_01100000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "_" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_00110000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "#" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name="labyrinthus:wire_10010000", param2 = 8})
				elseif string.sub(ar2[j], i, i) == "\\" then
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name=get_item_list(node_list2,string.sub(ar2[j], i, i),1,2), param2 = 8})
				else
					minetest.set_node({x=i+9, y=(13-j)+8, z=-77}, {name=get_item_list(node_list2,string.sub(ar2[j], i, i),1,2)})
				end
			end
		end
		if num == 1 then
			player_inv:set_stack("x", 1, "labyrinthus:dirt "..ar3[1])
			player_inv:set_stack("y", 1, "labyrinthus:dirt "..ar3[2])
			player_inv:set_stack("z", 1, "labyrinthus:dirt "..ar3[3])
			player_inv:set_stack("k", 1, nil)
			player_inv:set_stack("r", 1, nil)
			player_inv:set_stack("s", 1, nil)
			player_inv:set_stack("ss", 1, nil)
			player_inv:set_stack("p", 1, nil)
			player_inv:set_stack("g", 1, nil)
			player_inv:set_stack("c", 1, nil)
			player_inv:set_stack("ye", 1, nil)
			player_inv:set_stack("re", 1, nil)
			player_inv:set_stack("w", 1, nil)
			player_inv:set_stack("b", 1, nil)
			player_inv:set_stack("f", 1, nil)
			player_inv:set_stack("a", 1, nil)
			player_inv:set_stack("a2", 1, nil)
			player_inv:set_stack("time", 1, nil)
			player_inv:set_stack("wire", 1, nil)
			local file = io.open(minetest.get_worldpath().."/move1.txt", "w")
			file:write("")
			file:close()
			pon = 0
			for i = 9, 30 do
				for j = 0,14 do
					minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:meselamp"})
				end
			end
			local pos = {x=19, y=10.5, z=-88}
			local size = 30
			size = math.max(math.floor(size - 8), 0) 
			local minp = vector.subtract(pos, size)
			local maxp = vector.add(pos, size)
			local vm = minetest.get_voxel_manip(minp, maxp)
			vm:update_liquids()
			vm:write_to_map()
			vm:update_map()
			local emin, emax = vm:get_emerged_area()
			local x = player_inv:get_stack("x", 1):get_count()
			local y = player_inv:get_stack("y", 1):get_count()
			rrr = 0
			rrrr = 0
			minetest.set_node({x=x+10, y=y+8, z=-77}, {name="nyancat:nyancat"})
		else
			player_inv:set_stack("w", 1, "labyrinthus:dirt "..ar3[2])
			player_inv:set_stack("re", 1, "labyrinthus:dirt "..ar3[3])
			player_inv:set_stack("ye", 1, "labyrinthus:dirt "..ar3[4])
			player_inv:set_stack("c", 1, "labyrinthus:dirt "..ar3[5])
			player_inv:set_stack("p", 1, "labyrinthus:dirt "..ar3[6])
			player_inv:set_stack("g", 1, "labyrinthus:dirt "..ar3[7])
			player_inv:set_stack("k", 1, "labyrinthus:dirt "..ar3[8])
			player_inv:set_stack("r", 1, "labyrinthus:dirt "..ar3[9])
			player_inv:set_stack("s", 1, "labyrinthus:dirt "..ar3[10])
			player_inv:set_stack("ss", 1, "labyrinthus:dirt "..ar3[11])
			player_inv:set_stack("b", 1, "labyrinthus:dirt "..ar3[12])
			player_inv:set_stack("a", 1, "labyrinthus:dirt "..ar3[13])
			player_inv:set_stack("a2", 1, "labyrinthus:dirt "..ar3[14])
			player_inv:set_stack("time", 1, "labyrinthus:dirt "..ar3[15])
			player_inv:set_stack("f", 1, "labyrinthus:dirt "..ar3[17])
			player_inv:set_stack("x", 1, "labyrinthus:dirt "..ar3[18])
			player_inv:set_stack("y", 1, "labyrinthus:dirt "..ar3[19])
			player_inv:set_stack("z", 1, "labyrinthus:dirt "..ar3[20])
			local x = player_inv:get_stack("x", 1):get_count()
			local y = player_inv:get_stack("y", 1):get_count()
			minetest.set_node({x=x+10, y=y+8, z=-77}, {name="nyancat:nyancat"})
			pon = tonumber(ar3[21])
			rrr = tonumber(ar3[22])
			rrrr = tonumber(ar3[23])
			if ar3[1] == "false" then
				for i = 9, 30 do
					for j = 0,14 do
						minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:meselamp"})
					end
				end
			elseif ar3[1] == "true" then
				for i = 9, 30 do
					for j = 0,14 do
						minetest.set_node({x=i, y=22, z=-89+j}, {name="labyrinthus:stone"})
					end
				end
			end
			local pos = {x=19, y=10.5, z=-88}
			local size = 30
			size = math.max(math.floor(size - 8), 0) 
			local minp = vector.subtract(pos, size)
			local maxp = vector.add(pos, size)
			local vm = minetest.get_voxel_manip(minp, maxp)
			vm:update_liquids()
			vm:write_to_map()
			vm:update_map()
			local emin, emax = vm:get_emerged_area()
			for j=10,29 do
				for l=9,20 do
					if minetest.get_node({x=j, y=l, z=-77}).name == "nyancat:nyancat" then
						local fire = player_inv:get_stack("f", 1):get_count()
						if fire > 0 then
							minetest.set_node({x=j, y=l, z=-77}, {name="labyrinthus:nyancat2"})
						end
					end
				end
			end
		end
		update()
	end
end
function lvbut(from, num, level2)
	local formspec = 
		"image_button[4.5,-0.3;0.8,0.8;;esc;X]" ..
		"background[5,6.5;1,1;gui_formbg.png;true]" ..
		"listcolors[#00000069;#5A5A5A;#141318;#30434C;#FFF]" ..
		"bgcolor[#080808BB;true]"

	level2 = tonumber(level2)
	for i = 0, math.min(num - 1, 24) do
		if level2 > from + i then
			local x = i % 5
			local y = math.floor(i / 5) + 1
			local label = string.char(97 + i)
			formspec = formspec .. ("button[%d,%d;1,1;%s;%d]"):format(x, y, label, from + i + 1)
		end
	end
	return formspec
end
function level_formspec(player,file,max_level,level_count,previous_levels,previous_page,previous_page_name,next_page,next_name,pos)
	local player_inv = player:get_inventory()
	local lv = io.open(minetest.get_worldpath().."/"..file..".txt", "r")
	local level2 = lv:read("*l")
    lv:close()
    local player_inv = player:get_inventory()
	local formspec = "size[5,6.5]"
        .."label[0,0;World Level:     "..(tonumber(level2)-1).."/"..max_level.."]"
		if previous_page then
			formspec = formspec.."button[1.5,6;1,1;"..previous_page_name..";<]"
		end
		formspec = formspec..lvbut(previous_levels,level_count,level2)
		if tonumber(level2) > (previous_levels+level_count) then
			if next_page then
				formspec = formspec.."button[2.5,6;1,1;"..next_name..";>]"
			else
				formspec = formspec.."label[0,"..pos..";"..next_name.."]"
			end
		end
	return formspec
end
minetest.register_node("labyrinthus:new_w1",{
	tiles  = {"labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_new_w1.png"},
    paramtype = "light",
	light_source = 4,
	drawtype = "nodebox",
	use_texture_alpha = "clip",
    --groups = {snappy=1,choppy=2,oddly_breakable_by_hand=2,flammable=3},
    on_punch = function(pos, node, player, pointed_thing)
        minetest.show_formspec(player:get_player_name(), "tu" , level_formspec(player,"level1",18,18,0,false,"",false,"You have finished world 1!","4.7"))
    end,
})
minetest.register_node("labyrinthus:new_w2",{
	tiles  = {"labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_new_w2.png"},
    paramtype = "light",
	light_source = 4,
	drawtype = "nodebox",
	use_texture_alpha = "clip",
    --groups = {snappy=1,choppy=2,oddly_breakable_by_hand=2,flammable=3},
    on_punch = function(pos, node, player, pointed_thing)
        local player_inv = player:get_inventory()
        local page = player_inv:get_stack("page1", 1):get_count()+1
        if page == 1 then
			minetest.show_formspec(player:get_player_name(), "w11" , level_formspec(player,"level2",250,25,0,false,"",true,"wab",""))
        elseif page == 2 then
            minetest.show_formspec(player:get_player_name(), "w12" , level_formspec(player,"level2",250,25,25,true,"waa",true,"wac",""))
        elseif page == 3 then
            minetest.show_formspec(player:get_player_name(), "w13" , level_formspec(player,"level2",250,25,50,true,"wab",true,"wad",""))
        elseif page == 4 then
            minetest.show_formspec(player:get_player_name(), "w14" , level_formspec(player,"level2",250,25,75,true,"wac",true,"wae",""))
        elseif page == 5 then
            minetest.show_formspec(player:get_player_name(), "w15" , level_formspec(player,"level2",250,25,100,true,"wad",true,"waf",""))
        elseif page == 6 then
            minetest.show_formspec(player:get_player_name(), "w16" , level_formspec(player,"level2",250,25,125,true,"wae",true,"wag",""))
        elseif page == 7 then
            minetest.show_formspec(player:get_player_name(), "w17" , level_formspec(player,"level2",250,25,150,true,"waf",true,"wah",""))
        elseif page == 8 then
            minetest.show_formspec(player:get_player_name(), "w18" , level_formspec(player,"level2",250,25,175,true,"wag",true,"wai",""))
        elseif page == 9 then
            minetest.show_formspec(player:get_player_name(), "w19" , level_formspec(player,"level2",250,25,200,true,"wah",true,"waj",""))
        elseif page == 10 then
            minetest.show_formspec(player:get_player_name(), "w110" , level_formspec(player,"level2",250,25,225,true,"wai",false,"You have finished world 2!","5.7"))
        end
    end,
})
minetest.register_node("labyrinthus:new_w3",{
	tiles  = {"labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_new_w3.png"},
    paramtype = "light",
	light_source = 4,
	drawtype = "nodebox",
	use_texture_alpha = "clip",
    --groups = {snappy=1,choppy=2,oddly_breakable_by_hand=2,flammable=3},
    on_punch = function(pos, node, player, pointed_thing)
        local player_inv = player:get_inventory()
        local page = player_inv:get_stack("page2", 1):get_count()+1
        if page == 1 then
			minetest.show_formspec(player:get_player_name(), "w21" , level_formspec(player,"level3",174,25,0,false,"",true,"wbb",""))
        elseif page == 2 then
            minetest.show_formspec(player:get_player_name(), "w22" , level_formspec(player,"level3",174,25,25,true,"wba",true,"wbc",""))
        elseif page == 3 then
            minetest.show_formspec(player:get_player_name(), "w23" , level_formspec(player,"level3",174,25,50,true,"wbb",true,"wbd",""))
        elseif page == 4 then
            minetest.show_formspec(player:get_player_name(), "w24" , level_formspec(player,"level3",174,25,75,true,"wbc",true,"wbe",""))
        elseif page == 5 then
            minetest.show_formspec(player:get_player_name(), "w25" , level_formspec(player,"level3",174,25,100,true,"wbd",true,"wbf",""))
        elseif page == 6 then
            minetest.show_formspec(player:get_player_name(), "w26" , level_formspec(player,"level3",174,25,125,true,"wbe",true,"wbg",""))
        elseif page == 7 then
            minetest.show_formspec(player:get_player_name(), "w27" , level_formspec(player,"level3",174,24,150,true,"wbf",false,"You have finished world 3!","5.7"))
        end
    end,
})
minetest.register_node("labyrinthus:new_w4",{
	tiles  = {"labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_new_w4.png"},
    paramtype = "light",
	light_source = 4,
	drawtype = "nodebox",
	use_texture_alpha = "clip",
    --groups = {snappy=1,choppy=2,oddly_breakable_by_hand=2,flammable=3},
    on_punch = function(pos, node, player, pointed_thing)
        local player_inv = player:get_inventory()
        local page = player_inv:get_stack("page3", 1):get_count()+1
        if page == 1 then
            minetest.show_formspec(player:get_player_name(), "w31" , level_formspec(player,"level4",86,25,0,false,"",true,"wcb",""))
        elseif page == 2 then
            minetest.show_formspec(player:get_player_name(), "w32" , level_formspec(player,"level4",86,25,25,true,"wca",true,"wcc",""))
        elseif page == 3 then
            minetest.show_formspec(player:get_player_name(), "w33" , level_formspec(player,"level4",86,25,50,true,"wcb",true,"wcd",""))
        elseif page == 4 then
            minetest.show_formspec(player:get_player_name(), "w34" , level_formspec(player,"level4",86,11,75,true,"wcc",false,"You have finished world 4!","3.7"))
        end
    end,
})
minetest.register_node("labyrinthus:new_w5",{
	tiles  = {"labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_new_w5.png"},
    paramtype = "light",
	light_source = 4,
	drawtype = "nodebox",
	use_texture_alpha = "clip",
    --groups = {snappy=1,choppy=2,oddly_breakable_by_hand=2,flammable=3},
    on_punch = function(pos, node, player, pointed_thing)
        local player_inv = player:get_inventory()
        local page = player_inv:get_stack("page5", 1):get_count()+1
        if page == 1 then
            minetest.show_formspec(player:get_player_name(), "w51" , level_formspec(player,"level5",175,25,0,false,"",true,"wdb",""))
		elseif page == 2 then
            minetest.show_formspec(player:get_player_name(), "w52" , level_formspec(player,"level5",175,25,25,true,"wda",true,"wdc",""))
		elseif page == 3 then
            minetest.show_formspec(player:get_player_name(), "w53" , level_formspec(player,"level5",175,25,50,true,"wdb",true,"wdd",""))
		elseif page == 4 then
            minetest.show_formspec(player:get_player_name(), "w54" , level_formspec(player,"level5",175,25,75,true,"wdc",true,"wde",""))
		elseif page == 5 then
            minetest.show_formspec(player:get_player_name(), "w55" , level_formspec(player,"level5",175,25,100,true,"wdd",true,"wdf",""))
		elseif page == 6 then
            minetest.show_formspec(player:get_player_name(), "w56" , level_formspec(player,"level5",175,25,125,true,"wde",true,"wdg",""))
		elseif page == 7 then
            minetest.show_formspec(player:get_player_name(), "w57" , level_formspec(player,"level5",175,25,150,true,"wdf",false,"You have finished world 5!","5.7"))
        end
	end,
})
minetest.register_node("labyrinthus:new_w6",{
	tiles  = {"labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_glass.png","labyrinthus_new_w6.png"},
    paramtype = "light",
	light_source = 4,
	drawtype = "nodebox",
	use_texture_alpha = "clip",
    --groups = {snappy=1,choppy=2,oddly_breakable_by_hand=2,flammable=3},
    on_punch = function(pos, node, player, pointed_thing)
		local player_inv = player:get_inventory()
        local page = player_inv:get_stack("page6", 1):get_count()+1
        if page == 1 then
			minetest.show_formspec(player:get_player_name(), "w61" , level_formspec(player,"level6",50,25,0,false,"",true,"web",""))
		elseif page == 2 then
            minetest.show_formspec(player:get_player_name(), "w62" , level_formspec(player,"level6",50,25,25,true,"wea",false,"more comming soon","5.7"))
		end
    end,
})

function check_ground(ground_id, id)
	local list = {"2","z","3","4","6","a","b","#","c","h","j","p","q","H","I","J","K","Z","<",";","U","N","k","n","A","l","w","R",".","'","W","X","T"}
	local list_button = {"1", "y"}
	for _,v in pairs(list) do
		if v == ground_id then
			return false
		end
	end
	if ground_id ~= "0" and ground_id ~= "y" and (id == "6" or id == "C") then
		return false
	end
	if ground_id ~= "y" and (id == "N" or id == "O") then
		return false
	end
	return true
end

function check_num_items(meta, player, id, ids, num, name)
	node_letter = ""
	new_letter = true
	local k = 0
	for j=1,12 do
		for i=1,20 do
			for _, v in ipairs(ids) do
				if v == meta:get_string("na"..letter(i)..letter(j)) then
					k = k+1
				end
			end
		end
	end
	if k < num then
		node_letter = id
		meta:set_string("error_message", "")
		player:set_inventory_formspec(create2.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
	else
		new_letter = false
		meta:set_string("error_message", "You can only place "..num.." "..name.."!")
		minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
		player:set_inventory_formspec(create2.get_formspec(player))
	end
	return node_letter, new_letter
end

function place_only_once(meta, node_letter, layer)
	for i=1,20 do
		for j=1,12 do
			if meta:get_string(layer..letter(i)..letter(j)) == node_letter then
				meta:set_string(layer..letter(i)..letter(j),"0")
			end
		end
	end	
	return node_letter
end

function add_to_layerA(player, meta, i, j)
	local n1x = tonumber(meta:get_string("new_node1x"))
	local n1y = tonumber(meta:get_string("new_node1y"))
	local node_letter = ""
	local new_letter = true
	if n1x == 2 and n1y == 2 then
		node_letter, new_letter = check_num_items(meta, player, "a", {"a"}, 40, "keys")
	elseif n1x == 5 and n1y == 3 then	
		node_letter = place_only_once(meta, "l", "na")
	elseif n1x == 6 and n1y == 3 then
		node_letter = place_only_once(meta, "w", "na")
	elseif n1x == 5 and n1y == 4 then
		node_letter, new_letter = check_num_items(meta, player, "A", {"A", "G"}, 2, "purple orbs")
	elseif n1x == 6 and n1y == 4 then	
		node_letter, new_letter = check_num_items(meta, player, "G", {"A", "G"}, 2, "purple orbs")
	elseif n1x == 10 and n1y == 4 then
		node_letter, new_letter = check_num_items(meta, player, "I", {"I", "J", "O", ";", "]", "~"}, 50, "green orbs")
	elseif n1x == 11 and n1y == 4 then
		node_letter, new_letter = check_num_items(meta, player, "O", {"I", "J", "O", ";", "]", "~"}, 50, "green orbs")
	elseif n1x == 12 and n1y == 4 then
		node_letter, new_letter = check_num_items(meta, player, "J", {"I", "J", "O", ";", "]", "~"}, 50, "green orbs")
	elseif n1x == 13 and n1y == 4 then
		node_letter, new_letter = check_num_items(meta, player, ";", {"I", "J", "O", ";", "]", "~"}, 50, "green orbs")
	elseif n1x == 1 and n1y == 5 then
		node_letter, new_letter = check_num_items(meta, player, "]", {"I", "J", "O", ";", "]", "~"}, 50, "green orbs")
	elseif n1x == 2 and n1y == 5 then
		node_letter, new_letter = check_num_items(meta, player, "~", {"I", "J", "O", ";", "]", "~"}, 50, "green orbs")
	elseif n1x == 5 and n1y == 5 then
		node_letter, new_letter = check_num_items(meta, player, "R", {"R", "S", ".", "'"}, 60, "yellow orbs")
	elseif n1x == 6 and n1y == 5 then
		node_letter, new_letter = check_num_items(meta, player, "S", {"R", "S", ".", "'"}, 60, "yellow orbs")
	elseif n1x == 7 and n1y == 5 then	
		node_letter, new_letter = check_num_items(meta, player, "'", {"R", "S", ".", "'"}, 60, "yellow orbs")
	elseif n1x == 8 and n1y == 5 then
		node_letter, new_letter = check_num_items(meta, player, ".", {"R", "S", ".", "'"}, 60, "yellow orbs")
	elseif n1x == 10 and n1y == 5 then
		node_letter = "T"
		if j == 12 or check_ground(meta:get_string("na"..letter(i)..letter(j+1)), "T") == false or meta:get_string("nb"..letter(i)..letter(j)) ~= "0" then
			new_letter = false
			meta:set_string("error_message", "You can not place that there!")
			player:set_inventory_formspec(create2.get_formspec(player))
			minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
		else
			meta:set_string("nb"..letter(i)..letter(j+1), "D")
		end
	elseif n1x == 12 and n1y == 5 then
		node_letter, new_letter = check_num_items(meta, player, "W", {"W", "X", "["}, 10, "red orbs")
	elseif n1x == 13 and n1y == 5 then	
		node_letter, new_letter = check_num_items(meta, player, "[", {"W", "X", "["}, 10, "red orbs")
	elseif n1x == 1 and n1y == 6 then	
		node_letter, new_letter = check_num_items(meta, player, "X", {"W", "X", "["}, 10, "red orbs")
	elseif n1x == 2 and n1y == 6 then
		node_letter, new_letter = check_num_items(meta, player, "Z", {"Z", "<"}, 10, "white orbs")
	elseif n1x == 3 and n1y == 6 then
		node_letter, new_letter = check_num_items(meta, player, "<", {"Z", "<"}, 10, "white orbs")
	elseif n1x == 4 and n1y == 6 then
		node_letter, new_letter = check_num_items(meta, player, "L", {"L", "P", ","}, 10, "cyan orbs")
	elseif n1x == 5 and n1y == 6 then	
		node_letter, new_letter = check_num_items(meta, player, "P", {"L", "P", ","}, 10, "cyan orbs")
	elseif n1x == 6 and n1y == 6 then	
		node_letter, new_letter = check_num_items(meta, player, ",", {"L", "P", ","}, 10, "cyan orbs")
	else
		node_letter = get_item_list2(node_list1, n1x, n1y, 1)
	end
	if check_ground(node_letter, meta:get_string("nb"..letter(i)..letter(j))) == false and meta:get_string("nb"..letter(i)..letter(j)) ~= "0" then
		new_letter = false
		meta:set_string("error_message", "You can not put that under this block")
		player:set_inventory_formspec(create2.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
	end
	if new_letter then
		meta:set_string("na"..letter(i)..letter(j), node_letter)
		if meta:get_string("nb"..letter(i)..letter(j+1)) == "D" and node_letter ~= "T" then
			meta:set_string("nb"..letter(i)..letter(j+1), "0")
		end
		meta:set_string("error_message", "")
		player:set_inventory_formspec(create2.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
	end
end

function add_to_layerB(player, meta, i, j)
	local n2x = tonumber(meta:get_string("new_node2x"))
	local n2y = tonumber(meta:get_string("new_node2y"))
	local node_letter = ""
	local new_letter = true
	if n2x == 2 and n2y == 1 then
		node_letter = place_only_once(meta, "nn", "nb")
	elseif n2x == 7 and n2y == 2 then	
		node_letter = place_only_once(meta, "a", "nb")
	elseif n2x == 3 and n2y == 4 then	
		node_letter = place_only_once(meta, "H", "nb")
	elseif n2x == 4 and n2y == 4 then
		node_letter = place_only_once(meta, "I", "nb")
	elseif n2x == 5 and n2y == 4 then	
		node_letter = place_only_once(meta, "J", "nb")
	elseif n2x == 6 and n2y == 4 then
		node_letter = place_only_once(meta, "K", "nb")			
	elseif n2x == 7 and n2y == 4 then	
		node_letter = place_only_once(meta, "L", "nb")
	elseif n2x == 10 and n2y == 4 then	
		node_letter = "D"
		if j == 1 or meta:get_string("nb"..letter(i)..letter(j-1)) ~= "0" or check_ground(meta:get_string("na"..letter(i)..letter(j))) == false then
			new_letter = false
			meta:set_string("error_message", "You can not place that there!")
			player:set_inventory_formspec(create2.get_formspec(player))
			minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
		else
			meta:set_string("na"..letter(i)..letter(j-1), "T")
		end
	else
		node_letter = get_item_list2(node_list2, n2x, n2y, 1)
	end
	if new_letter and check_ground(meta:get_string("na"..letter(i)..letter(j)), node_letter) then
		meta:set_string("nb"..letter(i)..letter(j), node_letter)
		if meta:get_string("na"..letter(i)..letter(j-1)) == "T" and node_letter ~= "D" then
			meta:set_string("na"..letter(i)..letter(j-1), "0")
		end
		meta:set_string("error_message", "")
		player:set_inventory_formspec(create2.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
	elseif not check_ground(meta:get_string("na"..letter(i)..letter(j)), node_letter) then
		meta:set_string("error_message", "You can not put that on this ground!")
		player:set_inventory_formspec(create2.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
	end
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    local player_inv = player:get_inventory()
	local meta = player:get_meta()
    Load(player)
	if formname == "tu" then
        for k, v in pairs(fields) do
            if tonumber(v) ~= nil then
                New(player,"1_"..v,"n",1)
                player_inv:set_stack("l",  1, "labyrinthus:dirt "..v)
                player_inv:set_stack("ll", 1, "labyrinthus:dirt 1")
            end
        end
        minetest.show_formspec(player:get_player_name(), "", "")
	end
    if fields.waa then
        player_inv:set_stack("page1",  1, nil)
        minetest.show_formspec(player:get_player_name(), "w11" , level_formspec(player,"level2",250,25,0,false,"",true,"wab",""))
    elseif fields.wab then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt")
        minetest.show_formspec(player:get_player_name(), "w12" , level_formspec(player,"level2",250,25,25,true,"waa",true,"wac",""))
    elseif fields.wac then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 2")
        minetest.show_formspec(player:get_player_name(), "w13" , level_formspec(player,"level2",250,25,50,true,"wab",true,"wad",""))
    elseif fields.wad then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 3")
        minetest.show_formspec(player:get_player_name(), "w14" , level_formspec(player,"level2",250,25,75,true,"wac",true,"wae",""))
    elseif fields.wae then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 4")
        minetest.show_formspec(player:get_player_name(), "w15" , level_formspec(player,"level2",250,25,100,true,"wad",true,"waf",""))
    elseif fields.waf then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 5")
        minetest.show_formspec(player:get_player_name(), "w16" , level_formspec(player,"level2",250,25,125,true,"wae",true,"wag",""))
    elseif fields.wag then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 6")
        minetest.show_formspec(player:get_player_name(), "w17" , level_formspec(player,"level2",250,25,150,true,"waf",true,"wah",""))
    elseif fields.wah then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 7")
        minetest.show_formspec(player:get_player_name(), "w18" , level_formspec(player,"level2",250,25,175,true,"wag",true,"wai",""))
    elseif fields.wai then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 8")
        minetest.show_formspec(player:get_player_name(), "w19" , level_formspec(player,"level2",250,25,200,true,"wah",true,"waj",""))
    elseif fields.waj then
        player_inv:set_stack("page1",  1, "labyrinthus:dirt 9")
        minetest.show_formspec(player:get_player_name(), "w110" , level_formspec(player,"level2",250,25,225,true,"wai",false,"You have finished world 2!","5.7"))
	elseif fields.wba then
        player_inv:set_stack("page2",  1, nil)
        minetest.show_formspec(player:get_player_name(), "w21" , level_formspec(player,"level3",174,25,0,false,"",true,"wbb",""))
    elseif fields.wbb then
        player_inv:set_stack("page2",  1, "labyrinthus:dirt")
        minetest.show_formspec(player:get_player_name(), "w22" , level_formspec(player,"level3",174,25,25,true,"wba",true,"wbc",""))
    elseif fields.wbc then
        player_inv:set_stack("page2",  1, "labyrinthus:dirt 2")
        minetest.show_formspec(player:get_player_name(), "w23" , level_formspec(player,"level3",174,25,50,true,"wbb",true,"wbd",""))
    elseif fields.wbd then
        player_inv:set_stack("page2",  1, "labyrinthus:dirt 3")
        minetest.show_formspec(player:get_player_name(), "w24" , level_formspec(player,"level3",174,25,75,true,"wbc",true,"wbe",""))
    elseif fields.wbe then
        player_inv:set_stack("page2",  1, "labyrinthus:dirt 4")
        minetest.show_formspec(player:get_player_name(), "w25" , level_formspec(player,"level3",174,25,100,true,"wbd",true,"wbf",""))
    elseif fields.wbf then
        player_inv:set_stack("page2",  1, "labyrinthus:dirt 5")
        minetest.show_formspec(player:get_player_name(), "w26" , level_formspec(player,"level3",174,25,125,true,"wbe",true,"wbg",""))
    elseif fields.wbg then
        player_inv:set_stack("page2",  1, "labyrinthus:dirt 6")
        minetest.show_formspec(player:get_player_name(), "w27" , level_formspec(player,"level3",174,24,150,true,"wbf",false,"You have finished world 3!","5.7"))
	elseif fields.wca then
        player_inv:set_stack("page3",  1, nil)
        minetest.show_formspec(player:get_player_name(), "w31" , level_formspec(player,"level4",86,25,0,false,"",true,"wcb",""))
    elseif fields.wcb then
        player_inv:set_stack("page3",  1, "labyrinthus:dirt")
        minetest.show_formspec(player:get_player_name(), "w32" , level_formspec(player,"level4",86,25,25,true,"wca",true,"wcc",""))
    elseif fields.wcc then
        player_inv:set_stack("page3",  1, "labyrinthus:dirt 2")
        minetest.show_formspec(player:get_player_name(), "w33" , level_formspec(player,"level4",86,25,50,true,"wcb",true,"wcd",""))
    elseif fields.wcd then
        player_inv:set_stack("page3",  1, "labyrinthus:dirt 3")
        minetest.show_formspec(player:get_player_name(), "w34" , level_formspec(player,"level4",86,11,75,true,"wcc",false,"You have finished world 4!","3.7"))
	elseif fields.wda then
        player_inv:set_stack("page5",  1, nil)
        minetest.show_formspec(player:get_player_name(), "w51" , level_formspec(player,"level5",175,25,0,false,"",true,"wdb",""))
	elseif fields.wdb then
        player_inv:set_stack("page5",  1, "labyrinthus:dirt")
        minetest.show_formspec(player:get_player_name(), "w52" , level_formspec(player,"level5",175,25,25,true,"wda",true,"wdc",""))
	elseif fields.wdc then
        player_inv:set_stack("page5",  1, "labyrinthus:dirt 2")
        minetest.show_formspec(player:get_player_name(), "w53" , level_formspec(player,"level5",175,25,50,true,"wdb",true,"wdd",""))
	elseif fields.wdd then
        player_inv:set_stack("page5",  1, "labyrinthus:dirt 3")
        minetest.show_formspec(player:get_player_name(), "w54" , level_formspec(player,"level5",175,25,75,true,"wdc",true,"wde",""))
	elseif fields.wde then
        player_inv:set_stack("page5",  1, "labyrinthus:dirt 4")
        minetest.show_formspec(player:get_player_name(), "w55" , level_formspec(player,"level5",175,25,100,true,"wdd",true,"wdf",""))
	elseif fields.wdf then
        player_inv:set_stack("page5",  1, "labyrinthus:dirt 5")
        minetest.show_formspec(player:get_player_name(), "w56" , level_formspec(player,"level5",175,25,125,true,"wde",true,"wdg",""))
	elseif fields.wdg then
        player_inv:set_stack("page5",  1, "labyrinthus:dirt 6")
        minetest.show_formspec(player:get_player_name(), "w57" , level_formspec(player,"level5",175,25,150,true,"wdf",false,"You have finished world 5!","5.7"))
	elseif fields.wea then
        player_inv:set_stack("page6",  1, nil)
        minetest.show_formspec(player:get_player_name(), "w61" , level_formspec(player,"level6",50,25,0,false,"",true,"web",""))
	elseif fields.web then
        player_inv:set_stack("page6",  1, "labyrinthus:dirt")
        minetest.show_formspec(player:get_player_name(), "w62" , level_formspec(player,"level6",50,25,25,true,"wea",false,"more comming soon","5.7"))
	elseif fields.import then
		minetest.show_formspec(player:get_player_name(), "import" , import.get_formspec(player))
	elseif fields.save then
		local meta = player:get_meta()
		local s = ""
		local k1 = 0
		local k2 = 0
		for j=1,12 do
			for i=1,20 do
				if meta:get_string("na"..letter(i)..letter(j)) == "2" or meta:get_string("na"..letter(i)..letter(j)) == "z" then
					k1 = 1
				end
				if meta:get_string("nb"..letter(i)..letter(j)) == "nn" then
					k2 = 1
				end
			end
		end
		if k1 == 1 and k2 == 1 then
			for j=1,12 do
				for i=1,20 do
					local s1 = meta:get_string("na"..letter(i)..letter(j))
					s = s..s1
				end
				s=s.."\n"
			end
			s=s.."\n"
			local nyx = -1
			local nyy = -1
			for j=1,12 do
				for i=1,20 do
					local s2 = meta:get_string("nb"..letter(i)..letter(j))
					if s2 ~= "nn" then
						s = s..s2
					else
						s = s.."0"
						nyx = i-1
						nyy = 13-j
					end
				end
				s=s.."\n"
			end
			s=s.."\n"..nyx.."\n"..nyy.."\n1"
			local file = io.open(minetest.get_worldpath().."/own_level_"..meta:get_string("new_name")..".txt", "w")
			file:write(s)
			file:close()
			local t = minetest.deserialize(meta:get_string("levels"))
			if not t then
				t = {}
			end
			local kk = 0
			for i = 1, #t do
				if tostring(t[i]) == meta:get_string("new_name") then
					kk = 1
				end
			end
			if kk == 0 then
				table.insert(t, ""..tostring(meta:get_string("new_name")))
			end
			meta:set_string("levels", minetest.serialize(t))
			player:set_inventory_formspec(main.get_formspec(player))
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"Level was created successfully!"))
		else
			meta:set_string("error_message", "You have to place at least a rainbow \nand a nyancat!")
			minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
			player:set_inventory_formspec(create2.get_formspec(player))
		end
	elseif fields.change then
		local meta = player:get_meta()
		if meta:get_string("celected") ~= "" then
			meta:set_string("new_name", meta:get_string("celected"))
			local file = io.open(minetest.get_worldpath().."/own_level_"..meta:get_string("celected")..".txt", "r")
			local s = ""
			for j=1,12 do
				s = file:read("*l")
				for i = 1, string.len(s) do
					meta:set_string("na"..letter(i)..letter(j),string.sub(s, i, i))
				end
			end
			file:read("*l")
			for j=1,12 do
				s = file:read("*l")
				for i = 1, string.len(s) do
					meta:set_string("nb"..letter(i)..letter(j),string.sub(s, i, i))
				end
			end
			file:read("*l")
			local sx = file:read("*l")
			local sy = file:read("*l")
			meta:set_string("nb"..letter(tonumber(sx)+1)..letter(13-tonumber(sy)),"nn")
			meta:set_string("new_node1x", "1")
			meta:set_string("new_node1y", "1")
			meta:set_string("new_node2x", "1")
			meta:set_string("new_node2y", "1")
			meta:set_string("error_message", "")
			minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
			player:set_inventory_formspec(create2.get_formspec(player))
		else
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"You have to select a level!"))
		end
	elseif fields.create then
		local meta = player:get_meta()
		meta:set_string("new_name", "")
		for i=1,20 do
			for j=1,12 do
				meta:set_string("na"..letter(i)..letter(j), "0")
				meta:set_string("nb"..letter(i)..letter(j), "0")
			end
		end
		minetest.show_formspec(player:get_player_name(), "create" , create.get_formspec(player))
	elseif fields.create2 then
		local meta = player:get_meta()
		local k = 0
		if meta:get_string("levels") then
			local t = minetest.deserialize(meta:get_string("levels"))
			if t then
				for i = 1, #t do
					if tostring(t[i]) == fields.input2 then
						k = 1
					end
				end
			end
		end
		if tostring(fields.input2) == "" then
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"You can't create a level with no name!"))
		elseif k == 1 then 
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"This level already exists!"))
		elseif fields.input2 ~= nil then
			meta:set_string("new_name", fields.input2)
			meta:set_string("new_node1x", "1")
			meta:set_string("new_node1y", "1")
			meta:set_string("new_node2x", "1")
			meta:set_string("new_node2y", "1")
			meta:set_string("error_message", "")
			minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
			player:set_inventory_formspec(create2.get_formspec(player))
		else
			meta:set_string("error_message", "")
			minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
			player:set_inventory_formspec(create2.get_formspec(player))
		end
	elseif fields.delete then
		local meta = player:get_meta()
		if meta:get_string("celected") ~= "" then
			minetest.show_formspec(player:get_player_name(), "delete" , delete.get_formspec(player))
		else
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"You have to select a level!"))
		end
	elseif fields.play then
		local meta = player:get_meta()
		if meta:get_string("celected") ~= "" then
			player_inv:set_stack("l",  1, nil)
            player_inv:set_stack("ll", 1, nil)
			meta:set_string("toplay", meta:get_string("celected"))
			meta:set_string("celected", "")
			New(player,meta:get_string("toplay"),"o",1)
			minetest.show_formspec(player:get_player_name(), "", "")
		else
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"You have to select a level!"))
		end
	elseif fields.delete2 then
		local meta = player:get_meta()
		local t = minetest.deserialize(meta:get_string("levels"))
		if not t then
			t = {}
		end
		for i = 1, #t do
			if tostring(t[i]) == meta:get_string("celected") then
				minetest.rmdir(minetest.get_worldpath().."/own_level_"..t[i]..".txt", false)
				minetest.chat_send_all(t[i])
				table.remove(t, i)
			end
		end
		meta:set_string("levels", minetest.serialize(t))
		minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"The Level was successfully deleted from the inventory list!"))
	elseif fields.back then
		player:set_inventory_formspec(main.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "back" , back.get_formspec(player))
	elseif fields.main then
		player:set_inventory_formspec(main.get_formspec(player))
		minetest.show_formspec(player:get_player_name(), "main" , main.get_formspec(player))
	elseif fields.import2 then
		local meta = player:get_meta()
		local k = 0
		if meta:get_string("levels") then
			local t = minetest.deserialize(meta:get_string("levels"))
			if t then
				for i = 1, #t do
					if tostring(t[i]) == fields.input1 then
						k = 1
					end
				end
			end
		end
		if tostring(fields.input1) == "" then
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"You can't import a level with no name!"))
		elseif k == 1 then
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"This level already exists!"))
		elseif file_check(minetest.get_worldpath().."/own_level_"..fields.input1..".txt") then
			local t = minetest.deserialize(meta:get_string("levels"))
			if not t then
				t = {}
			end
			table.insert(t, ""..tostring(fields.input1))
			meta:set_string("levels", minetest.serialize(t))
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"Level was imported successfully!"))
		else
			minetest.show_formspec(player:get_player_name(), "info" , info.get_formspec(player,"This level does not exist!"))
		end
    elseif fields.esc then
        minetest.show_formspec(player:get_player_name(), "", "")
	elseif fields.quit then
		local meta = player:get_meta()
		meta:set_string("celected", "")
	end
	local event = minetest.explode_textlist_event(fields.levels)
	if(event.type == "CHG") then
		local meta = player:get_meta()
		if meta:get_string("levels") then
			local t = minetest.deserialize(meta:get_string("levels"))
			if t and t[event.index] ~= nil then
				meta:set_string("celected", ""..t[event.index])
			end
		end
	end
	if formname == "create2" or formname == "" then
		for i=1,20 do
			for j=1,12 do
				local meta = player:get_meta()
				if fields["na"..letter(i)..letter(j)] or fields["raa"..letter(j)] or fields["rab"..letter(i)] then
					add_to_layerA(player, meta, i, j)
				end
				if fields["nb"..letter(i)..letter(j)] or fields["rba"..letter(j)] or fields["rbb"..letter(i)] then
					add_to_layerB(player, meta, i, j)
				end
			end
		end
		for i=1,7 do
			for j=1,13 do
				local meta = player:get_meta()
				if fields["sa"..letter(i)..letter(j)] then
					meta:set_string("new_node1x", ""..j)
					meta:set_string("new_node1y", ""..i)
					meta:set_string("error_message", "")
					player:set_inventory_formspec(create2.get_formspec(player))
					minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
				end
				if fields["sb"..letter(i)..letter(j)] then
					meta:set_string("new_node2x", ""..j)
					meta:set_string("new_node2y", ""..i)
					meta:set_string("error_message", "")
					player:set_inventory_formspec(create2.get_formspec(player))
					minetest.show_formspec(player:get_player_name(), "create2" , create2.get_formspec(player))
				end
			end
		end
	end
    if formname == "w11" or formname == "w12" or formname == "w13" or formname == "w14" or formname == "w15" or formname == "w16" or formname == "w17" or formname == "w18" or formname == "w19" or formname == "w110" then
        for k, v in pairs(fields) do
            if tonumber(v) ~= nil then
                New(player,"2_"..v,"n",1)
                player_inv:set_stack("l",  2, "labyrinthus:dirt "..v)
                player_inv:set_stack("ll", 1, "labyrinthus:dirt 2")
				minetest.show_formspec(player:get_player_name(), "", "")
            end
        end
	end
    if formname == "w21" or formname == "w22" or formname == "w23" or formname == "w24" or formname == "w25" or formname == "w26" or formname == "w27" then
        for k, v in pairs(fields) do
            if tonumber(v) ~= nil then
                New(player,"3_"..v,"n",1)
                player_inv:set_stack("l",  3, "labyrinthus:dirt "..v)
                player_inv:set_stack("ll", 1, "labyrinthus:dirt 3")
				minetest.show_formspec(player:get_player_name(), "", "")
            end
        end
		
	end
    if formname == "w31" or formname == "w32" or formname == "w33" or formname == "w34" then
        for k, v in pairs(fields) do
            if tonumber(v) ~= nil then
                New(player,"4_"..v,"n",1)
                player_inv:set_stack("l",  4, "labyrinthus:dirt "..v)
                player_inv:set_stack("ll", 1, "labyrinthus:dirt 4")
				minetest.show_formspec(player:get_player_name(), "", "")
            end
        end
		
	end
	if formname == "w51" or formname == "w52" or formname == "w53" or formname == "w54" or formname == "w55" or formname == "w56" or formname == "w57" then
        for k, v in pairs(fields) do
            if tonumber(v) ~= nil then
                New(player,"5_"..v,"n",1)
                player_inv:set_stack("l",  5, "labyrinthus:dirt "..v)
                player_inv:set_stack("ll", 1, "labyrinthus:dirt 5")
				minetest.show_formspec(player:get_player_name(), "", "")
            end
        end
	end
	if formname == "w61" or formname == "w62" then
        for k, v in pairs(fields) do
            if tonumber(v) ~= nil then
                New(player,"6_"..v,"n",1)
                player_inv:set_stack("l",  6, "labyrinthus:dirt "..v)
                player_inv:set_stack("ll", 1, "labyrinthus:dirt 6")
				minetest.show_formspec(player:get_player_name(), "", "")
            end
        end
	end
end)