-- Copyright (c) 2013-18 rubenwardy and Wuzzy. MIT.

local S = awards.translator


awards.register_award("award_ruby_bronze",{
	title = S("Ruby (Bronze)"),
	description = S("Dig 25 Ruby Ore."),
	icon = "default_stone.png^ruby_ruby_ore.png",
	difficulty = 1,
	trigger = {
		type = "dig",
		node = "gems:ruby_ore",
		target = 25
	}
})

awards.register_award("award_ruby_silber",{
	title = S("Ruby (Silber)"),
	description = S("Dig 50 Ruby Ore."),
	icon = "default_stone.png^ruby_ruby_ore.png",
	requires = {"award_ruby_bronze"},
	difficulty = 2,
	trigger = {
		type = "dig",
		node = "gems:ruby_ore",
		target = 50
	}
})

awards.register_award("award_ruby_gold",{
	title = S("Ruby (Gold)"),
	description = S("Dig 100 Ruby Ore."),
	icon = "default_stone.png^ruby_ruby_ore.png",
	requires = {"award_ruby_silber"},
	difficulty = 3,
	trigger = {
		type = "dig",
		node = "gems:ruby_ore",
		target = 100
	}
})

awards.register_award("award_ruby_platin",{
	title = S("Ruby (Platin)"),
	description = S("Dig 200 Ruby Ore."),
	icon = "default_stone.png^ruby_ruby_ore.png",
	requires = {"award_ruby_gold"},
	difficulty = 4,
	trigger = {
		type = "dig",
		node = "gems:ruby_ore",
		target = 200
	}
})



awards.register_award("award_sapphire_bronze",{
	title = S("Sapphire (Bronze)"),
	description = S("Dig 25 Sapphire Ore."),
	icon = "default_stone.png^gems_sapphire_ore.png",
	difficulty = 5,
	trigger = {
		type = "dig",
		node = "gems:sapphire_ore",
		target = 25
	}
})

awards.register_award("award_sapphire_silber",{
	title = S("Sapphire (Silber)"),
	description = S("Dig 50 Sapphire Ore."),
	icon = "default_stone.png^gems_sapphire_ore.png",
	difficulty = 6,
	requires = {"award_sapphire_bronze"},
	trigger = {
		type = "dig",
		node = "gems:sapphire_ore",
		target = 50
	}
})

awards.register_award("award_sapphire_gold",{
	title = S("Sapphire (Gold)"),
	description = S("Dig 100 Sapphire Ore."),
	icon = "default_stone.png^gems_sapphire_ore.png",
	difficulty = 7,
	requires = {"award_sapphire_silber"},
	trigger = {
		type = "dig",
		node = "gems:sapphire_ore",
		target = 100
	}
})
	
awards.register_award("award_sapphire_platin",{
	title = S("Sapphire (Platin)"),
	description = S("Dig 200 Sapphire Ore."),
	icon = "default_stone.png^gems_sapphire_ore.png",
	difficulty = 8,
	requires = {"award_sapphire_gold"},
	trigger = {
		type = "dig",
		node = "gems:sapphire_ore",
		target = 200
	}
})

awards.register_award("award_amethyst_bronze",{
	title = S("Amethyst (Bronze)"),
	description = S("Dig 25 Amethyst Ore."),
	icon = "default_stone.png^gems_amethyst_ore.png",
	difficulty = 9,
	trigger = {
		type = "dig",
		node = "gems:amethyst_ore",
		target = 25
	}
})

awards.register_award("award_amethyst_silber",{
	title = S("Amethyst (Silber)"),
	description = S("Dig 50 Amethyst Ore."),
	icon = "default_stone.png^gems_amethyst_ore.png",
	difficulty = 10,
	requires = {"award_amethyst_bronze"},
	trigger = {
		type = "dig",
		node = "gems:amethyst_ore",
		target = 50
	}
})

awards.register_award("award_amethyst_Gold",{
	title = S("Amethyst (Gold)"),
	description = S("Dig 100 Amethyst Ore."),
	icon = "default_stone.png^gems_amethyst_ore.png",
	difficulty = 11,
	requires = {"award_amethyst_silber"},
	trigger = {
		type = "dig",
		node = "gems:amethyst_ore",
		target = 100
	}
})
	
awards.register_award("award_amethyst_platin",{
	title = S("Amethyst (Platin)"),
	description = S("Dig 200 Amethyst Ore."),
	icon = "default_stone.png^gems_amethyst_ore.png",
	difficulty = 12,
	requires = {"award_amethyst_Gold"},
	trigger = {
		type = "dig",
		node = "gems:amethyst_ore",
		target = 200
	}
})

awards.register_award("award_shadow_bronze",{
	title = S("Shadow (Bronze)"),
	description = S("Dig 25 Shadow Ore."),
	icon = "default_stone.png^shadow_ore.png",
	difficulty = 17,
	trigger = {
		type = "dig",
		node = "gems:shadow_ore",
		target = 25
	}
})

awards.register_award("award_shadow_silber",{
	title = S("Shadow (Silber)"),
	description = S("Dig 50 Shadow Ore."),
	icon = "default_stone.png^shadow_ore.png",
	difficulty = 18,
	requires = {"award_shadow_bronze"},
	trigger = {
		type = "dig",
		node = "gems:shadow_ore",
		target = 50
	}
})

awards.register_award("award_shadow_gold",{
	title = S("Shadow (Gold)"),
	description = S("Dig 100 Shadow Ore."),
	icon = "default_stone.png^shadow_ore.png",
	difficulty = 19,
	requires = {"award_shadow_silber"},
	trigger = {
		type = "dig",
		node = "gems:shadow_ore",
		target = 100
	}
})

awards.register_award("award_shadow_platin",{
	title = S("Shadow (Platin)"),
	description = S("Dig 200 Shadow Ore."),
	icon = "default_stone.png^shadow_ore.png",
	difficulty = 20,
	requires = {"award_shadow_gold"},
	trigger = {
		type = "dig",
		node = "gems:shadow_ore",
		target = 200
	}
})

awards.register_award("award_pearl_bronze",{
	title = S("Pearl (Bronze)"),
	description = S("Dig 25 Pearl Ore."),
	icon = "default_stone.png^gems_pearl_ore.png",
	difficulty = 13,
	trigger = {
		type = "dig",
		node = "gems:pearl_ore",
		target = 25
	}
})

awards.register_award("award_pearl_silber",{
	title = S("Pearl (Silber)"),
	description = S("Dig 50 Pearl Ore."),
	icon = "default_stone.png^gems_pearl_ore.png",
	difficulty = 14,
	requires = {"award_pearl_bronze"},
	trigger = {
		type = "dig",
		node = "gems:pearl_ore",
		target = 50
	}
})

awards.register_award("award_pearl_gold",{
	title = S("Pearl (Gold)"),
	description = S("Dig 100 Pearl Ore."),
	icon = "default_stone.png^gems_pearl_ore.png",
	difficulty = 15,
	requires = {"award_pearl_silber"},
	trigger = {
		type = "dig",
		node = "gems:pearl_ore",
		target = 100
	}
})

awards.register_award("award_pearl_platin",{
	title = S("Pearl (Platin)"),
	description = S("Dig 200 Pearl Ore."),
	icon = "default_stone.png^gems_pearl_ore.png",
	difficulty = 16,
	requires = {"award_pearl_gold"},
	trigger = {
		type = "dig",
		node = "gems:pearl_ore",
		target = 200
	}
})

awards.register_award("award_emerald_bronze",{
	title = S("Emerald (Bronze)"),
	description = S("Dig 25 Emerald Ore."),
	icon = "default_stone.png^gems_emerald_ore.png",
	difficulty = 21,
	trigger = {
		type = "dig",
		node = "gems:emerald_ore",
		target = 25
	}
})

awards.register_award("award_emerald_silber",{
	title = S("Emerald (Silber)"),
	description = S("Dig 50 Emerald Ore."),
	icon = "default_stone.png^gems_emerald_ore.png",
	difficulty = 22,
	requires = {"award_emerald_bronze"},
	trigger = {
		type = "dig",
		node = "gems:emerald_ore",
		target = 50
	}
})

awards.register_award("award_emerald_gold",{
	title = S("Emerald (Gold)"),
	description = S("Dig 100 Emerald Ore."),
	icon = "default_stone.png^gems_emerald_ore.png",
	difficulty = 23,
	requires = {"award_emerald_silber"},
	trigger = {
		type = "dig",
		node = "gems:emerald_ore",
		target = 100
	}
})

awards.register_award("award_emerald_platin",{
	title = S("Emerald (Platin)"),
	description = S("Dig 200 Emerald Ore."),
	icon = "default_stone.png^gems_emerald_ore.png",
	difficulty = 24,
	requires = {"award_emerald_gold"},
	trigger = {
		type = "dig",
		node = "gems:emerald_ore",
		target = 200
	}
})

awards.register_award("award_admin_ore_bronze",{
	title = S("Admin Ore (Bronze)"),
	description = S("Dig 5 Admin Ore."),
	icon = "default_stone.png^tutorial_admin_ore.png",
	difficulty = 29,
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_admin",
		target = 5
	}
})

awards.register_award("award_admin_ore_silber",{
	title = S("Admin Ore (Silber)"),
	description = S("Dig 10 Admin Ore."),
	icon = "default_stone.png^tutorial_admin_ore.png",
	difficulty = 30,
	requires = {"award_admin_ore_bronze"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_admin",
		target = 10
	}
})

awards.register_award("award_admin_ore_gold",{
	title = S("Admin Ore (Gold)"),
	description = S("Dig 20 Admin Ore."),
	icon = "default_stone.png^tutorial_admin_ore.png",
	difficulty = 31,
	requires = {"award_admin_ore_silber"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_admin",
		target = 20
	}
})

awards.register_award("award_admin_ore_platin",{
	title = S("Admin Ore (Platin)"),
	description = S("Dig 40 Admin Ore."),
	icon = "default_stone.png^tutorial_admin_ore.png",
	difficulty = 32,
	requires = {"award_admin_ore_gold"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_admin",
		target = 40
	}
})

awards.register_award("award_titan_ore_bronze",{
	title = S("Titan Ore (Bronze)"),
	description = S("Dig 10 Titan Ore."),
	icon = "tutorial_titan_ore.png",
	difficulty = 25,
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_titan",
		target = 10
	}
})
awards.register_award("award_titan_ore_silber",{
	title = S("Titan Ore (Silber)"),
	description = S("Dig 20 Titan Ore."),
	icon = "tutorial_titan_ore.png",
	difficulty = 26,
	requires = {"award_titan_ore_bronze"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_titan",
		target = 20
	}
})
awards.register_award("award_titan_ore_gold",{
	title = S("Titan Ore (Gold)"),
	description = S("Dig 40 Titan Ore."),
	icon = "tutorial_titan_ore.png",
	difficulty = 27,
	requires = {"award_titan_ore_silber"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_titan",
		target = 40
	}
})
awards.register_award("award_titan_ore_platin",{
	title = S("Titan Ore (Platin)"),
	description = S("Dig 80 Titan Ore."),
	icon = "tutorial_titan_ore.png",
	difficulty = 28,
	requires = {"award_titan_ore_gold"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_titan",
		target = 80
	}
})

awards.register_award("award_regnum_ore_bronze",{
	title = S("Regnum Ore (Bronze)"),
	description = S("Dig 2 Regnum Ore."),
	icon = "default_stone.png^tutorial_regnum_ore.png",
	difficulty = 33,
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_regnum",
		target = 2
	}
})
awards.register_award("award_regnum_ore_silber",{
	title = S("Regnum Ore (Silber)"),
	description = S("Dig 5 Regnum Ore."),
	icon = "default_stone.png^tutorial_regnum_ore.png",
	difficulty = 34,
	requires = {"award_regnum_ore_bronze"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_regnum",
		target = 5
	}
})
awards.register_award("award_regnum_ore_gold",{
	title = S("Regnum Ore (Gold)"),
	description = S("Dig 10 Regnum Ore."),
	icon = "default_stone.png^tutorial_regnum_ore.png",
	difficulty = 35,
	requires = {"award_regnum_ore_silber"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_regnum",
		target = 10
	}
})
awards.register_award("award_regnum_ore_platin",{
	title = S("Regnum Ore (Platin)"),
	description = S("Dig 20 Regnum Ore."),
	icon = "default_stone.png^tutorial_regnum_ore.png",
	difficulty = 36,
	requires = {"award_regnum_ore_gold"},
	trigger = {
		type = "dig",
		node = "tutorial:stone_with_regnum",
		target = 20
	}
})
awards.register_award("award_???_bronze",{
	title = S("Die next to Mese"),
	description = S("Die next to a Mese Block"),
	icon = "default_mese_block.png",
	difficulty = 37,
	secret = true
})
awards.register_on_death(function(player,data)
	local pos = player:get_pos()
	if pos and minetest.find_node_near(pos, 5, "default:mese") ~= nil then
		return "award_???_bronze"
	end	
	return nil
end)


awards.register_award("award_???_silber",{
	title = S("Die next to Mithril"),
	description = S("Die next to a Mithril Ore"),
	icon = "default_stone.png^moreores_mineral_mithril.png",
	difficulty = 38,
	secret = true
})
awards.register_on_death(function(player,data)
	local pos = player:get_pos()
	if pos and minetest.find_node_near(pos, 5, "moreores:mineral_mithril") ~= nil then
		return "award_???_silber"
	end	
	return nil
end)


awards.register_award("award_???_gold",{
	title = S("Die next to Titan"),
	description = S("Die next to a Titan Ore"),
	icon = "default_stone.png^tutorial_titan_ore.png",
	difficulty = 39,
	secret = true
})
awards.register_on_death(function(player,data)
	local pos = player:get_pos()
	if pos and minetest.find_node_near(pos, 5, "tutorial:stone_with_titan") ~= nil then
		return "award_???_gold"
	end	
	return nil
end)

awards.register_award("award_???_platin",{
	title = S("Die next to Admin"),
	description = S("Die next to an Admin Ore"),
	icon = "default_stone.png^tutorial_admin_ore.png",
	difficulty = 40,
	secret = true
})
awards.register_on_death(function(player,data)
	local pos = player:get_pos()
	if pos and minetest.find_node_near(pos, 5, "tutorial:stone_with_admin") ~= nil then
		return "award_???_platin"
	end	
	return nil
end)

awards.register_award("award_???_regnum",{
	title = S("Die next to Regnum"),
	description = S("Die next to a Regnum Ore"),
	icon = "default_stone.png^tutorial_regnum_ore.png",
	difficulty = 41,
	secret = true
})
awards.register_on_death(function(player,data)
	local pos = player:get_pos()
	if pos and minetest.find_node_near(pos, 5, "tutorial:stone_with_regnum") ~= nil then
		return "award_???_regnum"
	end	
	return nil
end)

awards.register_award("award_???_nyancat",{
	title = S("Die next to Nyancat"),
	description = S("Die next to a Nyancat"),
	icon = "nyancat_front.png",
	difficulty = 42,
	secret = true
})
awards.register_on_death(function(player,data)
	local pos = player:get_pos()
	if pos and minetest.find_node_near(pos, 5, "nyancat:nyancat") ~= nil then
		return "award_???_nyancat"
	end	
	return nil
end)