local player_page = {}
minetest.register_on_joinplayer(function(player)
	local name = player:get_player_name()
	player_page[name] = 1
end)

sfinv.register_page("tutorial:regnum_guide", {
	title = "Guide",
	get = function(self, player, context)
		return sfinv.make_formspec(player, context, get_regnum_page(player))
	end,
	on_player_receive_fields = function(self, player, context, fields)
		local name = player:get_player_name()
		local page = player_page[name]
		if fields.guide_next then
			if player_page[name] < 21 then
				page = page + 1
				player_page[name] = page
				sfinv.set_player_inventory_formspec(player)
			end
		elseif fields.guide_prev then
			if player_page[name] > 1 then
				page = page - 1
				player_page[name] = page
				sfinv.set_player_inventory_formspec(player)
			end
		end
	end
})

local reg_pages = {}

reg_pages[1] = "label[0.2,0;!!WELLCOME TO REGNUM!!]"
	.."label[0.2,0.6;This is the first page of the Regnum guide. Here you]"
	.."label[0.2,0.9;can find basic information about the game.]"
	.."label[0.2,1.2;I have been developing Regnum since 2011.]"
	.."label[0.2,1.8;Thanks to:]"
	.."label[0.2,2.1;NightmareLP for creating the mod 'pink']"
	.."label[0.2,2.4;et77 for great ideas]"
	.."label[0.2,2.7;wuschel1912 for testing]"
	.."label[0.2,3.0;jumali for testing]"
	.."label[0.2,3.3;Verlo for language improvements]"
	.."label[0.2,3.6;Skamiz Kazzarch for warning fixes]"
		
reg_pages[2] = "label[0.2,0;CONTENS]"
	.."label[0.2,0.6;  I. Inventory Navigation]"
	.."label[0.2,0.9;    1. Craftings]"
	.."label[0.2,1.2;    2. Equipment]"
	.."label[0.2,1.5;    3. Quests]"
	.."label[0.2,1.8;    4. Settings]"
	.."label[0.2,2.1;    5. Help]"
	.."label[0.2,2.4;    6. Spezial]"
	.."label[0.2,2.7;    7. Color Items]"
	.."label[0.2,3.3;  II. Gameplay]"
	.."label[0.2,3.6;    1. Regnum Tools]"
	.."label[0.2,3.9;    2. Admin Tools]"
	.."label[0.2,4.2;    3. Gifts]"
	.."label[0.2,4.5;    4. Mobs]"
	.."label[0.2,4.8;    5. Xp and Levelling]"
	.."label[0.2,5.1;    6. Ores]"
	.."label[0.2,5.4;    7. Chat Commands]"

reg_pages[3] = "label[0.2,0;I. 1. Craftings]"
	.."label[0.2,0.6;  a) Normal Crafting]"
	.."label[0.2,0.9;    The normal craft grid can be expanded to a size of 4x4]"
	.."label[0.2,1.2;    with a 'Craft Key Lv.MAX'. With an additional 'Legend Key',]"
	.."label[0.2,1.5;    it can be further expanded to 5x5. The '10' and '99']"
	.."label[0.2,1.8;    buttons directly craft the corresponding number of ]"
	.."label[0.2,2.1;    items and add them to the main inventory. All other]"
	.."label[0.2,2.4;    crafting types can be accessed through the 'Other']"
	.."label[0.2,2.7;    button in the normal crafting.]"
	.."label[0.2,3.3;  b) Regnum Crafting]"
	.."label[0.2,3.6;    The 'Regnum' craft tab allows you to craft 'Dark Regnum',]"
	.."label[0.2,3.9;    you will need 'Dark Colored Pixels' that can be earned]"
	.."label[0.2,4.2;    through the 'Regnum Gift'. The 'Regnum' craft tab is]"
	.."label[0.2,4.5;    initially locked. To unlock it you will need to craft a]"
	.."label[0.2,4.8;    'Regnum Key' and insert it into its respective slot.]"
	.."label[0.2,5.4;  c) Gem Crafting]"
	.."label[0.2,5.7;    The 'Gem' craft tab allows you to craft 'Magic Gems'.]"
	.."label[0.2,6.0;    To craft the 'Magic Gems' you will need 'Gem Fragments']"
	.."label[0.2,6.3;    and 'Mithril Ingots'. The 'Gem' craft tab is locked from]"
	.."label[0.2,6.6;    the beginning. To use it you need the 'Dragonkey'.]"

reg_pages[4] = "label[0.2,0;I. 1. Craftings]"
	.."label[0.2,0.6;  d) Cooking Crafting]"
	.."label[0.2,0.9;    The 'Cooking' craft tab is basically a portable furnace,]"
	.."label[0.2,1.2;    but instead of using coal or other burnable items as]"
	.."label[0.2,1.5;    fuel it uses uranium. The higher the level of the]"
	.."label[0.2,1.8;    uranium the more burn time. The 'Cooking' craft tab is]"
	.."label[0.2,2.1;    locked from the beginning. To use it you need the]"
	.."label[0.2,2.4;    'Fox Key'. The 'Cooking Key' on the other hand can be]"
	.."label[0.2,2.7;    inserted in its respective slot inside of the 'Cooking']"
	.."label[0.2,3.0;    craft tab to get more burn time.]"
	.."label[0.2,3.6;  e) Medallion Crafting]"
	.."label[0.2,3.9;    The 'Medallion' craft tab allows you to craft medallions]"
	.."label[0.2,4.2;    using 'Medallion Pieces' which can be obtained by]"
	.."label[0.2,4.5;    running around. The 'Medallion' craft tab is locked from]"
	.."label[0.2,4.8;    the beginning and can be unlocked with the 'Tortoise Key'.]"
	.."label[0.2,5.4;  f) Crystal Crafting]"
	.."label[0.2,5.7;    The 'Crystal' craft tab allows you to craft ]"
	.."label[0.2,6.0;    'Crystal Bottles'. The crafting process takes 500 seconds]"
	.."label[0.2,6.3;    and will give you two bottles. With every 'Crystal' you add]"
	.."label[0.2,6.6;    you will get one more bottle. To speed up the crafting]"
	.."label[0.2,6.9;    process you will need a 'Regnum Key' to be inserted. The]"
	.."label[0.2,7.2;    key halve the process time.]"

reg_pages[5] = "label[0.2,0;I. 1. Craftings]"
	.."label[0.2,0.6;  g) DNA Crafting]"
	.."label[0.2,0.9;    The 'DNA' craft tab allows you to get pets and a]"
	.."label[0.2,1.2;    'Colored Monster' spawn egg. You will need to fill all the]"
	.."label[0.2,1.5;    eight slots with at least one 'DNA String' and click]"
	.."label[0.2,1.8;    'Build DNA' in order to increase the DNA progression of]"
	.."label[0.2,2.1;    one of the pets. You will need 'Large DNA Strings' which]"
	.."label[0.2,2.4;    can be crafted in the 5x5 grid in order to get the]"
	.."label[0.2,2.7;    'Colored Monster' spawn egg.]"
	.."label[0.2,3.3;  h) Mining Crafting]"
	.."label[0.2,3.6;    The 'Mining' craft tab allows you to level up your]"
	.."label[0.2,3.9;    'Mining Laser' and 'Mining Drill' using 'Green Coins'.]"
	.."label[0.2,4.2;    These coins can be found in the 'Xp Items' tab after you]"
	.."label[0.2,4.5;    have mined enough uranium.]"
	.."label[0.2,5.1;  i) Trophy Crafting]"
	.."label[0.2,5.4;    The Trophy craft tab allows you to craft trophies. To]"
	.."label[0.2,5.7;    craft the trophies you will need 'Tears' which are ]"
	.."label[0.2,6.0;    dropped from the monsters that the 'Colored Monster' spawn]"
	.."label[0.2,6.3;    egg summons.]"

reg_pages[6] = "label[0.2,0;I. 1. Craftings]"
	.."label[0.2,0.6;  j) Backward Crafting]"
	.."label[0.2,0.9;    The 'Backward' craft tab allows you to destroy items]"
	.."label[0.2,1.2;    and get their components. This can be useful if you]"
	.."label[0.2,1.5;    accidentally craft the wrong thing. The 'Backward' craft]"
	.."label[0.2,1.8;    only works on certain items.]"
	.."label[0.2,2.4;  k) Color Crafting]"
	.."label[0.2,2.7;    The 'Color' craft tab allows you to fill the 'Color Stick'.]"
	.."label[0.2,3.0;    You need ten dye of every color to fill the 'Color Stick']"
	.."label[0.2,3.3;    by 3.33%.]"

reg_pages[7] = "label[0.2,0;I. 2. Equipment]"
	.."label[0.2,0.6;  a) Bags]"
	.."label[0.2,0.9;    In the 'Bag' tab you can use certain bags in order to]"
	.."label[0.2,1.2;    carry more things. The recipes for the bags are located in]"
	.."label[0.2,1.5;    the 'Craft Guide' tab. There are 8 bag slots but you can]"
	.."label[0.2,1.8;    only use 4 of them. To unlock the rest you must craft the]"
	.."label[0.2,2.1;    'Bag Key' and insert it into its slot on the left. With]"
	.."label[0.2,2.4;    each level of the 'Bag Key', an additional bag slot is]"
	.."label[0.2,2.7;    unlocked.]"
	.."label[0.2,3.3;  b) Armor]"
	.."label[0.2,3.6;    In the Armor tab you can insert your armor in the 6 slots.]"
	.."label[0.2,3.9;    There are 6 armor pieces: The helmet goes on the top slot,]"
	.."label[0.2,4.2;    the chestplate goes under the helmet, the leggings go ]"
	.."label[0.2,4.5;    under the chestplate and the boots go under the leggings.]"
	.."label[0.2,4.8;    The Shield goes on the slot located on the right to all]"
	.."label[0.2,5.1;    the other armour slots and the heart go under shield. If]"
	.."label[0.2,5.4;    you happen to have a full set of maxed out]"
	.."label[0.2,5.7;    'Superlegend armor' or 'Regnum armor' you will not take]"
	.."label[0.2,6.0;    fire damage or drown damage. With these, you also have the]"
	.."label[0.2,6.3;    ability to adjust the speed and jump boost as you wish.]"

reg_pages[8] = "label[0.2,0;I. 3. Quests]"
	.."label[0.2,0.6;  a) Achievements]"
	.."label[0.2,0.9;    In the 'Achievements' tab you will be able to view all the]"
	.."label[0.2,1.2;    achievements you have and all the achievements that you]"
	.."label[0.2,1.5;    don’t have. You can also see the requirements for the]"
	.."label[0.2,1.8;    achievements as well. Once you earn 25 achievements, you]"
	.."label[0.2,2.1;    will receive the '1248 Knight' and a star in your nametag]"
	.."label[0.2,2.4;    to show your progress to other players. You’ll get another]"
	.."label[0.2,2.7;    star at 50 achievements, along with the]"
	.."label[0.2,3.0;    'Repairing Tool for Color Stick'. There are a total of 54]"
	.."label[0.2,3.3;    achievements in Regnum. The goal is to collect them all.]"
	.."label[0.2,3.9;  b) Awards]"
	.."label[0.2,4.2;    In the 'Other' tab you can find the 'Awards' tab. There you]"
	.."label[0.2,4.5;    can see your awards. If you dig some ores you will get an]"
	.."label[0.2,4.8;    award. For the secret awards, you have to die alongside the]"
	.."label[0.2,5.1;    rarest resources that can be found on Earth.]"
	.."label[0.2,5.7;  c) Anniversary]"
	.."label[0.2,6.0;    In the 'Other' tab you can find the 'Anniversary' tab.]"
	.."label[0.2,6.3;    Every anniversary you will get a special achievement there]"
	.."label[0.2,6.6;    and a trophy.]"

reg_pages[9] = "label[0.2,0;I. 4. Settings]"
	.."label[0.2,0.6;  a) Skins]"
	.."label[0.2,0.9;    In the 'Skins' tab you can change your in game skin. Simply]"
	.."label[0.2,1.2;    click on one of the skins to change it. Unlike other skins]"
	.."label[0.2,1.5;    the invisible and knight skins require keys. The invisible]"
	.."label[0.2,1.8;    skin requires the 'Dark Regnum Key'. On the other hand the]"
	.."label[0.2,2.1;    Knight skins require the 'Knight Key']"
	.."label[0.2,2.7;  b) Music]"
	.."label[0.2,3.0;    In the 'Music' tab you can enable and disable background]"
	.."label[0.2,3.3;    music. The themes are played randomly.]"

		
reg_pages[10] = "label[0.2,0;I. 5. Help]"
	.."label[0.2,0.6;  a) Xp Guide]"
	.."label[0.2,0.9;    In the 'Xp Guide' tab you can find out how much XP you]"
	.."label[0.2,1.2;    have. If you have the 'Level Key' however, you can find out]"
	.."label[0.2,1.5;    how much XP you need for a certain level. To get the]"
	.."label[0.2,1.8;    'Level Key' you need to reach level 50 (2750XP) on green]"
	.."label[0.2,2.1;    XP. You can get XP by digging 'Uranium Ores', 'Red Ores',]"
	.."label[0.2,2.4;    'Blue Ores', 'Precious Metal Ores', 'Grey Xp Blocks',]"
	.."label[0.2,2.7;    'Yellow Xp Blocks' or by placing a 'Crystal Bottle'. If you]"
	.."label[0.2,3.0;    have the 'Bronze Key', you get silver XP from]"
	.."label[0.2,3.3;    'Precious Metal Ores' instead of bronze XP.]"
	.."label[0.2,3.9;  b) Regnum Crafts]"
	.."label[0.2,4.2;    In the 'Regnum Crafts' tab you will find all of the]"
	.."label[0.2,4.5;    crafting recipes for the battleaxes, armour pieces, guns,]"
	.."label[0.2,4.8;    wings and hearts. Just click on one of the numbers to show]"
	.."label[0.2,5.1;    a recipe and to change the recipe type (ex: from gun to]"
	.."label[0.2,5.4;    battleaxes) just click on the item portrait on the top]"
	.."label[0.2,5.7;    line.]"
	.."label[0.2,6.3;  c) Mob Postions]"
	.."label[0.2,6.6;    In the 'Mob Postions' tab you see the current position of]"
	.."label[0.2,6.9;    your animals.]"
	
reg_pages[11] = "label[0.2,0;I. 6. Spezial]"
	.."label[0.2,0.6;  a) Crystals]"
	.."label[0.2,0.9;    In the 'Crystals' tab you can make 'Legend Balls'. If]"
	.."label[0.2,1.2;    you happen to mine a 'Crystal Gift' you can get a]"
	.."label[0.2,1.5;    'Legendary Crystal'. With every new crystal you get, you]"
	.."label[0.2,1.8;    can make more powerful balls. If you have a 'Crystal Key']"
	.."label[0.2,2.1;    the creation time will be halved.]"
	.."label[0.2,2.7;  b) Gems]"
	.."label[0.2,3.0;    In the 'Gems' tab you can insert 'Magic Gems' into the]"
	.."label[0.2,3.3;    colors. If you have 5 'Magic Gems' inserted you will get]"
	.."label[0.2,3.6;    the ability to use the home privilege and if you have 10]"
	.."label[0.2,3.9;    you will be able to use the fast privilege.]"
	.."label[0.2,4.5;  c) XP Items]"
	.."label[0.2,4.8;    In the 'XP Items' tab you can collect rewards earned]"
	.."label[0.2,5.1;    through XP collection. The rewards can be 'XP blocks',]" 
	.."label[0.2,5.4;    'Coins', 'Keys' or even some tools.]"
	
reg_pages[12] = "label[0.2,0;I. 7. Color Items]"
	.."label[0.2,0.6;  a) Artifacts]"
	.."label[0.2,0.9;    In the 'Artifacts' tab you can see your artifacts. You]"
	.."label[0.2,1.2;    will get them if you run around. Collect 71 artifacts to]" 
	.."label[0.2,1.5;    get the 'Knight Key' as a reward.]"
	.."label[0.2,2.1;  b) Medallion]"
	.."label[0.2,2.4;    In the 'Medallion' tab you can see your medallion. You can]"
	.."label[0.2,2.7;    get them if you craft them in the 'Medallion' craft tab.]"
	.."label[0.2,3.0;    Collect 7 medallions to get the 'Crystal Key' as a reward.]"
	.."label[0.2,3.6;  c) Treasures]"
	.."label[0.2,3.9;    In the 'Treasures' tab you can see your treasures. You will]"
	.."label[0.2,4.2;    get them if you run around with the fox. Collect 6]"
	.."label[0.2,4.5;    treasures to get the 'Legend Stick' as a reward.]"
	.."label[0.2,5.1;  d) Trophys]"
	.."label[0.2,5.4;    In the 'Trophys' tab you can see your trophys. You can get]"
	.."label[0.2,5.7;    them if you craft them in the 'Trophys' craft tab. Collect]"
	.."label[0.2,6.0;    24 trothys to get the 'Protection Key Lv.1' as a reward.]"

reg_pages[13] = "label[0.2,0;II. 1. Regnum Tools]"
	.."label[0.2,0.6;  a) Battleaxe]"
	.."label[0.2,0.9;    The 'Battleaxe' is the most important tool in Regnum. It is]"
	.."label[0.2,1.2;    used to mine different ores. If its level is too low, the]"
	.."label[0.2,1.5;    ore is destroyed during mining and you get nothing.]"
	.."label[0.2,1.8;    Required levels for each ore are listed under]"
	.."label[0.2,2.1;    'II. 5. Ores'. You can see how to level it up in the]"
	.."label[0.2,2.4;    'Regnum Crafts' tab. If you have the 'Superlegend' or]"
	.."label[0.2,2.7;    'Regnum Battleaxe', change its mode with sneak plus]"
	.."label[0.2,3.0;    right-click. Mode 2 lets you mine water and lava. Mode 3 is]"
	.."label[0.2,3.3;    for hunting monsters without breaking blocks.]"
	.."label[0.2,3.9;  b) Gun]"
	.."label[0.2,4.2;    The 'Gun' is a ranged weapon for hunting monsters or other]"
	.."label[0.2,4.5;    players. You can see how to level it up in the]"
	.."label[0.2,4.8;    'Regnum Crafts' tab. From level 1, you can change its mode]"
	.."label[0.2,5.1;    with sneak plus right-click. Mode 2 deals no damage to]"
	.."label[0.2,5.4;    players. If you have the 'Superlegend' or 'Regnum Gun', you]"
	.."label[0.2,5.7;    unlock Mode 3, which adds thunder at the hit location for]"
	.."label[0.2,6.0;    extra damage.]"
	.."label[0.2,6.6;  c) Wings]"
	.."label[0.2,6.9;    The 'Wings' let you fly for a limited time. Each level adds]"
	.."label[0.2,7.2;    0.5 seconds of flight. After use, there's a 10-second]"
	.."label[0.2,7.5;    cooldown. See 'Regnum Crafts' tab for leveling.]"

reg_pages[14] = "label[0.2,0;II. 1. Regnum Tools]"
	.."label[0.2,0.6;  d) Wall Placer]"
	.."label[0.2,0.9;    The 'Wall Placer' lets you build walls faster. Each level]"
	.."label[0.2,1.2;    adds a new mode, switchable with sneak plus right-click.]"
	.."label[0.2,1.5;    Each mode changes wall size (up to 11x11). The]"
	.."label[0.2,1.8;    'Wall Placer' uses the item right next to it in inventory]"
	.."label[0.2,2.1;    as material. ]"
	.."label[0.2,2.7;  e) Legend Stick]"
	.."label[0.2,3.0;    The Legend Stick can be used to shoot balls that deal]"
	.."label[0.2,3.3;    damage and create thunder on impact. It damages both]" 
	.."label[0.2,3.6;    monsters and players. You can craft it with Thunder and]"
	.."label[0.2,3.9;    'Legend Balls'.]"
	.."label[0.2,4.5;  f) Mining Laser]"
	.."label[0.2,4.8;    The 'Mining Laser' is upgraded with Green Laser Coins in]"
	.."label[0.2,5.1;    the 'Mining' craft tab. Each shot mines several blocks in a]" 
	.."label[0.2,5.4;    straight line. It must be charged in a device like a]"
	.."label[0.2,5.7;    'Battery Box' before use.]"
	.."label[0.2,6.3;  g) Mining Drill]"
	.."label[0.2,6.6;    The 'Mining Drill' is upgraded with Green Laser Coins in]"
	.."label[0.2,6.9;    the 'Mining' craft tab. Its mode can be changed with sneak]" 
	.."label[0.2,7.2;    plus right-click. Depending on the mode, it mines several]"
	.."label[0.2,7.5;    blocks in an area with each use.]"
	
reg_pages[15] = "label[0.2,0;II. 1. Regnum Tools]"
	.."label[0.2,0.6;  h) Color Stick]"
	.."label[0.2,0.9;    The 'Color Stick' is upgraded with 'Dye' in the 'Color' craft]"
	.."label[0.2,1.2;    tab. It can transform ores into each other. So far, it can]"
	.."label[0.2,1.5;    only convert 'Black Ore' to 'White Ore' and vice versa.]"
	.."label[0.2,2.1;  i) Mole Stick]"
	.."label[0.2,2.4;    The 'Mole Stick' is a tool used to automatically dig for a]"
	.."label[0.2,2.7;    certain period of time. Each level increases the duration]"
	.."label[0.2,3.0;    by 10 seconds. After the time runs out, it takes 10 seconds]"
	.."label[0.2,3.3;    before it can be used again. You can craft it with]"
	.."label[0.2,3.6;    'Bronze Coins'.]"
	.."label[0.2,4.2;  j) Xray Stick]"
	.."label[0.2,4.5;    The 'Xray Stick' is a tool used to see through stone for a]"
	.."label[0.2,4.8;    certain period of time. Each level increases the duration]"
	.."label[0.2,5.1;    by 10 seconds. After the time runs out, it takes 10 seconds]"
	.."label[0.2,5.4;    before it can be used again. You can craft it with]"
	.."label[0.2,5.7;    'Silver Coins'.]"

reg_pages[16] = "label[0.2,0;II. 2. Admin Tools]"
	.."label[0.2,0.6;  Apart from the 'Wings' and the 'Color Stick', all Regnum]"
	.."label[0.2,0.9;  tools and armor also have an admin version. The 'Battleaxe',]"
	.."label[0.2,1.2;  'Gun', and the 'Legend Stick' deal significantly more damage,]"
	.."label[0.2,1.5;  the 'Wall Placer' doesn't consume any blocks, the]"
	.."label[0.2,1.8;  'Mining Laser' and 'Mining Drill' don't need to be charged,]" 
	.."label[0.2,2.1;  and the 'Mole Stick' and 'Xray Stick' grant their respective]"
	.."label[0.2,2.4;  effects for much longer and can be activated or deactivated]"
	.."label[0.2,2.7;  at any time by using them. The full armor makes the player]"
	.."label[0.2,3.0;  invulnerable, and the 'Heart' also grants significantly more]"
	.."label[0.2,3.3;  health. In addition to the tools already mentioned, there are]"
	.."label[0.2,3.6;  two more:]"
	.."label[0.2,4.2;  a) Server Hammer]"
	.."label[0.2,4.5;    The 'Server Hammer' has six modes. Four of them change a]"
	.."label[0.2,4.8;    player’s rank. The Outsider rank removes all privileges,]"
	.."label[0.2,5.1;    Member is the default rank with interact and shout rights,]"
	.."label[0.2,5.4;    Moderators gets additional rights like ban, kick, and]"
	.."label[0.2,5.7;    settime, and Admin rank grants all rights. The current]"
	.."label[0.2,6.0;    rank is visible on the nametag. The last two modes are used]"
	.."label[0.2,6.3;    to kick or ban players.]"
	.."label[0.2,6.9;  b) Monster Remover]"
	.."label[0.2,7.2;    The 'Monster Remover' removes all monsters within a]"
	.."label[0.2,7.5;    15-block radius.]"

reg_pages[17] = "label[0.2,0;II. 3. Gifts]"
	.."label[0.2,0.6;  You can craft gifts to get loot. To open them you must mine]"
	.."label[0.2,0.9;  them, sometimes the block will just drop instead of dropping]"
	.."label[0.2,1.2;  the loot, just place it back down and try again. Here is a]"
	.."label[0.2,1.5;  list of gifts and their possible rewards:]"
	.."label[0.2,1.8;  Gift:]"
	.."label[3.0,1.8;  Dark Matter Lv.4, Ice]"
	.."label[3.0,2.1;  Mese Crystal, Lightstone]"
	.."label[0.2,2.4;  Silver Gift:]"
	.."label[3.0,2.4;  Arena Glass, Arena Block]"
	.."label[3.0,2.7;  Mese Crystal, Lightstone]"
	.."label[0.2,3.0;  Golden Gift:]"
	.."label[3.0,3.0;  Monsters, Mese Crystal]"
	.."label[0.2,3.3;  Platinum Gift:]"
	.."label[3.0,3.3;  Any type of Wool Gift,]"
	.."label[3.0,3.6;  Mese Crystal]"
	.."label[0.2,3.9;  Any type of Deathgift:]"
	.."label[3.0,3.9;  Mese Crystal, Lightstone,]"
	.."label[3.0,4.2;  Ice, Part of Regnum]"
	.."label[0.2,4.5;  DNA Gift:]"
	.."label[3.0,4.5;  Sky Mobs, Water Mobs]"
	.."label[0.2,4.8;  Crystal Gift:]"
	.."label[3.0,4.8;  Gems, Legendary Crystal]"
	.."label[0.2,5.1;  Regnum Gift:]"
	.."label[3.0,5.1;  Dark Pixel]"
	.."label[0.2,5.4;  Wool gift:]"
	.."label[3.0,5.4;  White Wool]"
	.."label[0.2,5.7;  Colored Wool Gift:]"
	.."label[3.0,5.7;  Yellow/White/Violetta/Red/]"
	.."label[3.0,6.0;  Orange/Blue Wool]"
	.."label[0.2,6.3;  Spezial Colored Wool Gift:]"
	.."label[3.0,6.3;  Every Wool]"
	.."label[0.2,6.6;  Dragon Gift:]"
	.."label[3.0,6.6;  Coal Lump, Dragon Key]"
	.."label[0.2,6.9;  Tortoise Gift:]"
	.."label[3.0,6.9;  Coal Lump, Tortoise Key]"
	.."label[0.2,7.2;  Dragon Gem Gift:]"
	.."label[3.0,7.2;  Dragon Gem Fragment,]"
	.."label[3.0,7.5;  Crystal Gift]"
	.."label[0.2,7.8;  Tortoise Gem Gift:]"
	.."label[3.0,7.8;  Tortoise Gem Fragment,]"
	.."label[3.0,8.1;  Crystal Gift]"
		
reg_pages[18] = "label[0.2,0;II. 4. Mobs]"
	.."label[0.2,0.6;  There are multiple types of mobs in Regnum. All monsters try]"
	.."label[0.2,0.9;  to kill you. The monsters that resemble the textures of the]"
	.."label[0.2,1.2;  ground drop 'Wrapping Paper', 'Death Wrapping Paper' and]"
	.."label[0.2,1.5;  'DNA Strings'. Monsters spawned by the 'Colored Monster']"
	.."label[0.2,1.8;  spawn egg will drop 'Tears'. You can get water and sky]"
	.."label[0.2,2.1;  animals from the 'DNA Gift'. There are turtles, sharks, gulls]"
	.."label[0.2,2.4;  and many other animals. If you use the DNA craft you can get]"
	.."label[0.2,2.7;  pets. The dog and cat attack monsters and collect their]"
	.."label[0.2,3.0;  drops. The sheep produces wool. The fox gives treasures and]"
	.."label[0.2,3.3;  the 'Fox Key'. The dragon will produce a 'Dragon Gift' or a]"
	.."label[0.2,3.6;  'Dragon Gem Gift' if you have a 'Regnum Crystal'. The]"
	.."label[0.2,3.9;  tortoise will produce a 'Tortoise Gift' or a]"
	.."label[0.2,4.2;  'Tortoise Gem Gift' if you have a 'Regnum Crystal'. You can]"
	.."label[0.2,4.5;  change the color of the pets and have them follow you.]"

reg_pages[19] = "label[0.2,0;II. 5. Xp & Level]"
	.."label[0.2,0.6;  If you dig certain ores you will be rewarded with Xp. There]"
	.."label[0.2,0.9;  are a total of 8 different Xp types: Green Xp, Red Xp,]"
	.."label[0.2,1.2;  Blue Xp, Grey Xp, Yellow Xp, Cyan Xp, Bronze Xp and Silver]"
	.."label[0.2,1.5;  Xp. Every 'Uranium Ore' drops one Green Xp. When you reach]"
	.."label[0.2,1.8;  level 100 you will be rewarded with the]"
	.."label[0.2,2.1;  'Purple Battleaxe Lv.1'. With it you can mine 'Red/Blue Ore'.]"
	.."label[0.2,2.4;  Red and Blue Xp will give you a 'Red/Blue Xp Block Part' once]"
	.."label[0.2,2.7;  you reach level 20. With these, you can then craft the]"
	.."label[0.2,3.0;  'Grey Xp Block'. The 'Grey Xp Block' will then give you Grey]"
	.."label[0.2,3.3;  Xp. Upon reaching level 100 you will earn a]"
	.."label[0.2,3.6;  'Yellow Xp Block'. The 'Yellow Xp Block' will give you yellow]"
	.."label[0.2,3.9;  Xp when mined and reaching level 100 with it will grant you]"
	.."label[0.2,4.2;  the 'Golden Key'. The 'Golden Key' will unlock the 'Crystal']"
	.."label[0.2,4.5;  craft tab allowing you to make crystal bottles which will]"
	.."label[0.2,4.8;  give you Cyan Xp. With the 'Purple Battleaxe', you can also]"
	.."label[0.2,5.1;  mine 'Precious Metal Ore'. This gives you Bronze Xp. By]"
	.."label[0.2,5.4;  reaching level 100, you receive the 'Bronze Key', which]"
	.."label[0.2,5.7;  enables you to gain Silver Xp from 'Precious Metal Ore' if]"
	.."label[0.2,6.0;  you add it in the 'Xp Guide' tab. There you can also see how]"
	.."label[0.2,6.3;  much Xp you already have for the different types, and if you]"
	.."label[0.2,6.6;  have the 'Level Key', how much you need for each level. All]"
	.."label[0.2,6.9;  rewards for reaching new levels can be found in the]"
	.."label[0.2,7.2;  'XP Items' tab.]"

reg_pages[20] = "label[0.2,0;II. 6. Ores]"
	.."label[0.2,0.6;  Ores are essential for progressing in the game. By mining]"
	.."label[0.2,0.9;  specific ores, you collect materials that allow you to ]"
	.."label[0.2,1.2;  upgrade your tools. The following list shows all ores in the]"
	.."label[0.2,1.5;  game and the corresponding depth at which they can be found:]"
	.."label[0.2,1.8;  Coal:]"
	.."label[2.3,1.8;  y < 65]"
	.."label[0.2,2.1;  Iron:]"
	.."label[2.3,2.1;  y < 1]"
	.."label[0.2,2.4;  Copper:]"
	.."label[2.3,2.4;  y < -15]"
	.."label[0.2,2.7;  Tin:]"
	.."label[2.3,2.7;  y < -31]"
	.."label[0.2,3.0;  Gold:]"
	.."label[2.3,3.0;  y < -63]"
	.."label[0.2,3.3;  Mese:]"
	.."label[2.3,3.3;  y < -63]"
	.."label[0.2,3.6;  Diamond:]"
	.."label[2.3,3.6;  y < -127]"
	.."label[0.2,3.9;  Silver:]"
	.."label[2.3,3.9;  y < -1]"
	.."label[0.2,4.2;  Mithril:]"
	.."label[2.3,4.2;  y < -511]"
	.."label[0.2,4.5;  Black/White:]"
	.."label[2.3,4.5;  y < 2 (needs battleaxe lv.21)]"
	.."label[0.2,4.8;  Uranium:]"
	.."label[2.3,4.8;  y < -128 (needs battleaxe lv.46)]"
	.."label[0.2,5.1;  Ruby/Sapphire:]"
	.."label[2.3,5.1;  y < -300 (needs battleaxe lv.52)]"
	.."label[0.2,5.4;  Amethyst:]"
	.."label[2.3,5.4;  y < -600 (needs battleaxe lv.62)]"
	.."label[0.2,5.7;  Shadow/Pearl:]"
	.."label[2.3,5.7;  y < -900 (needs battleaxe lv.64)]"
	.."label[0.2,6.0;  Emerald:]"
	.."label[2.3,6.0;  y < -1200 (needs battleaxe lv.71)]"
	.."label[0.2,6.3;  Admin:]"
	.."label[2.3,6.3;  y < -500 (needs battleaxe lv.74)]"
	.."label[0.2,6.6;  Regnum:]"
	.."label[2.3,6.6;  y < -600 (needs battleaxe lv.74)]"
	.."label[0.2,6.9;  Titan:]"
	.."label[2.3,6.9;  y < -400 (needs battleaxe lv.110]"
	.."label[2.3,7.2;  or 'Titanium Remover')]"
	.."label[0.2,7.5;  Red/Blue:]"
	.."label[2.3,7.5;  y < -100 (needs battleaxe lv.122]"
	.."label[2.3,7.8;  or 'Purple Battleaxe')]"
	.."label[0.2,8.1;  Precious Metal:]"
	.."label[2.3,8.1;  y < -100 (needs battleaxe lv.122)]"
		
reg_pages[21] = "label[0.2,0;II. 7. Chat Commands]"
	.."label[0.2,0.6;  a) /regnum]"
	.."label[0.2,0.9;    The '/regnum' command gives you everything needed to earn]"
	.."label[0.2,1.2;    all achievements. You’ll receive all Regnum tools, armor,]"
	.."label[0.2,1.5;    and spawn eggs in your main inventory, as well as all keys,]"
	.."label[0.2,1.8;    gems, crystals, max-level XP, all XP blocks, all awards and]"
	.."label[0.2,2.1;    all color items. The command requires the privs privilege.]"
	.."label[0.2,2.7;  b) /admin]"
	.."label[0.2,3.0;    The '/admin' command gives all admin tools and armor. The]"
	.."label[0.2,3.3;    command requires the privs privilege.]"
	.."label[0.2,3.9;  c) /rank]"
	.."label[0.2,4.2;    The '/rank' command shows your current rank based on your]"
	.."label[0.2,4.5;    privileges and how your nametag appears to other players.]"
	.."label[0.2,4.8;    This command requires no privileges and can be used by]"
	.."label[0.2,5.1;    anyone.]"

function get_regnum_page(player)
	local name = player:get_player_name()
	local page = player_page[name]
	local page_formspec = ""
	if page < 1 then
		page_formspec = reg_pages[1]
	elseif page > 21 then
		page_formspec = reg_pages[16]
	else
		page_formspec = reg_pages[page]
	end
	if page > 1 then
		page_formspec = page_formspec.."image_button[2.4,8.5;0.8,0.8;craftguide_prev_icon.png;guide_prev;]"
	end
	if page < 21 then
		page_formspec = page_formspec.."image_button[4.8,8.5;0.8,0.8;craftguide_next_icon.png;guide_next;]"
	end
	page_formspec = page_formspec.."label[3.4,8.6;Page "..page.."/21]"
	return page_formspec
end