local _VERSION = 20241004

_LILZUL._RCP = _LILZUL._RCP or {}
if _LILZUL._VERSION_CHECK( _LILZUL._RCP, _VERSION ) then
	local _SELF = _LILZUL._RCP
	
	-- return position snap left
	function _LILZUL._RCP.pos_change( from_pos, from_width, to_width )
		local posm1 = from_pos-1
		return math.min( 1 + posm1%from_width, to_width ) + math.floor(posm1/from_width)*to_width
	end

	--[[
	return format
	{
		{ item_id = amount }, -- recipe 1
		{ item_id = amount, item_id = amount } -- recipe 2
	}
	while only have one recipe
	{ { item_id = amount } }
	--]]
	function _LILZUL._RCP.get_input_item_count( item_id )
		local result_table = {}
		
		local recipe_table = minetest.get_all_craft_recipes( item_id )
		if recipe_table ~= nil then
			for _, recipe in ipairs( recipe_table ) do
				if recipe.items ~= nil then -- I think recipe with no input item can't be register, but for safe
					table.insert( result_table, {} )
					for _, input_item_id in ipairs( recipe.items ) do
						-- count material
						result_table[ #result_table ][ input_item_id ] = ( result_table[ #result_table ][ input_item_id ] or 0 ) + 1
					end
				end
			end
		end
		
		return result_table
	end


	function _LILZUL._RCP.check_major_material_in_itemcount( input_item )
		local result_table = { order = {}, amount = {} }
		
		for item_id, amount in pairs( input_item ) do
			local is_lookup_item = lookup_group == nil
			if lookup_group ~= nil then
				for _, group_name in ipairs( lookup_group ) do
					if minetest.get_item_group( item_id, group_name ) ~= 0 then
						is_lookup_item = true
						break
					end
				end
			end
			
			if is_lookup_item then
				local insert_idx = 1
				for idx, item_id in ipairs( result_table ) do
					if amount < input_item[ item_id ] then break end
					insert_idx = idx + 1
				end
				table.insert( result_table.order, insert_idx, item_id )
				table.insert( result_table.amount, insert_idx, amount )
			end
		end
		
		return result_table
	end

	--[[
	return ordered list
	{
		{ order = { item_id, item_id }, amount = { 2, 1 } }
	}
	--]]
	function _LILZUL._RCP.check_all_major_material( item_id, lookup_group )
		local result_table = {}
		
		local item_table = _SELF.get_input_item_count( item_id )
		if #item_table > 0 then
			for _, input_item in ipairs( item_table ) do
				table.insert( result_table, _LILZUL._RCP.check_major_material_in_itemcount( input_item ) )
			end
		end
		
		return result_table
	end

	function _LILZUL._RCP.check_all_major_material_squeeze( item_id, lookup_group )
		local result_table = { order = {}, amount = {} }
		
		local item_table = _SELF.get_input_item_count( item_id )
		if #item_table > 0 then
			-- runthrow frist table and check every input item in all recipe, only item in all recipe canbe major material
			-- item have variant recipe return nothing in this function
			for item_id, amount in pairs( item_table[1] ) do
				local amount_table = {}
				for _, input_item in ipairs( item_table ) do
					if input_item[ item_id ] ~= nil and input_item[ item_id ] > 0 then
						table.insert( amount_table, input_item[ item_id ] )
					else
						amount_table = nil
						break
					end
				end
				
				if amount_table ~= nil then
					table.insert( result_table.order, item_id )
					table.insert( result_table.amount, amount_table )
				end
			end
			
			local idx = 1
			while idx < #result_table.order do -- i / i+1 exit
				local i_count, ip_count = 0, 0
				for _, c in ipairs( result_table.amount[ idx ] ) do
					i_count = i_count + c
				end
				for _, c in ipairs( result_table.amount[ idx + 1 ] ) do
					ip_count = ip_count + c
				end
				if i_count < ip_count then
					table.insert( result_table.order, idx, result_table.order[ idx + 1 ] )
					table.insert( result_table.amount, idx, result_table.amount[ idx + 1 ] )
					table.remove( result_table.order, idx + 2 )
					table.remove( result_table.amount, idx + 2 )
					idx = math.max( 1, idx - 1 )
				else
					idx = idx + 1
				end
			end
		end
		
		return result_table
	end
end
