-- get MOD constant
local ID_MOD	= minetest.get_current_modname()
local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
local TS		= minetest.get_translator( ID_MOD )

--
-- stack up order
--
local order_list = {}
_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.wood_order, order_list )
_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.stone_order, order_list )
_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.metal_order, order_list )
-- run for fix order after but pr smaller problem
local current_pr = -1
for _, check_mat_id in ipairs( order_list ) do
	-- ignore non-exit material even on list
	if _TOOLCRAFTER_CREATION_STAT[ check_mat_id ] then
		if _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank == -1 then
			-- unknown set to pr but add a flag to reassign after
			_TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank = current_pr
			_TOOLCRAFTER_CREATION_STAT[ check_mat_id ].unknown_rank = true
		else
			if _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank > current_pr then
				current_pr = _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank
			elseif _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank < current_pr then
				_TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank = current_pr
			end
		end
	end
end

--
-- make up final order table
--
local material_rank_order = {}
local hard_wood_sidx, stone_sidx, metal_sidx = 1, 1, 1
for mat_id, mat_data in pairs( _TOOLCRAFTER_CREATION_STAT ) do
	local in_order_list = false
	local start_pos, end_pos, insert_pos = 1, 1, 1
	-- check order list first
	local before_id, after_id = {}, {}
	for idx, check_mat_id in ipairs( order_list ) do
		if check_mat_id == mat_id then
			in_order_list = true
		elseif in_order_list then
			after_id[ check_mat_id ] = true
		else
			before_id[ check_mat_id ] = true
		end
	end
	if in_order_list then
		if mat_data.is_stone then
			insert_pos = stone_sidx
			start_pos = insert_pos
			end_pos = metal_sidx
		elseif mat_data.is_hardwood or mat_data.is_softwood then
			insert_pos = 1
			start_pos = insert_pos
			end_pos = stone_sidx
		else
			insert_pos = metal_sidx
			start_pos = insert_pos
			end_pos = #material_rank_order
		end
		for opm_pos = start_pos, end_pos do
			if before_id[ material_rank_order[ opm_pos ] ] then
				start_pos = opm_pos
			elseif after_id[ material_rank_order[ opm_pos ] ] then
				end_pos = opm_pos
				break
			end
		end
		for idx = start_pos, end_pos do
			local check_mat_id = material_rank_order[ idx ]
			local check_pr = check_mat_id ~= nil and _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank or -1
			if check_pr ~= -1 then -- don't lock at no pr mat
				if mat_data.posible_rank < check_pr then break end
				insert_pos = idx + 1
			end
		end
	else
		if mat_data.posible_rank == -1 then
			-- not on order list + no pr
			if mat_data.is_stone then
				insert_pos = math.random( stone_sidx, metal_sidx )
			elseif mat_data.is_hardwood then
				insert_pos = math.random( hard_wood_sidx, stone_sidx )
			elseif mat_data.is_softwood then
				insert_pos = math.random( 1, hard_wood_sidx )
			else
				insert_pos = math.random( metal_sidx, #material_rank_order + 1 )
			end
		else
			-- here run throw all inserted order
			-- should choose method by material amount?
			for idx, check_mat_id in ipairs( material_rank_order ) do
				-- skip random insert
				if _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank ~= -1 then
					if mat_data.posible_rank < _TOOLCRAFTER_CREATION_STAT[ check_mat_id ].posible_rank then break end
				end
				insert_pos = idx + 1
			end
		end
	end
	table.insert( material_rank_order, insert_pos, mat_id )
	
	if mat_data.is_stone or mat_data.is_hardwood or mat_data.is_softwood then
		metal_sidx = metal_sidx + 1
	end
	if mat_data.is_hardwood or mat_data.is_softwood then
		stone_sidx = stone_sidx + 1
	end
	if mat_data.is_softwood then
		hard_wood_sidx = hard_wood_sidx + 1
	end
end
for idx, mat_id in ipairs( material_rank_order ) do
	if _TOOLCRAFTER_CREATION_STAT[ mat_id ].unknown_rank then
		local range_low, range_up = 0, 0
		local dis_low, dis_up = 0, 0
		local i = idx
		while i > 0 do
			if not _TOOLCRAFTER_CREATION_STAT[ material_rank_order[i] ].unknown_rank then
				range_low = math.max( 0, _TOOLCRAFTER_CREATION_STAT[ material_rank_order[i] ].posible_rank )
				dis_low = idx - i
				break
			end
			i = i - 1
		end
		for i= idx, #material_rank_order do
			if not _TOOLCRAFTER_CREATION_STAT[ material_rank_order[i] ].unknown_rank then
				range_up = math.max( 0, _TOOLCRAFTER_CREATION_STAT[ material_rank_order[i] ].posible_rank )
				dis_up = i - idx
				break
			end
		end
		_TOOLCRAFTER_CREATION_STAT[ mat_id ].rank = range_low + ( range_up - range_low ) * ( dis_low / ( dis_low + dis_up ) )
	else
		_TOOLCRAFTER_CREATION_STAT[ mat_id ].rank = math.max( 0, _TOOLCRAFTER_CREATION_STAT[ mat_id ].posible_rank )
	end
end

--
-- use before stat and rank to calculate avg tool status of each level
--
local all_key_in_tool = {}
local avg_tool_status = {}
for _, mat_id in ipairs( material_rank_order ) do
	local current_mat = _TOOLCRAFTER_CREATION_STAT[ mat_id ]
	local current_rank = math.floor( current_mat.rank )
	avg_tool_status[ current_rank ] = avg_tool_status[ current_rank ] or {}
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		if current_mat[ tool_key ] ~= nil then
			avg_tool_status[ current_rank ][ tool_key ] = avg_tool_status[ current_rank ][ tool_key ] or {}
			
			for k,v in pairs( current_mat[ tool_key ] ) do
				all_key_in_tool[k] = true
				
				avg_tool_status[ current_rank ][ tool_key ][k] = avg_tool_status[ current_rank ][ tool_key ][k] or {}
				table.insert( avg_tool_status[ current_rank ][ tool_key ][k], v )
			end
		end
	end
end
for rank, rank_data in pairs( avg_tool_status ) do
	for _, tool_data in pairs( rank_data ) do
		-- flatten table to get avg
		for k, v_table in pairs( tool_data ) do
			if type( v_table ) == 'table' then
				local t = 0
				for _, v in ipairs( v_table ) do
					t = t + v
				end
				tool_data[k] = t / #v_table
			end
		end
	end
end

--
-- assign lost data and save all data to db
--
for mat_id, mat_data in pairs( _TOOLCRAFTER_CREATION_STAT ) do
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		-- assign nil data to avg data, this MOD don't add data to rank completely lost
		if mat_data[ tool_key ] == nil then
			--[[ _TOOLCRAFTER_CREATION_STAT > mat_id > tool_key
				droplevel		= drop level
				interval		= punch interval
				maxlevel		= maxlevel
				uses			= uses * maxlevel
				times_1..3		= time / (max of 1 and lv df to 1)
				dmggp_[name]	= rating
				gp_[name]		= rating
			--]]
			local mat_rank = math.floor( mat_data.rank )
			if avg_tool_status[ mat_rank ] ~= nil and avg_tool_status[ mat_rank ][ tool_key ] ~= nil then
				mat_data[ tool_key ] = {}
				for k,v in pairs( avg_tool_status[ mat_rank ][ tool_key ] ) do
					if mat_id:sub(1,6) ~= 'group:' or k:sub(1,6) ~= 'times_' then -- don't try to assign time to group:
						mat_data[ tool_key ][k] = v
						local is_int_value = k ~= 'interval'
						if is_int_value then
							mat_data[ tool_key ][k] = math.floor( mat_data[ tool_key ][k] )
						end
					end
				end
			end
		end
		
		if mat_data[ tool_key ] ~= nil then
			-- only push maxlevel to match rank
			if mat_data[ tool_key ].maxlevel ~= nil and mat_data.rank ~= nil then
				if mat_data[ tool_key ].maxlevel < math.floor( mat_data.rank ) then
					mat_data[ tool_key ].maxlevel = math.floor( mat_data.rank )
				end
			end
			
			local tool_str = ''
			for k,v in pairs( mat_data[ tool_key ] ) do
				tool_str = tool_str .. k .. '=' .. v .. ','
			end
			_TOOLCRAFTER_MOD_DB:set_string( _TOOLCRAFTER_ID._DB[ tool_key ]..mat_id:gsub(':','_'), tool_str )
		end
	end
end

_TOOLCRAFTER_CREATION_STAT = nil
