-- get MOD constant
local ID_MOD	= minetest.get_current_modname()
local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
local TS		= minetest.get_translator( ID_MOD )

-- table for pass data
_TOOLCRAFTER_CREATION_STAT = {}

--
-- make up handle list by stack setting strlist on default list
--
local group_name2id = {
	stick		= 'ROD',
	wood		= 'MAT',
	stone		= 'MAT',
	ingot		= 'MAT',
	ingot_like	= 'MAT',
}
_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.rod_group, group_name2id, 'ROD' )
_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.mat_group, group_name2id, 'MAT' )

--
-- auto search all registered item and list them in _TOOLCRAFTER_ITEMGROUP
--
local function wood_stone_extra_check( item_id, data )
	local not_building	= not( item_id:find('wall') or item_id:find('stair') or item_id:find('door') or item_id:find('chest') )
	local not_buildmat	= not( item_id:find('brick') or item_id:find('block') or item_id:find('tile') )
	local is_normal		= data.drawtype == 'normal'
	local is_fullbox	= data.node_box == nil or data.node_box.type == 'regular'
	local not_tool		= data.tool_capabilities == nil
	return not_building and not_buildmat and is_normal and is_fullbox and not_tool
end
local function add_material_to_stat( item_id, as_rod, as_mat, is_softwood, is_hardwood, is_stone )
	_TOOLCRAFTER_CREATION_STAT[ item_id ] = {
		posible_rank = -1,
		as_rod = as_rod,
		as_mat = as_mat,
		is_softwood = is_softwood,
		is_hardwood = is_hardwood,
		is_stone = is_stone
	}
end
for item_id, data in pairs( minetest.registered_items ) do
	if _TOOLCRAFTER_SPECIALLIST[ item_id ] ~= false then -- check material not on ignore list
		local flag_mat_added = false -- _ITEMGROUP is itable so use a flag to protect double add
		local is_wood, is_stone = false, false -- for stat
		for group_name, group_id in pairs( group_name2id ) do
			if minetest.get_item_group( item_id, group_name ) ~= 0 then
				local mat_basecheck = not ( flag_mat_added or _TOOLCRAFTER_SETTING.list_only )
				local not_wood_stone = group_name ~= 'wood' and group_name ~= 'stone'
				local wood_check = group_name == 'wood' and wood_stone_extra_check( item_id, data )
				local stone_check = group_name == 'stone' and wood_stone_extra_check( item_id, data )
				if group_id == 'ROD' or ( mat_basecheck and ( not_wood_stone or wood_check or stone_check ) ) then
					table.insert( _TOOLCRAFTER_ITEMGROUP[ group_id ], item_id )
					if group_id ~= 'ROD' then flag_mat_added = true end
				end
				if wood_check then
					table.insert( _TOOLCRAFTER_ITEMGROUP.WOOD, item_id )
					is_wood = true
				end
				if stone_check then
					table.insert( _TOOLCRAFTER_ITEMGROUP.STONE, item_id )
					is_stone = true
				end
			end
		end
		if not flag_mat_added and _TOOLCRAFTER_SPECIALLIST[ item_id ] then -- check material in include list but not added
			table.insert( _TOOLCRAFTER_ITEMGROUP.MAT, item_id )
			flag_mat_added = true
		end
		
		-- make room for stat data
		if flag_mat_added then
			local is_softwood = is_wood and data.groups ~= nil and data.groups.choppy >= 3
			local is_hardwood = is_wood and data.groups ~= nil and data.groups.choppy <= 2
			add_material_to_stat( item_id, nil, true, is_softwood, is_hardwood, is_stone )
		end
	end
end

-- make room for save wood and stone tool stat
add_material_to_stat( 'group:stone', nil, true, nil, nil, true )
add_material_to_stat( 'group:wood', nil, true, true, true )
add_material_to_stat( 'group:stick', true, nil, true, true )

--
-- function for save data inside _TOOLCRAFTER_CREATION_STAT (pass by mat_ref)
--   pick weakest value of all tool includ this material
--
local function update_data( mat_id, tool_ref, tool_key )
	-- don't update anything while tool no tool capabilities
	if tool_ref.tool_capabilities ~= nil then
		local mat_ref = _TOOLCRAFTER_CREATION_STAT[ mat_id ]
		-- for some setting
		local maxium_rating = 999
		local maxium_uses = 65535 -- api limit
		local maxium_time = 999
		
		local mat_tool_ref = mat_ref[ tool_key ]
		local cap_group = _TOOLCRAFTER_TOOLGROUP[ tool_key ]
		
		local rank_score, score_fix = 0, 0
		if tool_ref.tool_capabilities.full_punch_interval ~= nil then
			mat_tool_ref.interval = math.max( mat_tool_ref.interval or 0, tool_ref.tool_capabilities.full_punch_interval )
		end
		if tool_ref.tool_capabilities.max_drop_level ~= nil then
			mat_tool_ref.droplevel = math.min( mat_tool_ref.droplevel or maxium_rating, tool_ref.tool_capabilities.max_drop_level )
		end
		
		if tool_ref.tool_capabilities.groupcaps ~= nil and tool_ref.tool_capabilities.groupcaps[ cap_group ] ~= nil then
			local temp_tool_level = tool_ref.tool_capabilities.groupcaps[ cap_group ].maxlevel or 0
			_TOOLCRAFTER_SETTING.max_dig_level = math.max( _TOOLCRAFTER_SETTING.max_dig_level, temp_tool_level ) -- extend level while found any higher
			mat_tool_ref.maxlevel = math.min( mat_tool_ref.maxlevel or maxium_rating, temp_tool_level )
			rank_score = temp_tool_level -- max level increase rank directly
			mat_tool_ref.uses = math.min( mat_tool_ref.uses or maxium_uses, tool_ref.tool_capabilities.groupcaps[ cap_group ].uses or 0 )
			if tool_ref.tool_capabilities.groupcaps[ cap_group ].times ~= nil then
				-- note: MTG have 3lv + 3hardness, result in 3*3=9 speed fix, recalculate can reramp their value by multiply level, but not doing here
				local max_level = 0
				for node_level, dig_time in pairs( tool_ref.tool_capabilities.groupcaps[ cap_group ].times ) do
					max_level = math.max( max_level, node_level )
				end
				for node_level = 1, max_level do
					local dig_time = tool_ref.tool_capabilities.groupcaps[ cap_group ].times[ node_level ]
					if dig_time == nil then
						if mat_id:sub(1,6) == 'group:' then
							mat_tool_ref[ 'times_'..node_level ] = maxium_time
						end
					else
						mat_tool_ref[ 'times_'..node_level ] = math.max( mat_tool_ref[ 'times_'..node_level ] or 0, dig_time )
						score_fix = score_fix + ( 0.1 * math.max( 0, math.min( 1, ((5.0-dig_time)/5.0) ) ) )
					end
				end
			end
		end
		
		if tool_ref.tool_capabilities.damage_groups ~= nil then
			for dmg_type, dmg_rate in pairs( tool_ref.tool_capabilities.damage_groups ) do
				mat_tool_ref[ 'dmggp_'..dmg_type ] = math.min( mat_tool_ref[ 'dmggp_'..dmg_type ] or maxium_rating, dmg_rate )
				score_fix = score_fix +  ( 0.4 * ( dmg_rate / 20 ) )
			end
		end
		
		if tool_ref.groups ~= nil then
			for gp_type, gp_rate in pairs( tool_ref.groups ) do
				local on_tool_gp = false
				
				for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
					if gp_type == tool_key then
						on_tool_gp = true
						break
					end
				end
				
				if not on_tool_gp then
					mat_tool_ref[ 'gp_'..gp_type ] = math.min( mat_tool_ref[ 'gp_'..gp_type ] or maxium_rating, gp_rate )
				end
			end
		end
		
		rank_score = rank_score + math.max( 0.00, math.min( 0.99, score_fix ) )
		mat_ref.posible_rank = math.max( mat_ref.posible_rank, rank_score ) -- get highest for ranking
	end
end

--
-- check all exit tool and makeup ref table
--
local tool_table = {}
for tool_id, _ in pairs( minetest.registered_tools ) do
	-- check tool have handle tool type
	local posible_tool = {}
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		if minetest.get_item_group( tool_id, tool_key ) ~= 0 then
			table.insert( posible_tool, tool_key )
		end
	end
	
	if #posible_tool > 0 then
		local recipe_table = minetest.get_all_craft_recipes( tool_id )
		if recipe_table ~= nil then
			-- find use what material
			local material_list = {}
			for _, recipe in ipairs( recipe_table ) do -- usually one
				if recipe.items ~= nil then -- I think recipe with no input item can't be register, but for safe
					-- check this recipe is which tool type
					for _, tool_key in ipairs( posible_tool ) do
						local check_pass = false
						local recipe_input = _TOOLCRAFTER_TOOLRECIPE[ tool_key ].input
						
						-- recipe should match
						local input_width = _TOOLCRAFTER_TOOLRECIPE[ tool_key ].shape and _TOOLCRAFTER_TOOLRECIPE[ tool_key ].shape[1] or 1
						for offset = 0, math.max( 0, recipe.width - input_width ) do
							local recipe_pass = true
							for recipe_pos, recipe_item in ipairs( recipe_input ) do
								local corrected_pos = _LILZUL._RCP.pos_change( recipe_pos, input_width, recipe.width ) + offset
								if ( recipe_item ~= '*' and recipe.items[ corrected_pos ] == nil ) or ( recipe_item == '*' and recipe.items[ corrected_pos ] ~= nil ) then
									recipe_pass = false
									break
								end
							end
							if recipe_pass then check_pass = true end
							
							if check_pass then break end
						end
						
						if check_pass then
							for input_pos, input_item_id in ipairs( recipe.items ) do
								-- count material
								if material_list[ input_item_id ] == nil then material_list[ input_item_id ] = {} end
								if recipe_input[ input_pos ] == 'M' then
									material_list[ input_item_id ].mat = ( material_list[ input_item_id ].mat or 0 ) + 1
								else
									material_list[ input_item_id ].rod = ( material_list[ input_item_id ].rod or 0 ) + 1
								end
							end
						end
					end
				end
			end
			
			-- check precent of material (ignore material not on list)
			local mat_total, rod_total, mat_in_current_tool = 0, 0, {}
			for mat_id, count in pairs( material_list ) do
				if _TOOLCRAFTER_CREATION_STAT[ mat_id ] then
					mat_total = mat_total + ( count.mat or 0 )
					rod_total = rod_total + ( count.rod or 0 )
					mat_in_current_tool[ mat_id ] = { mat = count.mat, rod = count.rod }
				end
			end
			for mat_id, amount in pairs( mat_in_current_tool ) do
				if tool_table[ tool_id ] == nil then tool_table[ tool_id ] = { mat = {}, rod = {} } end
				if _TOOLCRAFTER_CREATION_STAT[ mat_id ] then
					if amount.mat ~= nil then tool_table[ tool_id ].mat[ mat_id ] = amount.mat / mat_total end
					if amount.rod ~= nil then tool_table[ tool_id ].rod[ mat_id ] = amount.rod / mat_total end
				end
			end
		end
	end
end

--
-- make up stat table and check tool table than add 100% tool to mat table
--
local tool_redirect_table = {}
for tool_id, tool_mat_cat in pairs( tool_table ) do
	-- use mat_rate to check tool make by what mat and rod (stick)
	local update_mat_list = {}
	local highest_rate_mat, highest_rate_rod = nil, nil
	for mat_id, mat_rate in pairs( tool_mat_cat.mat ) do
		local target_mat = _TOOLCRAFTER_CREATION_STAT[ mat_id ]
		if target_mat ~= nil then -- should all is ture but for safe
			update_mat_list[ mat_id ] = true
			if highest_rate_mat == nil or mat_rate > tool_mat_cat.mat[ highest_rate_mat ] then highest_rate_mat = mat_id end
		
		end
	end
	for mat_id, mat_rate in pairs( tool_mat_cat.rod ) do
		local target_mat = _TOOLCRAFTER_CREATION_STAT[ mat_id ]
		if target_mat ~= nil then -- should all is ture but for safe
			update_mat_list[ mat_id ] = true
			if highest_rate_rod == nil or mat_rate > tool_mat_cat.rod[ highest_rate_rod ] then highest_rate_rod = mat_id end
		end
	end
	-- update data with their tool group (it should at least have one, or more if there have multi tool MOD)
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		if minetest.get_item_group( tool_id, tool_key ) ~= 0 then
			for mat_id, _ in pairs( update_mat_list ) do
				_TOOLCRAFTER_CREATION_STAT[ mat_id ][ tool_key ] = _TOOLCRAFTER_CREATION_STAT[ mat_id ][ tool_key ] or {}
				update_data( mat_id, minetest.registered_tools[ tool_id ], tool_key )
			end
		end
	end
	
	if highest_rate_mat ~= nil then -- it should have one, unless there have something use stick but mat don't allowed
		local COM_ID		= highest_rate_mat:gsub(':','_')..'_'..( highest_rate_rod or 'group:stick' ):gsub(':','_') -- use stick group while rod is nil
		-- add all tool_key in this tool
		for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
			if minetest.get_item_group( tool_id, tool_key ) ~= 0 then
				local TOOL_ID		= ID_MOD..':_'..tool_key..'_'..COM_ID
				tool_redirect_table[ TOOL_ID ] = tool_id -- use this table to simple avoid same tool have two ref tool
				-- TODO: need add something to check multi tool or same tool make with same material
			end
		end
	end
end
-- output all actural handle tool list as string for after use
local tool_strlist = ''
for k,v in pairs( tool_redirect_table ) do
	tool_strlist = tool_strlist .. ( #tool_strlist>0 and ', ' or '' ) .. k .. '=' .. v
end
_TOOLCRAFTER_MOD_DB:set_string( _TOOLCRAFTER_ID._DB.tool_list, tool_strlist )

-- check any time is maxium, if so, remove them
for mat_id, mat_data in pairs( _TOOLCRAFTER_CREATION_STAT ) do
	for tool_key, tool_data in pairs( mat_data ) do
		if type( tool_data ) == 'table' then
			for k,v in pairs( tool_data ) do
				if k:sub(1,6) == 'times_' and v == 999 then
					tool_data[k] = nil
				end
			end
		end
	end
end

-- finally copy wood and stone data from group, do not override exit data
--   i.e. if some recipe use xxx_wood instend of group:wood, don't use group data override them even it's stronger or weaker
local function copy_data( from_mat, to_mat )
	local from_ref = _TOOLCRAFTER_CREATION_STAT[ from_mat ]
	local to_ref = _TOOLCRAFTER_CREATION_STAT[ to_mat ]
	
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		if from_ref[ tool_key ] ~= nil then
			to_ref[ tool_key ] = to_ref[ tool_key ] or {}
			for k,v in pairs( from_ref[ tool_key ] ) do
				if to_ref[ tool_key ][k] == nil then
					to_ref[ tool_key ][k] = v
				end
			end
		end
	end
end
for _, mat_id in ipairs( _TOOLCRAFTER_ITEMGROUP.WOOD ) do
	copy_data( 'group:wood', mat_id )
end
for _, mat_id in ipairs( _TOOLCRAFTER_ITEMGROUP.STONE ) do
	copy_data( 'group:stone', mat_id )
end
