local _VERSION = 20241004

_LILZUL._REG = _LILZUL._REG or {}
if _LILZUL._VERSION_CHECK( _LILZUL._REG, _VERSION ) then
	local _SELF = _LILZUL._REG
	
	-- auto select override or register new
	function _LILZUL._REG.add_craftitem( ID, DATA )
		( minetest.registered_items[ ID ] and minetest.override_item or minetest.register_craftitem )( ID, DATA )
	end
	function _LILZUL._REG.add_node( ID, DATA )
		( minetest.registered_nodes[ ID ] and minetest.override_item or minetest.register_node )( ID, DATA )
	end
	function _LILZUL._REG.add_tool( ID, DATA )
		( minetest.registered_tools[ ID ] and minetest.override_item or minetest.register_tool )( ID, DATA )
	end

	-- simple remove item / tool / node and recipe input or output is this node
	function _LILZUL._REG.remove_item( item_id )
		minetest.unregister_item( item_id )
	end

	function _LILZUL._REG.remove_items( ITEM_ID_TABLE )
		for _, item_id in ipairs( ITEM_ID_TABLE ) do
			_SELF.remove_item( item_id )
		end
	end

	--[[ can't found a fast way to get all node == node_id, use ABR or something to check around player if neccessary
	-- remove ore register and set them back to stone
	function _LILZUL._REG.remove_ores( ORES_ID_TABLE )
		for _, node_id in ipairs( ORES_ID_TABLE ) do
			if minetest.registered_nodes[ node_id ] then
				minetest.log( 'found node: '.. node_id )
				-- find all ore register with this id before remove
				local temp_remove_list = {}
				for ores_id, ores_data in pairs( minetest.registered_ores ) do
					for k,v in pairs(ores_data) do
						if k == 'ore' and v == node_id then
							table.insert( temp_remove_list, ores_id )
							break
						end
					end
				end
				for _, ores_id in ipairs( temp_remove_list ) do
					minetest.registered_ores[ ores_id ] = nil
					minetest.log( 'remove register ores: '.. ores_id )
				end
				
				minetest.log( 'remove node: '.. node_id )
				minetest.unregister_item( node_id )
			end
		end
	end
	--]]

	function _LILZUL._REG.clear_recipe_with_output( ID )
		if minetest.get_all_craft_recipes( ID ) then
			return minetest.clear_craft( { output = ID } )
		end
	end
end
