local _VERSION = 20241004

_LILZUL._STR = _LILZUL._STR or {}
if _LILZUL._VERSION_CHECK( _LILZUL._STR, _VERSION ) then
	local _SELF = _LILZUL._STR
	
	function _LILZUL._STR.head_upper( str )
		if type( str ) == 'string' then
			if #str > 1 then
				return str:sub(1,1):upper() .. str:sub(2)
			else
				return str:upper()
			end
		end
	end

	function _LILZUL._STR.cut_last( str, pattern )
		if type( str ) == 'string' then
			return str:sub( 1, #str - str:reverse():find('%'..pattern) )
		end
	end

	function _LILZUL._STR.split( str, sep )
		sep = sep or ','
		
		local split = {}
		for cut_str in str:gmatch('([^'..sep..']+)') do
			table.insert( split, cut_str )
		end
		return split
	end

	function _LILZUL._STR.to_list( str, table_ref, as_key_value, sep, no_space )
		table_ref = table_ref or {}
		sep = sep or ','
		no_space = no_space == nil or no_space
		
		for item in string.gmatch( str, '([^'..sep..']+)' ) do
			if no_space then item = item:gsub(' ','') end
			if as_key_value ~= nil then
				-- set item as key value
				table_ref[ item ] = as_key_value
			else
				-- as key value is nil, use itable insteand
				table.insert( table_ref, item )
			end
		end
		
		return table_ref
	end
end
