-- get MOD constant
local ID_MOD	= minetest.get_current_modname()
local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
local TS		= minetest.get_translator( ID_MOD )

-- const
local TOOL_SCALE = { x=1.5, y=1.5, z=1.0 }

--
-- register ROD first, ROD must add into GROUP before create tool
--
if _TOOLCRAFTER_SETTING.allow_rod then
	-- add wood rod (an counter part of stick but only can use as tool)
	if not _TOOLCRAFTER_SETTING.wood_variant then
		minetest.register_craftitem( ID_MOD..':_rod_group_wood', {
			description				= TS( 'Wood Rod' ),
			inventory_image			= _TOOLCRAFTER_TX.TOOL..'_texture_wood.png^'.._TOOLCRAFTER_TX.ROD_MASK..'^[mask:'.._TOOLCRAFTER_TX.ROD_PATTERN,
			groups					= { [ _TOOLCRAFTER_ID._GROUP.rod ] = 1 },
			_toolcrafter_material	= 'group:wood'
		} )
		table.insert( _TOOLCRAFTER_ITEMGROUP.ROD, ID_MOD..':_rod_group_wood' )
	end
	-- add stone rod
	if not _TOOLCRAFTER_SETTING.stone_variant then
		minetest.register_craftitem( ID_MOD..':_rod_group_stone', {
			description				= TS( 'Stone Rod' ),
			inventory_image			= _TOOLCRAFTER_TX.TOOL..'_texture_stone.png^'.._TOOLCRAFTER_TX.ROD_MASK..'^[mask:'.._TOOLCRAFTER_TX.ROD_PATTERN,
			groups					= { [ _TOOLCRAFTER_ID._GROUP.rod ] = 1 },
			_toolcrafter_material	= 'group:stone'
		} )
		table.insert( _TOOLCRAFTER_ITEMGROUP.ROD, ID_MOD..':_rod_group_stone' )
	end
	for _, MAT_ID in ipairs( _TOOLCRAFTER_ITEMGROUP.MAT ) do
		local wood_check = minetest.get_item_group( MAT_ID, _TOOLCRAFTER_ID._GROUP.wood ) == 0 or _TOOLCRAFTER_SETTING.wood_variant
		local stone_check = minetest.get_item_group( MAT_ID, _TOOLCRAFTER_ID._GROUP.stone ) == 0 or _TOOLCRAFTER_SETTING.stone_variant
		if wood_check and stone_check then
			-- register ROD
			local ROD_ID		= ID_MOD..':_rod_'..MAT_ID:gsub(':','_')
			local ROD_DESC		= minetest.registered_items[ MAT_ID ].description .. TS( ' Rod' ) -- get desc as Material Name (+ Rod)
			local MAT_TEXTURE	= _LILZUL._TXT.get_single_texture( MAT_ID )
			local addictional_info = ''
			minetest.register_craftitem( ROD_ID, {
				description				= ROD_DESC,
				inventory_image			= MAT_TEXTURE..'^'.._TOOLCRAFTER_TX.ROD_MASK..'^[mask:'.._TOOLCRAFTER_TX.ROD_PATTERN,
				groups					= { [ _TOOLCRAFTER_ID._GROUP.rod ] = 1 },
				_toolcrafter_material	= MAT_ID
			} )
			table.insert( _TOOLCRAFTER_ITEMGROUP.ROD, ROD_ID )
		end
	end
end

--
-- register TOOL
--
local function calculate_capabilities( mat_data, rod_data )
	local TOOL_CAPABILITIES = {}
	
	-- calculate rod avg duration, no any data inside = 1
	local rod_fix = rod_data.rod or {
		duration = 1
	}
	
	-- calculate mat highest level, for assign data to lost tool data
	local mat_highest_level = 0
	for _, tool_data in pairs( mat_data ) do
		mat_highest_level = math.max( mat_highest_level, tool_data.maxlevel or 0 )
	end
	
	local base_data = {
		pickaxe = {
			full_punch_interval = 1.2,
			max_drop_level = 0,
			groupcaps={ cracky = { times={ 6.00, 3.00, 1.60 }, uses= 10 + 10 * mat_highest_level, maxlevel = mat_highest_level }, },
			damage_groups = { fleshy = 1 + mat_highest_level }
		},
		axe = {
			full_punch_interval = 1.0,
			max_drop_level = 0,
			groupcaps={ choppy = { times={ 6.00, 3.00, 1.60 }, uses= 10 + 10 * mat_highest_level, maxlevel = mat_highest_level }, },
			damage_groups = { fleshy = 1 + mat_highest_level }
		},
		shovel = {
			full_punch_interval = 1.2,
			max_drop_level = 0,
			groupcaps={ crumbly = { times={ 3.00, 1.60, 0.60 }, uses= 10 + 10 * mat_highest_level, maxlevel = mat_highest_level }, },
			damage_groups = { fleshy = 1 + mat_highest_level }
		},
		sword = {
			full_punch_interval = 0.9,
			max_drop_level = 3,
			groupcaps={ snappy = { times={ 2.40, 1.20, 0.60 }, uses= 20 + 20 * mat_highest_level, maxlevel = mat_highest_level }, },
			damage_groups = { fleshy = 4 + 2 * mat_highest_level }
		}
	}
	
	for tool_key, base in pairs( base_data ) do
		local mat_tool_data = mat_data[ tool_key ] or {}
		TOOL_CAPABILITIES[ tool_key:upper() ] = {
			full_punch_interval = ( mat_tool_data.interval or base.full_punch_interval ) * rod_fix.interval,
			max_drop_level = mat_tool_data.droplevel or base.max_drop_level,
			groupcaps = {},
			damage_groups = {}
		}
		local TC = TOOL_CAPABILITIES[ tool_key:upper() ]
		for group_name, group_data in pairs( base.groupcaps ) do
			TC.groupcaps[ group_name ] = {
				maxlevel = mat_tool_data.maxlevel or group_data.maxlevel,
				uses = math.floor( ( mat_tool_data.uses or group_data.uses ) * rod_fix.duration ),
				times = {}
			}
			for level, time in pairs( group_data.times ) do
				TC.groupcaps[ group_name ].times[ level ] = mat_tool_data[ 'times_'..level ] -- don't apply time even it's nil
			end
		end
		for group_name, group_rate in pairs( base.damage_groups ) do
			TC.damage_groups[ group_name ] = mat_tool_data[ 'dmggp_'..group_name ] or group_rate
		end
	end
	
	if _TOOLCRAFTER_SETTING.add_hoe then
		--
		-- hoe
		--
		TOOL_CAPABILITIES.HOE = {
			uses = math.floor( ( 200 + 200 * mat_highest_level ) * rod_fix.duration )
		}
	end
	
	return TOOL_CAPABILITIES
end

local function tool_register( ROD_ID, MAT_ID, MAT_DESC, MAT_TEXTURE, MAT_DATA, ROD_DATA )
	local TOOL_CAPABILITIES = calculate_capabilities( MAT_DATA, ROD_DATA )
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		local KEY_UID			= tool_key:upper()
		local KEY_NAME			= _LILZUL._STR.head_upper(tool_key)
		
		local COM_ID			= MAT_ID:gsub(':','_')..'_'
		if minetest.registered_items[ ROD_ID ]._toolcrafter_material ~= nil then
			COM_ID				= COM_ID..ROD_ID:gsub(':','_')
		else
			COM_ID				= COM_ID..'group_stick'
		end
		local TOOL_ID			= ID_MOD..':_'..tool_key..'_'..COM_ID
		
		local TOOL_DESC			= ''
		if _TOOLCRAFTER_TOOLREDIRECT[ TOOL_ID ] ~= nil then
			TOOL_DESC			= minetest.registered_items[ _TOOLCRAFTER_TOOLREDIRECT[ TOOL_ID ] ].description
		else
			local ROD_DESC		= minetest.registered_items[ ROD_ID ].description
			local ROD_DESC_CUT	= ROD_DESC:find('\n') and ( ROD_DESC:find('\n') - 1 ) or nil
			ROD_DESC			= ROD_DESC:sub( 1, ROD_DESC_CUT )
			TOOL_DESC			= TS( KEY_NAME..' made by ' )..ROD_DESC..TS(' and ')..MAT_DESC
		end
		
		local TXT_ROD = minetest.registered_items[ ROD_ID ].inventory_image
		local TOOL_IMAGE		= TXT_ROD..'^('..MAT_TEXTURE..'^'.._TOOLCRAFTER_TX[ KEY_UID..'_MASK' ]..'^[mask:'.._TOOLCRAFTER_TX[ KEY_UID..'_PATTERN' ]..')'
		
		local TOOL_CAPABILITIE	= TOOL_CAPABILITIES[ KEY_UID ] or {}
		
		--[[ for debug print out
		if true then
			if ROD_DATA.rod then
			TOOL_DESC = TOOL_DESC .. '\n' .. 'rod_interval: ' .. (ROD_DATA.rod.interval or '-' )
			TOOL_DESC = TOOL_DESC .. '\n' .. 'rod_duration: ' .. (ROD_DATA.rod.duration or '-' )
			end
			TOOL_DESC = TOOL_DESC .. '\n' .. 'full_punch_interval: ' .. (TOOL_CAPABILITIE.full_punch_interval or '-' )
			TOOL_DESC = TOOL_DESC .. '\n' .. 'max_drop_level: ' .. (TOOL_CAPABILITIE.max_drop_level or '-' )
			if TOOL_CAPABILITIE.groupcaps ~= nil then
				TOOL_DESC = TOOL_DESC .. '\n' .. 't1: ' .. (TOOL_CAPABILITIE.groupcaps[ _TOOLCRAFTER_TOOLGROUP[tool_key] ].times[1] or '-')
				TOOL_DESC = TOOL_DESC .. '\n' .. 't2: ' .. (TOOL_CAPABILITIE.groupcaps[ _TOOLCRAFTER_TOOLGROUP[tool_key] ].times[2] or '-')
				TOOL_DESC = TOOL_DESC .. '\n' .. 't3: ' .. (TOOL_CAPABILITIE.groupcaps[ _TOOLCRAFTER_TOOLGROUP[tool_key] ].times[3] or '-')
				TOOL_DESC = TOOL_DESC .. '\n' .. 'uses: ' .. (TOOL_CAPABILITIE.groupcaps[ _TOOLCRAFTER_TOOLGROUP[tool_key] ].uses or '-' )
				TOOL_DESC = TOOL_DESC .. '\n' .. 'level: ' .. (TOOL_CAPABILITIE.groupcaps[ _TOOLCRAFTER_TOOLGROUP[tool_key] ].maxlevel or '-' )
			end
			if TOOL_CAPABILITIE.damage_groups ~= nil then
				TOOL_DESC = TOOL_DESC .. '\n' .. 'damage: ' .. (TOOL_CAPABILITIE.damage_groups.fleshy or '-' )
			end
		end
		--]]
		
		-- select method by checking have redirect or not
		if _TOOLCRAFTER_TOOLREDIRECT[ TOOL_ID ] ~= nil then
			local override_data = {}
			
			-- have redirect data but not keep graphic, swap image to new one
			if not _TOOLCRAFTER_SETTING.keep_graphic then
				override_data.inventory_image = TOOL_IMAGE
			end
			
			override_data.description = TOOL_DESC
			
			-- override old data and simple add alias to tool
			minetest.override_item( _TOOLCRAFTER_TOOLREDIRECT[ TOOL_ID ], override_data )
			minetest.register_alias( TOOL_ID, _TOOLCRAFTER_TOOLREDIRECT[ TOOL_ID ] )
		else
			local TOOL_GROUPS	= { [tool_key] = 1 }
			-- TODO: add flammable or other groups on some material
			
			if tool_key ~= 'hoe' then
				minetest.register_tool( TOOL_ID, {
					description = TOOL_DESC,
					inventory_image = TOOL_IMAGE,
					wield_scale = TOOL_SCALE,
					tool_capabilities = TOOL_CAPABILITIE,
					groups = TOOL_GROUPS,
					sound = { breaks = 'default_tool_breaks' }
				} )
			elseif _TOOLCRAFTER_SETTING.add_hoe then
				farming.register_hoe( TOOL_ID, {
					description = TOOL_DESC,
					inventory_image = TOOL_IMAGE,
					wield_scale = TOOL_SCALE,
					max_uses = TOOL_CAPABILITIE.uses,
					groups = TOOL_GROUPS,
					sound = { breaks = 'default_tool_breaks' }
				} )
			end
		end
	end
end

local function get_rod_data( ROD_ID )
	-- note: inside rod group but not assign any material should be added by group:stick
	return _TOOLCRAFTER_TOOLDATA[ minetest.registered_items[ ROD_ID ]._toolcrafter_material or 'group:stick' ] or {}
end
-- wood tool while not using variant
if not _TOOLCRAFTER_SETTING.wood_variant then
	for _, ROD_ID in ipairs( _TOOLCRAFTER_ITEMGROUP.ROD ) do
		-- given hard code tool cap
		tool_register( ROD_ID, 'group:wood', 'Wood', _TOOLCRAFTER_TX.TOOL..'_texture_wood.png', _TOOLCRAFTER_TOOLDATA['group:wood'] or {
			pickaxe = { droplevel=0, interval=1.4, maxlevel=0, uses = 10 },
			axe = { droplevel=0, interval=1.2, maxlevel=0, uses = 10 },
			shovel = { droplevel=0, interval=1.4, maxlevel=0, uses = 10 },
			sword = { droplevel=0, interval=1.0, maxlevel=0, uses = 20 },
		}, get_rod_data( ROD_ID ) )
	end
end
-- stone tool while not using variant
if not _TOOLCRAFTER_SETTING.stone_variant then
	for _, ROD_ID in ipairs( _TOOLCRAFTER_ITEMGROUP.ROD ) do
		-- given hard code tool cap
		tool_register( ROD_ID, 'group:stone', 'Stone', _TOOLCRAFTER_TX.TOOL..'_texture_stone.png', _TOOLCRAFTER_TOOLDATA['group:stone'] or {
			pickaxe = { droplevel=0, interval=3.0, maxlevel=1, uses = 20 },
			axe = { droplevel=0, interval=2.5, maxlevel=1, uses = 20 },
			shovel = { droplevel=0, interval=3.0, maxlevel=1, uses = 20 },
			sword = { droplevel=0, interval=2.0, maxlevel=1, uses = 40 },
		}, get_rod_data( ROD_ID ) )
	end
end
for _, MAT_ID in ipairs( _TOOLCRAFTER_ITEMGROUP.MAT ) do
	local wood_check = minetest.get_item_group( MAT_ID, _TOOLCRAFTER_ID._GROUP.wood ) == 0 or _TOOLCRAFTER_SETTING.wood_variant
	local stone_check = minetest.get_item_group( MAT_ID, _TOOLCRAFTER_ID._GROUP.stone ) == 0 or _TOOLCRAFTER_SETTING.stone_variant
	if wood_check and stone_check then
		for _, ROD_ID in ipairs( _TOOLCRAFTER_ITEMGROUP.ROD ) do
		
			local MAT_DESC = minetest.registered_items[ MAT_ID ].description
			local MAT_TEXTURE = _LILZUL._TXT.get_single_texture( MAT_ID )
			
			tool_register( ROD_ID, MAT_ID, MAT_DESC, MAT_TEXTURE, _TOOLCRAFTER_TOOLDATA[ MAT_ID ] or {}, get_rod_data( ROD_ID ) )
		end
	end
end
