local _VERSION = 20241004

_LILZUL._VEC = _LILZUL._VEC or {}
if _LILZUL._VERSION_CHECK( _LILZUL._VEC, _VERSION ) then
	local _SELF = _LILZUL._VEC
	
	local function is_ipos( vec ) return type(vec)=='table' and type(vec[1])=='number' and type(vec[2])=='number' and type(vec[3])=='number' end
	local function is_pos( vec ) return type(vec)=='table' and type(vec.x)=='number' and type(vec.y)=='number' and type(vec.z)=='number' end

	function _LILZUL._VEC.ipos_to_pos( vec ) return is_ipos(vec) and { x=vec[1], y=vec[2], z=vec[3] } or ( is_pos(vec) and vec or { x=0, y=0, z=0 } ) end
	function _LILZUL._VEC.pos_to_ipos( vec ) return is_pos(vec) and { vec.x, vec.y, vec.z } or ( is_ipos(vec) and vec or { 0, 0, 0 } ) end

	-- normal return -0.5 ~ 0.5
	function _LILZUL._VEC.random( mag )
		mag = _SELF.pos_to_ipos(mag) or {1}
		
		return vector.new( mag[1] * (math.random()-0.5), mag[2] * (math.random()-0.5), mag[3] * (math.random()-0.5) )
	end
end
