-- get MOD constant
local ID_MOD	= minetest.get_current_modname()
local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
local TS		= minetest.get_translator( ID_MOD )

--
-- add all tool group to id table with db.tool_status and bptool here
-- bc i14y can add new tool inside table
--
for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
	_TOOLCRAFTER_ID._DB[ tool_key ] = _TOOLCRAFTER_ID._DB.tool_status..tool_key..'_'
	_TOOLCRAFTER_ID._BPTOOL[ tool_key ] = _TOOLCRAFTER_ID._BP..tool_key
end

-- only search once or checked refresh setting todo recalculater
if _TOOLCRAFTER_SETTING.update or _TOOLCRAFTER_MOD_DB:get_int( 'flag_havedata' ) ~= 1 then

	--
	-- make special material list before run throw all item
	--
	_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.exc_material, _TOOLCRAFTER_SPECIALLIST, false )
	_LILZUL._STR.to_list( _TOOLCRAFTER_SETTING.inc_material, _TOOLCRAFTER_SPECIALLIST, true )
	_TOOLCRAFTER_SETTING.exc_material = nil
	_TOOLCRAFTER_SETTING.inc_material = nil
	
	dofile( PATH_MOD .. 'search_register.lua')
	dofile( PATH_MOD .. 'data_calculation.lua')

	--
	-- output list to DB
	--
	for group_id, item_list in pairs( _TOOLCRAFTER_ITEMGROUP ) do
		temp_str = ''
		for i, item_id in ipairs( item_list ) do
			temp_str = temp_str .. (i>1 and ', ' or '') .. item_id
		end
		_TOOLCRAFTER_MOD_DB:set_string( _TOOLCRAFTER_ID._DB[ group_id ], temp_str )
	end
	
	_TOOLCRAFTER_MOD_DB:set_int( _TOOLCRAFTER_ID._DB.dig_level, _TOOLCRAFTER_SETTING.max_dig_level )
	
	--
	-- end update data
	--
	_TOOLCRAFTER_MOD_DB:set_int( 'flag_havedata', 1 )
	_LILZUL._SET.set( ID_MOD, 'update', false, 'bool' )
	_LILZUL._SET.save()
else
	_TOOLCRAFTER_SETTING.exc_material = nil
	_TOOLCRAFTER_SETTING.inc_material = nil
	
	--
	-- read data from MOD DB (skip checking)
	--
	for group_id, _ in pairs( _TOOLCRAFTER_ITEMGROUP ) do
		_LILZUL._STR.to_list( _TOOLCRAFTER_MOD_DB:get_string( _TOOLCRAFTER_ID._DB[ group_id ] ), _TOOLCRAFTER_ITEMGROUP[ group_id ] )
	end
	_TOOLCRAFTER_SETTING.max_dig_level = _TOOLCRAFTER_MOD_DB:get_int( _TOOLCRAFTER_ID._DB.dig_level )
end

--
-- add group inside all target material
--
local group_id2name = {
	MAT = _TOOLCRAFTER_ID._GROUP.mat,
	ROD = _TOOLCRAFTER_ID._GROUP.rod,
}
for group_id, _ in pairs( _TOOLCRAFTER_ITEMGROUP ) do
	if group_id2name[ group_id ] ~= nil then
		for _, item_id in ipairs( _TOOLCRAFTER_ITEMGROUP[ group_id ] ) do
			minetest.registered_items[ item_id ].groups[ group_id2name[ group_id ] ] = 1
		end
	end
end
for _, item_id in ipairs( _TOOLCRAFTER_ITEMGROUP.WOOD ) do
	minetest.registered_items[ item_id ].groups[ _TOOLCRAFTER_ID._GROUP.wood ] = 1
end
for _, item_id in ipairs( _TOOLCRAFTER_ITEMGROUP.STONE ) do
	minetest.registered_items[ item_id ].groups[ _TOOLCRAFTER_ID._GROUP.stone ] = 1
end

--
-- read tool list and make up a texture list and remove them while option ON
--
local toolitem_list = {}
_LILZUL._STR.to_list( _TOOLCRAFTER_MOD_DB:get_string( _TOOLCRAFTER_ID._DB.tool_list ), toolitem_list )
for _, tool_item in ipairs( toolitem_list ) do
	local item_arg = _LILZUL._STR.split( tool_item, '=' )
	local tool_new_id = item_arg[1]
	local tool_id = item_arg[2]
	
	-- rebuild table while both is not nil
	if tool_new_id ~= nil and tool_id ~= nil then _TOOLCRAFTER_TOOLREDIRECT[ tool_new_id ] = tool_id end
	_LILZUL._REG.clear_recipe_with_output( tool_id )
end
toolitem_list = nil

--
-- read data of each material and handle tool on list, and make up a table for setting data
--
local function read_data( mat_id )
	_TOOLCRAFTER_TOOLDATA[ mat_id ] = {}
	for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
		--[[ data like this
			droplevel		= drop level
			interval		= punch interval
			maxlevel		= maxlevel
			uses			= uses * maxlevel
			times_1..3		= time / (max of 1 and lv df to 1)
			dmggp_[name]	= rating
		--]]
		local tool_statstr = _TOOLCRAFTER_MOD_DB:get_string( _TOOLCRAFTER_ID._DB[ tool_key ]..mat_id:gsub(':','_') )
		if tool_statstr ~= nil and #tool_statstr > 0 then
			local temp_list = _LILZUL._STR.to_list( tool_statstr )
			_TOOLCRAFTER_TOOLDATA[ mat_id ][ tool_key ] = {}
			for _, str_item in ipairs( temp_list ) do
				local temp_arg = _LILZUL._STR.split( str_item, '=' )
				_TOOLCRAFTER_TOOLDATA[ mat_id ][ tool_key ][ temp_arg[1] ] = tonumber( temp_arg[2] )
			end
		end
	end
	-- calculate rod data after set all tool data
	local temp_rod_data = {
		interval = 1,
		duration = 1,
	}
	
	if mat_id == 'group:stick' then
		temp_rod_data.interval = 0.5
		temp_rod_data.duration = 0.1
	else
		local rod_avg_ivl, rod_dev_ivl = 0, 0
		local rod_avg_dur, rod_dev_dur = 0, 0
		for tool_key, tool_data in pairs( _TOOLCRAFTER_TOOLDATA[ mat_id ] ) do
			if tool_key ~= 'hoe' then
				rod_avg_ivl = rod_avg_ivl + tool_data.interval
				rod_dev_ivl = rod_dev_ivl + 1
				rod_avg_dur = rod_avg_dur + tool_data.uses
				rod_dev_dur = rod_dev_dur + 20
			end
		end
		if rod_dev_ivl > 0 then temp_rod_data.interval = rod_avg_ivl / rod_dev_ivl end
		if rod_dev_dur > 0 then temp_rod_data.duration = rod_avg_dur / rod_dev_dur end
	end
	
	_TOOLCRAFTER_TOOLDATA[ mat_id ].rod = temp_rod_data
end
for _, mat_id in ipairs( _TOOLCRAFTER_ITEMGROUP.MAT ) do
	read_data( mat_id )
end
read_data( 'group:wood' )
read_data( 'group:stone' )
read_data( 'group:stick' )
