-- Note:
--   I plan to auto add recipe, but after thinking some scenario, I decide to add them by hand and not try to add them automatically

-- get MOD constant
local ID_MOD	= minetest.get_current_modname()
local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
local TS		= minetest.get_translator( ID_MOD )

--
-- a fake crafting recipe for tool
--
local TXT_ROD		= _TOOLCRAFTER_TX.ROD_PATTERN
local TXT_BPTOOL = {
	rod				= TXT_ROD,
	material		= _TOOLCRAFTER_TX.TOOL..'_pattern_mat.png',
}
for tool_key, _ in pairs( _TOOLCRAFTER_TOOLGROUP ) do
	if _TOOLCRAFTER_TX[ tool_key:upper()..'_PATTERN' ] ~= nil then
		TXT_BPTOOL[ tool_key ] = TXT_ROD..'^'.._TOOLCRAFTER_TX[ tool_key:upper()..'_PATTERN' ]
	end
end

for key, id in pairs( _TOOLCRAFTER_ID._BPTOOL ) do
	local pass_checking = true
	if key == 'hoe' and not _TOOLCRAFTER_SETTING.add_hoe then pass_checking = false end
	if pass_checking then
		minetest.register_craftitem( id, {
			description = TS( 'Blueprint '.._LILZUL._STR.head_upper(key) ),
			inventory_image = TXT_BPTOOL[key]..'^[multiply:#4772FF',
			groups = { [ _TOOLCRAFTER_ID._GROUP.blueprint ] = 1 }
		} )
	end
end

-- short form for recipe
local R_MAT = _TOOLCRAFTER_ID._BPTOOL.material
local R_ROD = _TOOLCRAFTER_ID._BPTOOL.rod

for tool_key, tool_recipe in pairs( _TOOLCRAFTER_TOOLRECIPE ) do
	if ( tool_key ~= 'rod' or _TOOLCRAFTER_SETTING.allow_rod ) and ( tool_key ~= 'hoe' or _TOOLCRAFTER_SETTING.add_hoe ) then
		local w = tool_recipe.shape and tool_recipe.shape[1] or 1
		local input_table = {}
		for y = 1, ( tool_recipe.shape and tool_recipe.shape[2] or 1 ) do
			table.insert( input_table, {} )
			for x = 1, w do
				local i = x + (y-1) * w
				if tool_recipe.input[i] == 'R' then
					table.insert( input_table[#input_table], R_ROD )
				elseif tool_recipe.input[i] == 'M' then
					table.insert( input_table[#input_table], R_MAT )
				else
					table.insert( input_table[#input_table], '' )
				end
			end
		end
		minetest.register_craft( {
			output = _TOOLCRAFTER_ID._BPTOOL[ tool_key ] .. ( tool_recipe.output ~= nil and ( ' '..tool_recipe.output ) or '' ),
			recipe = input_table
		} )
	end
end
