-- get MOD constant
local ID_MOD	= minetest.get_current_modname()
local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
local TS		= minetest.get_translator( ID_MOD )

--
-- crafting table for tool, craft stick/rod (only wood stick can craft by hand), than craft tool directly like typical hand craft
--
local ID_CRAFTTABLE			= ID_MOD..':toolcrafter'

local TXT_BG				= _TOOLCRAFTER_TX.CRAFTER..'_bg.png'
local TXT_ARROW				= _TOOLCRAFTER_TX.CRAFTER..'_arrow.png'
local TXT_TOP_MASK			= _TOOLCRAFTER_TX.CRAFTER..'_top_mask.png'
local TXT_BOTTOM_MASK		= _TOOLCRAFTER_TX.CRAFTER..'_bottom_mask.png'
local TXT_SIDE_MASK			= _TOOLCRAFTER_TX.CRAFTER..'_side_mask.png'

local INVLIST_SRC			= 'input'
local INVLIST_DST			= 'output'

local DESC_CRAFTTABLE		= TS('Tool Crafter')
local function apply_logger( def_ref ) return _LILZUL._LOG.log_set_inventory_action( def_ref, DESC_CRAFTTABLE ) end

-- user interface (formspecs)
local function get_formspec()
	local temp_formspec = 'size[8,8.5]'
	temp_formspec = temp_formspec .. 'image[0,0;10,2;'..TXT_BG..']' -- bg test
	temp_formspec = temp_formspec .. 'hypertext[6,0.25;4,1;TITLE;<big>'..DESC_CRAFTTABLE..'</big>]' -- bg test
	temp_formspec = temp_formspec .. 'list[context;'..INVLIST_SRC..';2,0.75;3,3;]'
	temp_formspec = temp_formspec .. 'image[5.1,1.75;1,1;'..TXT_ARROW..']'
	temp_formspec = temp_formspec .. 'list[context;'..INVLIST_DST..';6.25,1.75;1,1;]'
	
	temp_formspec = temp_formspec .. 'listring[context;'..INVLIST_DST..']'
	temp_formspec = temp_formspec .. 'listring[current_player;main]'
	temp_formspec = temp_formspec .. 'listring[context;'..INVLIST_SRC..']'
	temp_formspec = temp_formspec .. 'listring[current_player;main]'

	-- normal player inventory
	temp_formspec = temp_formspec .. _LILZUL._INV.player_inventory_formspecs( 0, 4.25 )

	return temp_formspec
end

local function recheck_recipe( node_pos )
	local rod_count, mat_count = {}, {}
	
	local meta = minetest.get_meta( node_pos )
	local inv = meta:get_inventory()
	local input_table = { method = 'normal', width = 3, items = {} }
	-- replace input item to blueprint for search recipe
	for idx = 1, 9 do
		local stack = inv:get_stack( INVLIST_SRC, idx )
		if stack:is_empty() then
			table.insert( input_table.items, '' )
		else
			if minetest.get_item_group( stack:get_name(), _TOOLCRAFTER_ID._GROUP.rod ) ~= 0 then
				table.insert( input_table.items, _TOOLCRAFTER_ID._BPTOOL.rod )
				rod_count[ stack:get_name() ] = ( rod_count[ stack:get_name() ] or 0 ) + 1
			elseif minetest.get_item_group( stack:get_name(), _TOOLCRAFTER_ID._GROUP.mat ) ~= 0 then
				table.insert( input_table.items, _TOOLCRAFTER_ID._BPTOOL.material )
				mat_count[ stack:get_name() ] = ( mat_count[ stack:get_name() ] or 0 ) + 1
			else
				table.insert( input_table.items, stack:get_name() )
			end
		end
	end
	
	local output, decremented_input = minetest.get_craft_result( input_table )
	local mix_mat_check = true
	local single_rod, single_mat = true, true
	for _, _ in pairs( rod_count ) do
		if single_rod then single_rod = false else mix_mat_check = false end
	end
	for _, _ in pairs( mat_count ) do
		if single_mat then single_mat = false else mix_mat_check = false end
	end
	if output ~= nil and not output.item:is_empty() and mix_mat_check and output.item:get_name():sub( 1, #_TOOLCRAFTER_ID._BP ) == _TOOLCRAFTER_ID._BP then
	
		-- caculate main material
		local main_rod, main_mat = nil, nil
		local max_count = 0
		for id, count in pairs( rod_count ) do
			if count > max_count then
				main_rod = id
				max_count = count
			end
		end
		max_count = 0
		for id, count in pairs( mat_count ) do
			if count > max_count then
				main_mat = id
				max_count = count
			end
		end
		
		-- replace wood and stone while not using variant
		if not _TOOLCRAFTER_SETTING.wood_variant and minetest.get_item_group( main_mat, _TOOLCRAFTER_ID._GROUP.wood ) ~= 0 then
			main_mat = 'group:wood'
		elseif not _TOOLCRAFTER_SETTING.stone_variant and minetest.get_item_group( main_mat, _TOOLCRAFTER_ID._GROUP.stone ) ~= 0 then
			main_mat = 'group:stone'
		end
		
		-- replace stick in rod
		if main_rod ~= nil and minetest.registered_items[ main_rod ]._toolcrafter_material == nil then
			main_rod = 'group:stick'
		end
		
		local COM_ID = main_mat:gsub(':','_')..( main_rod and ( '_'..main_rod:gsub(':','_') ) or '' )
		local TOOLTYPE_ID = output.item:get_name():sub( 1+#_TOOLCRAFTER_ID._BP )
		local RESULT_ID = ID_MOD .. ':_' .. TOOLTYPE_ID .. '_' .. COM_ID
		_LILZUL._INV.replace_item( inv, INVLIST_DST, 1, RESULT_ID, output.item:get_count() )
		-- set recipe cost
		for idx, replace_stack in ipairs( decremented_input.items ) do
			if replace_stack:is_empty() and not inv:get_stack( INVLIST_SRC, idx ):is_empty() then
				meta:set_int( 'cost'..idx, 1 )
			else
				meta:set_int( 'cost'..idx, 0 )
			end
		end
	else
		-- empty result, clean item on DST
		_LILZUL._INV.remove_item( inv, INVLIST_DST, 1 )
		for idx = 1, 9 do
			meta:set_int( 'cost'..idx, 0 )
		end
	end
end

--
-- event function to check who and what put into furnace inventory
-- 
local function allow_metadata_inventory_put( node_pos, invlist, idx, stack, player )
	-- reject protected
	if minetest.is_protected( node_pos, player:get_player_name() ) then return 0 end
	if invlist == INVLIST_SRC then
		-- you can put anything here, but only matched item have result
		return stack:get_count()
	elseif invlist == INVLIST_DST then
		-- reject on put anything into output slot
		return 0
	end
end
local function allow_metadata_inventory_move( node_pos, from_invlist, from_idx, to_invlist, to_idx, count, player )
	local inv = minetest.get_meta( node_pos ):get_inventory()
	local stack = inv:get_stack( from_invlist, from_idx )
	return allow_metadata_inventory_put( node_pos, to_invlist, to_idx, stack, player )
end
local function allow_metadata_inventory_take( node_pos, invlist, idx, stack, player )
	-- reject protected
	if minetest.is_protected( node_pos, player:get_player_name() ) then return 0 end
	-- no limit to take
	return stack:get_count()
end
local function on_metadata_inventory_take( node_pos, invlist, idx, stack, player)
	local inv = minetest.get_meta( node_pos ):get_inventory()
	if invlist == INVLIST_DST then
		local meta = minetest.get_meta( node_pos )
		local inv = meta:get_inventory()
		for i = 1, 9 do
			local temp_cost = meta:get_int( 'cost'..i )
			if temp_cost > 0 then
				_LILZUL._INV.modify_item_amount( inv, INVLIST_SRC, i, -temp_cost )
			end
		end
	end
	recheck_recipe( node_pos )
end

-- drop inventory item while destory
local function drop_inventory( node_pos )
	_LILZUL._INV.drop_inventory( node_pos, INVLIST_SRC )
end
-- inventory item only survive while blast with low intensity
local function check_blast_damage( node_pos, intensity )
	if tonumber(intensity) < 1.5 then
		drop_inventory( node_pos )
	else
		minetest.remove_node( node_pos )
	end
end

--
-- register all material variation later, now use wood as sample
--
local function register_crafter( NODE_ID, NODE_DESC, NODE_TILES )
	minetest.register_node( NODE_ID, apply_logger( {
		description = NODE_DESC,
		tiles = NODE_TILES,
		paramtype2 = 'facedir',
		drawtype = 'nodebox',
		node_box = {
			type = 'fixed',
			fixed = {
				{-0.5, -0.3, -0.5, 0.5, 0.5, 0.5},
				{-0.5, -0.5, -0.5, -0.2, -0.3, -0.2},
				{0.2, -0.5, -0.5, 0.5, -0.3, -0.2},
				{-0.5, -0.5, 0.2, -0.2, -0.3, 0.5},
				{0.2, -0.5, 0.2, 0.5, -0.3, 0.5},
			},
		},
		groups = { choppy=2 },
		is_ground_content = false,
		
		sound = {
			footstep	= { name = 'default_wood_footstep', gain = 0.15 },
			dig			= { name = 'default_dig_choppy', gain = 0.4 },
			dug			= { name = 'default_wood_footstep', gain = 1.0 },
			place		= { name = 'default_place_node_hard', gain = 1.0 }
		},

		can_dig = function(...) return true end,
		drop = NODE_ID,
		on_destruct = drop_inventory,
		on_blast = check_blast_damage,

		on_construct = function( node_pos )
			local meta = minetest.get_meta( node_pos )
			meta:set_string( 'formspec', get_formspec() )
			for idx = 1, 9 do
				meta:set_int( 'craft_cost'..idx, 0 )
			end
			local inv = meta:get_inventory()
			inv:set_size( INVLIST_SRC, 9 )
			inv:set_size( INVLIST_DST, 1 )
		end,

		on_metadata_inventory_put = recheck_recipe,
		on_metadata_inventory_move = recheck_recipe,
		on_metadata_inventory_take = on_metadata_inventory_take,
		allow_metadata_inventory_put = allow_metadata_inventory_put,
		allow_metadata_inventory_move = allow_metadata_inventory_move,
		allow_metadata_inventory_take = allow_metadata_inventory_take,
	} ) )
end
if _TOOLCRAFTER_SETTING.table_variant then
	for _, mat_id in ipairs( _TOOLCRAFTER_ITEMGROUP.WOOD ) do
		local MIX_TILES = _LILZUL._TXT.mix_tiles(
			_LILZUL._TXT.get_tiles( mat_id ),
			'[contrast:-32:8',
			{ TXT_TOP_MASK, TXT_BOTTOM_MASK, TXT_SIDE_MASK, TXT_SIDE_MASK, TXT_SIDE_MASK, TXT_SIDE_MASK }
		)
		local ID_IDV			= '_'..mat_id:gsub(':','_')
		register_crafter( ID_CRAFTTABLE..ID_IDV, DESC_CRAFTTABLE..' ('..minetest.registered_items[ mat_id ].description..')', MIX_TILES )
		minetest.register_craft( {
			output = ID_CRAFTTABLE..ID_IDV,
			recipe = {
				{ mat_id, mat_id, mat_id },
				{ mat_id, mat_id, mat_id },
				{ mat_id, '', mat_id }
			}
		} )
	end
else
	local MIX_TILES = _LILZUL._TXT.mix_tiles(
		_TOOLCRAFTER_TX.TOOL..'_texture_wood.png',
		'[contrast:-32:8',
		{ TXT_TOP_MASK, TXT_BOTTOM_MASK, TXT_SIDE_MASK, TXT_SIDE_MASK, TXT_SIDE_MASK, TXT_SIDE_MASK }
	)
	register_crafter( ID_CRAFTTABLE, DESC_CRAFTTABLE, MIX_TILES )
	local mat_id = 'group:wood'
	minetest.register_craft( {
		output = ID_CRAFTTABLE,
		recipe = {
			{ mat_id, mat_id, mat_id },
			{ mat_id, mat_id, mat_id },
			{ mat_id, '', mat_id }
		}
	} )
end
