local _VERSION = 20241004

_LILZUL._INV = _LILZUL._INV or {}
if _LILZUL._VERSION_CHECK( _LILZUL._INV, _VERSION ) then
	local _SELF = _LILZUL._INV

	local function random_vec() return _LILZUL._VEC.random({1,0,1}) end

	function _LILZUL._INV.drop_item( node_pos, item_id, amount, fast )
		amount = amount or 1
		
		if fast then
			minetest.add_item( vector.add( node_pos, random_vec() ), item_id..' '..amount )
		else
			for _= 1, amount do
				minetest.add_item( vector.add( node_pos, random_vec() ), item_id )
			end
		end
	end

	function _LILZUL._INV.drop_inventory( node_pos, invlist_name, fast )
		local inv = minetest.get_meta( node_pos ):get_inventory()
		for i = 1, inv:get_size( invlist_name ) do
			local stack = inv:get_stack( invlist_name, i )
			if stack:get_count() > 0 then
				_SELF.drop_item( node_pos, stack:get_name(), stack:get_count(), fast )
			end
		end
	end

	-- try add to digger inventory or fail to pop on node pos
	function _LILZUL._INV.addto_inventory( node_pos, digger_obj, item_id, amount )
		amount = amount or 1
		
		local digger_inv = digger_obj:get_inventory()
		if digger_inv ~= nil then
			local stack = ItemStack( item_id..' '..amount )
			if digger_inv:room_for_item( 'main', stack ) then
				digger_inv:add_item( 'main', stack )
				return true
			end
		end
		
		-- no return before this line = fail to get
		_SELF.drop_item( node_pos, item_id )
	end

	function _LILZUL._INV.remove_item( inv_ref, invlist, idx )		
		local stack = inv_ref:get_stack( invlist, idx )
		stack:clear()
		inv_ref:set_stack( invlist, idx, stack )
	end

	function _LILZUL._INV.replace_item( inv_ref, invlist, idx, item_name, amount )
		amount = amount or 1
		
		local stack = inv_ref:get_stack( invlist, idx )
		stack:replace( item_name )
		stack:set_count( amount )
		inv_ref:set_stack( invlist, idx, stack )
	end

	function _LILZUL._INV.modify_item_amount( inv_ref, invlist, idx, amount )
		amount = amount or 1
		
		local stack = inv_ref:get_stack( invlist, idx )
		stack:set_count( stack:get_count() + amount )
		inv_ref:set_stack( invlist, idx, stack )
	end

	function _LILZUL._INV.player_inventory_formspecs( x, y )
		local temp_formspec = ''
		if minetest.get_modpath( 'default' ) then
			temp_formspec = temp_formspec .. 'list[current_player;main;'..x..','..y..';8,1;]'
			temp_formspec = temp_formspec .. 'list[current_player;main;'..x..','..(y+1.25)..';8,3;8]'
		else
			temp_formspec = temp_formspec .. 'list[current_player;main;'..x..','..y..';8,3;8]'
			temp_formspec = temp_formspec .. 'list[current_player;main;'..x..','..(y+3.25)..';8,1;]'
		end
		return temp_formspec
	end
end
