local _VERSION = 20241004

_LILZUL._TXT = _LILZUL._TXT or {}
if _LILZUL._VERSION_CHECK( _LILZUL._TXT, _VERSION ) then
	local _SELF = _LILZUL._TXT
	
	-- const
	local DEFAULT_EXT	= 'png'

	function _LILZUL._TXT.get_folder_path( ID_MOD )
		local PATH_MOD	= minetest.get_modpath( ID_MOD ) .. DIR_DELIM
		return PATH_MOD .. 'textures' .. DIR_DELIM
	end

	function _LILZUL._TXT.is_exit( folder_path, name, ext )
		ext = ext or DEFAULT_EXT
		
		return io.open( folder_path..name..'.'..ext )
	end

	function _LILZUL._TXT.get_name( folder_path, name_base, name_idv, ext )
		ext = ext or DEFAULT_EXT
		
		if _SELF.is_exit( folder_path, name_base..'_'..name_idv, ext ) then
			return name_base..'_'..name_idv..'.'..ext
		else
			return name_base..'.'..ext
		end
	end

	function _LILZUL._TXT.get_single_image( item_id )
		if minetest.registered_items[ item_id ] then
			if minetest.registered_items[ item_id ].tiles then
				for _, v in ipairs( minetest.registered_items[ item_id ].tiles ) do
					if type(v) == 'string' then
						return v
					elseif type(v.name) == 'string' then
						return v.name
					end
				end
			elseif minetest.registered_items[ item_id ] ~= nil then
				if minetest.registered_items[ item_id ].inventory_image then
					return minetest.registered_items[ item_id ].inventory_image
				end
			end
		else
			return ''
		end
	end

	function _LILZUL._TXT.get_single_texture( item_id )
		local result_texture_name = _SELF.get_single_image( item_id )
		if type(result_texture_name) ~= 'string' then return '' end
		local i,j = result_texture_name:find( '%^' )
		if i and j and j >= i and i > 0 then
			result_texture_name = result_texture_name:sub( 1, j-1 )
		end
		return result_texture_name
	end

	function _LILZUL._TXT.get_tiles( item_id )
		if minetest.registered_nodes[ item_id ] ~= nil then
			return minetest.registered_items[ item_id ].tiles
		else
			return { _SELF.get_single_texture( item_id ) }
		end
	end

	function _LILZUL._TXT.mix_tiles( ... )
		local INPUT_TILES = {...}
		local RESULT_TILES = {}
		for i = 1, 6 do
			RESULT_TILES[i] = ''
			for ti, TILES in ipairs( INPUT_TILES ) do
				if ti > 1 then RESULT_TILES[i] = RESULT_TILES[i] .. '^' end
				if type( TILES ) == 'string' then
					RESULT_TILES[i] = RESULT_TILES[i] .. TILES
				elseif type( TILES ) == 'table' then
					local TILES_TEXTURE = TILES[ 1 + ( (i-1) % #TILES ) ]
					if type( TILES_TEXTURE ) == 'string' then
						RESULT_TILES[i] = RESULT_TILES[i] .. TILES_TEXTURE
					elseif type( TILES_TEXTURE.name ) == 'string' then
						RESULT_TILES[i] = RESULT_TILES[i] .. TILES_TEXTURE.name
					end
				end
			end
		end
		return RESULT_TILES
	end
end
