local _VERSION = 20241005

_LILZUL._LOG = _LILZUL._LOG or {}
if _LILZUL._VERSION_CHECK( _LILZUL._LOG, _VERSION ) then
	local _SELF = _LILZUL._LOG
	
	local function get_table_str( arg )
		local result_str = ''
		if type(arg) == 'table' then
			for k,v in pairs(arg) do
				result_str = result_str..(#result_str>0 and ', ' or '')
				if type(v) == 'table' then
					result_str = result_str..k..'='..get_table_str(v)
				else
					result_str = result_str..k..'='..v
				end
			end
		end
		return result_str
	end

	local function is_player( arg ) return type(arg) == 'userdata' and arg:is_valid() and arg:is_player() end
	local function is_pos( arg ) return type(arg) == 'table' and type(arg.x) == 'number' and type(arg.y) == 'number' and type(arg.z) == 'number' end

	-- function to convert arg to string or empty string to avoid error
	function _LILZUL._LOG.convert( ... )
		local msg = ''
		for _, arg in ipairs({...}) do
			local arg_log = ''
			if type(arg) == 'string' or type(arg) == 'number' then
				arg_log = arg
			elseif type(arg) == 'boolean' then
				arg_log = arg and 'True' or 'False'
			elseif is_pos(arg) then
				arg_log = minetest.pos_to_string(arg)
			elseif type(arg) == 'table' then
				arg_log = get_table_str(arg)
			elseif is_player(arg) then
				arg_log = arg:get_player_name()
			end
			msg = msg..' '..arg_log
		end
		minetest.log( 'action',  msg )
	end

	local nop = function() end
	function _LILZUL._LOG.log_set_inventory_action(def, name)

		local on_move = def.on_metadata_inventory_move or nop
		def.on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
			_SELF.convert( player, "moves stuff in", name, "at", pos)
			return on_move(pos, from_list, from_index, to_list, to_index, count, player)
		end
		
		local on_put = def.on_metadata_inventory_put or nop
		def.on_metadata_inventory_put = function(pos, listname, index, stack, player)
			_SELF.convert( player, "moves", stack:get_name(), stack:get_count(), "to", name, "at", pos)
			return on_put(pos, listname, index, stack, player)
		end
		
		local on_take = def.on_metadata_inventory_take or nop
		def.on_metadata_inventory_take = function(pos, listname, index, stack, player)
			_SELF.convert( player, "takes", stack:get_name(), stack:get_count(), "from", name, "at", pos)
			return on_take(pos, listname, index, stack, player)
		end
		
		return def
	end
end
