local _VERSION = 20241004

_LILZUL._SET = _LILZUL._SET or {}
if _LILZUL._VERSION_CHECK( _LILZUL._SET, _VERSION ) then
	local _SELF = _LILZUL._SET
	
	function _LILZUL._SET.has( ID_MOD, key )
		return minetest.settings:has( ID_MOD..KEY )
	end

	function _LILZUL._SET.get( ID_MOD, key, value_type, default_value )
		value_type = type(value_type) == 'string' and value_type:lower() or ''
		
		if value_type == 'bool' then
			return minetest.settings:get_bool( ID_MOD..'_'..key, default_value )
		elseif value_type == 'noiseparams' then
			return minetest.settings:get_np_group( ID_MOD..'_'..key ) or default_value
		elseif value_type == 'flags' then
			return minetest.settings:get_flags( ID_MOD..'_'..key ) or default_value
		elseif value_type == 'int' then
			return math.floor( minetest.settings:get( ID_MOD..'_'..key ) or default_value )
		elseif value_type == 'float' then
			return tonumber( minetest.settings:get( ID_MOD..'_'..key ) or default_value )
		else
			return minetest.settings:get( ID_MOD..'_'..key ) or default_value
		end
	end

	function _LILZUL._SET.set( ID_MOD, key, value, value_type )
		value_type = type(value_type) == 'string' and value_type:lower() or ''
		
		if value_type == 'bool' then
			return minetest.settings:set_bool( ID_MOD..'_'..key, value )
		elseif value_type == 'noiseparams' then
			return minetest.settings:set_np_group( ID_MOD..'_'..key, value )
		elseif value_type == 'flags' then
			return minetest.settings:set_flags( ID_MOD..'_'..key, value )
		else
			return minetest.settings:set( ID_MOD..'_'..key, value )
		end
	end

	function _LILZUL._SET.save()
		return minetest.settings:write()
	end

	function _LILZUL._SET.keys()
		return minetest.settings:get_names()
	end

	function _LILZUL._SET.get_table()
		return minetest.settings:to_table()
	end

	function _LILZUL._SET.log()
		for k,v in pairs(minetest.settings:to_table()) do
			minetest.log( k .. ' ' .. type(v) )
		end
	end
end
