player_style.skins = {
	type0={},	--males & females
	type1={},	--males	
	type2={},	--females
	type3={},	--other
	skins={
		{name="ASDASD",type=1,skin="character.png",cost=0,info="Default character, random made npc from aliveai",origin="Aliveai"},
		{name="Dacy",type=2,skin="player_style_dacy.png",cost=0,info="Another default character, random made npc from aliveai",origin="Aliveai"},
		{name="Villager",type=1,skin="examobs_villager.png",cost=100,info="Just another fool",origin="XaEnvironment"},
		{name="Villager girl",type=2,skin="examobs_villagergirl.png",cost=100,info="Yes",origin="XaEnvironment"},
		{name="Spacesuit",type=3,skin="spacestuff_spacesuit2.png",cost=200,info="Suit used to protect against non breathable areas",origin="Marssurvive"},
		{name="Jamie",type=1,skin="player_style_jamie.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Rainybowie",type=1,skin="player_style_rainybowie.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Hej",type=1,skin="player_style_hej.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="James",type=1,skin="player_style_james.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Danny",type=1,skin="player_style_danny.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Jack",type=1,skin="player_style_jack.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Bugy",type=1,skin="player_style_bugy.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Litle boy",type=1,skin="player_style_litleboy.png",cost=200,info="Litle boy npc from aliveai",origin="Aliveai"},
		{name="Litle girl",type=2,skin="player_style_litlegirl.png",cost=200,info="Litle girl npc from aliveai",origin="Aliveai"},
		{name="Military",type=1,skin="player_style_military.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Sneaky",type=1,skin="player_style_sneaky.png",cost=200,info="Light shade stealing npc from aliveai",origin="Aliveai"},
		{name="Stubborn",type=1,skin="player_style_stubborn.png",cost=200,info="Stubborn half npc from aliveai",origin="Aliveai"},
		{name="Admin",type=1,skin="player_style_admin.png",cost=200,info="Admin npc from aliveai",origin="Aliveai"},
		{name="Police",type=1,skin="player_style_police.png",cost=500,info="Pilice officer npc",origin="XaEnvironment"},
		{name="Old Dan",type=1,skin="player_style_old_dan.png",cost=200,info="Random npc from aliveai",origin="Aliveai"},
		{name="Trader",type=2,skin="player_style_trader.png",cost=200,info="Trader npc from aliveai",origin="Aliveai"},
		{name="Clown",type=1,skin="player_style_clown.png",cost=200,info="The juggling clown npc from aliveai",origin="Aliveai"},
		{name="Sporty",type=1,skin="player_style_sporty.png",cost=200,info="",origin="Aliveai"},
		{name="Dum",type=1,type=1,skin="player_style_dum.png",cost=200,info="Alone survival npc",origin="Aliveai"},
		{name="Jezy",type=1,skin="player_style_jezy.png",cost=200,info="Alone survival npc",origin="Aliveai"},
		{name="Mrs tree",type=2,skin="player_style_mrs_tree.png",cost=200,info="Random npc",origin="XaEnvironment"},
		{name="Nyon girl",type=2,skin="player_style_nyongirl.png",cost=200,info="Random npc",origin="XaEnvironment"},
		{name="Sporty girl",type=2,skin="player_style_sportygirl.png",cost=200,info="Random npc",origin="XaEnvironment"},
		{name="Tomato NPC",type=3,skin="examobs_tomato_npc.png",cost=500,info="Tomato farmer that is farming its own family",origin="XaEnvironment"},
		{name="Underground npc",type=3,skin="examobs_underground_npc.png",cost=300,info="An underground living thing",origin="XaEnvironment"},
		{name="Diplazer bot",type=3,skin="player_style_diplazerbot.png",cost=200,info="The diplazer service bot",origin="diplazer"},

		{name="Terminator",type=3,skin="examobs_terminator.png",cost=2000,info="Destruction machine",origin="Aliveai"},
		{name="Bronze terminator",type=3,skin="player_style_terminator_bronze.png",cost=200,info="Murder machine",origin="Aliveai"},
		{name="Eletric terminator",type=3,skin="player_style_eletric_terminator.png",cost=200,info="War machine",origin="Aliveai"},
		{name="Fast eleltric Terminator",type=3,skin="player_style_eletric_terminator.png^[colorize:#00ff0033",cost=200,info="War machine",origin="Aliveai"},
		{name="Lightning terminator",type=3,skin="player_style_eletric_terminator.png^[colorize:#fa7fff44",cost=200,info="War machine",origin="Aliveai"},
		{name="Terminator police",type=3,skin="player_style_terminator_police.png",cost=200,info="Police machine",origin="XaEnvironment"},

		{name="Gassman",type=3,skin="examobs_gassman.png",cost=500,info="High explosive machine",origin="Pollution"},
		{name="Acid axov",type=3,skin="examobs_gassman.png^[colorize:#00dd00cc",cost=500,info="Acid machine",origin="Pollution"},
		{name="Uranium axov",type=3,skin="examobs_gassman.png^[colorize:#aaff00aa",cost=500,info="Uranium machine",origin="Pollution"},
		{name="Crystal axov",type=3,skin="player_style_pollutioncrystal.png",cost=500,info="Crystal machine",origin="Pollution"},
		{name="Ice axov",type=3,skin="player_style_pollutionice.png",cost=500,info="Nitrogen machine",origin="Pollution"},

		{name="Acidman",type=3,skin="player_style_acidman.png",cost=200,info="Acid machine",origin="Aliveai"},
		{name="Negative gassman",type=3,skin="player_style_negativegassman.png",cost=200,info="Came to life through a dream",origin="Aliveai"},
		{name="Uranium",type=3,skin="player_style_uranium.png",cost=1000,info="Massdestruction machine",origin="Aliveai"},
		{name="Nuker",type=3,skin="player_style_nuker.png",cost=200,info="Massdestruction machine",origin="Aliveai"},
		{name="Blackhole bot",type=3,skin="player_style_blackholebot.png",cost=200,info="Massdestruction machine",origin="Aliveai"},
		{name="Nitrogen bomb",type=3,skin="player_style_nitrogenbomb.png",cost=200,info="Nitrogen bomb",origin="Aliveai"},
		{name="Nitrogen",type=3,skin="player_style_nitrogen.png",cost=200,info="Nitrogen monster",origin="Aliveai"},

		{name="Air monster",type=3,skin="examobs_airmonster.png",cost=2000,info="Odd phenomenon",origin="XaEnvironment"},
		{name="Mummy",type=3,skin="pyramids_mummy.png",cost=1000,info="Living in ancient pyramids civilizations",origin="Aliveai"},
		{name="Slime",type=3,skin="player_style_slime.png",cost=400,info="Slime monster",origin="Aliveai"},
		{name="Pull",type=3,skin="player_style_pull.png",cost=400,info="Pull monster",origin="Aliveai"},
		{name="Storm",type=3,skin="player_style_storm.png",cost=500,info="Storm",origin="Aliveai"},
		{name="Ninja",type=3,skin="player_style_ninja.png",cost=500,info="Invisible ninja",origin="Aliveai"},
		{name="UjE",type=3,skin="player_style_uje.png",cost=1000,info="AiTechEye's first skin for minetest"},

		{name="Quantum",type=3,skin="player_style_quantum_monster.png",cost=1000,info="Teleporting monster\nRight click to random teleport yourself",origin="Aliveai",
			on_step=function(self,player,dtime)
				self.timer = self.timer + dtime
				if self.timer > 0.1 then
					self.timer = 0
					local p=apos(player:get_pos(),0,1)
					minetest.add_particlespawner({
						amount = 20,
						time =1,
						minpos = {x=p.x+1,y=p.y+1,z=p.z+1},
						maxpos = {x=p.x-1,y=p.y-1,z=p.z-1},
						minvel = {x=0, y=0, z=0},
						maxvel = {x=0, y=0, z=0},
						minacc = {x=0, y=0, z=0},
						maxacc = {x=0, y=0, z=0},
						minexptime = 0.5,
						maxexptime = 1,
						minsize = 0.4,
						maxsize = 0.8,
						glow=13,
						texture = "player_style_quantum_monster_lights.png",
					})
				end
			end,
			on_stop_using=function(self,player)
				default.hand_on_secondary_use[player:get_player_name().."-Quantum-skin"]  = nil
			end,
			on_use_join=function(self,player)
				self.timer = 0
				default.hand_on_secondary_use[player:get_player_name().."-Quantum-skin"] = function(itemstack,user,pointed_thing)
					local pos = vector.round(user:get_pos())
					local name = user:get_player_name()
					local a = {}
					for i=0,100 do
						local pos2 = apos(pos,math.random(-15,15),math.random(-15,15),math.random(-15,15))
						if (default.defpos(pos2,"walkable") or ((default.defpos(pos2,"liquid_viscosity") or 0)) > 0) and not default.defpos(apos(pos2,0,1),"walkable") and not default.defpos(apos(pos2,0,2),"walkable") and not minetest.is_protected(pos2,name) then
							user:set_pos(apos(pos2,0,1))
							player_style.hunger(player,-1)
							return
						end
					end
				end
			end,
		},
		{name="Snowman",type=3,skin="player_style_snowman.png",cost=1000,info="Just a snowman\nIt thrive in snow\nRight click to throw snowballs",origin="XaEnvironment",
			on_stop_using=function(self,player)
				default.hand_on_secondary_use[player:get_player_name().."-Snowman-skin"]  = nil
				if self.hat and self.hat:get_luaentity() then
					self.hat:remove()
				end
			end,
			on_use_join=function(self,player)
				self.timer = 0
				minetest.after(0,function(self,player)
					self.hat = minetest.add_entity(player:get_pos(),"default:wielditem")
					self.hat:set_attach(player, "head",{x=0, y=7, z=0}, {x=0, y=0,z=0})
					self.hat:set_properties({textures={"examobs:hat"},visual_size = {x=0.5,y=0.5,z=0.5}})
				end,self,player)
				default.hand_on_secondary_use[player:get_player_name().."-Snowman-skin"] = function(itemstack,user,pointed_thing)
					local item = ItemStack("default:bow_wood_loaded")
					local meta = item:get_meta()
					meta:set_string("arrow","examobs:arrow_snowball")
					meta:set_string("shots",1)
					bows.shoot(item, user,nil,function(item)
						item:remove()
					end)
					player_style.thirst(user,-0.1)
				end
			end,
			on_step=function(self,player,dtime)
				self.timer = self.timer + dtime
				if self.timer > 1 then
					self.timer = 0
					local pos = player:get_pos()
					if minetest.get_item_group(minetest.get_node(apos(pos,0,-1)).name,"snowy") > 0 then
						player_style.hunger(player,1)
						player_style.thirst(player,1)
						player:set_hp(player:get_hp()+1)
					else
						player_style.hunger(player,-0,1)
						player_style.thirst(player,-0.1)
					end
				end
			end,
		},
		{name="Slimy",type=3,skin="player_style_alienslimy.png",cost=200,info="Alien from mars",origin="Marssurvive"},
		{name="Glitch",type=3,skin="player_style_alienglitch.png",cost=200,info="Alien from mars",origin="Marssurvive",
			on_step=function(self,player,dtime)
				self.timer = self.timer + dtime
				if self.timer > 0.5 then
					self.timer = math.random(0,10)*0.05
					local rgb = math.random(0,10)
					player_style.update_player_skin(player,"player_style_alienglitch.png^[transform"..self.t[math.random(1,8)]..(rgb > 0 and "^[invert:"..self.r[rgb] or ""))
				end
			end,
			on_use_join=function(self,player)
				self.timer = 0
				self.t = {"I","R90","R180","R270","FX","FXR90","FY","FYR90"}
				self.r = {"r","g","b","a","rb","gr","gb","br","bg","rgb"}
			end,
		},
		{name="Alien1",type=3,skin="player_style_alien1.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien2",type=3,skin="player_style_alien2.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien3",type=3,skin="player_style_alien3.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien4",type=3,skin="player_style_alien4.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien5",type=3,skin="player_style_alien5.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien6",type=3,skin="player_style_alien6.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien7",type=3,skin="player_style_alien7.png",cost=200,info="Alien from space",origin="Aliveai"},
		{name="Alien8",type=3,skin="player_style_alien8.png",cost=200,info="Alien from space",origin="Aliveai"},
	},
}

player_style.random_skin_type=function(typ)
	local a = player_style.skins["type"..typ]
	return a[math.random(1,#a)]
end

minetest.register_on_mods_loaded(function(player)
	for i,v in ipairs(player_style.skins.skins) do
		table.insert(player_style.skins["type"..v.type],v.skin)
		if v.type < 3 then
			table.insert(player_style.skins.type0,v.skin)
		end
	end
end)

player_style.register_button({
	name="Skins",
	image="character.png",
	type="image",
	info="Change or buy skins",
	action=function(player)
		player_style.skins.store(player)
	end
})

player_style.register_skin=function(def)
	if not def.name then
		minetest.log("warning","Register skin is unamed")
		return
	elseif not def.skin then
		minetest.log("warning","Register skin"..def.name.." skin is missing skin texture")
		return
	end
	def.cost = def.cost or 0
	def.info = def.info or ""
	def.origin = def.origin or minetest.get_current_modname()
	table.insert(player_style.skins.skins,def)
end

player_style.get_player_skin=function(player)
	local skin = player:get_meta():get_string("skin")
	return skin ~= "" and skin or "charcacter.png"
end

player_style.get_current_player_skin=function(player)
	return player:get_properties().textures[1]
end

player_style.add_player_skin=function(player,texture,level)
	if texture == "" then
		return
	end
	local skin = player:get_meta():get_string("skin")
	local p = player_style.players[player:get_player_name()].skin
	p[level] = p[level] or {}
	table.insert(p[level],texture)


	for i,v in pairs(p) do
		for i2,v2 in ipairs(v) do
			skin = skin .."^"..v2
		end
	end
	local textures = player:get_properties().textures
	textures[1] = skin
	player:set_properties({textures=textures})
	player_style.inventory(player)
end

player_style.remove_player_skin=function(player,texture,level)
	if texture == "" then
		return
	end
	local skin = player:get_meta():get_string("skin")
	local p = player_style.players[player:get_player_name()].skin
	if p[level] then
		for i,v in pairs(p) do
			for i2,v2 in pairs(v) do
				if v2 == texture then
					p[level][i2] = nil
				else
					skin = skin .."^"..v2
				end
			end
		end
	end
	local textures = player:get_properties().textures
	textures[1] = skin
	player:set_properties({textures=textures})
	player_style.inventory(player)
end

player_style.update_player_skin=function(player,newskin)
	local skin = newskin or player:get_meta():get_string("skin")
	local p = player_style.players[player:get_player_name()].skin
	for i,v in pairs(p) do
		for i2,v2 in ipairs(v) do
			skin = skin .."^"..v2
		end
	end
	local textures = player:get_properties().textures
	textures[1] = skin
	player:set_properties({textures=textures})
	player_style.inventory(player)
end

player_style.skins.store=function(player,scroll)
	local text = ""
	local m = player:get_meta()
	local skin = m:get_string("skin")
	local own = minetest.deserialize(m:get_string("skins")) or {}
	local y = 0

	local achskins = m:get_int("exaachievements_artist")
	if achskins == 0 then
		for i,v in pairs(own) do
			achskins = achskins +1
		end
		m:set_int("exaachievements_artist",achskins-1)
		exaachievements.customize(player,"artist")
	end

	for i,v in ipairs(player_style.skins.skins) do
		local functional = (v.on_step or v.on_use or v.on_join or v.on_stop_using or v.on_use_join)

		text = text
		.."label[2,"..y..";"..v.name..(v.origin and (" - " ..v.origin) or "").."]"
		.."label[2,"..y..";"..v.name..(v.origin and (" - " ..v.origin) or "").."]"
		..(functional and "box[2,"..(y+0.5)..";2.1,0.5;#222]label[2,"..(y+0.5)..";"..minetest.colorize("#0f0","Functional skin").."]" or "")
		..(functional and "textarea[2.3,"..(y+1)..";5.7,2.3;;;"..v.info.."]" or "textarea[2.3,"..(y+0.5)..";5.7,2.5;;;"..v.info.."]")
		.."model[-0.5,"..y..";2,3;preskin;character.b3d;"..v.skin..";0,180;false;true;1,31]"

		.."box[2,"..(y+2.8)..";5.5,0.2;#222]"

		if skin == v.skin then
		elseif own[v.name] then
			text = text .."button[1.2,"..y..";1,1;skinuse="..i..";Use]"
		else
			text = text .."image_button[1.2,"..y..";1,1;player_style_coin.png;skinbuy="..i..";"..(v.cost > 0 and v.cost or "Free").."]"
		end

		y = y +3
	end
	return minetest.show_formspec(player:get_player_name(), "player_style_skins",
		"size[8,8]" 
		.."listcolors[#77777777;#777777aa;#000000ff]"
		.."label[6,-0.35;"..minetest.colorize("#FFFF00",Getcoin(player)).."]"
		.."scrollbaroptions[max="..((#player_style.skins.skins-3)*36)..";]"
		.."scrollbar[7.5,0;0.5,8;vertical;scrollbar;"..(scroll or 0).."]"
		.."scroll_container[0,0;9.7,10;scrollbar;vertical]"
		..text
		.."scroll_container_end[scrollbar]"
	)
end

minetest.register_on_player_receive_fields(function(player, form, pressed)
	if form == "player_style_skins" then
		local name = player:get_player_name()
		if pressed.quit then
			return
		end
		for i,v in pairs(pressed) do
			local index = i:sub(1,8)
			if index == "skinbuy=" then
				local m = player:get_meta()
				local v = player_style.skins.skins[tonumber(i:sub(9,-1))]
				if Getcoin(player) >= v.cost then
					local own = minetest.deserialize(m:get_string("skins")) or {}
					own[v.name] = true
					m:set_string("skins", minetest.serialize(own))
					Coin(player,-v.cost)
					index = "skinuse="
					minetest.sound_play("default_lose_coins", {to_player=name, gain = 2})
					exaachievements.customize(player,"artist")
				end
			end
			if index == "skinuse=" then
				local m = player:get_meta()
				local textures = player:get_properties().textures
				local skin = m:get_string("skin")
				local v = player_style.skins.skins[tonumber(i:sub(9,-1))]
				textures[1] = v.skin
				player:set_properties({textures=textures})
				m:set_string("skin",v.skin)
				local scbv = minetest.explode_scrollbar_event(pressed.scrollbar).value or 0
				player_style.update_player_skin(player)
				player_style.skins.store(player,scbv)
				local p = player_style.players[name]
				for i,v in ipairs(player_style.skins.skins) do
					if v.skin == skin then
						if v.on_stop_using then
							v.on_stop_using(p.skin_self,player)
						end
						break
					end
				end

				p.skin_self = {}
				if v.on_use then
					v.on_use(p.skin_self,player)
				end
				if v.on_use_join then
					v.on_use_join(p.skin_self,player)
				end
				if v.on_step then
					p.on_step_skin=v.on_step
				else
					p.on_step_skin = nil
				end
				break
			end
		end
	end
end)

minetest.register_on_newplayer(function(player)
	player:get_meta():set_string("skin","character.png")
end)