# Global Patterns

**Author:** Albert OAD  
**License:** MIT (See LICENSE.txt for details)  
**Mod Type:** Pattern generation tool for Minetest

---

## Description

Global Patterns allows players to generate complex structures and patterns efficiently. Patterns are generated from the node where the player places a block. This mod is useful for large buildings and structures, reducing the time required to build manually.

---

## Commands

- **/setpattern `<pattern_name>`**  
  Select a pattern to generate. Example:

- **/setdim <x> <y> <z>**
  Defines teh dimensional values in x y z
  
- **/setchar <char>**
  Special variable used to set what char is to be printed in xy or zy direction when pattern is set to letter
  
- ** /setoffset <x> <y> <z> **
  Can create an offset such the pattern shall be generated such that the node referred to after offset is added will be taken as the node from which pattern is supposed to be made
  
## Patterns

- **cuboid**
  /setpattern cuboid
  Makes a cuboid from the placed node of the placed node type in x y and z direction depending on the sing of x, y and z. 
  For a 4 x 4 x 4 cuboid from the starting node to +x+y+z direction, use /setdim 4 4 4 
  For a 4 x 4 x 4 cuboid from the starting node to +x-y-z direction, use /setdim 4 -4 -4 
  For a line in any direction, set value with direction in that dimensino with other dimension as 1
    for downward pole, /setdim 1 -len 1
	for upward pole, /setdim 1 len 1
	for horizontal line starting from node placed, /setdim (+/-)len 1 1 or /setdim 1 1 (+/-)len
	
	
- **general cuboid**
  /setpattern general_cuboid
  Similar to cuboid but will work with the placed node as centre in xz axis. will only place upward in y direction and not in -y direction. 
  For a 5 x 5 cross area cube exteding upward by 10 nodes: /setdim 2 10 2
  
  
- ** stair **
  /setpattern stair
  This one is used to place a stair in any direction.
  /setdim is used to set dimensions for stair
  ** y ** is used to define teh offset. for normal stair, set 1 or -1 for upward or downward.
  set either x or z for stair in that direction from the placed node while setting other to 1
  If both are not one, then x is taken as the value to be taken and stair generated towards x axis 
  
  
- ** O **
  /setpattern o
  /setpattern O
  Generates a rectangular outline in xz direction.
  Does not generate in y and y can be anything and is not valued.
  For a 5 x 5 square, /setdim 2 {anything} 2 


- ** letter **
  /setpattern letter
  Used to generate a letter from placed node upward. 
  For orientation along x, set x to non-zero and z to zero, /setdim 1 0 0 
  For orientation along z, set x to zero and z to non-zero, /setdim 0 0 1
  For character, use /setchar
    /setchar a
	/setchar z
	/setchar 0
	/setchar 9
  

- ** bridge **
  /setpattern bridge
  Used to create an xz bridge.
  from the starting node, it shall extend in all four directions. An extension of any direction shall end if a node is met at the end.
  The bridge shall extend over air, water, lava
  The max_len for such bridge is 500
  
 
- ** extending x+ line **
  /setpattern x
  /setpattern x+
  /setpattern +x
  /setpattern X+
  /setpattern +X
  Similar to bridge but from starting pos, it shall keep extending node towards +x till a node is met  or limit is reached.
  

- ** extending x- line **
  /setpattern x-
  /setpattern -x
  /setpattern X-
  /setpattern -X
  Similar to bridge but from starting pos, it shall keep extending node towards -x till a node is met  or limit is reached. Air, water and lava can be replaced.
  

- ** extending z+ line **
  /setpattern z
  /setpattern z+
  /setpattern +z
  /setpattern Z+
  /setpattern +Z
  Similar to bridge but from starting pos, it shall keep extending node towards +z till a node is met  or limit is reached. Air, water and lava can be replaced.


- ** extending z- line **
  /setpattern z-
  /setpattern -z
  /setpattern Z-
  /setpattern -Z
  Similar to bridge but from starting pos, it shall keep extending node towards -z till a node is met  or limit is reached. Air, water and lava can be replaced.  
  

- ** extending y- line **
  /setpattern y-
  /setpattern -y
  /setpattern Y-
  /setpattern -Y
  Similar to bridge but from starting pos, it shall keep extending node towards -y till a node is met  or limit is reached. Air, water and lava can be replaced.  
  

- ** wallz+ **
  /setpattern wallz+
  From the placed node extends a wall towards z+ till the node at the same height reaches an end. The wall shall extend automaticall downward till it reaches the ground. Air, water and lava can be replaced.
  

- ** wallz- **
  /setpattern wallz+
  From the placed node extends a wall towards z- till the node at the same height reaches an end. The wall shall extend automaticall downward till it reaches the ground. Air, water and lava can be replaced.
  
  
- ** wallx+ **
  /setpattern wallz+
  From the placed node extends a wall towards x+ till the node at the same height reaches an end. The wall shall extend automaticall downward till it reaches the ground. Air, water and lava can be replaced.
  
  
- ** wallx- **
  /setpattern wallz+
  From the placed node extends a wall towards x- till the node at the same height reaches an end. The wall shall extend automaticall downward till it reaches the ground. Air, water and lava can be replaced.
  
  
- ** floodfillxz **
  /setpattern floodfillxz
  fills in xz direction till it encounters a closed boundary in xz direction