local function on_place(itemstack, placer, pointed_thing)
    if not minetest.is_player(placer) then
        return minetest.item_place(itemstack, placer, pointed_thing)
    end

    local look_dir = placer:get_look_dir()

    if not vector.check(look_dir) then
        return minetest.item_place(itemstack, placer, pointed_thing)
    end

    local facedir = minetest.dir_to_facedir(look_dir)
    local aim_dir = pointed_thing.under - pointed_thing.above

    local param2
    if aim_dir.x == -1 then
        param2 = 15
    elseif aim_dir.x == 1 then
        param2 = 17
    elseif aim_dir.y == -1 then
        param2 = facedir
    elseif aim_dir.y == 1 then
        param2 = 20 + ((2 - facedir) % 4)
    elseif aim_dir.z == -1 then
        param2 = 6
    elseif aim_dir.z == 1 then
        param2 = 8
    end

    return minetest.item_place(itemstack, placer, pointed_thing, param2)
end

function yl_googly_eyes.register_eye(name)
    minetest.register_node(":yl_googly_eyes:" .. name, {
        description = "Googly Eyes!",
        drawtype = "nodebox",
        use_texture_alpha = "blend",
        tiles = {"yl_googly_eyes_" .. name .. ".png"},
        is_ground_content = false,
        inventory_image = "yl_googly_eyes_" .. name .. ".png",
        wield_image = "yl_googly_eyes_" .. name .. ".png",
        paramtype = "light",
        paramtype2 = "facedir",
        walkable = false,
        climbable = false,
        sunlight_propagates = true,
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.4375, -0.5, 0.5, -0.4375, 0.5}
        },
        groups = {choppy = 3},
        on_place = on_place
    })
end

-- Each time the server loads, the animated ones have a different style of looking

function yl_googly_eyes.register_eye_with_tiles(name, tiles)
    minetest.register_node(":yl_googly_eyes:" .. name, {
        description = "Googly Eyes!",
        drawtype = "nodebox",
        use_texture_alpha = "blend",
        tiles = tiles,
        is_ground_content = false,
        paramtype = "light",
        paramtype2 = "facedir",
        walkable = false,
        climbable = false,
        sunlight_propagates = true,
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.4375, -0.5, 0.5, -0.4375, 0.5}
        },
        groups = {choppy = 3},
        on_place = on_place
    })
end