
# yl_matterbridge

## Purpose

This mod adds support for [matterbridge](https://github.com/42wim/matterbridge) to handle chat messages between Minetest and other chat protocols like
- Discord
- IRC
- Matrix
- Telegram
- Twitch
- WhatsApp
- and more

## Download

Get it from https://gitea.your-land.de/AliasAlreadyTaken/yl_matterbridge

## Installation

copy the "yl_matterbridge" folder to your mod folder and enable it in your world.mt.

add yl_matterbridge to secure.http_mods in your minetest.conf

```
secure.http_mods = yl_matterbridge
```

Download and install [matterbridge](https://github.com/42wim/matterbridge)

## Configuration

Create a config for [matterbridge](https://github.com/42wim/matterbridge) and the chat protocols you want to use.

* https://github.com/42wim/matterbridge/wiki/How-to-create-your-config
* https://github.com/42wim/matterbridge/wiki/Api

An example config for minetest looks like this

```
[api.mt]
BindAddress="127.0.0.1:4242"
Buffer=1000
RemoteNickFormat="{NICK}"
#Token="DISABLED, NOT YET SUPPORTED"
```
Gateway section:

```
[[gateway]]
name="default"
enable=true
[[gateway.inout]]
account="api.mt"
channel="api"
```

## Modmakers

API: Overwrite these function in your chat mod, if you want to handle messages yourself
Don't forget to add an optional dependency to yl_matterbridge

Overwrite this function to receive something from the bridge
```
function yl_matterbridge.receive_from_bridge(user_name, message_text)
    core.chat_send_all("<" .. user_name .. "@irc> " .. message_text)
end
```

Overwrite this function instead if you want to use other fields coming from the bridge.
```
function yl_matterbridge.receive_all_from_bridge(dataset)
    if dataset.username and dataset.text and dataset.account then
        local user_name = dataset.username
        local message_text = dataset.text
        local account_name = dataset.account
        yl_matterbridge.receive_from_bridge(user_name, message_text, account_name)
    else
        core.log(
            "error",
            "[MOD] yl_matterbridge: receive/http.fetch failed. No dataset in returned data = " .. dump(dataset)
        )
    end
end
```

Call this function to send something to the bridge
```
function yl_matterbridge.send_to_bridge(user_name, message_text)
    send(user_name, message_text)
end
```

Set this function to yl_matterbridge.chat_message = function() end if you call yl_matterbridge.send_to_bridge yourself

```
function yl_matterbridge.chat_message(user_name, message_text)
    send_to_bridge(user_name, message_text)
end
```

## Supported versions

If you run yl_matterbridge in one of the supported versions, but something is wrong, please [file a bug](https://gitea.your-land.de/AliasAlreadyTaken/yl_matterbridge/issues/new). PRs also welcome.

If you run yl_matterbridge in one of the unknown versions, like MacOS or Android or Linux, please tell us whether it works or not. We will add your findings to the readme.

There is no reason to believe it doesn't work anywhere, but you never know.

### Windows

MT versions 5.0.0, 5.0.1, 5.1.0, 5.1.1, 5.2.0, 5.3.0, 5.4.0 5.4.1, 5.5.0

### Linux

MT versions 5.5.0

### MacOS

unknown

### Android

unknown

### Misc

unknown

## Allied projects

If you know a project that uses this bridge tell us and we will add it to the list.

* smart_chat : https://github.com/acmgit/smart_chat/

## Uninstall

Remove it from your mod folder or deactivate it in your world.mt

Mods that depend on it will cease to work, if the mod is removed without proper replacement.

## License

MIT

## Thank you

* Bla 
* clyde (https://github.com/acmgit/)