-- Version 1.0.3
-- Author AliasAlreadyTaken
-- License MIT

-- Changelog

-- 0.0.1 First puny attempts
-- 0.0.2 Feature complete including settings
-- 1.0.0 Ready for release
-- 1.0.1 Bugfix https://gitea.your-land.de/your-land/bugtracker/issues/1646
-- 1.0.2 Bugfix settingtypes: bool instead of boolean
-- 1.0.3 Release to cdb

local mod_start_time = core.get_us_time()
core.log("action", "[MOD] yl_matterbridge loading")

yl_matterbridge = {}
--yl_matterbridge.error = {}
--yl_matterbridge.modstorage = core.get_mod_storage()
--yl_matterbridge.modpath = core.get_modpath("yl_matterbridge") .. DIR_DELIM
--yl_matterbridge.worldpath = core.get_worldpath() .. DIR_DELIM

yl_matterbridge.information = {}
yl_matterbridge.information.version = "1.0.3"
yl_matterbridge.information.author = "AliasAlreadyTaken"
yl_matterbridge.information.license = "MIT"
yl_matterbridge.information.name = "yl_matterbridge"
yl_matterbridge.information.source = "https://gitea.your-land.de/AliasAlreadyTaken/yl_matterbridge"
yl_matterbridge.information.additional =
    "Sends and receives ingame chat to and from matterbridge https://github.com/42wim/matterbridge"

local settings = {}
settings.address = core.settings:get("yl_matterbridge.address") or "127.0.0.1"
settings.port = core.settings:get("yl_matterbridge.port") or "4242"
settings.gateway = core.settings:get("yl_matterbridge.gateway") or "default"
settings.token = core.settings:get("yl_matterbridge.token") or ""
settings.debug = core.settings:get_bool("yl_matterbridge.debug", false) or false

local http = core.request_http_api()

assert(http, "[MOD] yl_matterbridge: Please add yl_matterbridge to secure.http_mods")

if settings.debug then
    core.log("action", "[MOD] yl_matterbridge : settings = " .. dump(settings))
end

local post_headers = {"Content-Type: application/json"}
if settings.token and settings.token ~= "" then
    table.insert(post_headers, "Authorization: Bearer " .. settings.token)
end
local url_send = "http://" .. settings.address .. ":" .. settings.port .. "/api/message"
local url_receive = "http://" .. settings.address .. ":" .. settings.port .. "/api/messages"

function send(user_name, message_text)
    if settings.debug then
        core.log(
            "action",
            "[MOD] yl_matterbridge : send user_name = " .. dump(user_name) .. ",  message_text = " .. dump(message_text)
        )
    end
    local timeout = 10
    local data = {
        text = message_text,
        username = user_name,
        gateway = settings.gateway
    }

    http.fetch(
        {
            url = url_send,
            extra_headers = post_headers,
            timeout = timeout,
            post_data = core.write_json(data)
        },
        function(result)
            if not result.completed or not result.succeeded or not result.code == 200 then
                core.log("error", "[MOD] yl_matterbridge: send/http.fetch failed. Result = " .. dump(result))
                return false
            else
                if settings.debug then
                    local data = core.parse_json(result.data)
                    core.log(
                        "action",
                        "[MOD] yl_matterbridge : send result = " .. dump(result) .. ", data = " .. dump(data)
                    )
                end
                return true
            end
        end
    )
end

local function receive()
    if settings.debug then
        core.log("action", "[MOD] yl_matterbridge : receive")
    end
    local timeout = 0

    http.fetch(
        {
            url = url_receive,
            extra_headers = post_headers,
            timeout = timeout
        },
        function(result)
            if not result.completed or not result.succeeded or not result.code == 200 then
                core.log("error", "[MOD] yl_matterbridge: receive/http.fetch failed. Result (req) = " .. dump(result))
                return false
            else
                local data = core.parse_json(result.data)
                if not data then
                    if not next(data) then
                        if settings.debug then
                            core.log(
                                "error",
                                "[MOD] yl_matterbridge: receive/http.fetch failed. Result (data) = " .. dump(result)
                            )
                        end
                    end
                    return false
                end
                for _, dataset in ipairs(data) do
                    if dataset then
                        if settings.debug then
                            core.log("action", "[MOD] yl_matterbridge : dataset = " .. dump(dataset))
                        end
                        yl_matterbridge.receive_all_from_bridge(dataset)
                    else
                        core.log(
                            "error",
                            "[MOD] yl_matterbridge: receive/http.fetch failed. No dataset in returned data = " ..
                                dump(data)
                        )
                    end
                end
            end
        end
    )
end

-- API
-- Overwrite these function in your chat mod, if you want to govern sending and receveiving yourself
-- Don't forget to add an optional dependency to yl_matterbridge

function yl_matterbridge.receive_from_bridge(user_name, message_text, account_name)
    core.chat_send_all("<" .. account_name .. "|" .. user_name .. "> " .. message_text)
end

-- Overwrite this function instead if you want to use other fields coming from the bridge.

function yl_matterbridge.receive_all_from_bridge(dataset)
    if dataset.username and dataset.text and dataset.account then
        local user_name = dataset.username
        local message_text = dataset.text
        local account_name = dataset.account
        yl_matterbridge.receive_from_bridge(user_name, message_text, account_name)
    else
        core.log(
            "error",
            "[MOD] yl_matterbridge: receive/http.fetch failed. No dataset in returned data = " .. dump(dataset)
        )
    end
end

-- Call this function to feed into the bridge from your own mod, if you unset yl_matterbridge.chat_message

function yl_matterbridge.send_to_bridge(user_name, message_text)
    send(user_name, message_text)
end

-- Set this function to yl_matterbridge.chat_message = function() end
-- if you call yl_matterbridge.send_to_bridge yourself

function yl_matterbridge.chat_message(user_name, message_text)
    yl_matterbridge.send_to_bridge(user_name, message_text)
end

-- connect to Minetest
function yl_matterbridge.register_chat()
    core.register_on_chat_message(yl_matterbridge.chat_message)
end

core.register_on_mods_loaded(yl_matterbridge.register_chat)

core.register_globalstep(receive)

local mod_end_time = (core.get_us_time() - mod_start_time) / 1000000
core.log("action", "[MOD] yl_matterbridge loaded in [" .. mod_end_time .. "s]")
