local chatcommand_cmd = "scheduler_list"
local chatcommand_params = "[[part of] UUID]"
local chatcommand_description =
    "Lists all tasks, optionally only those that match the given (part of a) UUID. See /" ..
        chatcommand_cmd .. " help"

local chatcommand_definition = {
    params = chatcommand_params,
    description = chatcommand_description,
    privs = yl_scheduler.get_privs(chatcommand_cmd),
    func = function(name, params)
        local success, message = yl_scheduler["cmd_" .. chatcommand_cmd](name,
                                                                         params)
        if success then
            return true, message
        else
            return false, message
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
