local timer = 0

local gs = function(dtime)
    timer = timer + dtime
    if timer <= yl_scheduler.settings.execution_interval then return end
    timer = 0

    local _, tasks = yl_scheduler.list_all_tasks()
    local current_utc_time = os.time()
    for _, task in ipairs(tasks) do
        if (task.at < current_utc_time) and
            ((task.done == nil) or (task.done == -1)) then
            local UUID = task.id
            local success, message = yl_scheduler.execute_task(UUID)
            if (success == false) then
                minetest.log("warning", "[MOD] yl_scheduler : " .. dump(message))
            else
                minetest.log("action",
                             "[MOD] yl_scheduler : Executed " .. dump(task.id))
            end
        end
    end
end

minetest.register_globalstep(gs)
