local chatcommand_cmd = yl_ticker.settings.chatcommand_domain .. "_add"
local chatcommand_definition = {
    params = "<message>$<frequency>$<runtime|timestamp>",
    description = "Sends the message each frequency for runtime or until timestamp." ..
        "\n" .. "Example: /" .. chatcommand_cmd .. " Message $ 50 $ 3600" ..
        "\n" .. "For more examples do /" ..
        yl_ticker.settings.chatcommand_domain .. "_examples",
    privs = {[yl_ticker.settings.admin_privs] = true},
    func = function(name, param)
        local success, message = yl_ticker.chatcommand_ticker_add(name, param)

        if success then
            minetest.log("action", "[yl_ticker] player " .. name ..
                             " added new ticker: " .. param)
            return true, message
        else
            minetest.log("warning",
                         "[yl_ticker] player " .. name .. " added new ticker: " ..
                             param .. " unsuccessfully, message: " .. message)
            return false, message
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
yl_ticker.register_help(chatcommand_cmd, chatcommand_definition)
