local chatcommand_cmd = yl_ticker.settings.chatcommand_domain .. "_list_all"
local chatcommand_definition = {
    params = "",
    description = "Lists all tickers to you." .. "\nExample: /" ..
        chatcommand_cmd,
    privs = {[yl_ticker.settings.user_privs] = true},
    func = function(name, param)
        local success, message = yl_ticker.chatcommand_ticker_list_all(name,
                                                                       param)

        if success then
            minetest.log("action", "[yl_ticker] player " .. name ..
                             " lists all tickers: " .. param)
            return true, message
        else
            minetest.log("warning",
                         "[yl_ticker] player " .. name .. " lists all tickers: " ..
                             param .. " unsuccessfully, message: " ..
                             dump(message))
            return false, dump(message)
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
yl_ticker.register_help(chatcommand_cmd, chatcommand_definition)
