local chatcommand_cmd = yl_ticker.settings.chatcommand_domain .. "_say_all"
local chatcommand_definition = {
    params = "",
    description = "Say all tickers in main chat." .. "\nExample: /" ..
        chatcommand_cmd,
    privs = {[yl_ticker.settings.admin_privs] = true},
    func = function(name, param)
        local success, message = yl_ticker.chatcommand_ticker_say_all(name,
                                                                      param)

        if success then
            minetest.log("action", "[yl_ticker] player " .. name ..
                             " sent all tickers: " .. param)
            return true, message
        else
            minetest.log("warning",
                         "[yl_ticker] player " .. name .. " sent all tickers: " ..
                             param .. " unsuccessfully, message: " .. message)
            return false, message
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
yl_ticker.register_help(chatcommand_cmd, chatcommand_definition)
