local chatcommand_cmd = yl_ticker.settings.chatcommand_domain .. "_copy"
local chatcommand_definition = {
    params = "<ticker ID>",
    description = "Open the ticker with ID in a formspec, so it can be copied." ..
        "\nExample: /" .. chatcommand_cmd .. " 5",
    privs = {[yl_ticker.settings.user_privs] = true},
    func = function(name, param)
        local success, message = yl_ticker.chatcommand_ticker_copy(name, param)

        if success then
            minetest.log("action", "[yl_ticker] player " .. name ..
                             " copied ticker: " .. param)
            return true, message
        else
            minetest.log("warning",
                         "[yl_ticker] player " .. name .. " copied ticker: " ..
                             param .. " unsuccessfully, message: " .. message)
            return false, message
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
yl_ticker.register_help(chatcommand_cmd, chatcommand_definition)
