
# yl_ticker

## Purpose

This mod allows you to send messages to your players in an interval.

## Download

Get it from https://gitea.your-land.de/your-land/yl_ticker

## Installation

1. Copy the "yl_ticker" folder to your mod directory.
2. Enable the mod in your world.mt file.

## Configuration

```
yl_ticker.debug = false
```
Set to true to enable debug mode

```
yl_ticker.save_path
```
Set this to where in the worldfolder you want the JSON files stored.

```
yl_ticker.chatcommand_domain
```
Set this to what the chatcommand should start with. Default is ticker, so chatcommands start with `/ticker_` but if you set it to "towncrier", chatcommands will start with `/towncrier_`

```
yl_ticker.colour
```
Set this to the colour you want the ticker have in chat

```
yl_ticker.frequency
```
Set this to the default repeat timer you want the ticker have in chat. 3600 means "once per hour"

```
yl_ticker.examples
```

Set this to what the examples command should display. Break line with `\n`

```
yl_ticker.user_privs
yl_ticker.admin_privs
```
Set those to the list of privs you want to allow the execution of the corresponding commands:

yl_ticker.user_privs allows
* listing single ticker
* copy single ticker
* listing all tickers
* Show help
* Show examples

yl_ticker.admin_privs allows
* listing single ticker
* copy single ticker
* listing all tickers
* add ticker
* delete ticker
* say ticker to main chat
* say all tickers to main chat

## Usage

This mod targets servers, but should work in singleplayer, too. It comes with no direct content but exposes functions you can use in your mod.

### Data structure

One ticker consists of an id, a message, an owner, a runtime and a frequency. Example:

```
{
    id = 1,
    creation_date = os.time(),
    message = "[EVENT] Don't forget to join the event tonight!",
    owner = "Admin",
    runtime = 1000000,
    frequency = 3600,
    param = "[EVENT] Don't forget to join the event tonight!$3600$1000000"
}
```

Those tickers sit in a table with `id` as index:

```
{
    1 = {ticker},
    2 = {ticker},
    [5] = {ticker}
}
```

### Chatcommands

```
/ticker_add message$frequency in seconds/minutes/hours/days/weeks$runtime in seconds/minutes/hours/days/weeks/utc
```

Sends the message each frequency for runtime or until timestamp.

Time distances may be given as `60s` or `60 s`, allowed units are s = second, m = minute, h = hour, d = day and w = week.

Runtime may also be given as an enddate in utc timestamp `1704117600utc` or `1704117600 utc`

```
/ticker_copy ticker_id
```

Open the ticker with ID in a formspec, so it can be copied.

```
/ticker_delete ticker_id
```

Delete the ticker ID.

```
/ticker_list
```

List attributes of ticker with ID to you.

```
/ticker_list_all
```

Lists all tickers to you.

```
/ticker_say ticker_id
```

Say the ticker with ID in main chat.

```
/ticker_say_all
```

Say all tickers in main chat.

```
/ticker_help
```

Displays a help overview of all ticker-related commands

```
/ticker_examples
```

Shows a formspec with (configurable) examples people can copy out of

### Modmakers

Use the following public functions to get, set, list and remove ticker

```
yl_ticker.get(ticker_id)
```

Returns a table with the values of this ticker_id. Returns `nil`, if it does not exist. Returns `false, "errormessage"` if an error occurred.

```
yl_ticker.set(message, frequency, runtime, owner, param)
```

Adds this ticker to the list and returns `true, ticker_id` if accepted, `false, "errormessage"` if not.

```
yl_ticker.formspec(ticker_id)
```

Returns `true, formspecstring` if a ticker was found, with formspecstring including the `/ticker_add` string, so it can be easily copied from. Returns `false, errormessage` if an error occurred.

```
yl_ticker.delete(ticker_id)
```

Returns `true, {ticker}` if one ticker was successfully removed, `false, "errormessage"` otherwise.

```
yl_ticker.list()
```

Returns `true, { id = {ticker}, ... }` if one or more ticker were found or `false, {}` if none were found.

```
yl_ticker.say(ticker_id, target)
```

Returns `true, {ticker}` if one ticker was found or `false, {}` if none were found.

## Limitations

* No colours
* No tags like \[EVENT\]

## Alternatives

* For immediate one-time ticker, use the notification mod
* For future one-time ticker, use the yl_scheduler mod

## Supported versions

If you run yl_ticker, but something is wrong, please [file a bug](https://gitea.your-land.de/your-land/yl_ticker/issues/new). PRs also welcome.

There is no reason to believe it doesn't work anywhere, but you never know.

## Allied projects

If you know a project that uses this mod tell us and we will add it to the list.

## Uninstall

Remove it from your mod folder or deactivate it in your world.mt

Mods that depend on it will cease to work, if the mod is removed without proper replacement.

## License

See [LICENSE.md](https://gitea.your-land.de/your-land/yl_ticker/src/LICENSE.md)

* Code MIT AliasAlreadyTaken
* Screenshot CC0 Styxcolor

## Thank you

* Styxcolor
