local chatcommand_cmd = yl_ticker.settings.chatcommand_domain .. "_help"
local chatcommand_definition = {
    params = "",
    description = "Lists the command help for the ticker." .. "\nExample: /" ..
        chatcommand_cmd,
    privs = {[yl_ticker.settings.user_privs] = true},
    func = function(name, param)
        local success, message = yl_ticker.chatcommand_ticker_help(name, param)

        if success then
            minetest.log("action", "[yl_ticker] player " .. name ..
                             " displays help for ticker: " .. param)
            return true, message
        else
            minetest.log("warning",
                         "[yl_ticker] player " .. name ..
                             " displays help for ticker: " .. param ..
                             " unsuccessfully, message: " .. message)
            return false, message
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
yl_ticker.register_help(chatcommand_cmd, chatcommand_definition)
