local chatcommand_cmd = yl_ticker.settings.chatcommand_domain .. "_list"
local chatcommand_definition = {
    params = "<ticker ID>",
    description = "List attributes of ticker with ID to you." .. "\nExample: /" ..
        chatcommand_cmd .. " 5",
    privs = {[yl_ticker.settings.user_privs] = true},
    func = function(name, param)
        local success, message = yl_ticker.chatcommand_ticker_list(name, param)

        if success then
            minetest.log("action", "[yl_ticker] player " .. name ..
                             " lists tickers: " .. param)
            return true, message
        else
            minetest.log("warning",
                         "[yl_ticker] player " .. name .. " lists tickers: " ..
                             param .. " unsuccessfully, message: " .. message)
            return false, message
        end
    end
}

minetest.register_chatcommand(chatcommand_cmd, chatcommand_definition)
yl_ticker.register_help(chatcommand_cmd, chatcommand_definition)
