function yl_ticker.list()
    if next(yl_ticker.data) ~= nil then return true, yl_ticker.data end
    return false, {}
end

function yl_ticker.get(ticker_id)

    -- Check ticker_id
    if (type(ticker_id) ~= "number") then
        return false, "Ticker ID is not a number"
    end
    if (ticker_id <= 0) then
        return false, "Ticker ID cannot be zero or negative"
    end

    local success, data = yl_ticker.list()
    if ((success == true) and (data[ticker_id] ~= nil)) then
        return true, table.copy(data[ticker_id])
    end
    return nil
end

function yl_ticker.set(message, frequency, runtime, owner, param)

    -- Check message
    if (type(message) ~= "string") then return false, "message not a string" end

    -- Check frequency
    if (type(frequency) ~= "number") then
        return false, "frequency not a number"
    end
    if (frequency <= 0) then
        return false, "Frequency cannot be zero or negative"
    end

    -- Check runtime
    if (type(runtime) ~= "number") then return false, "Runtime not a number" end
    if (runtime <= 0) then return false, "Runtime cannot be zero or negative" end

    -- Check owner
    if (type(owner) ~= "string") then return false, "Owner not a string" end
    if (owner == "") then return false, "Owner cannot be empty" end

    local index = 1
    while yl_ticker.data[index] ~= nil do index = index + 1 end

    local content = {
        id = index,
        creation_date = os.time(),
        message = message,
        frequency = frequency,
        runtime = runtime,
        owner = owner,
        param = param
    }

    yl_ticker.data[index] = content

    local success = yl_ticker.save_json(tostring(index) .. ".json", content)

    if (success == true) then return true, index end
    return false, "Could not store ticker"
end

-- /ticker_add message$frequency in seconds$runtime in seconds
function yl_ticker.formspec(ticker_id)

    -- Check ticker_id
    if (type(ticker_id) ~= "number") then
        return false, "Ticker ID is not a number"
    end
    if (ticker_id <= 0) then
        return false, "Ticker ID cannot be zero or negative"
    end

    local success, ticker = yl_ticker.get(ticker_id)
    core.log("action", "ticker = " .. dump(ticker))
    if ((success == false) or (ticker == nil)) then return false, "No ticker" end

    local m = ticker.message or "message"
    local f = ticker.frequency or "frequency"
    local r = ticker.runtime or "runtime"
    local p = ticker.param or "param"

    local c = "/" .. yl_ticker.settings.chatcommand_domain .. "_add " .. m ..
                  "$" .. f .. "$" .. r .. "utc"
    local pa = "/" .. yl_ticker.settings.chatcommand_domain .. "_add " .. p
    local content = minetest.formspec_escape(
                        c .. "\n\n" .. pa .. "\n\n" .. dump(ticker))
    local formspec = "formspec_version[6]" .. "size[16,6]" ..
                         "button_exit[15.4,0.1;0.5,0.5;X;X]" ..
                         "textarea[0.05,0.05;15.3,5.9;;;" .. content .. "]"
    return true, formspec
end

function yl_ticker.delete(ticker_id)

    -- Check ticker_id
    if (type(ticker_id) ~= "number") then
        return false, "Ticker ID is not a number"
    end
    if (ticker_id <= 0) then
        return false, "Ticker ID cannot be zero or negative"
    end

    local success, data = yl_ticker.list()

    if ((success == false) or (data == nil)) then
        return false, "Could not retrieve list"
    end
    if ((success == true) and (data[ticker_id] == nil)) then
        return false, "Could not retrieve ticker ID" .. dump(ticker_id)
    end

    local ticker = table.copy(data[ticker_id]) or "No data available"

    if (ticker ~= nil) then
        data[ticker_id] = nil
        local success_f, err = yl_ticker.remove_file(ticker_id .. ".json")
        if (success_f == nil) then return false, err end
        success = true
    end

    if (success ~= true) then
        ticker = "Could not find ticker with id " .. dump(ticker_id)
    end
    return success, ticker
end

function yl_ticker.say(ticker_id, target)

    -- Check ticker_id
    if (type(ticker_id) ~= "number") then
        return false, "Ticker ID is not a number"
    end
    if (ticker_id <= 0) then
        return false, "Ticker ID cannot be zero or negative"
    end

    -- No check for target, it is optional

    local success = false

    local ticker = yl_ticker.data[ticker_id]

    if (ticker ~= nil) then
        local color = yl_ticker.settings.colour
        local message = ticker.message
        local content = minetest.colorize(color, message)

        if ((target == "*") or (target == nil)) then
            minetest.chat_send_all(content)
        else
            minetest.chat_send_player(target, content)
        end
        success = true
    end

    if (success ~= true) then
        ticker = "Could not find ticker with id " .. dump(ticker_id)
    end
    return success, ticker
end
