local welcome = 	"size[20,16]" ..
	"hypertext[1,1;18.5,16;welcome_text;" ..
	"<global margin=5 valign=top size=normal font=normal halign=justify>" ..

	"<style size=22 color=purple><b><u><center>Welcome Information</center></u></b></style>" ..
	"You are here, and you have a mission... Rumor tells of a far off land, inaccasible by normal means." ..
	"Great rewards have been promissed to those who reach this land. There is one way, and one way alone, " ..
	"by which you can reach this land.\nThere is, somewhere, a tower which will permit you to travel " ..
	"there. But, unfortunately, nobody knows where this tower is. So, you're going to have to find it. " ..
	"But, before you head off, here are some hints to get you started.\n\n" ..

	"<style size=20 color=blue><center>Aids to Exploring</center></style>" ..
	"You're going to be traveling quite a bit to find these rewards. You'll be delving deep into the " ..
	"center of the earth, and exploring the floating islands which fill the sky. For the delving, you " ..
	"know what to do. But the floating islands, they present a greater challenge. Luckly, there are some " ..
	"things that will help you.\nTo get from island to island, you will probably want the <i>" ..
	"slingshot</i> to fling yourself from island to island. But, if you do that without protection, " ..
	"you will die rapidly from the rapid speeds of impact. To stay in a healthy condition, you'll want " ..
	"to get hold of the <i>bouncer</i> as well, which should help to prevent you from " ..
	"dying ... too often.\nTo use the slingshot, simply rightclick with it while pointing at something, and " ..
	"you can either wait for 4 or 5 seconds to be slung with full force, or, if you want less force, change " ..
	"what you're holding sooner. After you've been slung, you're going to want to hold on to the bouncer, " ..
	"which should permit you to bounce without taking fall damage. Just try not to bounce off the islands!\n" ..

	"<style size=18><b>Crafting:</b></style>\n" .. 
	"Slingshot:\n" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>\n" ..
	"<img name=default_steel_ingot.png width=32 hight=32><img name=default_stick.png width=32 hight=32>" ..
	"<img name=default_steel_ingot.png width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=gui_furnace_arrow_bg.png^[transformR270 width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=fragments_sling.png width=32 hight=32>" ..
	"\n<img name=blank.png width=32><img name=default_stick.png width=32 hight=32>\n" ..
	"Bouncer:\n" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>\n" ..
	"<img name=default_diamond.png width=32 hight=32>" ..
	"<img name=default_diamond.png width=32 hight=32>" ..
	"<img name=default_diamond.png width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=gui_furnace_arrow_bg.png^[transformR270 width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=fragments_bouncer.png width=32 hight=32>\n" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>" ..
	"<img name=default_mese_crystal_fragment.png width=32 hight=32>\n\n" ..

	"<style size=20 color=blue><center>Finding the Tower</center></style>" ..
	"First of all, you're going to want something to show you where this tower is. You're going to need it, " ..
	"because it could be anywhere. But to find it, you're going to need to begin by going up. In the floatlands, " ..
	"at least 200 nodes above the sea, there are two precious crystals which are going to become very important " ..
	"to you. <i>Amethyst</i>, a purple crystal can be found in any normal stone, while for the blue crystal of " ..
	"<i>lapis lazuli</i>, you will have to search in the deserts of the floatlands. You're going to need " ..
	"that slingshot and that bouncer to navigate! I also recomend making some binoculars, so that you can " ..
	"scan islands to see if you can see the ores on them...\n Once you've found some lapis " ..
	"lazuli, you'll be able to make a tower locator, if you have some gold and some diamonds. You're going to need to " ..
	"find some amethyst as well, so you can make a key to get into the tower.\nTo use the tower locator, you can " ..
	"rightclick with it. You can only use it once a minute though!\n" ..

	"<style size=18><b>Crafting:</b></style>\n" .. 
	"Tower Locator:\n" ..
	"<img name=default_diamond.png width=32 hight=32><img name=fragments_lapis_chunk.png width=32 hight=32>" ..
	"<img name=default_diamond.png width=32 hight=32>\n" ..
	"<img name=fragments_lapis_chunk.png width=32 hight=32><img name=default_gold_ingot.png width=32 hight=32>" ..
	"<img name=fragments_lapis_chunk.png width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=gui_furnace_arrow_bg.png^[transformR270 width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=fragments_tower_locator.png width=32 hight=32>" ..
	"\n<img name=default_diamond.png width=32 hight=32><img name=fragments_lapis_chunk.png width=32 hight=32>" ..
	"<img name=default_diamond.png width=32 hight=32>\n" ..
	"Tower Key\n" ..
	"<img name=fragments_amethyst_crystal.png width=32 hight=32><img name=fragments_amethyst_crystal.png width=32 hight=32>" ..
	"<img name=fragments_amethyst_crystal.png width=32 hight=32>\n" ..
	"<img name=fragments_amethyst_crystal.png width=32 hight=32><img name=default_gold_ingot.png width=32 hight=32>" ..
	"<img name=fragments_amethyst_crystal.png width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=gui_furnace_arrow_bg.png^[transformR270 width=32 hight=32><img name=blank.png width=32>" ..
	"<img name=fragments_tower_key.png width=32 hight=32>" ..
	"\n<img name=fragments_amethyst_crystal.png width=32 hight=32><img name=fragments_amethyst_crystal.png width=32 hight=32>" ..
	"<img name=fragments_amethyst_crystal.png width=32 hight=32>\n" ..

	"<style size=20 color=blue><center>Finding and Activating the Tower</center></style>" ..
	"Once you've ready, use the tower locator to find the tower! It might take a bit of trial and error to find the " ..
	"right direction, but you should get there...\nOnce you're at the tower, you can enter it by rightclicking on " ..
	"tower door with the tower key you made. But, before you enter, make sure that you have everything you need, " ..
	"as the only way out is by dying. To activate the tower, you need to make sure that you have the following resources:\n" ..
	"<left><b>-One Mese Block</b> <item name=default:mese width=40 height=40 rotate=yes>\n" ..
	"<b>-One Diamond Block</b> <item name=default:diamondblock width=40 height=40 rotate=yes>\n" ..
	"<b>-One Amethyst Block</b> <item name=fragments:amethyst width=40 height=40 rotate=yes>\n" ..
	"<b>-One Lapis Lazuli Block</b> <item name=fragments:lapis_lazuli width=40 height=40 rotate=yes></left>\n" ..
	
	"And that is all that I can tell you - for as far as I know, no one has made it that far before... Or, rather, " ..
	"no one has returned after having made it that far. The rest, you will have to work out for yourself.\n" ..
	"Good luck brave explorer!]"

minetest.register_chatcommand("welcome", {
	func = function(name)
		minetest.show_formspec(name, "welcome", welcome)
	end
})

minetest.register_craftitem("fragments:welcome_book", {
	description = "Welcome Information Book\nCan also be accessed by /welcome",
	inventory_image = "fragments_welcome_book.png",
	on_use = function(i, user)
		if user and user:is_player() then
			minetest.show_formspec(user:get_player_name(), "welcome", welcome)
		end
	end,
	on_secondary_use = function(i, user)
		if user and user:is_player() then
			minetest.show_formspec(user:get_player_name(), "welcome", welcome)
		end
	end,
})
