minetest.register_craftitem("lottthrowing:bolt_mithril", {
	description = "Mithril Bolt",
	inventory_image = "lottthrowing_bolt_mithril.png",
})

minetest.register_node("lottthrowing:bolt_mithril_box", {
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			-- Shaft
			{-6.5/17, -1.5/17, -1.5/17, 6.5/17, 1.5/17, 1.5/17},
			--Spitze
			{-4.5/17, 2.5/17, 2.5/17, -3.5/17, -2.5/17, -2.5/17},
			{-8.5/17, 0.5/17, 0.5/17, -6.5/17, -0.5/17, -0.5/17},
			--Federn
			{6.5/17, 1.5/17, 1.5/17, 7.5/17, 2.5/17, 2.5/17},
			{7.5/17, -2.5/17, 2.5/17, 6.5/17, -1.5/17, 1.5/17},
			{7.5/17, 2.5/17, -2.5/17, 6.5/17, 1.5/17, -1.5/17},
			{6.5/17, -1.5/17, -1.5/17, 7.5/17, -2.5/17, -2.5/17},
			
			{7.5/17, 2.5/17, 2.5/17, 8.5/17, 3.5/17, 3.5/17},
			{8.5/17, -3.5/17, 3.5/17, 7.5/17, -2.5/17, 2.5/17},
			{8.5/17, 3.5/17, -3.5/17, 7.5/17, 2.5/17, -2.5/17},
			{7.5/17, -2.5/17, -2.5/17, 8.5/17, -3.5/17, -3.5/17},
		}
	},
	tiles = {"lottthrowing_bolt_mithril.png", "lottthrowing_bolt_mithril.png", "lottthrowing_bolt_mithril_back.png", "lottthrowing_bolt_mithril_front.png", "lottthrowing_bolt_mithril_2.png", "lottthrowing_bolt_mithril.png"},
	use_texture_alpha = "clip",
	groups = {not_in_creative_inventory=1},
})

local THROWING_BOLT_ENTITY={
	physical = false,
	timer=0,
	visual = "wielditem",
	visual_size = {x=0.1, y=0.1},
	textures = {"lottthrowing:bolt_mithril_box"},
	lastpos={},
	collisionbox = {0,0,0,0,0,0},
	player = nil,
}

THROWING_BOLT_ENTITY.on_step = function(self, dtime)
	self.timer=self.timer+dtime
	local pos = self.object:get_pos()
	local node = minetest.get_node(pos)

	if self.timer>0.2 then
		local objs = minetest.get_objects_inside_radius({x=pos.x,y=pos.y,z=pos.z}, 2)
		for k, obj in pairs(objs) do
			if obj:get_luaentity() ~= nil then
				if obj:get_luaentity().name ~= "lottthrowing:bolt_mithril_entity" and obj:get_luaentity().name ~= "__builtin:item" then
					local damage = 20
					obj:punch(self.player, 1.0, {
						full_punch_interval=1.0,
						damage_groups={fleshy=damage},
					}, nil)
					self.object:remove()
				end
			else
				local damage = 20
				obj:punch(self.player, 1.0, {
					full_punch_interval=1.0,
					damage_groups={fleshy=damage},
				}, nil)
				self.object:remove()
			end
		end
	end

	if self.lastpos.x~=nil then
		if node.name ~= "air" then
			minetest.add_item(self.lastpos, 'lottthrowing:bolt_mithril')
			self.object:remove()
		end
	end
	self.lastpos={x=pos.x, y=pos.y, z=pos.z}
end

minetest.register_entity("lottthrowing:bolt_mithril_entity", THROWING_BOLT_ENTITY)

minetest.register_craft({
	output = 'lottthrowing:bolt_mithril 16',
	recipe = {
		{'default:steel_ingot', 'lottores:mithril_ingot'},
	}
})
