--[[
More Blocks: registrations

Copyright © 2011-2020 Hugo Locurcio and contributors.
Licensed under the zlib license. See LICENSE.md for more information.
--]]


local box_slope = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25, 0.5,     0, 0.5},
		{-0.5,     0,     0, 0.5,  0.25, 0.5},
		{-0.5,  0.25,  0.25, 0.5,   0.5, 0.5}
	}
}

local box_slope_half = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5,   -0.5,  0.5, -0.375, 0.5},
		{-0.5, -0.375, -0.25, 0.5, -0.25,  0.5},
		{-0.5, -0.25,  0,    0.5, -0.125, 0.5},
		{-0.5, -0.125, 0.25, 0.5,  0,     0.5},
	}
}

local box_slope_half_raised = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5,   -0.5,  0.5, 0.125, 0.5},
		{-0.5, 0.125, -0.25, 0.5, 0.25,  0.5},
		{-0.5, 0.25,  0,    0.5, 0.375, 0.5},
		{-0.5, 0.375, 0.25, 0.5,  0.5,     0.5},
	}
}

--==============================================================

local box_slope_inner = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.5, -0.25, 0.5, 0, 0.5},
		{-0.5, -0.5, -0.5, 0.25, 0, 0.5},
		{-0.5, 0, -0.5, 0, 0.25, 0.5},
		{-0.5, 0, 0, 0.5, 0.25, 0.5},
		{-0.5, 0.25, 0.25, 0.5, 0.5, 0.5},
		{-0.5, 0.25, -0.5, -0.25, 0.5, 0.5},
	}
}

local box_slope_inner_half = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.375, 0.5},
		{-0.5, -0.375, -0.25, 0.5, -0.25, 0.5},
		{-0.5, -0.375, -0.5, 0.25, -0.25, 0.5},
		{-0.5, -0.25, -0.5, 0, -0.125, 0.5},
		{-0.5, -0.25, 0, 0.5, -0.125, 0.5},
		{-0.5, -0.125, 0.25, 0.5, 0, 0.5},
		{-0.5, -0.125, -0.5, -0.25, 0, 0.5},
	}
}

local box_slope_inner_half_raised = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, 0.125, 0.5},
		{-0.5, 0.125, -0.25, 0.5, 0.25, 0.5},
		{-0.5, 0.125, -0.5, 0.25, 0.25, 0.5},
		{-0.5, 0.25, -0.5, 0, 0.375, 0.5},
		{-0.5, 0.25, 0, 0.5, 0.375, 0.5},
		{-0.5, 0.375, 0.25, 0.5, 0.5, 0.5},
		{-0.5, 0.375, -0.5, -0.25, 0.5, 0.5},
	}
}

--==============================================================

local box_slope_outer = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5,   0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25,  0.25,     0, 0.5},
		{-0.5,     0,     0,     0,  0.25, 0.5},
		{-0.5,  0.25,  0.25, -0.25,   0.5, 0.5}
	}
}

local box_slope_outer_half = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5,   0.5, -0.375, 0.5},
		{-0.5, -0.375, -0.25,  0.25, -0.25, 0.5},
		{-0.5,  -0.25,     0,     0, -0.125, 0.5},
		{-0.5,  -0.125,  0.25, -0.25, 0, 0.5}
	}
}

local box_slope_outer_half_raised = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5,   0.5, 0.125, 0.5},
		{-0.5, 0.125, -0.25,  0.25, 0.25, 0.5},
		{-0.5,  0.25,     0,     0, 0.375, 0.5},
		{-0.5,  0.375,  0.25, -0.25, 0.5, 0.5}
	}
}

local function pixel_box(x1, y1, z1, x2, y2, z2)
	return {
		x1 / 16 - 0.5,
		y1 / 16 - 0.5,
		z1 / 16 - 0.5,
		x2 / 16 - 0.5,
		y2 / 16 - 0.5,
		z2 / 16 - 0.5,
	}
end

local function get_microblock_def(name, bbox, node_box)
	local t = {}

	t.mesh = "moreblocks_" .. name .. ".obj"

	if not node_box then
		t.collision_box = {
			type = "fixed",
			fixed = bbox
		}
	else
		t.node_box = {
			type = "fixed",
			fixed = bbox
		}
	end

	t.selection_box = {
		type = "fixed",
		fixed = bbox
	}
	return t
end

stairsplus.defs = {
	["micro"] = {
		[""] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, 0, 0.5},
			},
		},
		["_1"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, -0.4375, 0.5},
			},
		},
		["_2"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, -0.375, 0.5},
			},
		},
		["_4"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, -0.25, 0.5},
			},
		},
		["_12"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, 0.25, 0.5},
			},
		},
		["_14"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, 0.375, 0.5},
			},
		},
		["_15"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0, 0.4375, 0.5},
			},
		}
	},
	["panel"] = {
		[""] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, 0, 0.5},
			},
		},
		["_double_1"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, -0.4375, 0},
					{0, -0.5, 0, 0.5, -0.4375, 0.5}
				},
			},
		},
		["_1"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, -0.4375, 0.5},
			},
		},
		["_double_2"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, -0.375, 0},
					{0, -0.5, 0, 0.5, -0.375, 0.5}
				},
			},
		},
		["_2"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, -0.375, 0.5},
			},
		},
		["_double_4"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, -0.25, 0},
					{0, -0.5, 0, 0.5, -0.25, 0.5}
				},
			},
		},
		["_4"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, -0.25, 0.5},
			},
		},
		["_double_12"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, 0.25, 0},
					{0, -0.5, 0, 0.5, 0.25, 0.5}
				},
			},
		},
		["_12"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, 0.25, 0.5},
			},
		},
		["_double_14"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, 0.375, 0},
					{0, -0.5, 0, 0.5, 0.375, 0.5}
				},
			},
		},
		["_14"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, 0.375, 0.5},
			},
		},
		["_double_15"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, 0.4375, 0},
					{0, -0.5, 0, 0.5, 0.4375, 0.5}
				},
			},
		},
		["_15"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, 0.4375, 0.5},
			},
		},
		["_double_16"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, 0.5, 0},
					{0, -0.5, 0, 0.5, 0.5, 0.5}
				},
			},
		},
		["_16"] = {
			node_box = {
				type = "fixed",
				fixed = {-0.5, -0.5, 0, 0.5, 0.5, 0.5},
			},
		},
		["_pillar"] = {
			node_box = {
				type = "fixed",
				fixed = {
					pixel_box(2, 0, 5, 14, 16, 11),
					pixel_box(3, 0, 3, 13, 16, 13),
					pixel_box(5, 0, 2, 11, 16, 14),
				},
			},
		},
		["_pcend"] = {
			node_box = {
				type = "fixed",
				fixed = {
					pixel_box(2, 0, 5, 14, 16, 11),
					pixel_box(3, 0, 3, 13, 16, 13),
					pixel_box(5, 0, 2, 11, 16, 14),

					pixel_box(0, 0, 0, 16, 3, 16),
					pixel_box(1, 3, 1, 15, 5, 15),
					pixel_box(2, 5, 2, 14, 7, 14),
				},
			}
		},
	},
	["slab"] = {
		[""] = 8,
		["_quarter"] = 4,
		["_three_quarter"] = 12,
		["_1"] = 1,
		["_2"] = 2,
		["_14"] = 14,
		["_15"] = 15,
		["_two_sides_half"] = {
			{-0.5, -0.5, -0.5, 0, -7/16, 7/16},
			{-0.5, -0.5, 7/16, 0, 0.5, 0.5}
		},
		["_two_sides_half_2"] = {
			{-0.5, -0.5, -0.5, 0, -0.375, 0.375},
			{-0.5, -0.5, 0.375, 0, 0.5, 0.5}
		},
		["_two_sides_half_3"] = {
			{-0.5, -0.5, -0.5, 0, -0.25, 0.25},
			{-0.5, -0.5, 0.25, 0, 0.5, 0.5}
		},
		["_two_sides_half_4"] = {
			{ -0.5, -0.5, -0.5, 0.5, -7/16, 7/16 },
			{ -0.5, -0.5, 7/16, 0.5, 0, 0.5 }
		},
		["_two_sides_half_5"] = {
			{ -0.5, -0.5, -0.5, 0.5, -0.375, 0.375 },
			{ -0.5, -0.5, 0.375, 0.5, 0, 0.5 }
		},
		["_two_sides_half_6"] = {
			{ -0.5, -0.5, -0.5, 0.5, -0.25, 0.25 },
			{ -0.5, -0.5, 0.25, 0.5, 0, 0.5 }
		},
		["_two_sides"] = {
			{ -0.5, -0.5, -0.5, 0.5, -7/16, 7/16 },
			{ -0.5, -0.5, 7/16, 0.5, 0.5, 0.5 }
		},
		["_two_sides_2"] = {
			{ -0.5, -0.5, -0.5, 0.5, -0.375, 0.375 },
			{ -0.5, -0.5, 0.375, 0.5, 0.5, 0.5 }
		},
		["_two_sides_3"] = {
			{ -0.5, -0.5, -0.5, 0.5, -0.25, 0.25 },
			{ -0.5, -0.5, 0.25, 0.5, 0.5, 0.5 }
		},
		["_three_sides_half"] = {
			{ -7/16, -0.5, -0.5, 0.5, -7/16, 7/16 },
			{ -7/16, -0.5, 7/16, 0.5, 0, 0.5 },
			{ -0.5, -0.5, -0.5, -7/16, 0, 0.5 }
		},
		["_three_sides_half_2"] = {
			{ -0.375, -0.5, -0.5, 0.5, -0.375, 0.375 },
			{ -0.375, -0.5, 0.375, 0.5, 0, 0.5 },
			{ -0.5, -0.5, -0.5, -0.375, 0, 0.5 }
		},
		["_three_sides_half_3"] = {
			{ -0.25, -0.5, -0.5, 0.5, -0.25, 0.25 },
			{ -0.25, -0.5, 0.25, 0.5, 0, 0.5 },
			{ -0.5, -0.5, -0.5, -0.25, 0, 0.5 }
		},
		["_three_sides"] = {
			{ -7/16, -0.5, -0.5, 0.5, -7/16, 7/16 },
			{ -7/16, -0.5, 7/16, 0.5, 0.5, 0.5 },
			{ -0.5, -0.5, -0.5, -7/16, 0.5, 0.5 }
		},
		["_three_sides_2"] = {
			{ -0.375, -0.5, -0.5, 0.5, -0.375, 0.375 },
			{ -0.375, -0.5, 0.375, 0.5, 0.5, 0.5 },
			{ -0.5, -0.5, -0.5, -0.375, 0.5, 0.5 }
		},
		["_three_sides_3"] = {
			{ -0.25, -0.5, -0.5, 0.5, -0.25, 0.25 },
			{ -0.25, -0.5, 0.25, 0.5, 0.5, 0.5 },
			{ -0.5, -0.5, -0.5, -0.25, 0.5, 0.5 }
		},
		["_three_sides_u"] = {
			{ -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
			{ -0.5, -0.5, -7/16, 0.5, -7/16, 7/16 },
			{ -0.5, -0.5, 7/16, 0.5, 0.5, 0.5 }
		},
		["_four_sides"] = {
			{ -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
			{ -0.5, -0.5, -7/16, 0.5, -7/16, 7/16 },
			{ -0.5, -0.5, 7/16, 0.5, 0.5, 0.5 },
			{ -0.5, -7/16, -7/16, -7/16, 0.5, 7/16 },
		},
		["_hole"] = {
			{-0.5, -0.5, -0.5, 0.5, 0.5, -7/16},
			{-0.5, -0.5, 0.5, 0.5, 0.5, 7/16},
			{-0.5, -0.5, -7/16, -7/16, 0.5, 7/16},
			{0.5, -0.5, -7/16, 7/16, 0.5, 7/16},
		},
		["_two_opposite"] = {
			{-0.5, -0.5, -0.5, 0.5, 0.5, -7/16},
			{-0.5, -0.5, 0.5, 0.5, 0.5, 7/16},
		},
		["_pit"] = {
			{ -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
			{ -0.5, -0.5, -7/16, 0.5, -7/16, 7/16 },
			{ -0.5, -0.5, 7/16, 0.5, 0.5, 0.5 },
			{ -0.5, -7/16, -7/16, -7/16, 0.5, 7/16 },
			{ -7/16, 0.5, -7/16, 0.5, 7/16, 7/16 },
		},
		["_pit_half"] = {
			{ -0.5, -0.5, -0.5, 0.0, 0.5, -7/16 },
			{ -0.5, -0.5, -7/16, 0.0, -7/16, 7/16 },
			{ -0.5, -0.5, 7/16, 0.0, 0.5, 0.5 },
			{ -0.5, -7/16, -7/16, -7/16, 0.5, 7/16 },
			{ -7/16, 0.5, -7/16, 0.0, 7/16, 7/16 },
		},
		["_hole_half"] = {
			{-0.5, -0.5, -0.5,  0.5,   0, -7/16},
			{-0.5, -0.5, 0.5,   0.5,   0, 7/16},
			{-0.5, -0.5, -7/16, -7/16, 0, 7/16},
			{0.5, -0.5, -7/16,  7/16,  0, 7/16},
		}
	},
	["slope"] = {
		[""] = {
			mesh = "moreblocks_slope.obj",
			collision_box = box_slope,
			selection_box = box_slope,

		},
		["_half"] = {
			mesh = "moreblocks_slope_half.obj",
			collision_box = box_slope_half,
			selection_box = box_slope_half,
		},
		["_half_lh"] = get_microblock_def("slope_half_lh", {
				{-0.5, -0.5,   -0.5,  0, -0.375, 0.5},
				{-0.5, -0.375, -0.25, 0, -0.25,  0.5},
				{-0.5, -0.25,  0,    0, -0.125, 0.5},
				{-0.5, -0.125, 0.25, 0,  0,     0.5},
		}),
		["_half_rh"] = get_microblock_def("slope_half_rh", {
				{0, -0.5,   -0.5,  0.5, -0.375, 0.5},
				{0, -0.375, -0.25, 0.5, -0.25,  0.5},
				{0, -0.25,  0,    0.5, -0.125, 0.5},
				{0, -0.125, 0.25, 0.5,  0,     0.5}
		}),
		["_half_raised_lh"] = get_microblock_def("slope_half_raised_lh", {
				{-0.5, -0.5,   -0.5,  0, 0.125, 0.5},
				{-0.5, 0.125, -0.25, 0, 0.25,  0.5},
				{-0.5, 0.25,  0,    0, 0.375, 0.5},
				{-0.5, 0.375, 0.25, 0,  0.5,     0.5},
		}),
		["_half_raised_rh"] = get_microblock_def("slope_half_raised_rh", {
				{0, -0.5,   -0.5,  0.5, 0.125, 0.5},
				{0, 0.125, -0.25, 0.5, 0.25,  0.5},
				{0, 0.25,  0,    0.5, 0.375, 0.5},
				{0, 0.375, 0.25, 0.5,  0.5,     0.5},
		}),
		["_half_raised"] = {
			mesh = "moreblocks_slope_half_raised.obj",
			collision_box = box_slope_half_raised,
			selection_box = box_slope_half_raised,
		},
		["_astair_1"] = get_microblock_def("astair_1", {
				{-0.5, -0.5, -0.5, -0.25, 0, 0.5},
				{-0.25, -0.5, -0.25, 0, 0, 0.5},
				{0, -0.5, 0, 0.25, 0, 0.5},
				{0.25, -0.5, 0.25, 0.5, 0, 0.5},
				{-0.5, 0, 0, -0.25, 0.5, 0.5},
				{-0.25, 0, 0.25, 0, 0.5, 0.5}
		}),
		["_astair_2"] = get_microblock_def("astair_2", {
				{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
				{-0.5, 0, -0.5, -0.25, 0.5, 0.5},
				{-0.25, 0, -0.25, 0, 0.5, 0.5},
				{0, 0, 0, 0.25, 0.5, 0.5},
				{0.25, 0, 0.25, 0.5, 0.5, 0.5},
		}),
		["_astair_3"] = get_microblock_def("astair_3", {
				{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
				{-0.5, 0, 0, -0.25, 0.5, 0.5},
				{-0.25, 0, 0.25, 0, 0.5, 0.5}
		}),
		["_astair_4"] = get_microblock_def("astair_4", {
				{-0.5, -0.5, -0.5, 0, 0, 0.5},
				{0, -0.5, -0.25, 0.25, 0, 0.5},
				{0.25, -0.5, 0, 0.5, 0, 0.5},
				{-0.5, 0, 0, -0.25, 0.5, 0.5},
				{-0.25, 0, 0.25, 0, 0.5, 0.5}
		}),

		--==============================================================

		["_inner"] = {
			mesh = "moreblocks_slope_inner.obj",
			collision_box = box_slope_inner,
			selection_box = box_slope_inner,
		},
		["_inner_half"] = {
			mesh = "moreblocks_slope_inner_half.obj",
			collision_box = box_slope_inner_half,
			selection_box = box_slope_inner_half,
		},
		["_inner_half_raised"] = {
			mesh = "moreblocks_slope_inner_half_raised.obj",
			collision_box = box_slope_inner_half_raised,
			selection_box = box_slope_inner_half_raised,
		},

		--==============================================================

		["_inner_cut"] = {
			mesh = "moreblocks_slope_inner_cut.obj",
			collision_box = box_slope_inner,
			selection_box = box_slope_inner,
		},
		["_inner_cut2"] = get_microblock_def("slope_inner_cut2", {
				{-0.5,  -0.5,  -0.5, 0.5,   0, 0.5},
				{-0.5,  0,  -0.5, 0.25,   0.25,  0.5},
				{-0.5, 0.25, -0.5, 0, 0.5, 0.5},
				{0.25, 0, -0.25, 0.5, 0.25, 0.5},
				{0, 0.25, 0, 0.5, 0.5, 0.5}
		}),
		["_inner_cut3"] = get_microblock_def("slope_inner_cut3", {
				{-0.5,  -0.5,  -0.5, 0.5,   0, 0.5},
				{-0.5, 0, -0.5, 0, 0.5, 0.5},
				{0, 0, 0, 0.5, 0.5, 0.5}
		}),
		["_inner_cut4"] = get_microblock_def("slope_inner_cut4", {
				{-0.5, -0.5, -0.5, 0, 0, 0.5},
				{0, -0.5, 0, 0.5, 0, 0.5},
				{-0.5, 0, -0.5, -0.25, 0.5, 0.5},
				{-0.25, 0, 0.25, 0.5, 0.5, 0.5}
		}),
		["_inner_cut5"] = get_microblock_def("slope_inner_cut5", {
				{-0.5, -0.5, -0.5, 0, 0, 0.5},
				{0, -0.5, 0, 0.5, 0, 0.5},
				{-0.5, 0, -0.5, -0.25, 0.5, 0.5},
				{-0.25, 0, 0.25, 0.5, 0.5, 0.5}
		}),
		["_inner_cut6"] = get_microblock_def("slope_inner_cut6", {
				{-0.5,  -0.5,  -0.5, 0.5,   0, 0.5},
				{-0.5,  0,  -0.5, 0.25,   0.25,  0.5},
				{-0.5, 0.25, -0.5, 0, 0.5, 0.5},
				{0.25, 0, -0.25, 0.5, 0.25, 0.5},
				{0, 0.25, 0, 0.5, 0.5, 0.5}
		}),
		["_inner_cut7"] = get_microblock_def("slope_inner_cut7", {
				{-0.5,  -0.5,  -0.5, 0.5,   0, 0.5},
				{-0.5, 0, -0.5, 0, 0.5, 0.5},
				{0, 0, 0, 0.5, 0.5, 0.5}
		}),
		["_inner_cut8"] = get_microblock_def("slope_inner_cut8", {
				{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
				{-0.5, 0, -0.5, 0, 0.5, 0.5},
				{-0.5, 0, 0, 0.5, 0.5, 0.5},
				{0, 0, -0.25, 0.25, 0.5, 0}
		}),
		["_inner_cut_half"] = {
			mesh = "moreblocks_slope_inner_cut_half.obj",
			collision_box = box_slope_inner_half,
			selection_box = box_slope_inner_half,
		},
		["_inner_cut_half_raised"] = {
			mesh = "moreblocks_slope_inner_cut_half_raised.obj",
			collision_box = box_slope_inner_half_raised,
			selection_box = box_slope_inner_half_raised,
		},

		--==============================================================

		["_outer"] = {
			mesh = "moreblocks_slope_outer.obj",
			collision_box = box_slope_outer,
			selection_box = box_slope_outer,
		},
		["_outer_half"] = {
			mesh = "moreblocks_slope_outer_half.obj",
			collision_box = box_slope_outer_half,
			selection_box = box_slope_outer_half,
		},
		["_outer_half_raised"] = {
			mesh = "moreblocks_slope_outer_half_raised.obj",
			collision_box = box_slope_outer_half_raised,
			selection_box = box_slope_outer_half_raised,
		},

		--==============================================================

		["_outer_cut"] = {
			mesh = "moreblocks_slope_outer_cut.obj",
			collision_box = box_slope_outer,
			selection_box = box_slope_outer,
		},
		["_outer_cut_half"] = {
			mesh = "moreblocks_slope_outer_cut_half.obj",
			collision_box = box_slope_outer_half,
			selection_box = box_slope_outer_half,
		},
		["_outer_cut_half_raised"] = {
			mesh = "moreblocks_slope_outer_cut_half_raised.obj",
			collision_box = box_slope_outer_half_raised,
			selection_box = box_slope_outer_half_raised,
		},
		["_cut"] = {
			mesh = "moreblocks_slope_cut.obj",
			collision_box = box_slope_outer,
			selection_box = box_slope_outer,
		},
		["_cut2"] = get_microblock_def("xslopes_cut", {
				{-0.5,     -0.5,     0, 0.5,  0.25, 0.5},
				{-0.5,  0.25,  0.25, 0.5,   0.5, 0.5}
		}),
		["_lh"] = get_microblock_def("slope_lh", {
				{-0.5,  -0.5,  -0.5, 0, -0.25, 0.5},
				{-0.5, -0.25, -0.25, 0,     0, 0.5},
				{-0.5,     0,     0, 0,  0.25, 0.5},
				{-0.5,  0.25,  0.25, 0,   0.5, 0.5}
		}),
		["_rh"] = get_microblock_def("slope_rh", {
				{0,  -0.5,  -0.5, 0.5, -0.25, 0.5},
				{0, -0.25, -0.25, 0.5,     0, 0.5},
				{0,     0,     0, 0.5,  0.25, 0.5},
				{0,  0.25,  0.25, 0.5,   0.5, 0.5}
		}),
		["_peak_half_lh"] = get_microblock_def("xslopes_peak_half_lh", {
				{-0.5,  -0.5,  -0.5, 0, -0.25, -0.25},
				{-0.5, -0.5, -0.25, 0,     0, 0},
				{-0.5,  -0.5,     0, 0,  0, 0.25},
				{-0.5,  -0.5,  0.25, 0,   -0.25, 0.5}
		}),
		["_peak_half"] = get_microblock_def("xslopes_peak_half", {
				{-0.5,  -0.5,  -0.5, 0.5, -0.25, -0.25},
				{-0.5, -0.5, -0.25, 0.5,     0, 0},
				{-0.5,  -0.5,     0, 0.5,  0, 0.25},
				{-0.5,  -0.5,  0.25, 0.5,   -0.25, 0.5}
		}),
		["_peak_lh"] = get_microblock_def("xslopes_peak_lh", {
				{-0.5,  -0.5,  -0.5, 0, 0, -0.25},
				{-0.5, -0.5, -0.25, 0,     0.5, 0},
				{-0.5,  -0.5,     0, 0,  0.5, 0.25},
				{-0.5,  -0.5,  0.25, 0,   0, 0.5}
		}),
		["_peak"] = get_microblock_def("xslopes_peak", {
				{-0.5,  -0.5,  -0.5, 0.5, 0, -0.25},
				{-0.5, -0.5, -0.25, 0.5,     0.5, 0},
				{-0.5,  -0.5,     0, 0.5,  0.5, 0.25},
				{-0.5,  -0.5,  0.25, 0.5,   0, 0.5}
		}),
		["_quarter"] = get_microblock_def("xslopes_quarter", {
				{-0.5, -0.5, -0.5, -0.25, -0.25, 0},
				{-0.5, -0.5, 0, 0, 0, 0.5}
		}),
		["_quarter2"] = get_microblock_def("xslopes_quarter2", {
				{0.25, -0.5, -0.5, 0.5, -0.25, 0},
				{0, -0.5, 0, 0.25, 0, 0.5}
		}),
		["_slope_lh"] = get_microblock_def("xslopes_slope_lh", {
				{-0.5, -0.5, 0, 0, -0.25, 0.5},
				{-0.5, -0.25, 0.25, 0, 0, 0.5}
		}),
		["_slope_rh"] = get_microblock_def("xslopes_slope_rh", {
				{0, -0.5, 0, 0.5, -0.25, 0.5},
				{0, -0.25, 0.25, 0.5, 0, 0.5}
		}),
		["_slope"] = get_microblock_def("xslopes_slope", {
				{-0.5, -0.5, 0, 0.5, -0.25, 0.5},
				{-0.5, -0.25, 0.25, 0.5, 0, 0.5}
		}),
		["_three_quarter_half"] = get_microblock_def("xslopes_three_quarter_half", {
				{-0.5, -0.5, 0, 0.25, 0.25, 0.5},
				{-0.5, 0.25, 0.25, 0.5, 0.5, 0.5},
				{0.25, -0.5, 0.25, 0.5, 0.5, 0.5}
		}),
		["_three_quarter"] = get_microblock_def("xslopes_three_quarter", {
				{-0.5, -0.5, -0.5, 0, 0, -0.25},
				{-0.5, -0.5, -0.25, 0.25, 0.25, 0.25},
				{-0.5, -0.5, 0.25, 0.5, 0.5, 0.5}
		}),
		["_sloped_slat"] = get_microblock_def("sloped_slat", {
				{-0.5, -0.5, -0.15, -0.25, -0.25, 0.15},
				{-0.25, -0.25, -0.15, 0, 0, 0.15},
				{0, 0, -0.15, 0.25, 0.25, 0.15},
				{0.25, 0.25, -0.15, 0.5, 0.5, 0.15}
		}),
		["_vertical_slat"] = get_microblock_def("vertical_inclined_slat", {-0.15, -0.5, -0.15, 0.15, 0.5, 0.15}),
		["_vertical_inclined_slat"] = get_microblock_def("vertical_slat", {-0.15, -0.5, -0.15, 0.15, 0.9, 0.15}),
		["_horizontal_slat"] = get_microblock_def("horizontal_slat", {-0.5, -0.5, -0.15, 0.5, -0.2, 0.15}),
		["_horizontal_corner_slat"] = get_microblock_def("horizontal_corner_slat", {
				{-0.5, -0.5, -0.15, 0.15, -0.2, 0.15},
				{-0.15, -0.5, -0.5, 0.15, -0.2, 0.15}
		}),
		["_horizontal_folded_slat"] = get_microblock_def("horizontal_folded_slat", {-0.5, -0.5, -0.15, 0.5, -0.2, 0.15}),
		["_inclined_folded_slat"] = get_microblock_def("inclined_folded_slat", {
				{-0.5, -0.5, -0.15, -0.25, -0.25, 0.15},
				{-0.25, -0.25, -0.15, 0, 0, 0.15},
				{0, 0, -0.15, 0.25, 0.25, 0.15},
				{0.25, 0.25, -0.15, 0.5, 0.5, 0.15}
		}),
		["_inclined_slat_lh"] = get_microblock_def("inclined_slat_lh", {
				{-0.15, -0.5, -0.5, 0.15, 0, -0.15},
				{-0.15, -0.25, -0.15, 0.15, 0.25, 0.15},
				{0.15, 0.25, -0.15, 0.5, 0.5, 0.15}
		}),
		["_inclined_slat_rh"] = get_microblock_def("inclined_slat_rh", {
				{-0.15, -0.5, 0.5, 0.15, 0, 0.15},
				{-0.15, -0.25, -0.15, 0.15, 0.25, 0.15},
				{0.15, 0.25, -0.15, 0.5, 0.5, 0.15}
		}),
	},
	["stair"] = {
		[""] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
					{-0.5, 0, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_half"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0, 0, 0.5},
					{-0.5, 0, 0, 0, 0.5, 0.5},
				},
			},
		},
		["_right_half"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{0, -0.5, -0.5, 0.5, 0, 0.5},
					{0, 0, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_half_1"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, -7/16, 0, 0.5},
					{-0.5, 0, 0, -7/16, 0.5, 0.5},
				},
			},
		},
		["_right_half_1" ]= {
			node_box = {
				type = "fixed",
				fixed = {
					{7/16, -0.5, -0.5, 0.5, 0, 0.5},
					{7/16, 0, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_inner"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
					{-0.5, 0, 0, 0.5, 0.5, 0.5},
					{-0.5, 0, -0.5, 0, 0.5, 0},
				},
			},
		},
		["_outer"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
					{-0.5, 0, 0, 0, 0.5, 0.5},
				},
			},
		},
		["_alt"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0, 0},
					{-0.5, 0, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_alt_1"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.0625, -0.5, 0.5, 0, 0},
					{-0.5, 0.4375, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_alt_2"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.125, -0.5, 0.5, 0, 0},
					{-0.5, 0.375, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_alt_4"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.25, -0.5, 0.5, 0, 0},
					{-0.5, 0.25, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_alt_5"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.0625, 0.0, 0.5, 0, 0.5},
					{-0.5, 0.4375, 0, 0.5, 0.5, 0.5},
				},
			},
		},
		["_alt_6"] = {
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.0625, -0.5, 0.5, 0, 0.5},
					{-0.5, 0.4375, -0.5, 0.5, 0.5, 0.5},
				},
			},
		}
	},
}

for type,a in pairs(stairsplus.defs) do
	for name,b in pairs(stairsplus.defs[type]) do
		table.insert(stairsplus.shapes_list, { type .. "_", name })
	end
end
