superquest.hud = {}

superquest.hud.show_popup = function(player, text)
    local bg = player:hud_add({
        hud_elem_type = "image",
        name = "message_bg",
        scale = { x = 5, y = 5 },
        text = "message_bg.png",
        position = { x = 0.5, y = 0.1 },
        offset = { x = 0, y = 0 },
        alignment = { x = 0, y = 0 }
    })

    local msg = player:hud_add({
        player = "text",
        name = "message_text",
        scale = { x = 100, y = 100 },
        number = 0xFFFFFF,
        text = text,
        position = { x = 0.5, y = 0.1 },
        offset = { x = 0, y = 0 },
        alignment = { x = 0, y = 0 },
        size = { x = 2 },
        style = 5
    })

    minetest.after(3, function()
        player:hud_remove(msg)
        player:hud_remove(bg)
    end)
end

superquest.hud.show_waypoints = function(player, waypoints)
    local huds = {}

    for k, v in pairs(waypoints) do
        huds[k] = player:hud_add({
            hud_elem_type = "waypoint",
            name = v.name,
            number = v.color,
            world_pos = k
        })
    end

    minetest.after(10, function()
        for k, _ in pairs(huds) do
            player:hud_remove(huds[k])
        end
    end)
end