# SuperQuest
A Minetest mod that allows to create active quests and challenges.

![Screenshot](/screenshot.png)

## Nodes
The mod contains the following nodes:

- Flag
- Quest Machine
- Flat Quest Machine

## Completing quests
To complete a quest, you need to punch all the flags which belong to the quest. To get a reward, after punching all the flags, you need to punch a quest machine which belongs to the quest (network). Reward for the first completion might be different from reward for further completions. If the quest machine's internal inventory does not contain enough items, you won't be able to get the reward until it will be refilled. The maximum number of completions of a quest for one player might be restricted.
Flags can also be triggered automatically when a player entered a cubic area around the flag specified in the flag's configuration, if the feature is enabled in mod's config. It was decided to use a cubic area instead of a spherical one to make it more customizable. Need to mention that in some time flags might not be triggered when the player entered the area. This might happen because of a big lag or the player entered it for a very short time (scanning occurs periodically, once per second by default); in this case, the flag should be punched manually.

By right-clicking a quest machine, you can see:

 - How many flags you punched, and the total number of flags
 - Which reward you will get for completing the quest
 - How many rewards are currently available
 - How many times you completed the quest
 - The maximum number of completions to get a reward (0 = infinity)

Need to mention that the number of available rewards for first and further completions are calculated based on the shared inventory of the Quest Machine, thus, if rewards for first and further completions contain the same items, receiving reward for the first completion might also affect the number of available rewards for the further completions, and vice versa.

## Creating quests
After placing flags or quest machines the placer becomes the owner of the node.

All flags and quest machines which belong to the same quest, must be assigned to the same network name. Under the hood, owner's name is also included into the network's name to prevent other players from altering the network. It's forbidden to use the # symbol in network name since it's reserver for internal usage.

Right-clicking flags and quest machines displays menu in which the nodes can be configured. Flag's menu allows to:

 - Specify network's name
 - Specify coordinates of a cubic area, entering which automatically activates the flag for the player (if automatic triggering is enabled in the server's setting)

The cubic area is specified by the means of the "From coords" and "To coords" fields which accept relative coordinates of two opposite angles of the cube relative to the flag's coordinates in the format x,y,z (for example, 8,5,7). All the values should be non-negative. Values in "From coords" are subtracted from the flag's coordinates while values in "To coords" are added to them.

Menu of Quest Machine allows to:

 - Specify network's name
 - Specify the maximum number of completions
 - Specify rewards
 - Manipulate Quest Machine's inventory
 - Switch to user mode, and vice versa
 - See the number of flags in the network
 - See the number of available rewards

Ownership doesn't protect flags and quest machines from digging by other players. That's because flags and quest machines should be placed in protected areas anyway. Creating quest in unprotected areas might lead to possibility for players to modify the quest itself. This approach might also be reconsidered.

You can test your quests by switching to the user mode in the Quest Machine.

### Chat commands

List names of networks of the current user:
```
/superquest list_my_networks
```

List all the elements of a particular network of the current user:
```
/superquest list_my_network_elements <network_name>
```

## Administrating quests

Players with the "superquest_admin" privilege are allowed to edit all quests, including quests owned by other players. This privilege also gives access to administrative chat commands.

### Administrative chat commands

List players which own networks:
```
/superquest_admin list_owners
```

List networks of a player:
```
/superquest_admin list_player_networks <player_name>
```

List elements of a network of a player:
```
/superquest_admin list_player_network_elements <player_name>#<network_name>
```