package.path = "../?.lua;" .. package.path

dofile('tests/mut.lua')

insulate("Nodes", function()
    dofile('init.lua')

    local player = mut.create_player("user1", {
        pos = vector.new(0, 0, 0)
    })

    it("Flag basic handlers", function()
        local node = mut.place_node(vector.new(2, 2, 2), {
            stack = ItemStack("superquest:flag"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        local meta = minetest.get_meta(node.pos)
        assert(meta:get_string("owner") == "user1")
        assert(not meta:contains("network"))

        mut.rightclick_node(node.pos, {
            clicker = player,
        })

        assert(mut.is_formspec_active(player.name, "superquest:flag_settings"))

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        mut.punch_node(node.pos, player)

        assert(mut.dig_node(node.pos, player))
    end)

    it("Quest Machine basic handlers", function()
        local node = mut.place_node(vector.new(2, 2, 2), {
            stack = ItemStack("superquest:reward_box"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        local meta = minetest.get_meta(node.pos)
        assert(meta:get_string("owner") == "user1")
        assert(not meta:contains("network"))

        mut.rightclick_node(node.pos, {
            clicker = player,
        })

        assert(mut.is_formspec_active(player.name, "superquest:reward_box_owner"))

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            max_completions = "0",
        })

        mut.punch_node(node.pos, player)

        assert(mut.dig_node(node.pos, player))
    end)
end)
