superquest.hud = {}

local current_popups = {}

local function remove_popup_for_player(player_name, popup)
    if not popup or current_popups[player_name] ~= popup then
        -- The popup was already removed
        return
    end

    local player = minetest.get_player_by_name(player_name)

    if player then
        player:hud_remove(popup.msg)
        player:hud_remove(popup.bg)
    end

    current_popups[player_name] = nil
end

superquest.hud.show_popup = function(player, text)
    local player_name = player:get_player_name()

    remove_popup_for_player(player_name, current_popups[player_name])

    local bg = player:hud_add({
        type = "image",
        name = "message_bg",
        scale = { x = 5, y = 5 },
        text = "message_bg.png",
        position = { x = 0.5, y = 0.1 },
        offset = { x = 0, y = 0 },
        alignment = { x = 0, y = 0 }
    })

    local msg = player:hud_add({
        type = "text",
        name = "message_text",
        scale = { x = 100, y = 100 },
        number = 0xFFFFFF,
        text = text,
        position = { x = 0.5, y = 0.1 },
        offset = { x = 0, y = 0 },
        alignment = { x = 0, y = 0 },
        size = { x = 2 },
        style = 5
    })

    current_popups[player_name] = {
        msg = msg,
        bg = bg,
    }

    minetest.after(3, remove_popup_for_player, player_name, current_popups[player_name])
end

local TimerHudBase = {}

TimerHudBase.set_time = function(self, seconds)
    local player = minetest.get_player_by_name(self._player_name)
    if not player then
        return
    end

    if self._hud then
        player:hud_remove(self._hud)
    end

    self._hud = player:hud_add({
        type = "text",
        name = "timer_text",
        number = 0xFFFFFF,
        text = superquest.utils.seconds_to_timer_string(seconds),
        position = { x = 1, y = 1 },
        offset = { x = -10, y = -10 },
        alignment = { x = -1, y = -1 },
        size = { x = 2 },
        style = 5
    })
end

TimerHudBase.remove = function(self)
    local player = minetest.get_player_by_name(self._player_name)
    if player and self._hud then
        player:hud_remove(self._hud)
        self._hud = nil
    end
end

TimerHudBase.__index = TimerHudBase

superquest.hud.TimerHud = function(player_name)
    local data = {
        _player_name = player_name,
    }
    setmetatable(data, TimerHudBase)
    return data
end

superquest.hud.show_waypoints = function(player, waypoints)
    local huds = {}

    for k, v in pairs(waypoints) do
        huds[k] = player:hud_add({
            type = "waypoint",
            name = v.name,
            number = v.color,
            world_pos = k
        })
    end

    local name = player:get_player_name()

    minetest.after(10, function()
        local player = minetest.get_player_by_name(name)

        if player then
            for k, _ in pairs(huds) do
                player:hud_remove(huds[k])
            end
        end
    end)
end
