superquest.teleportation = {}

local teleport_to_per_player = {}

local DestinationType = {
    QUEST_MACHINE = {},
}

superquest.teleportation.set_tp_dest_to_quest_machine = function(player_name, owner, network, reset_after_tp)
    teleport_to_per_player[player_name] = {
        type = DestinationType.QUEST_MACHINE,
        owner = owner,
        network = network,
        reset_after_tp = reset_after_tp
    }
end

superquest.teleportation.reset_tp_destination = function(player_name)
    teleport_to_per_player[player_name] = nil
end

local function is_suitable_for_tp(node_name)
    if node_name == "ignore" then
        return false
    end
    local node_def = minetest.registered_nodes[node_name]
    return node_def.drawtype == "airlike" or node_def.walkable == false
end

superquest.teleportation.teleport_to_destination = function(player_name)
    local tp_dest = teleport_to_per_player[player_name]
    if not tp_dest then
        return
    end

    local tp_dest_pos = nil
    if tp_dest.type == DestinationType.QUEST_MACHINE then
        tp_dest_pos = superquest.reward_box.get_tp_destination(tp_dest.owner, tp_dest.network)
    end

    if tp_dest_pos == nil then
        return
    end

    local node_dest = superquest.utils.get_node(tp_dest_pos)
    if not is_suitable_for_tp(node_dest.name) then
        return
    end

    local node_dest_below = superquest.utils.get_node(tp_dest_pos + vector.new(0, -1, 0))
    local node_dest_above = superquest.utils.get_node(tp_dest_pos + vector.new(0, 1, 0))
    -- It's OK if one of them is not suitable but not both
    if not is_suitable_for_tp(node_dest_below.name) and not is_suitable_for_tp(node_dest_above.name) then
        return
    end

    local player = minetest.get_player_by_name(player_name)
    if player then
        player:set_pos(tp_dest_pos)
    end

    if tp_dest.reset_after_tp then
        superquest.teleportation.reset_tp_destination(player_name)
    end
end

minetest.register_on_leaveplayer(function(player)
    superquest.teleportation.reset_tp_destination(player:get_player_name())
end)
