local S = superquest.S

superquest.quest_machine.formspec.user = {}

local form_name_user = minetest.get_current_modname()..":quest_machine_user"

local pos_to_formspec_inv_loc = superquest.utils.pos_to_formspec_inv_loc

local node_positions = {}

local function get_formspec_for_user(pos, params)
    local completions_str = tostring(params.completions)
    if params.max_completions ~= 0 then
        completions_str = completions_str.." / "..params.max_completions
    end

    local formspec_data =
            "formspec_version[4]" ..
            "size[10.75,10.5]" ..
            "container[0.5,0]"..
            "label[0,0.5;"..S("Owner")..": "..minetest.formspec_escape(params.owner).."]" ..
            "label[0,1;"..S("Network")..": "..minetest.formspec_escape(params.network).."]" ..
            "label[0,1.5;"..S("Your completions")..": "..minetest.formspec_escape(completions_str).."]"..
            "label[0,2;"..S("Flags reached")..": "..minetest.formspec_escape(params.reached_flags.." / "..params.total_flags).."]"
    if params.timed_duration ~= 0 then
        local seconds = params.timed_duration
        formspec_data = formspec_data..
            "label[0,2.5;"..S("Duration")..": "..minetest.formspec_escape(superquest.utils.seconds_to_timer_string(seconds)).."]"..
            "button_exit[5,0.5;4.5,2;start;"..S("Start").."]"..
            "container[0,3.3]"
    else
        formspec_data = formspec_data..
            "container[0,2.8]"
    end
    formspec_data = formspec_data ..
            "label[0,0;"..S("Reward for first completion")..":]"..
            "list["..pos_to_formspec_inv_loc(pos)..";first_compl_rewards;0,0.3;8,1]"..
            "label[0,1.6;"..S("Available")..": "..minetest.formspec_escape(params.available_rewards.first_compl_rewards).."]"..
            "label[0,2.3;"..S("Reward for further completions")..":]"..
            "list["..pos_to_formspec_inv_loc(pos)..";further_compl_rewards;0,2.6;8,1]"..
            "label[0,3.9;"..S("Available")..": "..minetest.formspec_escape(params.available_rewards.further_compl_rewards).."]"..
            "button_exit[0,4.2;9.75,0.8;close;"..S("Close").."]"..
            "button[0,5.2;9.75,0.8;completions;"..S("Show completions").."]"
    if params.owner_mode_avail then
        formspec_data = formspec_data..
            "button[0,6.2;9.75,0.8;owner_mode;"..S("Owner mode").."]"
    end
    formspec_data = formspec_data ..
            "container_end[]"..
            "container_end[]"

    return formspec_data
end

superquest.quest_machine.formspec.user.show = function(player_name, pos, params)
    node_positions[player_name] = pos
    minetest.show_formspec(player_name, form_name_user,
        get_formspec_for_user(pos, params)
    )
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= form_name_user or not (player and player:is_player()) then
        return
    end

    local player_name = player:get_player_name()

    local pos = node_positions[player_name]
    if pos == nil then
        return
    end

    if fields.owner_mode then
        superquest.quest_machine.logic.set_mode(player, pos, false)
    elseif fields.completions then
        superquest.quest_machine.logic.show_completions(player_name, pos)
    elseif fields.start then
        superquest.quest_machine.logic.start_quest(player, pos)
    end
end)
