local S = superquest.S

superquest.quest_machine.formspec.owner = {}

local form_name_owner = minetest.get_current_modname()..":quest_machine_owner"

local pos_to_formspec_inv_loc = superquest.utils.pos_to_formspec_inv_loc

local node_positions = {}

local function get_formspec_for_owner(pos, params)
    local formspec_data =
        "formspec_version[4]" ..
        "size[22,13.3]"..
        "container[0.5,0.0]"
    if params.can_edit_owner then
        formspec_data = formspec_data ..
            "field[0,0.5;9.75,0.8;owner;"..S("Owner")..";"..minetest.formspec_escape(params.owner).."]"
    else
        formspec_data = formspec_data ..
            "label[0,0.8;"..S("Owner")..": "..minetest.formspec_escape(params.owner).."]"
    end
    formspec_data = formspec_data ..
        "field[11,0.5;9.75,0.8;timed_duration;"..S("Duration in seconds (0 @=@= unlimited)")..";"..minetest.formspec_escape(tostring(params.timed_duration)).."]"..
        "field[0,1.8;9.75,0.8;network;"..S("Network")..";"..minetest.formspec_escape(params.network).."]" ..
        "field[11,1.8;9.75,0.8;max_completions;"..S("Max completions per user (0 @=@= infinite)")..";"..minetest.formspec_escape(params.max_completions).."]"..
        "container[0,3.1]"..
        "label[0,0;"..S("Reward for first completion")..":]"..
        "list["..pos_to_formspec_inv_loc(pos)..";first_compl_rewards;0,0.2;8,1]"..
        "label[0,1.5;"..S("Available: @1 (reopen the form to see the updated value)", minetest.formspec_escape(params.available_rewards.first_compl_rewards)).."]"..
        "label[11,0;"..S("Reward for further completions")..":]"..
        "list["..pos_to_formspec_inv_loc(pos)..";further_compl_rewards;11,0.2;8,1]"..
        "label[11,1.5;"..S("Available: @1 (reopen the form to see the updated value)", minetest.formspec_escape(params.available_rewards.further_compl_rewards)).."]"..
        "label[0,2.2;"..S("Quest Machine inventory")..":]"..
        "list["..pos_to_formspec_inv_loc(pos)..";reward_box_storage;0,2.4;8,4;]"..
        "label[11,2.2;"..S("Your inventory")..":]"..
        "list[current_player;main;11,2.4;8,4;]"..
        "listring[]"..
        "label[0,7.7;"..S("Flags in network")..": "..minetest.formspec_escape(params.total_flags).."]"
    if superquest.config.teleportation then
        formspec_data = formspec_data ..
            "checkbox[11,7.7;teleport_after_compl;"..S("Teleport to the Quest Machine after completion")..";"..tostring(params.teleport_after_compl).."]"
    end
    formspec_data = formspec_data ..
        "container[0,8.2]"..
        "button_exit[0,0;20.75,0.8;save;"..S("Save").."]"..
        "button[0,1;10,0.8;completions;"..S("Show completions").."]"..
        "button[10.75,1;10,0.8;user_mode;"..S("User mode").."]"..
        "container_end[]"..
        "container_end[]"..
        "container_end[]"

    return formspec_data
end

local teleport_after_compl_temp = {}

superquest.quest_machine.formspec.owner.show = function(player_name, pos, params)
    if superquest.config.teleportation then
        teleport_after_compl_temp[player_name] = {
            pos = pos,
            value = params.teleport_after_compl
        }
    end

    node_positions[player_name] = pos

    minetest.show_formspec(player_name, form_name_owner,
        get_formspec_for_owner(pos, params)
    )
end

local timed_quest_max_duration = superquest.config.timed_quest_max_duration * 3600

local function save_input_validate_and_convert(player_name, fields)
    local data = {}

    if not fields.network or not fields.max_completions or not fields.timed_duration then
        return nil
    end

    data.new_network_name = fields.network:gsub('^%s*(.-)%s*$', '%1')
    data.max_completions = tonumber(fields.max_completions)
    data.timed_duration = tonumber(fields.timed_duration)

    if data.max_completions == nil or data.max_completions < 0 or data.max_completions > 1000000 or data.max_completions % 1 ~= 0 then
        minetest.chat_send_player(player_name, S("Incorrect max completions value! The value should be an integer between 0 and 1000000!"))
        return nil
    end

    if data.timed_duration == nil or data.timed_duration < 0 or data.timed_duration > timed_quest_max_duration or data.timed_duration % 1 ~= 0 then
        minetest.chat_send_player(player_name, S("Incorrect duration value! The value should be an integer between 0 and @1!", timed_quest_max_duration))
        return nil
    end

    if data.timed_duration == 0 then
        data.timed_duration = nil
    end

    if data.new_network_name:len() > superquest.config.max_network_name_length then
        minetest.chat_send_player(player_name, S("Max network name length (@1 symbols) exceeded", superquest.config.max_network_name_length))
        return nil
    end
    if data.new_network_name:find("#") then
        minetest.chat_send_player(player_name, S("Using the '#' symbol is not allowed in the network name"))
        return nil
    end

    if fields.owner then
        data.new_owner = fields.owner:gsub('^%s*(.-)%s*$', '%1')

        if data.new_owner:len() > superquest.config.max_owner_name_length then
            minetest.chat_send_player(player_name, S("Max owner name length (@1 symbols) exceeded", superquest.config.max_owner_name_length))
            return nil
        end
        if data.new_owner:find("#") then
            minetest.chat_send_player(player_name, S("Using the '#' symbol is not allowed in the owner name"))
            return nil
        end
    end

    data.teleport_after_compl = fields.teleport_after_compl

    return data
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= form_name_owner or not (player and player:is_player()) then
        return
    end

    local player_name = player:get_player_name()

    local pos = node_positions[player_name]
    if pos == nil then
        return
    end

    local teleport_after_compl = false
    if superquest.config.teleportation then
        if fields.teleport_after_compl ~= nil then
            teleport_after_compl_temp[player_name] = {
                value = (fields.teleport_after_compl == "true"),
                pos = pos
            }
            return
        end

        if teleport_after_compl_temp[player_name] then
            if teleport_after_compl_temp[player_name].pos == pos then
                fields.teleport_after_compl = teleport_after_compl_temp[player_name].value
            end
            teleport_after_compl_temp[player_name] = nil
        end
    end

    local meta = minetest.get_meta(pos)
    local owner = meta:get_string("owner")

    if owner ~= player_name and not superquest.privileges.can_edit_all(player_name) then
        return
    end

    if fields.user_mode then
        superquest.quest_machine.logic.set_mode(player, pos, true)
    elseif fields.save then
        local data = save_input_validate_and_convert(player_name, fields)
        if not data then
            return
        end

        superquest.quest_machine.logic.save_data(player, pos, data)
    elseif fields.completions then
        superquest.quest_machine.logic.show_completions(player, pos)
    end
end)
