local storage = minetest.get_mod_storage()

superquest.storage = {}

local cached_network = nil

-- Contains names and owners of all the networks (without additional data)
local networks_list = {}

local function parse_networks_list()
    networks_list = {}
    local data = storage:to_table().fields

    for k, _ in pairs(data) do
        local s, e = k:find("network#")

        if s == 1 then
            local owner_s = e + 1
            local delimiter_2 = k:find("#", owner_s)
            local owner_e = delimiter_2 - 1
            local network_s = delimiter_2 + 1

            local owner = k:sub(owner_s, owner_e)
            local network = k:sub(network_s)

            if networks_list[owner] == nil then
                networks_list[owner] = {}
            end

            networks_list[owner][network] = 1
        end
    end
end

parse_networks_list()

local function get_key(owner, network)
    -- The values shouldn't contain # anyway but we perform substitution just in case
    local _owner = owner:gsub("#", "_")
    local _network = network:gsub("#", "_")

    return "network#".._owner.."#".._network
end

superquest.storage.get_network_data = function(owner, network)
    local key = get_key(owner, network)

    local data;
    if not cached_network or cached_network.key ~= key then
        data = storage:get_string(key)
        if data == nil then
            return nil
        end

        cached_network = {
            key = key,
            data = minetest.deserialize(data)
        }
    end

    return cached_network.data
end

superquest.storage.set_network_data = function(owner, network, data)
    local key = get_key(owner, network)

    if networks_list[owner] == nil then
        networks_list[owner] = {}
    end

    if data == nil or next(data, nil) == nil then
        cached_network = nil
        storage:set_string(key, "")

        networks_list[owner][network] = nil
        if next(networks_list[owner], nil) == nil then
            networks_list[owner] = nil
        end
    else
        cached_network = {
            key = key,
            data = data
        }
        storage:set_string(key, minetest.serialize(data))
        networks_list[owner][network] = 1
    end
end

superquest.storage.get_networks_list = function()
    return networks_list
end

superquest.storage.coords_to_key = function(pos)
    return vector.to_string(pos)
end

superquest.storage.key_to_coords = function(key)
    return vector.from_string(key)
end

superquest.storage.set_active_timed_quests = function(data)
    if next(data) then
        storage:set_string("active_timed", minetest.serialize(data))
    else
        storage:set_string("active_timed", "")
    end
end

superquest.storage.get_active_timed_quests = function()
    local serialized_data = storage:get_string("active_timed")
    if serialized_data == "" then
        return {}
    end
    return minetest.deserialize(serialized_data)
end
