local S = superquest.S

superquest.quest_machine.formspec.completions = {}

local form_name_completions = core.get_current_modname()..":quest_machine_completions"

local node_positions = {}

local function get_completions_formspec(completions, is_owner)
    local formspec_data =
        "formspec_version[4]" ..
        "size[10,10]" ..
        "tablecolumns[text;text]" ..
        "table[0.5,0.5;9,7.3;compl_list;"
    for k, v in pairs(completions) do
        formspec_data = formspec_data .. core.formspec_escape(k) .. "," .. core.formspec_escape(v) .. ","
    end
    formspec_data = formspec_data .. ";1]"..
        "button_exit[0.5,8;9,0.8;close;"..S("Close").."]"
    if is_owner then
        formspec_data = formspec_data .. "button_exit[0.5,9;9,0.8;reset_completions;"..S("Reset Completions").."]"
    end

    return formspec_data
end

superquest.quest_machine.formspec.completions.show = function(player_name, pos, completions, is_owner)
    node_positions[player_name] = pos

    core.show_formspec(player_name, form_name_completions, get_completions_formspec(completions, is_owner))
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= form_name_completions or not (player and player:is_player()) then
        return
    end

    local player_name = player:get_player_name()

    local pos = node_positions[player_name]
    if pos == nil then
        return
    end

    if fields.reset_completions then
        superquest.quest_machine.logic.reset_completions(player, pos)
    end
end)
