# Development

## Source files at src/

### active_timed_quests.lua
Contains code responsible for management of active timed quests.

### commands.lua
Contains code responsible for chat commands.

### config.lua
Contains code for working with configuration.

### flag.lua
Implements flag node and all the underlying logic.

### hud.lua
Contains functions for displaying HUDs.

### init.lua
Entry point. Brings together all other files.

### migrations.lua
Contains code responsible for migrating to more recent versions of data format. It should run only on world start, check the format version on the sever, and if it's different from the format version in the current version of the mod, run the corresponding migrations.

### privileges.lua
Responsible for privileges.

### quest_machine/
Contains all the code related to Quest Machine.

### quest_machine/formspec/
Contains code which implements Quest Machine's formspecs. Each file within this directory corresponds to a particular formspec.

### quest_machine/logic.lua
Defines functions for handling different events related to Quest Machine and its formspecs.

### quest_machine/nodes.lua
Contains definition of Quest Machine's nodes (ordinary and flat) and the related code.

### quest_network.lua
Defines object which represents quest's network's data.

### storage.lua
Responsible for loading/saving data.

### timer_expiration.lua
Contains callback which is called on timer expiration.
(To do: allow to have different callbacks for different timers)

### timer.lua
Contains implementation of the timer object.
