superquest.utils = {}

function superquest.utils.seconds_to_timer_string(seconds)
    local hours = math.floor(seconds / 3600)
    local text
    if hours == 0 then
        text = string.format("%d:%02d", math.floor(seconds / 60), seconds % 60)
    else
        local seconds_no_h = seconds % 3600
        text = string.format("%d:%02d:%02d", hours, math.floor(seconds_no_h / 60), seconds_no_h % 60)
    end

    return text
end

function superquest.utils.get_node(pos)
    local node
    for i = 1, 5 do
        core.load_area(pos)
        node = core.get_node(pos)
        if node.name ~= "ignore" then
            break
        end
    end
    return node
end

function superquest.utils.pos_to_formspec_inv_loc(pos)
    return "nodemeta:"..pos.x..","..pos.y..","..pos.z
end
