local S = superquest.S

local function expiration_callback(player_name)
    local active_network = superquest.active_timed_quests:get_active_network_for_player(player_name)
    superquest.active_timed_quests:stop_and_remove(player_name)

    local network_obj = assert(superquest.Network(active_network.owner, active_network.network))

    network_obj:clear_reached_flags_for_player(player_name)

    if superquest.config.teleportation then
        if core.get_player_by_name(player_name) and network_obj:get_teleport_after_compl() then
            superquest.teleportation.set_tp_dest_to_quest_machine(player_name, active_network.owner, active_network.network, true)
            core.chat_send_player(player_name, S("Quest timeout expired").."! "..S("You can type '/superquest teleport' to teleport to the Quest Machine."))
        end
    end
end

superquest.timer.set_expiration_callback(expiration_callback)
