local S = superquest.S

superquest.quest_machine.formspec.user = {}

local form_name_user = core.get_current_modname()..":quest_machine_user"

local pos_to_formspec_inv_loc = superquest.utils.pos_to_formspec_inv_loc

local node_positions = {}

local function get_formspec_for_user(pos, params)
    local completions_str = tostring(params.completions)
    if params.max_completions ~= 0 then
        completions_str = completions_str.." / "..params.max_completions
    end

    local height_cur = 0
    local formspec_data = ""

    formspec_data = formspec_data ..
        "label[0,"..tostring(height_cur)..";"..S("Owner")..": "..core.formspec_escape(params.owner).."]"
    height_cur = height_cur + 0.5

    formspec_data = formspec_data ..
        "label[0,"..tostring(height_cur)..";"..S("Network")..": "..core.formspec_escape(params.network).."]"
    height_cur = height_cur + 0.5

    formspec_data = formspec_data ..
        "label[0,"..tostring(height_cur)..";"..S("Your completions")..": "..core.formspec_escape(completions_str).."]"
    height_cur = height_cur + 0.5

    formspec_data = formspec_data ..
        "label[0,"..tostring(height_cur)..";"..S("Flags reached")..": "..core.formspec_escape(params.reached_flags.." / "..params.total_flags).."]"
    height_cur = height_cur + 0.5

    if params.timed_duration ~= 0 then
        local seconds = params.timed_duration
        formspec_data = formspec_data..
            "label[0,"..tostring(height_cur)..";"..S("Duration")..": "..core.formspec_escape(superquest.utils.seconds_to_timer_string(seconds)).."]"..
            "button_exit[5,0;4.5,2;start;"..S("Start").."]"
        height_cur = height_cur + 0.5
    end

    height_cur = height_cur + 0.3

    formspec_data = formspec_data ..
        "container[0,"..tostring(height_cur).."]"..
        "label[0,0;"..S("Reward for first completion")..":]"..
        "list["..pos_to_formspec_inv_loc(pos)..";first_compl_rewards;0,0.3;8,1]"..
        "label[0,1.6;"..S("Available")..": "..core.formspec_escape(params.available_rewards.first_compl_rewards).."]"..
        "label[0,2.3;"..S("Reward for further completions")..":]"..
        "list["..pos_to_formspec_inv_loc(pos)..";further_compl_rewards;0,2.6;8,1]"..
        "label[0,3.9;"..S("Available")..": "..core.formspec_escape(params.available_rewards.further_compl_rewards).."]"..
        "container_end[]"
    height_cur = height_cur + 4.2

    formspec_data = formspec_data ..
        "button_exit[0,"..tostring(height_cur)..";9.75,0.8;close;"..S("Close").."]"
    height_cur = height_cur + 1

    formspec_data = formspec_data ..
        "button[0,"..tostring(height_cur)..";9.75,0.8;completions;"..S("Show completions").."]"
    height_cur = height_cur + 1

    if params.owner_mode_avail then
        formspec_data = formspec_data..
            "button[0,"..tostring(height_cur)..";9.75,0.8;owner_mode;"..S("Owner mode").."]"
        height_cur = height_cur + 1
    end

    formspec_data =
        "formspec_version[4]" ..
        "size[10.75,"..tostring(height_cur + 0.5).."]" ..
        "container[0.5,0.5]" ..
        formspec_data ..
        "container_end[]"

    return formspec_data
end

superquest.quest_machine.formspec.user.show = function(player_name, pos, params)
    node_positions[player_name] = pos
    core.show_formspec(player_name, form_name_user,
        get_formspec_for_user(pos, params)
    )
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= form_name_user or not (player and player:is_player()) then
        return
    end

    local player_name = player:get_player_name()

    local pos = node_positions[player_name]
    if pos == nil then
        return
    end

    if fields.owner_mode then
        superquest.quest_machine.logic.set_mode(player, pos, false)
    elseif fields.completions then
        superquest.quest_machine.logic.show_completions(player, pos)
    elseif fields.start then
        superquest.quest_machine.logic.start_quest(player, pos)
    end
end)
