# SuperQuest
A Minetest mod that allows to create active quests and challenges.

![Screenshot](/screenshot.png)

## Nodes
The mod contains the following nodes:

- Flag
- Digiline-requiring flag
- Quest Machine
- Flat Quest Machine

## Completing quests
To complete a quest, you need to punch all the flags which belong to the quest. To get a reward, after punching all the flags, you need to punch a quest machine which belongs to the quest (network). Reward for the first completion might be different from reward for further completions. If the quest machine's internal inventory does not contain enough items, you won't be able to get the reward until it will be refilled. The maximum number of completions of a quest for one player might be restricted.
Flags can also be triggered automatically when a player entered a cubic area around the flag specified in the flag's configuration, if the feature is enabled in mod's config. It was decided to use a cubic area instead of a spherical one to make it more customizable. Need to mention that in some time flags might not be triggered when the player entered the area. This might happen because of a big lag or the player entered it for a very short time (scanning occurs periodically, once per second by default); in this case, the flag should be punched manually.
Except of ordinary flags, there are also "Digiline-requiring flags" which can be activated only after receiving the corresponding Digiline message. How can the flag receive the corresponding message depends on the quest itself, and it's the quest owner's responsibility to make it clear for players which are completing the quest and which are not familiar with Digilines.
To complete a timed quest, it needs to be started first by pressing the "Start" button in the quest's Quest Machine. If the quest wasn't completed within the time limit, the progress (triggered flags) will be reset.
Players can teleport to Quest Machines after completing the quest as well as last counted flag in case of death during completion of the quest if it's enabled by server and the quest's 
author, and if there is enough place to teleport. If the last counted flag doesn't support teleportation, the player will be teleported to the last counted flag which supported teleportation at the moment of counting if there is such a flag (if the teleportation to the flag became unavailable between the two events, the player won't be able to teleport).
This feature exists to allow players avoid extra actions like traveling from the last counted flag to the Quest machine which could be quite far from each other, or allow to continue
completing the quest in case of death without necessity to start it from scratch. For this reason, the player can teleport only to the latest location, and it's cleared after taking the reward or logging out, so it shouldn't be used as a reliable method of teleportation. Teleportation is performed with a chat command specified in the corresponding section.

By right-clicking a quest machine, you can see:

 - How many flags you punched, and the total number of flags
 - Which reward you will get for completing the quest
 - How many rewards are currently available
 - How many times you completed the quest
 - The maximum number of completions to get a reward (0 = infinity)
 - For timed quests, the time limit for completing the quest

Need to mention that the number of available rewards for first and further completions are calculated based on the shared inventory of the Quest Machine, thus, if rewards for first and further completions contain the same items, receiving reward for the first completion might also affect the number of available rewards for the further completions, and vice versa.

## Creating quests
After placing flags or quest machines the placer becomes the owner of the node.

All flags and quest machines which belong to the same quest, must be assigned to the same network name. Under the hood, owner's name is also included into the network's name to prevent other players from altering the network. It's forbidden to use the # symbol in network name since it's reserver for internal usage.

Right-clicking flags and quest machines displays menu in which the nodes can be configured. Flag's menu allows to:

 - Specify network's name
 - Specify coordinates of a cubic area, entering which automatically activates the flag for the player (if automatic triggering is enabled in the server's setting)
 - Specify the teleportation point (if teleportation is enabled in the server's settings)

The cubic area is specified by the means of the "From coords" and "To coords" fields which accept relative coordinates of two opposite angles of the cube relative to the flag's coordinates in the format x,y,z (for example, 8,5,7). All the values should be non-negative. Values in "From coords" are subtracted from the flag's coordinates while values in "To coords" are added to them.

The teleportation point is specified by coordinates in the format x,y,z (for example, 1,-1,0) relative to the flag's position. The field can be empty which means that teleportation is
disabled for the flag.

Menu of Quest Machine allows to:

 - Specify network's name
 - Specify the maximum number of completions
 - Specify the time limit for completing the quest in seconds
 - Specify whether teleportation to the Quest Machine is enabled
 - Specify rewards
 - Manipulate Quest Machine's inventory
 - Switch to user mode, and vice versa
 - See the number of flags in the network
 - See the number of available rewards

Ownership doesn't protect flags and quest machines from digging by other players. That's because flags and quest machines should be placed in protected areas anyway. Creating quest in unprotected areas might lead to possibility for players to modify the quest itself. This approach might also be reconsidered.

If the "digilines" mod is installed, SuperQuest provides Digiline-requiring Flags, as well as a set of Digiline messages for flags (ordinary and digiline-requiring) and quest machines which are described in the "SuperQuest Digiline Guide" which can be accessed by pressing the "?" button near the "Digiline channel" field. The only difference between ordinary and digiline-requiring flags is that digiline-requiring flags can be triggered only after receiving the corresponding Digiline signal. This allows to make Digilines-based mini games a part of quests. Digiline-requiring flags cannot be triggered just by sending the corresponding digiline signal without the same action from the player as for ordinary flags (punching or presence within its range), otherwise any player would be able to annoy any other player by continuous triggering a digiline-requiring flag for the user and triggering the "*/* flags counted" popup for them. It's the quest author's responsibility to make it clear for ordinary players (including those who are not familiar with Digilines) how to activate each digiline-requiring flag within the quest.

This is the responsibility of quests' authors to guarantee that the teleportation point is safe for teleportation, and the player, for example, won't fall to lava just by teleporting.

You can test your quests by switching to the user mode in the Quest Machine.

### Chat commands

List names of networks of the current user:
```
/superquest list_my_networks
```

List all the elements of a particular network of the current user:
```
/superquest list_my_network_elements <network_name>
```

Cancel the current active timed quest:
```
/superquest cancel
```

Teleport to the last location (if available)
```
/superquest teleport
```

## Administrating quests

Players with the "superquest_admin" privilege are allowed to edit all quests, including quests owned by other players. This privilege also gives access to administrative chat commands.

### Administrative chat commands

List players which own networks:
```
/superquest_admin list_owners
```

List networks of a player:
```
/superquest_admin list_player_networks <player_name>
```

List elements of a network of a player:
```
/superquest_admin list_player_network_elements <player_name>#<network_name>
```
