package.path = "../?.lua;" .. package.path

dofile('tests/mut.lua')

local function flags_cmp(a, b)
    return vector.from_string(a.coords).x < vector.from_string(b.coords).x
end

insulate("Flags ordering", function()
    dofile('init.lua')

    local player = mut.create_player("user1", {
        pos = vector.new(0, 0, 0)
    })

    it("Basic test", function()
        local node1 = mut.place_node(vector.new(2, 2, 2), {
            stack = ItemStack("superquest:flag"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "Flag 1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        local node2 = mut.place_node(vector.new(5, 2, 2), {
            stack = ItemStack("superquest:flag"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node2.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "Flag 2",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        local node3 = mut.place_node(vector.new(8, 2, 2), {
            stack = ItemStack("superquest:flag"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node3.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "",
            flags_before = "Flag 1\nFlag 2",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        local node4 = mut.place_node(vector.new(10, 2, 2), {
            stack = ItemStack("superquest:quest_machine"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node4.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            max_completions = "0",
            timed_duration = 0
        })

        mut.rightclick_node(node4.pos, {
            clicker = player
        })

        mut.submit_active_formspec(player.name, {
            user_mode = true
        })

        local elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node1.pos), name = "Flag 1" },
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
                { coords = vector.to_string(node3.pos) },
            },
            quest_machines = {
                vector.to_string(node4.pos)
            }
        }))

        local reached, total
        reached, total = assert(superquest.Network(player.name, "test_network")):get_flags_stats_for_player(player.name)
        assert(reached == 0 and total == 3)

        mut.punch_node(node3.pos, player)

        reached, total = assert(superquest.Network(player.name, "test_network")):get_flags_stats_for_player(player.name)
        assert(reached == 0 and total == 3)

        mut.punch_node(node1.pos, player)
        mut.punch_node(node2.pos, player)

        reached, total = assert(superquest.Network(player.name, "test_network")):get_flags_stats_for_player(player.name)
        assert(reached == 2 and total == 3)

        mut.punch_node(node3.pos, player)

        reached, total = assert(superquest.Network(player.name, "test_network")):get_flags_stats_for_player(player.name)
        assert(reached == 3 and total == 3)

        assert(mut.dig_node(node1.pos, player))

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
                { coords = vector.to_string(node3.pos) },
            },
            quest_machines = {
                vector.to_string(node4.pos)
            }
        }))

        assert(mut.dig_node(node2.pos, player))
        assert(mut.dig_node(node3.pos, player))
        assert(mut.dig_node(node4.pos, player))
    end)

    it("Changing name", function()
        local node1 = mut.place_node(vector.new(2, 2, 2), {
            stack = ItemStack("superquest:flag"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "Flag 1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        local node2 = mut.place_node(vector.new(5, 2, 2), {
            stack = ItemStack("superquest:flag"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node2.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "Flag 2",
            flags_before = "Flag 1",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        local node3 = mut.place_node(vector.new(10, 2, 2), {
            stack = ItemStack("superquest:quest_machine"),
            placer = player,
            bottom_dir = vector.new(0, -1, 0),
        })

        mut.rightclick_node(node3.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            max_completions = "0",
            timed_duration = 0
        })

        mut.rightclick_node(node3.pos, {
            clicker = player
        })

        mut.submit_active_formspec(player.name, {
            user_mode = true
        })

        local elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node1.pos), name = "Flag 1" },
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "Flag 1_1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node1.pos), name = "Flag 1_1" },
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node1.pos) },
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "test_network",
            name = "Flag 1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node1.pos), name = "Flag 1" },
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "",
            name = "Flag 1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "",
            name = "Flag 1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "",
            name = "",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        mut.rightclick_node(node1.pos, {
            clicker = player,
        })

        mut.submit_active_formspec(player.name, {
            save = true,
            network = "",
            name = "Flag 1",
            flags_before = "",
            from_coords = "0,0,0",
            to_coords = "0,0,0"
        })

        elements = assert(superquest.Network(player.name, "test_network")):get_network_elements()
        table.sort(elements.flags, flags_cmp)
        assert(mut.compare_objects(elements, {
            flags = {
                { coords = vector.to_string(node2.pos), name = "Flag 2" },
            },
            quest_machines = {
                vector.to_string(node3.pos)
            }
        }))

        assert(mut.dig_node(node1.pos, player))
        assert(mut.dig_node(node2.pos, player))
        assert(mut.dig_node(node3.pos, player))
    end)
end)
